<?php
/**
 * This example shows settings to use when sending via Google's Gmail servers.
 * This uses traditional id & password authentication - look at the gmail_xoauth.phps
 * example to see how to use XOAUTH2.
 * The IMAP section shows how to save this message to the 'Sent Mail' folder using IMAP commands.
 */
//Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
require 'vendor/autoload.php';

if(isset($_POST['submit']))
{
	//Create a new PHPMailer instance
	$mail = new PHPMailer;


	//Solo habilitado por problemas de certificado
	$mail->SMTPAutoTLS = false;
	$mail->SMTPSecure = false;

	//Tell PHPMailer to use SMTP
	if ($_POST['isSMTP'] = 1) {
        $mail->isSMTP();
    }
	//Enable SMTP debugging
	// 0 = off (for production use)
	// 1 = client messages
	// 2 = client and server messages
	// 3 = client, server and connection messages
	// 4 = client, server, connection and low level messages
	$mail->SMTPDebug = $_POST['debug'];
	$mail->Debugoutput = 'html';
	//Set the hostname of the mail server
	$mail->Host = $_POST['host'];
	// use
	// $mail->Host = gethostbyname('smtp.gmail.com');
	// if your network does not support SMTP over IPv6
	//Set the SMTP port number - 587 for authenticated TLS, a.k.a. RFC4409 SMTP submission
	$mail->Port = $_POST['port'];
	//Set the encryption system to use - ssl (deprecated) or tls
	$mail->SMTPSecure = ['SMTPSecure'];
	//Whether to use SMTP authentication
	if ($_POST['SMTPAuth'] = 1) {        
		$mail->SMTPAuth = true;;
    }
	//Username to use for SMTP authentication - use full email address for gmail
	$mail->Username = $_POST['username'];
	//Password to use for SMTP authentication
	$mail->Password = $_POST['password'];
	//Set who the message is to be sent from
	$mail->setFrom($_POST['username'], 'Test PHP Mailer DJ');
	//Set an alternative reply-to address
	//$mail->addReplyTo('replyto@example.com', 'First Last');
	//Set who the message is to be sent to
	$mail->addAddress($_POST['toAddress']);
	//Set the subject line
	$mail->Subject = $_POST['subject'];
	$mail->Body    = $_POST['message'];
	//Read an HTML message body from an external file, convert referenced images to embedded,
	//convert HTML into a basic plain-text alternative body
	//$mail->msgHTML(file_get_contents('contents.html'), __DIR__);
	//Replace the plain text body with one created manually
	//$mail->AltBody = 'This is a plain-text message body';
	//Attach an image file
	//$mail->addAttachment('images/phpmailer_mini.png');
	//send the message, check for errors
	if (!$mail->send()) {
	    echo "Mailer Error: " . $mail->ErrorInfo;
	} else {
	    echo "Message sent!";
	    
	    //Section 2: IMAP
	    //Uncomment these to save your message in the 'Sent Mail' folder.
	    #if (save_mail($mail)) {
	    #    echo "Message saved!";
	    #}
	}
	//Section 2: IMAP
	//IMAP commands requires the PHP IMAP Extension, found at: https://php.net/manual/en/imap.setup.php
	//Function to call which uses the PHP imap_*() functions to save messages: https://php.net/manual/en/book.imap.php
	//You can use imap_getmailboxes($imapStream, '/imap/ssl') to get a list of available folders or labels, this can
	//be useful if you are trying to get this working on a non-Gmail IMAP server.

	//function save_mail($mail)
	//{
	//    //You can change 'Sent Mail' to any other folder or tag
	//    $path = "{imap.gmail.com:993/imap/ssl}[Gmail]/Sent Mail";
	//    //Tell your server to open an IMAP connection using the same username and password as you used for SMTP
	//    $imapStream = imap_open($path, $mail->Username, $mail->Password);
	//    $result = imap_append($imapStream, $path, $mail->getSentMIMEMessage());
	//    imap_close($imapStream);
	//    return $result;
	//}
}
?>

<!doctype html>
<html>
<head>
	<title>GoSmart AWS</title>
	<h2 style="text-align:center;">Envio Simple de Correo DJ</h2>
</head>

<body>
	<form method="post" action="">
		<div>
			<label for="debug">Debug Level</label>
            <select id="debug" name="debug">
                <option value="0" >OFF (0)</option>
                <option value="1" >CLIENT (1)</option>
                <option value="2" >SERVER (2)</option>
                <option value="3" >CONNECTION (3)</option>
                <option value="4" >LOW LEVEL (4)</option>
            </select>
		</div>
		<div>
			<label for="isSMTP">is SMTP:</label>
            <select id="isSMTP" name="isSMTP">
                <option value="1" >Yes</option>
                <option value="2" >No</option>
            </select>
		</div>
		<div>
			<label for="host">Host:</label> <input type="text" id="host" name="host">
		</div>
		<div>
			<label for="port">Port:</label> <input type="text" id="port" name="port">
		</div>
		<div>
			<label for="SMTPSecure">Encription:</label>
            <select id="SMTPSecure" name="SMTPSecure">
                <option value="tls" >TLS</option>
                <option value="ssl" >SSL</option>
                <option value="" >None</option>
            </select>
		</div>
		<div>
			<label for="SMTPAuth">SMTP Auth:</label>
            <select id="SMTPAuth" name="SMTPAuth">
                <option value="1" >Yes</option>
                <option value="2" >No</option>
            </select>
		</div>
		<div>
			<label for="username">Login:</label> <input type="text" id="username" name="username">
		</div>
		<div>
			<label for="password">Password:</label> <input type="text" id="password" name="password">
		</div>
		<div>
			<label for="toAddress">Enviar a email:</label> <input type="email" id="toAddress" name="toAddress">
		</div>
		<div>
			<label for="subject">Asunto:</label> <input type="text" id="subject" name="subject">
		</div>
		<div>
			<label for="message">Mensaje:</label> <textarea id="message" name="message"></textarea>
		</div>
		<div class="button">
			<input type="submit" name="submit" value="Enviar" />
		</div>
	</form>
</body>

</html>

<style>
form {margin: 0 auto; width: 420px; padding: 1em; border: 1px solid #CCC; border-radius: 1em;}
form div + div {margin-top: 1em;}
label {display: inline-block; width: 100px; text-align: right;}
input, textarea {font: 1em sans-serif; width: 300px; box-sizing: border-box; border: 1px solid #999;}
input:focus, textarea:focus {border-color: #000;}
textarea {vertical-align: top; height: 5em;}
.button { padding-left: 90px;}
button {margin-left: .5em;}
</style>