<?php
$host = 'localhost'; //host
//$host = '172.31.17.214'; //host
$port = '9000'; //port
$null = NULL; //null var
$admin_sid = '';

//Create TCP/IP sream socket
$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
//reuseable port
socket_set_option($socket, SOL_SOCKET, SO_REUSEADDR, 1);

//bind socket to specified host
socket_bind($socket, 0, $port);
//socket_bind($socket, '3.13.193.129', $port);

//listen to port
socket_listen($socket);

//create & add listning socket to the list
$clients = array($socket);
$clients_sid = array();


//start endless loop, so that our script doesn't stop
while (true) {
  //manage multipal connections
  $changed = $clients;
  //returns the socket resources in $changed array
  socket_select($changed, $null, $null, 0, 10);
  
//print_r($changed);

  //check for new socket
  if (in_array($socket, $changed)) {
    $socket_new = socket_accept($socket); //accpet new socket
    $clients[] = $socket_new; //add socket to client array    

    var_dump("socket_new >>> $socket_new");

    $header = trim(@socket_read($socket_new, 2048)); //read data sent by the socket

// var_dump(utf8_encode(utf8_decode($header)));
// var_dump(utf8_decode(utf8_encode($header)));
// var_dump(utf8_decode($header));
// var_dump(utf8_encode($header));
    var_dump($header);


    perform_handshaking($header, $socket_new, $host, $port); //perform websocket handshake
    
    socket_getpeername($socket_new, $ip); //get ip address of connected socket
    $response = mask(json_encode(array('type'=>'system', 'message'=>$ip.' connected'))); //prepare json data
    send_message($response); //notify all users about new connection
    
    
    socket_recv($socket_new, $buf, 1024, 0);
    $received_text = unmask($buf); //unmask data
    $tst_msg = json_decode($received_text); //json decode 
    $clients_sid[$tst_msg->sid]['name'] = $tst_msg->name;
    $clients_sid[$tst_msg->sid]['socket'] = $socket_new;
      
    $response = mask(json_encode(array('type'=>'users', 'message'=> json_encode(users_list($clients_sid))))); //prepare json data
    send_message($response);

    if ($tst_msg->name == 'Admin') {
      $admin_sid = $tst_msg->sid;
    }

    //make room for new socket
    $found_socket = array_search($socket, $changed);
    unset($changed[$found_socket]);
  }
  //loop through all connected sockets
  foreach ($changed as $changed_socket) {  
    
    //check for any incomming data
    while(socket_recv($changed_socket, $buf, 1024, 0) >= 1)
    {
      $received_text = unmask($buf); //unmask data
      $tst_msg = json_decode($received_text); //json decode 

      $user_name = $tst_msg->name; //sender name
      $user_message = $tst_msg->message; //message text
      $user_color = $tst_msg->color; //color
      $user_sid = $tst_msg->sid; 
      $to_users = $tst_msg->to_users; 

      $type = "usermsg";
      $invite = 0;
      if (isset($tst_msg->invite) && $tst_msg->invite > 0) {
        $type = "invite";
        $invite = $tst_msg->invite;
        
        // accept invitation
        if ($tst_msg->invite == 2) {
          $clients_sid[$tst_msg->sid]['users'][] = $tst_msg->to_users[0];
          $clients_sid[$tst_msg->to_users[0]]['users'][] = $tst_msg->sid;
        }
      }

      
      if ($type == "usermsg") {
        array_push($to_users, $tst_msg->sid);
      }
      
      //prepare data to be sent to client
      $response_text = mask(
        json_encode(
          array(
            'type'     => $type, 
            'name'     => $user_name, 
            'message'  => $user_message, 
            'color'    => $user_color,
            'sid'      => $user_sid,
            'to_users' => $to_users,
            'invite'   => $invite,
          )
        )
      );
      
      send_message($response_text, $to_users); //send data
      break 2; //exist this loop
    }
    
    $buf = @socket_read($changed_socket, 1024, PHP_NORMAL_READ);
    if ($buf === false) { // check disconnected client
      // remove client for $clients array
      $found_socket = array_search($changed_socket, $clients);
      socket_getpeername($changed_socket, $ip);
      unset($clients[$found_socket]);
      
      //notify all users about disconnected connection
      $response = mask(json_encode(array('type'=>'system', 'message'=>$ip.' disconnected')));
      send_message($response);
    }
  }
}
// close the listening socket
socket_close($sock);

function send_message($msg, $to_users = false)
{
  global $clients, $clients_sid;
  
  if ($to_users) {
    
    foreach($clients_sid as $key => $value) {
      if (in_array($key, $to_users)) {
  //print_r($value);
        @socket_write($value['socket'], $msg, strlen($msg));
      }
    }
    return true;
    
  }

  foreach($clients as $changed_socket) {    
    @socket_write($changed_socket,$msg,strlen($msg));
  }
  return true;
}


//Unmask incoming framed message
function unmask($text) {
  $length = ord($text[1]) & 127;
  if($length == 126) {
    $masks = substr($text, 4, 4);
    $data = substr($text, 8);
  }
  elseif($length == 127) {
    $masks = substr($text, 10, 4);
    $data = substr($text, 14);
  }
  else {
    $masks = substr($text, 2, 4);
    $data = substr($text, 6);
  }
  $text = "";
  for ($i = 0; $i < strlen($data); ++$i) {
    $text .= $data[$i] ^ $masks[$i%4];
  }
  return $text;
}

//Encode message for transfer to client.
function mask($text)
{
  $b1 = 0x80 | (0x1 & 0x0f);
  $length = strlen($text);
  
  if($length <= 125)
    $header = pack('CC', $b1, $length);
  elseif($length > 125 && $length < 65536)
    $header = pack('CCn', $b1, 126, $length);
  elseif($length >= 65536)
    $header = pack('CCNN', $b1, 127, $length);
  return $header.$text;
}

//handshake new client.
function perform_handshaking($receved_header,$client_conn, $host, $port)
{
  $headers = array();
  $lines = preg_split("/\r\n/", $receved_header);
  foreach($lines as $line)
  {
    $line = chop($line);
    if(preg_match('/\A(\S+): (.*)\z/', $line, $matches))
    {
      $headers[$matches[1]] = $matches[2];
    }
  }

  $secKey = $headers['Sec-WebSocket-Key'];
  $secAccept = base64_encode(pack('H*', sha1($secKey . '258EAFA5-E914-47DA-95CA-C5AB0DC85B11')));
  //hand shaking header
  $upgrade  = "HTTP/1.1 101 Web Socket Protocol Handshake\r\n" .
  "Upgrade: websocket\r\n" .
  "Connection: Upgrade\r\n" .
  "WebSocket-Origin: $host\r\n" .
  "WebSocket-Location: ws://$host:$port/demo/shout.php\r\n".
  "Sec-WebSocket-Accept:$secAccept\r\n\r\n";
  socket_write($client_conn,$upgrade,strlen($upgrade));
}


function users_list($users){

  $list = array();
  foreach($users as $key => $value) {
    $list[] = array(
      'name' => $value['name'],
      'id'   => $key
    );
  }
  return $list;

}