//const inputImage = document.getElementById("uploadImage");
const previewImage = document.getElementById("preview");
const textArea = document.getElementById("base64");
///////////////////////////////////////////////////////
//const inputFile = document.getElementById("uploadFile");

$(".pre").hide();
$(".preFile").hide();

const convertBase64 = (file) => {
    return new Promise((resolve, reject) => {
        const fileReader = new FileReader();
        fileReader.readAsDataURL(file);

        fileReader.onload = () => {
            resolve(fileReader.result);
        };

        fileReader.onerror = (error) => {
            reject(error);
        };
    });
};

const uploadImage = async (event) => {
    $(".pre").show();
    const file = event.target.files[0];
    const base64 = await convertBase64(file);
    previewImage.src = base64;
    $("#imgBase64").val(base64);    
};

const uploadFile = async (event) => {
    $(".preFile").show();
    const file = event.target.files[0];   
    console.log(file.type);     
    $("#preDoc").prop("src", file.name);
};

function clearPhoto() {	 
	$('#uploadImage').val(""); 	 
    $(".pre").hide();
    $("#imgBase64").val("");   	 
}

function clearFile() {	 
	$('#uploadFile').val(""); 	 
    $(".preFile").hide();     
}

function fileValidationImage(e){
    var fileInput = document.getElementById('uploadImage');
    var filePath = fileInput.value;
    var allowedExtensions = /(.jpg|.jpeg|.png|.JPG|.JPEG|.PNG)$/i;
    if(!allowedExtensions.exec(filePath)){
        swal('Please upload file having extensions .jpeg/.jpg/.png/ only.');
        clearPhoto();
    }else{
        uploadImage(e);
    }
}

function fileValidationFile(e){
    var fileInput = document.getElementById('uploadFile');
    var filePath = fileInput.value;
    var allowedExtensions = /(.pdf|.PDF|.doc|.DOC|.docx|.DOCX)$/i;
    if(!allowedExtensions.exec(filePath)){
        swal('Please upload file having extensions .pdf/.doc/ only.');
        clearFile();
    }else{
        uploadFile(e);
    }
}

///////////////////////////////////////
/////////////////////////////////////// 

$("#uploadImage").change(function (e) { 
    e.preventDefault();
    fileValidationImage(e);
});
 

$("#uploadFile").change(function (e) { 
    e.preventDefault();
    fileValidationFile(e);
});

$("#btnSaveUploadImageClear").click(function (e) { 
    e.preventDefault();   
    clearPhoto();    
});

$("#btnSaveUploadFileClear").click(function (e) { 
    e.preventDefault();   
    clearFile();    
});

