/**
 * @license Copyright © 2013 Stuart Sillitoe <stuart@vericode.co.uk>
 * This work is mine, and yours. You can modify it as you wish.
 *
 * Stuart Sillitoe
 * stuartsillitoe.co.uk
 *
 */

CKEDITOR.plugins.add('strinsert',
{
	requires : ['richcombo'],
	init : function( editor )
	{
		//  array of strings to choose from that'll be inserted into the editor
		var strings = [];
		strings.push(["{{name}}","Contact Name","Insert Contact Name"]);
		strings.push(["{{last_name}}","Contact Last Name","Insert Contact Last Name"]);
		strings.push(["{{title}}","Contact Title","Insert Contact Title"]);
		strings.push(["{{tags}}","Contact Tags","Insert Contact Tags"]);
		strings.push(["{{score}}","Contact Score","Insert Contact Score"]);
		strings.push(["{{full_name}}","Lead Full Name","Insert Lead Full Name"]);
		strings.push(["{{city}}","Lead City","Insert Lead City"]);
		strings.push(["{{country}}","Lead Country","Insert Lead Country"]);
		strings.push(["{{zip}}","Lead Zip Code","Insert Lead Zip Code"]);
		strings.push(["{{name_user_crm}}","User name","Insert User Name"]);
		strings.push(["{{cell}}","User cell","Insert User Cell"]);
		strings.push(["{{email}}","User email","Insert User Email"]);

		// add the menu to the editor
		editor.ui.addRichCombo('strinsert',
		{
			label: 		'Fields',
			title: 		'Insert Merge Fields',
			voiceLabel: 'Insert Merge Fields',
			className: 	'cke_format',
			multiSelect:false,
			panel:
			{
				css: [ editor.config.contentsCss, CKEDITOR.skin.getPath('editor') ],
				voiceLabel: editor.lang.panelVoiceLabel
			},

			init: function()
			{
				this.startGroup( "Merge Fields" );
				for (var i in strings)
				{
					this.add(strings[i][0], strings[i][1], strings[i][2]);
				}
			},

			onClick: function( value )
			{
				editor.focus();
				editor.fire( 'saveSnapshot' );
				editor.insertHtml(value);
				editor.fire( 'saveSnapshot' );
			}
		});
	}
});