<?php
    //INCLUDES
    //CONEXION BD
    include '../../common/generalWs.php';
    // incluimos la libreria ó toolkit nusoap
    require_once('../../assets/lib_nusoap/nusoap.php');
   
    $obj_bdmysql = new coBdmysql();
    $server = new nusoap_server();

    /* Database connection end */
    $conn = mysqli_connect(DBHOST, DBUSER, DBPASS, DBNOM) or die("Connection failed: " . mysqli_connect_error());
    $server->configureWSDL('Ws User - login', 'urn:login');
    $server->wsdl->schemaTargetNamespace = 'urn:login';

    //**********login***********

    // Parametros de entrada
    $server->wsdl->addComplexType(
        'param_login_in',
        'complexType',
        'struct',
        'all',
        '',
        array(
            'email' => array('name' => 'email', 'type' => 'xsd:string'),
            'password' => array('name' => 'password', 'type' => 'xsd:string'),
            'subdomain' => array('name' => 'subdomain', 'type' => 'xsd:string')
        )
    );

    // Parametros de Salida
    $server->wsdl->addComplexType(
        'param_login_out',
        'complexType',
        'struct',
        'all',
        '',
        array(
            'valida_sesion'   => array('name' => 'valida_sesion','type' => 'xsd:string'),
            'name'   => array('name' => 'name','type' => 'xsd:string'),
            'username'   => array('name' => 'username','type' => 'xsd:string'),
            'image'   => array('name' => 'image','type' => 'xsd:string'),
            'id_user_crm'   => array('name' => 'id_user_crm','type' => 'xsd:string'),
            'id_client'   => array('name' => 'id_client','type' => 'xsd:string'),
            'key_word'   => array('name' => 'key_word','type' => 'xsd:string'),
            'edit'   => array('name' => 'edit','type' => 'xsd:string'),
            'id_role'   => array('name' => 'id_role','type' => 'xsd:string'),
            'rol'   => array('name' => 'rol','type' => 'xsd:string'),
            'private_identity'   => array('name' => 'private_identity','type' => 'xsd:string'),
            'public_identity'   => array('name' => 'public_identity','type' => 'xsd:string'),
            'password'   => array('name' => 'password','type' => 'xsd:string'),
            'realm'   => array('name' => 'realm','type' => 'xsd:string'),
            'ucctc_status'   => array('name' => 'ucctc_status','type' => 'xsd:string'),
            'sctc_status'   => array('name' => 'sctc_status','type' => 'xsd:string')
        )
    );

    $server->register( 'login', // nombre del metodo o funcion
        array('param_login_in' => 'tns:param_login_in'), // parametros de entrada
        array('return' => 'tns:struct'), // parametros de salida
        'urn:login', // namespace
        'urn:login#login', // soapaction debe ir asociado al nombre del metodo
        'rpc', // style
        'encoded', // use
        'web service para ingresar Contacto por Lote' // documentation,
        //$encodingStyle
    );

    //Definimos la estructura de la matriz que usa los registros
    $server->wsdl->addComplexType( 'struct',
        'complexType',
        'array',
        '',
        'SOAP-ENC:Array', array(),
        array(
            array(
                'ref' => 'SOAP-ENC:arrayType',
                'wsdl:arrayType' => 'tns:param_login_out[]'
            )
        ),
        'tns:param_login_out'
    );
   
    function login($param) {
        global $conn, $obj_bdmysql;
        $data = array();
        $sql = "SELECT us.id, us.id_client, us.name, us.username, us.email, us.password, us.image, us.status, group_concat(key_word) AS key_word,
            group_concat(csrm.id_module,'-',csrm.edit) AS edit, us.id_role, rl.name rol, ucctc.private_identity, ucctc.public_identity,
             ucctc.password AS ucctc_password, ucctc.realm , ucctc.status AS ucctc_status, sctc.status AS sctc_status
             FROM user_crm us
             INNER JOIN role rl ON us.id_role = rl.id
             INNER JOIN client_setting_role_module csrm ON rl.id = csrm.id_role AND us.id_client = csrm.id_client
             INNER JOIN module ON csrm.id_module = module.id
             INNER JOIN client ON us.id_client = client.id
             LEFT JOIN user_crm_click_to_call ucctc ON ucctc.id_user_crm = us.id
             LEFT JOIN setting_click_to_call sctc ON sctc.id_client = us.id_client
             WHERE (email LIKE '".$param['email']."' OR username LIKE '".$param['email']."') AND us.password LIKE '".$param['password']."' AND client.subdomain LIKE '".$param['subdomain']."'
             GROUP BY us.id, us.id_client, us.name, us.email, us.username, us.password, us.status, us.id_role,ucctc.private_identity, ucctc.public_identity, ucctc.password, ucctc.realm , ucctc.status, sctc.status ";
        $result = $obj_bdmysql->query($sql,$conn);
        foreach ($result as $rows){
            $row['valida_sesion'] = $rows['valida_sesion'];
            $row['name'] = $rows['name'];
            $row['username'] = $rows['username'];
            $row['image'] = $rows['image'];
            $row['id_user_crm'] = $rows['id'];
            $row['id_client'] = $rows['id_client'];
            $row['key_word'] = $rows['key_word'];
            $row['edit'] = $rows['edit'];
            $row['id_role'] = $rows['id_role'];
            $row['rol'] = $rows['rol'];
            $row['private_identity'] = $rows['private_identity'];
            $row['public_identity'] = $rows['public_identity'];
            $row['password'] = $rows['password'];
            $row['realm'] = $rows['realm'];
            $row['ucctc_status'] = $rows['ucctc_status'];
            $row['sctc_status'] = $rows['sctc_status'];
            $data[] = $row;
        }
        return $data;
    }
    //**********fin login();***********
 
    $HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
    @$server->service(file_get_contents("php://input"));
?>