"use strict";
var MODELO = '../model/member_model.php';
var dataTable = '';
var formMember = $('#formMember');

var id_role = localStorage.getItem('id_role')
var id_company = localStorage.getItem('id_company') 
 
var Members ={
    init:function () {         
        ////////
        loadMemberCompany(id_company)
        
        formMember.validate({
            debug: false,
            rules: {
                full_name: {
                    required: true,
                },
                user_name: {
                    required: true,
                },
                phone: {
                    required: true,
                },
                email: {
                    required: true,
                    email:true
                },
                add_password_member: {
                    required: true,
                    minlength: 8,
                },
                add_confirm_password_user: {
                    required: true,
                    minlength: 8,
                    equalTo: "#add_password_member"
                }
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                add_password_member: {
                    equalTo: "Passwords do not match"
                }
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    },
    events:function () {
        $("#btnModalAddMember").click(function (e) { 
            e.preventDefault();
            Members.clean();
            let select_company = $("#select_company").val();
            if (select_company == 0) {
                preloader('hide', 'Select Company', 'error'); 
            }
            if (select_company != 0) {
                $("#titleModalMember").html('Add Member');
                $("#modalAddMember").modal("show");
            }            
        });
        //////
        $("#select_company").change(function (e) { 
            e.preventDefault();
            let select_company = $("#select_company").val();
            if (select_company != 0) {
                loadMemberCompany(select_company);
            }
            if (select_company == 0) {
                $('#tableMember').DataTable().clear().destroy();
            }
        });
        ///////
        $("#btnSaveNewMember").click(function (e) { 
            e.preventDefault();
            if (formMember.valid()) {
                var dt ={
                    method:"saveMember",
                    id:$("#add_id_member").val(),
                    full_name:$("#full_name").val(),
                    user_name:$("#user_name").val(),
                    phone:$("#phone").val(),
                    email:$("#email").val(),
                    password_member:$("#add_password_member").val(),
                    select_company:id_company,
                    id_role:localStorage.getItem('id_role')
               };
               preloader('show');
               $.post(MODELO, dt,
                   function (response, textStatus, jqXHR) {
                    if (response.code == 440) {
                        loginTimeout(response.message);
                        return;
                    } else if (response.code == 200) {
                        $("#modalAddMember").modal("hide");
                        preloader('hide', response.message, 'success');                     
                        dataTable.ajax.reload();
                    } else if (response.code == 204) {
                        preloader('hide', response.message, 'error');
                    }
                   },
                   "json"
               );
            }            
        }); 
        ////
        $('#tableMember tbody').on('click', '.button_edit', function () {
            var $tr = $(this).closest('tr');
            var data = dataTable.row($(this).parents($tr)).data();
            var id = data.id;  
            Members.editMember(id);          
        });
        ////////
        $('#tableMember tbody').on('click', '.checkbox_status', function () {
            var $tr = $(this).closest('tr');
            var data = dataTable.row($(this).parents($tr)).data();
            var id = data.id;
            var status = $(this).is(":checked") == true ? 1 : 0;            
            Members.statusMember(id,status);
        });
        /////
        $('#tableMember tbody').on('click', '.button_delete', function () {
            var $tr = $(this).closest('tr');
            var data = dataTable.row($(this).parents($tr)).data();
            var id = data.id;
            Members.deleteMember(id)
        });
        ///
        $('#tableMember tbody').on('click', '.uploadAvatar', function () {
           Members.clean();
            var $tr = $(this).closest('tr');
            var data = dataTable.row($(this).parents($tr)).data();
            var id = data.id;
            Members.clean()
            $('#id_related').val(id);

            $('#modalAddAvatar').modal('show');
        });
        /////
        $('#btnSaveAvatar').click(function (e) {
            e.preventDefault();
            firebaseInit();
            var storageRef = firebase.storage().ref();
            var file = document.getElementById("file-1").files;
            var id_related = $('#id_related').val();
            var uploadTask = storageRef.child('members/'+ id_related + '/' + file[0].name).put(file[0]);
            uploadTask.on('state_changed', function(snapshot) {
                var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
                console.log('Upload is ' + progress + '% done');
                switch (snapshot.state) {
                    case firebase.storage.TaskState.PAUSED: // or 'paused'
                        console.log('Upload is paused');
                        break;
                    case firebase.storage.TaskState.RUNNING: // or 'running'
                        console.log('Upload is running');
                        break;
                }
            },
            function(error) {
                // Handle unsuccessful uploads
            }, function() {

                uploadTask.snapshot.ref.getDownloadURL().then(function(downloadURL) {
                    preloader('show')
                     $.post(MODELO, {
                        "method": 'updateImage',
                        "id": id_related,
                        "path_image": 'members/'+ id_related + '/' + file[0].name,
                        "name_image": downloadURL,
                        },function(response) {
                            if (response.code == 440) {
                                loginTimeout(response.message);
                                return;
                            } else if (response.code == 200) {
                                preloader('hide', response.message, 'success');
                                $('#modalAddAvatar').modal('hide');
                                dataTable.ajax.reload();
                            } else if (response.code == 204) {
                                storageRef.child('members/'+ id_related + '/' + file[0].name).delete();
                                preloader('hide', response.message, 'error');
                            }
                    }, "json");

                });
            });
        });

        //
        $("#file-1").change(function(event) { //validar que sea imagen
            console.log('imagen change');
            var fileInput = document.getElementById('file-1');
            var imagen = this.files[0];
            var filePath = fileInput.value;
            var allowedExtensions = /(.jpg|.jpeg|.png|.gif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                Swal.fire("Ups..", 'Please upload file having extensions .jpeg/.jpg/.png/.gif Only.', "warning");
                $("#imagen").val('');
            }
            var datosImagen = new FileReader();
            datosImagen.readAsDataURL(imagen);
            $(datosImagen).on("load", function(event) {
                var rutaImagen = event.target.result;
                $(".previsualizar").attr("src", rutaImagen);
            });
        });
        ///
        $('.inputfile').each( function(){
            var $input   = $( this ),
                $label   = $input.next( 'label' ),
                labelVal = $label.html();

            $input.on( 'change', function( e )
            {
                var fileName = '';

                if( this.files && this.files.length > 1 )
                    fileName = ( this.getAttribute('data-multiple-caption') || '' ).replace('{count}', this.files.length );
                else if( e.target.value )
                    fileName = e.target.value.split( '\\' ).pop();

                if( fileName )
                    $label.find('span').html( fileName );
                else
                    $label.html( labelVal );
            });

            // Firefox bug fix
            $input
            .on( 'focus', function(){ $input.addClass('has-focus'); })
            .on( 'blur', function(){ $input.removeClass('has-focus'); });
        });

        /////
        $("#seePass").hover(function() {
            console.log("#seePass");
            var x = document.getElementById("add_password_member");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        });

    },
    clean:function () {
        $('#add_id_member').val(0)
        $('#id_related').val(0);
        $('#full_name').val('')
        $('#user_name').val('')
        $('#phone').val('')
        $('#email').val('')
        $('#add_password_member').val('')
        $("#add_confirm_password_user").val('')
        //$('#add_path_image').val('')
        //$('#add_path_name').val('')
        $('#imagen_url').prop('src', '')

        $("#add_password_member-error").hide();
        $("label.error").hide();
        $(".is-invalid").removeClass("is-invalid");
    },
    editMember:function (id) {
        Members.clean();
        preloader("show")
        $.post(MODELO, {method:"editMember",id:id},
            function (response, textStatus, jqXHR) {
                preloader("hide")
                let obj = response.data[0]
                $("#titleModalMember").html('Edit Member');
                $("#add_id_member").val(id)
                $("#full_name").val(obj.full_name)
                $("#user_name").val(obj.user_name)
                $("#phone").val(obj.phone)
                $("#email").val(obj.email)
                $("#add_password_member").val(obj.password)
                $("#add_confirm_password_user").val(obj.password)

                $("#modalAddMember").modal("show");
            },
            "json"
        );       
    },
    statusMember:function (id,status) {
        
        preloader("show")
        $.post(MODELO, {method:"statusMember",id:id,status:status},
            function (response, textStatus, jqXHR) {
                preloader("hide")
                dataTable.ajax.reload();
            },
            "json"
        );       
    },
    deleteMember: function(id) {

        Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then(result => {
                if (result.value) {
                    preloader('show');
                    var parametros = {
                        "method": "deleteMember",
                        "id": id
                    };
                    $.post(MODELO, parametros, function(data) {
                        if (data.code == '440') {
                            loginTimeout(data.message);
                            return;
                        } else if (data.code == 200) {
                            preloader('hide', data.message, 'success');
                            dataTable.ajax.reload();
                        }
                        else if (data.code == 204) {
                            preloader('hide',data.message, 'error');
                        }
                    }, 'json');
                }
        });
    }
}


function loadMemberCompany(id_company) {

    $('#tableMember').DataTable().clear().destroy();
    dataTable = $('#tableMember').DataTable({
        processing: true,
        responsive: true,
        paging:true,
        serverMethod: 'post',
        ajax: {
            url:MODELO,
            data: {
                method: "listMember",
                id_company:id_company
            },
            error: function() {}
        },
        "columns":[
            {"data":"id"},             
            {"data": null,
                render:function(data, type, row)
                {
                    let $upload = '';
                    if (data.name_image === null || data.name_image === '') {
                        $upload = '<button type="button" class="btn btn-xs btn-info uploadAvatar">Upload</button>';
                    }else{
                        $upload = '<img src="'+data.path_image+'",width=42px, height=42px />';
                    }
                  return $upload;
                },
                "targets": -1
            },
            {"data":"full_name"},
            {"data":"user_name"},
            {"data":"phone"},
            {"data":"email"},
            {"data": null,
            render:function(data, type, row)
                {
                    let $checked = '';
                    if(data.status == 1) $checked = 'checked'; else $checked = '';
                    return '<label class="switch"><input type="checkbox" class="checkbox_status" id="'+data.id+'" '+$checked+'><span class="slider round"></span></label>';
                },
                "targets": -1
            },
            {"defaultContent":
                '<a class="mb-2 mr-2 btn btn-warning btn-sm button_edit" title=""><i class="fas fa-edit" aria-hidden="true"></i></a>' +
                '<a class="mb-2 mr-2 btn btn-danger btn-sm button_delete" title=""><i class="fas fa-trash-alt" aria-hidden="true"></i></a>'
            }
        ],
        "order": [[0, "desc"]],
        drawCallback: function(response) {
            if (response.json !== undefined){
                if (response.json.code == '440') {
                    loginTimeout(response.json.message);
                    return;
                }
            }
        }
    });
}

$(function() {   
    Members.init(); 
    Members.events();    
});