<?php

include '../../common/generalWs.php';

class Aplicaciones
{

    private $conn;

    public function __construct()
    {
        $this->conn = new mysqli(DBHOST, DBUSER, DBPASS, DBNOM);
        $this->conn->set_charset('utf8mb4');
    }

    public function getApplications($agentCode)
    {
        $sql = "SELECT 
                cs.agreement_number AS policy_number, 
                cs.date_created, 
                cs.date_sale, 
                ss.name AS status, 
                cspp.plan_name AS plan_name, 
                cspp.pay_type, 
                cph.phone_number, 
                ce.email, 
                CASE
                    WHEN cpms.type = 0 THEN 'Bank Account - No verified'
                    WHEN cpms.type = 1 THEN 'Bank Account'
                    WHEN cpms.type = 2 THEN 'Credit Card'
                    ELSE 'Other'
                END payment_type, 
                CONCAT(cts.name,' ', cts.last_name) AS name_application
            FROM
                contacts_services_agents csa
                    LEFT JOIN
                contacts_services cs ON cs.id = csa.id_contacts_services
                    LEFT JOIN
                services ser ON ser.id = cs.id_services
                    LEFT JOIN
                opportunities opp ON opp.id = cs.id_opportunities
                    LEFT JOIN
                contacts cts ON cts.id = opp.id_contacts
                    LEFT JOIN
                services s ON cs.id_services = s.id
                    LEFT JOIN
                user_crm uc ON csa.id_user_crm = uc.id
                    LEFT JOIN
                contacts_phone cph ON cts.id = cph.id_contacts
                    LEFT JOIN
                contacts_email ce ON cts.id = ce.id_contacts
                    LEFT JOIN
                status_services ss ON cs.id_status_services = ss.id
                    LEFT JOIN
                (SELECT 
                    s.id_contacts_services,
                        s.status,
                        s.plan_name,
                        s.pay_type,
                        s.id_contacts_payment_methods_stripe
                FROM
                    contacts_services_pending_payment s
                GROUP BY s.id_contacts_services) cspp ON cs.id = cspp.id_contacts_services
                    LEFT JOIN
                (SELECT 
                    id, type, id_contacts
                FROM
                    contacts_payment_methods_stripe
                WHERE
                    principal = 1) cpms ON cpms.id_contacts = cts.id
            WHERE 
                1 = 1 AND uc.code_agent LIKE '%$agentCode%'";

        $result = $this->conn->query($sql);

        $aplicaciones = [];
        while ($row = $result->fetch_assoc()) {
            $aplicaciones[] = $row;
        }

        $this->conn->close();

        return json_encode($aplicaciones);
    }
}

$agentCode = isset($_GET['agentCode']) ? $_GET['agentCode'] : null; // Recibe el parámetro agentCode desde la URL

if ($agentCode) {
    $aplicaciones = new Aplicaciones();
    echo $aplicaciones->getApplications($agentCode);
}
