<?php 
// error_reporting(E_ALL);
// ini_set('display_errors', '1');

require_once realpath(__DIR__ . '/../../assets/bower_components/dompdf/lib/html5lib/Parser.php');
require_once realpath(__DIR__ .  '/../../assets/bower_components/dompdf/src/Autoloader.php'); 
require_once realpath(__DIR__ .  '/../../common/generalWs.php');
require_once realpath(__DIR__ .  '/../../vendor/autoload.php');


$obj_function = new coFunction();
$obj_bdmysql = new coBdmysql();
$conn = mysqli_connect(DBHOST, DBUSER, DBPASS, DBNOM) or die("Connection failed: " . mysqli_connect_error());
$conn->set_charset('utf8mb4');

Dompdf\Autoloader::register();
use Dompdf\Dompdf;
use PHPMailer\PHPMailer\PHPMailer;

$logFile =  "/var/www/html/v103/app/ws/renovation_debug.log";
$jsondebug = $logFile; 

// error_log("\n".date('d/m/Y h:i:s')."\n".print_r("Ejecución Cron 2025",true), 3, $jsondebug);
 
 
function generateRenewalPDF($data, $daysToRenewal) {
    $html = htmlRenovation();
   

    $initialDate = DateTime::createFromFormat('m/d/Y', $data['initialDate']);    

    $renewalStartDate = clone $initialDate;
    $renewalStartDate->add(new DateInterval('P1Y'));    

    $renewalEndDate = clone $renewalStartDate;
    $renewalEndDate->add(new DateInterval('P1Y')); // +1 año 
    $renewalEndDate->sub(new DateInterval('P1D')); // -1 día     

    $nextPeriodStart = $renewalStartDate->format('M/d/Y');
    $nextPeriodEnd = $renewalEndDate->format('M/d/Y'); 
  
    // Reemplazar los valores en el HTML
    $html = str_replace("ActivationInicialDate", date('M/d/Y', strtotime($data['saleDate'])), $html);
    $html = str_replace("HolderName", $data['holderName'], $html);
    $html = str_replace("PlanName", $data['planName'], $html);
    $html = str_replace("AgreementNumber", $data['agreementNumber'], $html);
    $html = str_replace("PaymentType", $data['paymentMethod'], $html);
    $html = str_replace("NextPayment", '$'.$data['nextPayment'], $html);
    $html = str_replace("TotalPayment", '$'.$data['amountDueToday'], $html);
    $html = str_replace("NewDateRenovation", $nextPeriodStart . ' - ' . $nextPeriodEnd, $html);
    $html = str_replace("DateNow", date("M/d/Y"), $html);
    $html = str_replace("Anio", date("Y"), $html);
    $html = str_replace("DiasRenovation", $daysToRenewal. ' días ', $html);
    
    // Generar tablas de beneficiarios, mascotas y riders
    
    $beneficiariesRows = '';
    $totalShow = isset($data['beneficiaries']['totalShow']) ? (int)$data['beneficiaries']['totalShow'] : 0;
    $showedSeparator = false; // Bandera para controlar si ya mostramos el separador

    for ($i = 1; $i <= 10; $i++) {
        $beneficiaryKey = "beneficiary" . ($i == 1 ? 'One' : ($i == 2 ? 'Two' : ($i == 3 ? 'Three' : ($i == 4 ? 'Four' : 
                        ($i == 5 ? 'Five' : ($i == 6 ? 'Six' : ($i == 7 ? 'Seven' : ($i == 8 ? 'Eight' : ($i == 9 ? 'Nine' : 'Ten')))))))));
        
        $beneficiaryExists = isset($data['beneficiaries'][$beneficiaryKey]) && !empty($data['beneficiaries'][$beneficiaryKey]['name']);
        
        $beneficiariesRows .= '<tr>';
        $beneficiariesRows .= '<td>' . $i . '</td>';
        
        if ($totalShow > 0 && $i > $totalShow) {
            if (!$showedSeparator) {
                // Mostrar ============= solo en el primer beneficiario después del límite
                $beneficiariesRows .= '<td class="td-left">=========================</td>';
                $beneficiariesRows .= '<td>=============</td>';
                $beneficiariesRows .= '<td>=============</td>';
                $beneficiariesRows .= '<td>=============</td>';
                $beneficiariesRows .= '<td>=============</td>';
                $showedSeparator = true;
            } else {
                // Beneficiarios siguientes vacíos
                $beneficiariesRows .= '<td class="td-left"></td>';
                $beneficiariesRows .= '<td></td>';
                $beneficiariesRows .= '<td></td>';
                $beneficiariesRows .= '<td></td>';
                $beneficiariesRows .= '<td></td>';
            }
        } else {
            // Mostrar información normal del beneficiario
            $beneficiariesRows .= '<td class="td-left">' . 
                                 ($beneficiaryExists ? ($data['beneficiaries'][$beneficiaryKey]['name'] ?? '') . ' ' . 
                                                  ($data['beneficiaries'][$beneficiaryKey]['lastName'] ?? '') : '') . '</td>';
            $beneficiariesRows .= '<td>' . ($beneficiaryExists ? ($data['beneficiaries'][$beneficiaryKey]['relationship'] ?? '') : '') . '</td>';
            $beneficiariesRows .= '<td>' . ($beneficiaryExists ? 'Activo' : '') . '</td>';
            $beneficiariesRows .= '<td>' . ($beneficiaryExists ? (date('M/d/Y', strtotime($data['beneficiaries'][$beneficiaryKey]['birthdate'])) ?? '') : '') . '</td>';
            $beneficiariesRows .= '<td>' . ($beneficiaryExists ? date('M/d/Y', strtotime($data['initialDate'])) : '') . '</td>';
        }
        
        $beneficiariesRows .= '</tr>';
    }
        // Generar tabla de mascotas
    $petsRows = '';
    if (isset($data['pets']) && is_array($data['pets'])) {
        foreach ($data['pets'] as $pet) {
            $hasPet = !empty($pet['name']);
            $siSelected = $hasPet ? 'selected' : '';
            $noSelected = $hasPet ? '' : 'selected';
            
            $petsRows .= '<tr>
                <td class="label">Mascota</td>
                <td class="option-cell">
                    <div class="checkbox-container">
                        <span class="checkbox-option ' . $siSelected . '"></span>
                        <span class="checkbox-label">SI</span>
                    </div>
                    <div class="checkbox-container">
                        <span class="checkbox-option ' . $noSelected . '"></span>
                        <span class="checkbox-label">NO</span>
                    </div>
                </td>
                <td class="label">Cobertura</td>
                <td class="value-cell">' . ($hasPet ? ($pet['coverage'] ?? '') : '') . '</td>
                <td class="label">Nombre</td>
                <td class="value-cell">' . ($hasPet ? ($pet['name'] ?? '') : '') . '</td>
            </tr>';
        }
    } else {
        $petsRows .= '<tr>
            <td class="label">Mascota</td>
            <td class="option-cell">
                <div class="checkbox-container">
                    <span class="checkbox-option"></span>
                    <span class="checkbox-label">SI</span>
                </div>
                <div class="checkbox-container">
                    <span class="checkbox-option selected"></span>
                    <span class="checkbox-label">NO</span>
                </div>
            </td>
            <td class="label">Cobertura</td>
            <td class="value-cell"></td>
            <td class="label">Nombre</td>
            <td class="value-cell"></td>
        </tr>';
    }

    // Generar tabla de riders
    $ridersRows = '';
    $riderCount = 0;
    $riderOrder = ['riderOne', 'riderTwo', 'riderThree', 'riderFour', 'riderFive', 'riderSix'];

    foreach ($riderOrder as $riderKey) {
        if (isset($data['rider'][$riderKey]) && !empty($data['rider'][$riderKey]['name'])) {
            $rider = $data['rider'][$riderKey];
            $riderCount++;

            $isChecked = isset($rider['itsChecked']) && strtolower($rider['itsChecked']) === 'yes';
            $siSelected = $isChecked ? 'selected' : '';
            $noSelected = $isChecked ? '' : 'selected';
            
            $ridersRows .= '<tr>
                <td class="label">' . htmlspecialchars($rider['name']) . '</td>
                <td class="option-cell">
                    <div class="checkbox-container">
                        <span class="checkbox-option ' . $siSelected . '"></span>
                        <span class="checkbox-label">SI</span>
                    </div>
                    <div class="checkbox-container">
                        <span class="checkbox-option ' . $noSelected . '"></span>
                        <span class="checkbox-label">NO</span>
                    </div>
                </td>
                <td class="label">Cobertura</td>
                <td class="value-cell">' . htmlspecialchars('$' . $rider['price'] . ' - Espera: ' . $rider['tiempoEspera'] . ' días') . '</td>
            </tr>';
        }
    }

    if ($riderCount === 0) {
        $ridersRows .= '<tr>
            <td class="label">Repatriacion</td>
            <td class="option-cell">
                <div class="checkbox-container">
                    <span class="checkbox-option"></span>
                    <span class="checkbox-label">SI</span>
                </div>
                <div class="checkbox-container">
                    <span class="checkbox-option selected"></span>
                    <span class="checkbox-label">NO</span>
                </div>
            </td>
            <td class="label">Cobertura</td>
            <td class="value-cell"></td>
        </tr>';
    }

    $html = str_replace('BeneficiariesTable', $beneficiariesRows, $html);
    $html = str_replace('PetsTable', $petsRows, $html);
    $html = str_replace('RidersTable', $ridersRows, $html);
    
    // Generar PDF
    $dompdf = new Dompdf();
    $dompdf->set_option('isRemoteEnabled', true);
    $dompdf->load_html($html);
    $dompdf->set_paper("letter", "portrait");
    $dompdf->render();
    
    return $dompdf->output();
}
 
function processRenewalNotices() {
    global $obj_bdmysql, $conn, $obj_function;
   
   logMessage("Iniciando cron de renovación");

    $today = new DateTime();
    $todayStr = $today->format('Y-m-d');
    
    // Intervalos de días para enviar avisos (90, 60, 30 días antes)
    $intervals = [90, 60, 30];
    
    foreach ($intervals as $days) {
       

        // Calcular la fecha objetivo (fecha de vencimiento - X días)
        $targetDate = clone $today;
        $targetDate->add(new DateInterval("P{$days}D"));
        $targetDateStr = $targetDate->format('Y-m-d');

         logMessage("Procesando intervalo de $days días. Fecha objetivo: $targetDateStr");
        
        // Consulta para encontrar pólizas que vencen exactamente en X días
        $sql = "SELECT cs.*, cc.name, cc.last_name , cc.id AS id_contacts
                FROM contacts_services cs
                JOIN opportunities opp ON cs.id_opportunities = opp.id
                JOIN contacts cc ON opp.id_contacts = cc.id 
                WHERE cs.id_status_services IN(24,55) AND cs.id_services IN(209,210,262)
                AND DATE(DATE_ADD(cs.date_sale, INTERVAL 365 DAY)) = '$targetDateStr'";       

        $services = mysqli_query($conn, $sql) or die($sql); 
        logMessage("Consulta ejecutada. Resultados encontrados: " . mysqli_num_rows($services));

        while ($service = mysqli_fetch_array($services)) {
           
            logMessage("Procesando contrato: " . ($service['agreement_number'] ?? 'N/A'), [], 'INFO');

            $dataJson = json_decode($service['data_json'], true);            
            
            if (!isset($dataJson['holder']['email']) || empty($dataJson['holder']['email'])) {  
                logMessage("Email del titular no encontrado", [
                    'contract' => $service['agreement_number'] ?? 'unknown',
                    'service_id' => $service['id'] ?? 'unknown'
                ], 'WARNING');
                continue;
            }
            
            if (!isset($dataJson['payment']['agentEmail']) || empty($dataJson['payment']['agentEmail'])) { 
                logMessage("Email del agente no encontrado", [
                    'contract' => $service['agreement_number'] ?? 'unknown',
                    'agent_id' => $dataJson['payment']['agentId'] ?? 'unknown'
                ], 'WARNING');
                continue;
            }
            
         
            $holderName = $dataJson['holder']['name'] ?? '';
            $holderLastName = $dataJson['holder']['lastName'] ?? '';
            
            if (empty($holderName)) {
                $holderName = $service['first_name'] ?? '';
                $holderLastName = $service['last_name'] ?? '';
            }
            
            // Calcular fechas importantes
            $saleDate = new DateTime($service['date_sale']);
            $renewalDate = clone $saleDate;
            $renewalDate->add(new DateInterval('P1Y')); // +1 año
            
             
            $pdfData = [
                'saleDate' => $saleDate->format('m/d/Y'),
                'holderName' => trim("{$holderName} {$holderLastName}"),
                'planName' => $service['plan_name'] ?? ($dataJson['payment']['typePlan'] ?? ''),
                'agreementNumber' => $service['agreement_number'],
                'paymentMethod' => $dataJson['payment']['paymentMethod'] ?? '',
                'nextPayment' => $dataJson['payment']['nextPayment'] ?? '',
                'amountDueToday' => $dataJson['payment']['amountDueToday'] ?? '',
                'initialDate' => $saleDate->format('m/d/Y'),
                'renewalDate' => $renewalDate->format('m/d/Y'),
                'beneficiaries' => $dataJson['beneficiaries'] ?? [],
                'pets' => $dataJson['pets'] ?? [],
                'riders' => $dataJson['rider'] ?? []
            ];
            
            // Generar el PDF
            $pdfContent = generateRenewalPDF($pdfData, $days);
            
            // Preparar el email
            $subject = "Plan Raices - Aviso de Renovación (a {$days} días) - " . $pdfData['agreementNumber'];
            $body = "<p>Estimado/a {$pdfData['holderName']},</p>
                    <p>Le informamos que su plan de asistencia funeraria está a {$days} días de llegar a su año aniversario.</p>
                    <p>Adjunto encontrará el aviso de renovación con todos los detalles de su plan.</p>
                    <p>Para cualquier consulta, no dude en contactarnos al +1(786) 567-9818 o clientes@planraices.com</p>
                    <p>Atentamente,<br>Equipo Plan Raices Internacional</p>";
            
            // Obtener emails desde el JSON
            $to = $dataJson['holder']['email'];
            $cc = $dataJson['payment']['agentEmail'];
            
             
            if (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
                logMessage("Email del titular no válido", [
                    'email' => $to,
                    'contract' => $service['agreement_number'] ?? 'unknown',
                    'validation_error' => filter_var($to, FILTER_VALIDATE_EMAIL) === false ? 'Formato inválido' : 'Otro error'
                ], 'ERROR');
                continue;
            }
            
            if (!filter_var($cc, FILTER_VALIDATE_EMAIL)) {
                logMessage("Email del agente no válido", [
                    'email' => $cc,
                    'contract' => $service['agreement_number'] ?? 'unknown',
                    'validation_error' => filter_var($cc, FILTER_VALIDATE_EMAIL) === false ? 'Formato inválido' : 'Otro error'
                ], 'ERROR');
                $cc = null;  
            }
            
            // Obtener configuración del servidor de correo
            $sql = "SELECT name, host, security AS SMTPSecure, port, is_smtp AS isSMTP, smtp_auth AS SMTPAuth, 
                    user AS from_email, password
                    FROM email_server_setting
                    WHERE type_related = 3 AND id_client = 149";  
            $results = $obj_bdmysql->query($sql, $conn);
            
            if (empty($results)) {
                logMessage("Configuración de servidor de correo no encontrada", [
                    'contract' => $service['agreement_number'] ?? 'unknown'
                ], 'ERROR');
                continue;
            }
            
            $isSMTP = $results[0]['isSMTP'];
            $host = $results[0]['host'];
            $port = $results[0]['port'];
            $SMTPSecure = $results[0]['SMTPSecure'];
            $SMTPAuth = $results[0]['SMTPAuth'];
            $from_email = $results[0]['from_email'];
            $name = $results[0]['name'];
            $password = $results[0]['password'];
            
            // Obtener id_related (contacto)
            $sql = "SELECT opp.id_contacts AS id_related FROM contacts_services cs
                    JOIN opportunities opp ON cs.id_opportunities = opp.id
                    WHERE cs.id = " . $service['id'];
            $result = $obj_bdmysql->query($sql, $conn);
            $id_related = $result[0]['id_related'];
            
            // Configurar parámetros para sendEmail
            $tracking = '0';
            $recipient_type = '1'; // 1 para contact
            $header = '0';
            $footer = '0';
            $count = '';
            $random_id = rand();
            $bcc = $cc ? $cc : '';
            $bcc .= ", clientes@planraices.com, renewals@innovusgroup.us";
            
            // Adjuntar PDF
            $strg_pdf = $pdfContent;
            $name_pdf = ['Aviso_Renovacion_Raices_Internacional'];
                       
            $salida = $obj_function->sendEmail2(
                $isSMTP, 
                $host, 
                $port, 
                $SMTPSecure, 
                $SMTPAuth, 
                $from_email, 
                $name, 
                $password, 
                $to, 
                "", // CC vacío (usamos BCC para el agente)
                $bcc, 
                $subject, 
                $body, 
                "", // files
                $tracking, 
                $random_id, 
                $count, 
                $recipient_type, 
                $id_related, 
                $header, 
                $footer, 
                $strg_pdf,
                $name_pdf
            );
            
            if ($salida == 'Email Sent') {
                logMessage("Aviso de renovación enviado exitosamente", [
                    'email' => $to,
                    'days_before' => $days,
                    'contract' => $service['agreement_number'] ?? 'unknown',
                    'sent_at' => date('Y-m-d H:i:s')
                ], 'INFO');
                
                // Registrar en base de datos que se envió el aviso
                $campo = "id_contacts_services, notice_days_before, sent_date, sent_to, sent_cc";
                $valores = "'".$service['id']."', '".$days."', NOW(), '".$to."', '".($cc ?? '')."'";
                $obj_bdmysql->insert("renewal_notices_log", $campo, $valores, $conn);   
                history($services['id_contacts'], 20, $service['id'], $service['person_interacting']);  
            } else {
                logMessage("Error al enviar aviso de renovación", [
                    'email' => $to,
                    'days_before' => $days,
                    'contract' => $service['agreement_number'] ?? 'unknown',
                    'error' => $salida
                ], 'ERROR');
            }
        }
      
    }

    logMessage("Cron de renovación finalizado");
}

function htmlRenovation() { 
    return '<!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Raices Internacional - Aviso de Renovacion <span>Anio</span></title> 
            <style type="text/css">
                * {
                    margin: 0;
                    padding: 0;
                    text-indent: 0;
                    font-family: Arial, sans-serif;
                }
                body {
                    padding: 20px;
                    color: #243745;
                }
                /* NUEVOS ESTILOS PARA LA CABECERA */
                .header-container {
                    margin-bottom: 10px;
                }
                .date-container {
                    text-align: right;
                    margin-bottom: 10px;
                    font-size: 11pt;
                    color: #041c40;
                }
                .logo-container {
                    text-align: center;
                    margin-bottom: 10px;
                }
                /* FIN NUEVOS ESTILOS */
                h1 {
                    color: #041c40;
                    font-style: italic;
                    font-weight: bold;
                    font-size: 15pt;
                    margin-bottom: 10px;
                    text-align: center;
                }
                h2 {
                    color: #041c40;
                    font-weight: bold;
                    font-size: 12pt;
                    margin: 10px 0;
                }
                p {
                    font-size: 10pt;
                    text-align: justify;
                    margin: 5px 0;
                    line-height: 1.2;
                }
                table {
                    width: 100%;
                    border-collapse: collapse;
                    font-size: 12px;
                }
                td,
                th {
                    border: 1px solid #ddd;
                    padding: 8px;
                    text-align: center;
                }
                th {
                    background: #0f1f47;
                    color: #fff;
                }
                .subtext {
                    text-align: center;
                    font-size: 10px;
                    color: #555;
                }
                .info-table {
                    width: 100%;
                    margin-top: 8px;
                    border-collapse: separate;
                    border-spacing: 5px;
                }
                .info-table .label {
                    background: #0f1f47;
                    color: #fff;
                    padding: 10px;
                    border-radius: 0px;
                    text-align: center;
                    width: 25%;
                }
                .info-table .value {
                    background: #fff;
                    padding: 10px;
                    border: 2px solid #0f1f47;
                    border-radius: 5px;
                    text-align: center;
                    width: 25%;
                }
                .table-section {
                    margin-top: 8px;
                }
                .beneficiarios-container {
                    margin-top: 10px;
                    width: 100%;
                    overflow-x: auto;
                }
                .beneficiarios-table {
                    width: 100%;
                    background: #d7dbe1;
                    border-radius: 5px;
                    table-layout: fixed;
                }
                .beneficiarios-table td,
                .beneficiarios-table th {
                    padding: 3px;
                    font-size: 9pt;
                }
                .beneficiarios-table th {
                    border: none;
                    background: #0f1f47;
                    color: #fff;
                    border-bottom: 1px solid #0f1f47;
                    text-align: center;
                }
                .beneficiarios-table .td-left {
                    text-align: left;
                }
                .contact-info {
                    margin-top: 10px;
                    font-weight: bold;
                }
                .footer {
                    font-size: 8pt;
                    margin-top: 10px;
                    color: #535353;
                    text-align: center;
                    border-top: 1px solid #ccc;
                    padding-top: 5px;
                    display: flex;
                    justify-content: space-between;
                }
                .addons-section {
                    width: 100%;
                    margin: 10px 0;
                }
                pet-detail-row td {
                    background-color: #f5f5f5;
                    font-size: 10pt;
                    padding: 5px 8px;
                }

                .addons-table {
                    width: 100%;
                    border-collapse: separate;
                }

                .addons-table td {
                    border: 1px solid #041c40;
                    padding: 8px;
                }

                .addons-table .label {
                    background: #041c40;
                    color: #fff;
                    font-weight: bold;
                    width: 20%;
                }
                .addons-table .option-cell { 
                    border: none; /* Sin borde */
                    vertical-align: middle;
                    width: 30%;
                }
                .addons-table .value-cell { 
                    border: 1px solid #041c40;
                    border-radius: 5px;
                    vertical-align: middle;
                    width: 25%;
                }
                .checkbox-container {
                    display: inline-block;
                    margin-right: 15px;
                }
                .checkbox-option {
                    display: inline-block;
                    width: 20px;
                    height: 20px;
                    border: 2px solid #041c40;
                    border-radius: 3px;
                    text-align: center;
                    line-height: 20px;
                    margin-right: 5px;
                    vertical-align: middle;
                }
                .checkbox-option.selected {
                    background-color: #041c40;
                    color: white;
                }
                .checkbox-option.selected::after {
                    content: "X";
                    font-size: 12px;
                    font-weight: bold;
                }
                .checkbox-label {
                    vertical-align: middle;
                    font-size: 10pt;
                }
               .footer {
                    position: fixed;
                    bottom: 0;
                    left: 0;
                    right: 0;
                    font-size: 9pt;
                    margin-top: 10px;
                    color: #535353;
                    text-align: center;
                    border-top: 1px solid #000;
                    padding: 5px 20px;
                    background-color: white;
                    display: flex;
                    justify-content: space-between;
                    align-items: center; 
                    height: 30px;
                }
                
                .footer-table {
                    width: 100%; 
                    border-collapse: collapse;
                }
                
                .footer-table td {
                    border: none;
                    padding: 0 10px;
                    vertical-align: middle; 
                    font-size: 7pt; 
                }
                
                .footer-table td:first-child {
                    text-align: left;
                    width: 80%; 
                    font-size: 6pt;
                }
                
                .footer-table td:last-child {
                    text-align: right;
                    width: 20%;
                }
            </style>
        </head>
        <body>
            <div class="header-container">
                <div class="logo-container">
                    <img style="width:100%;height:100%" alt="image" src="https://raices.gosmartcrm.com/assets/media/img/images/header-plan-raices.png" />
                </div>
                <div class="date-container">
                    <strong>Fecha</strong> <span style="border: 2px solid #041c40; padding: 10px">DateNow</span>
                </div>
            </div>
            <h1>AVISO DE RENOVACION</h1>

            <h2>Estimado cliente</h2>

            <p>
                Le informamos que su plan de Asistencia funeraria está a <strong>DiasRenovation</strong> a llegar a su año aniversario y por lo tanto le
                recordamos que según consta en las condiciones generales, su plan será renovado automáticamente conforme a la última
                información de pago contenida en nuestro sistema, a no ser que usted nos indique lo contrario. En el evento que usted
                quisiera cambiar el método, la forma o frecuencia de pago, por favor comuníquese con el departamento de Atención al
                Cliente a la brevedad al [Whatsapp] <strong>+1(786) 567-9818</strong> o enviando un email a
                <strong>clientes@planraices.com</strong>.
            </p>

            <p>
                En caso de haber realizado su pago por medio de una transferencia por medio de la plataforma Zelle o de haber
                realizado el pago en forma de dinero en efectivo, le sugerimos realice este pago con 3 días de anticipación al
                vencimiento de su plan para así evitar retrasos en la renovación y una posible pausa en su cobertura.
            </p>

            <table class="info-table">
                <tr>
                    <td class="label">Activación Inicial</td>
                    <td class="value">ActivationInicialDate</td>
                    <td class="label">Nombre del Plan</td>
                    <td class="value">PlanName</td>
                </tr>
                <tr>
                    <td class="label">Nombre del Titular</td>
                    <td class="value">HolderName</td>
                    <td class="label">No. de Membresia</td>
                    <td class="value">AgreementNumber</td>
                </tr>
                <tr>
                    <td class="label">Modalidad de Pago</td>
                    <td class="value">PaymentType</td>
                    <td class="label">Proximo Pago (USD)</td>
                    <td class="value">NextPayment</td>
                </tr>
                <tr>
                    <td class="label">Total a Pagar USD</td>
                    <td class="value">TotalPayment</td>
                    <td class="label">Nueva Vigencia</td>
                    <td class="value">NewDateRenovation</td>
                </tr>
            </table>

            <h2>Beneficiarios</h2>

            <div class="beneficiarios-container">
                <table class="beneficiarios-table">
                    <tr>
                        <th style="width: 5%">#</th>
                        <th style="width: 25%">Beneficiarios</th>
                        <th style="width: 15%">Relacion</th>
                        <th style="width: 15%">Estatus</th>
                        <th style="width: 15%">FDN</th>
                        <th style="width: 15%">Inicio Cobertura</th>
                    </tr>
                    BeneficiariesTable
                </table>
            </div> 
            <div style="height:110px"></div>
            <div class="footer">
                <table class="footer-table"> 
                    <tr>
                        <td>Los planes de <strong>Raices Internacional</strong> NO SON UN SEGURO, o plan de prepago, o plan de prenecesidad, ni similar. Los planes de <strong>Raices Internacionall</strong> son una membresía de coordinación de beneficios funerarios. El contenido de este documento es con propósitos informativos únicamente. El detalle y descripción de beneficios están incluidos en el Condicionado General. Todos los beneficios estan respaldados y coordinados por <strong>InnovusGroup,LLC</strong>.</td>
                        <td><strong>RAICES INTERNACIONAL</strong></td>
                    </tr>
                </table>
            </div>
        </body>
        </html>';
}

function logMessage($message, $context = [], $level = 'INFO') {
    global $logFile;
    
    $logEntry = [
        'timestamp' => date('Y-m-d H:i:s'),
        'level' => $level,
        'message' => $message,
        'context' => $context
    ];

    file_put_contents($logFile, json_encode($logEntry, JSON_PRETTY_PRINT) . PHP_EOL, FILE_APPEND);
}

 
processRenewalNotices();
function history($id_contacts, $type, $id_related, $id_user_crm) {

	global $conn, $obj_bdmysql;

	$campo = "id_contacts, type, id_related, id_user_crm";
	$valor = "$id_contacts, $type, $id_related, $id_user_crm";
 
	$obj_bdmysql->insert("contacts_history", $campo, $valor, $conn);
}
 