<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

include "/var/www/html/v103/common/generalWs.php";
include "/var/www/html/v103/vendor/autoload.php";

use PHPMailer\PHPMailer\PHPMailer;
//use Plivo\RestAPI;

$fecha = date("Ymd-His");
$mail = new PHPMailer;
$obj_function = new coFunction();
$obj_bdmysql = new coBdmysql();
$conn = mysqli_connect(DBHOST, DBUSER, DBPASS, DBNOM) or die("Connection failed: " . mysqli_connect_error());

//Buscar si hay transacciones pendientes
// error_log("cronGeneral - Jc $fecha >>> \n", 3, '/var/www/html/v103/app/ws/cronGeneralEmail');

$sql = "SELECT COUNT(atr.id) 
    FROM automation_transaction atr
    JOIN automation_node an ON atr.id_automation_node = an.id 
    WHERE atr.status IN (1,3) AND an.id_type_node = 3";
$queryPendingTransactions = mysqli_fetch_array(mysqli_query($conn, $sql)) or die($sql);


if ($queryPendingTransactions[0] > 0) {

    //Buscar transacciones EMAIL
    $batch_mail_id = 'mail' . uniqid();

    $stmt = $conn->prepare("CALL spCronEmailTransactionInProcess(?)");
    $stmt->bind_param("s", $batch_mail_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();
    $queryStatusMail = mysqli_query($conn, $sql) or die($sql);

    if ($queryStatusMail != '') {
        $sql = "SELECT atr.id AS id_query_transaction, atr.type as transaction_type, atr.id_related, atr.id_automation_node
      FROM automation_transaction atr
      WHERE atr.batch = '$batch_mail_id'";
        $query = $obj_bdmysql->query($sql, $conn);

        if ($query != 0) {
            processEmail($query);
        }
    }

    $sql = "SELECT atr.id AS id_query_transaction, atr.type as transaction_type, atr.id_related, atr.id_automation_node, an.id_type_node
    FROM automation_transaction atr
    JOIN automation_node an ON atr.id_automation_node = an.id
    WHERE atr.status = 3 AND an.id_type_node = 3 AND atr.retries > 3";
    $query = $obj_bdmysql->query($sql, $conn);
    if ($query != 0) {
        $query = $obj_bdmysql->query($sql, $conn);
        $campo = "status = 4";
        $where = "status = 3 AND retries > 3";
        $obj_bdmysql->update("automation_transaction", $campo, $where, $conn);
    }

    // Llamada a spCore
    $test = $obj_bdmysql->query("CALL spCore()", $conn, FALSE, 'CALL');

    function addToString($str, $item)
    {
        $parts = explode(',', $str);
        $parts[] = $item;

        return implode(',', $parts);
    }
} else {
    $mss = 'No Pending Transactions';
    echo " >>> ", $mss, " <<<\n";
}


//Funcion para EMAIL

// function sendEmail($id_transaction, $isSMTP, $host, $port, $SMTPSecure, $SMTPAuth, $email_cc, $email_bcc, $email_sender, $password, $sender_name, $email_to, $email_subject, $email_message, $transaction_type, $id_email_server_setting, $id_related, $id_user_crm, $email_attachment, $email_to_user, $bulk_email)
function sendEmail($id_transaction, $isSMTP, $host, $port, $SMTPSecure, $SMTPAuth, $email_cc, $email_bcc, $email_sender, $password, $sender_name, $email_to, $email_subject, $email_message, $transaction_type, $id_email_server_setting, $id_related, $id_user_crm, $email_attachment, $email_to_user, $bulk_email)
{

    // var_dump($isSMTP, 'isSMTP', $SMTPAuth, 'SMTPAuth', $email_sender, 'email_sender', $password, 'password', $SMTPSecure, '$SMTPSecure', $email_cc, 'email_cc');
    global $mail, $conn, $obj_bdmysql;

    $mail->ClearAddresses();  // each AddAddress add to list
    $mail->ClearCCs();
    $mail->ClearBCCs();

    //Solo habilitado por problemas de certificado OJO *********************************
    // $mail->SMTPAutoTLS = false;
    // $mail->SMTPSecure = false;
    //Solo habilitado por problemas de certificado OJO *********************************

    error_log("ln 534: sendEmail >>> $id_transaction, $isSMTP, $host, $port, $SMTPSecure, $SMTPAuth, $email_cc, $email_bcc, $email_sender, $password, $sender_name, $email_to, $email_subject, $email_message, $transaction_type, $id_email_server_setting, $id_related, $id_user_crm, $email_attachment, $email_to_user, $bulk_email\n", 3, '/var/www/html/v103/app/ws/cronGeneralError');

    $addCC = explode(",", $email_cc);
    $addBCC = explode(",", $email_bcc);
    $random_id = rand();

    //$mail = new PHPMailer;

    //$mail->SMTPDebug = 3;
    if ($isSMTP == 1) {
        $mail->isSMTP();
    }
    $mail->CharSet = "utf-8";
    $mail->Host = $host;
    $mail->Port = $port;
    if ($SMTPSecure == 1) {
        $mail->SMTPSecure = 'tls';
    } elseif ($SMTPSecure == 2) {
        $mail->SMTPSecure = 'ssl';
    } else {
        $mail->SMTPSecure = false;
    }
    if ($SMTPAuth == 1) {
        $mail->SMTPAuth = true;
    } else {
        $mail->SMTPAuth = false;
    }

    if ($bulk_email == 0) {
        $mail->Username = $email_sender;
        $mail->Password = $password;
        $mail->setFrom($email_sender, $sender_name);
    } elseif ($bulk_email == 1) {
        $mail->Username = MJ_API_KEY;
        $mail->Password = MJ_SECRET_KEY;
        $mail->setFrom($email_sender);
    }

    $mail->addAddress($email_to);
    //$mail->addAddress('dimasjbs@gmail.com'); //for testting only

    foreach ($addCC as $email) {
        if ($email != '') {
            $mail->addCC($email);
        }
    }

    if ($email_to_user != '') {
        $mail->addCC($email_to_user);
    }

    foreach ($addBCC as $email) {
        if ($email != '') {
            $mail->addBCC($email);
        }
    }

    $mail->Subject = $email_subject;
    //$mail->Body = $email_plain_message;
    //$mail->AltBody = $email_plain_message;
    //$mail->MsgHTML($email_message);
    if ($email_attachment != '' || $email_attachment != null) {
        // $email_attachment = '/var/www/html/v103/app/'.$email_attachment;
        // $mail->addAttachment($email_attachment);
        $mail->addStringAttachment(file_get_contents($email_attachment), $email_attachment);
    }

    // Inicio tracking Pixel (construye el body con el message a enviar)
    $originalImage = "/var/www/html/v103/img/tracking/LogoPowered.jpg";
    $userImage = "/var/www/html/v103/img/tracking/LogoPowered_" . $random_id . ".jpg";
    $urlImageSource = "https://services.gosmartcrm.com/img/tracking/LogoPowered_" . $random_id . ".jpg";
    copy($originalImage, $userImage);

    if (substr_count($email_message, '<html>') > 0) {
        $email_message = str_replace("</html>", "<img src=" . $urlImageSource . "></html>", $email_message);
    } else {
        $email_message = "<html>" . $email_message . "<img src=" . $urlImageSource . "></html>";
    }
    //Fin tracking pixel
    error_log('sendEmail >>> 1');
    // Inicio verificacion merge fields (construye el body con campos genericos) ----------------------------------------------------------
    if ($transaction_type == 1) {
        //caso contact
        $sql = "SELECT c.name, c.last_name, c.title, c.tags, c.score, uc.name AS name_user_crm, uc.cell, uc.email FROM contacts c 
        LEFT JOIN user_crm uc ON c.id_user_crm = uc.id
        WHERE c.id  = $id_related";
        $query = mysqli_query($conn, $sql) or die($sql);
        $data = mysqli_fetch_assoc($query);
    } elseif ($transaction_type == 2) {
        //caso lead
        $sql = "SELECT l.full_name ,l.city ,l.country ,l.zip, uc.name AS name_user_crm, uc.cell, uc.email FROM leads l
        LEFT JOIN leads_user lu ON l.id = lu.id_leads
        LEFT JOIN user_crm uc ON lu.id_user_crm = uc.id 
        WHERE l.id = $id_related";
        $query = mysqli_query($conn, $sql) or die($sql);
        $data = mysqli_fetch_assoc($query);
    } elseif ($transaction_type == 3) {
        //caso user_crm
        $sql = "SELECT uc.name, uc.cell, uc.email FROM user_crm uc WHERE id = $id_related";
        $query = mysqli_query($conn, $sql) or die($sql);
        $data = mysqli_fetch_assoc($query);
    }

    $sql = "SELECT name, value, type_merge_field FROM merge_field WHERE status = 1";
    $query = mysqli_query($conn, $sql) or die($sql);
    extract(mysqli_fetch_array($query));

    error_log('sendEmail >>> 2');
    foreach ($query as $row) {

        $merge_field_name = $row['name'];
        $merge_field_value = $row['value'];

        if (strpos($email_message, $merge_field_name) !== false) {
            $value_data = $data["$merge_field_value"];
            $email_message = str_replace($merge_field_name, $value_data, $email_message);
        }
    }
    //Fin verificacion merge fields ---------------------------------------------------------------------------------------------------

    error_log('sendEmail >>> 3');
    //$mail->Body = utf8_encode(utf8_decode($email_message));
    $mail->Body = $email_message;
    $mail->isHTML(true);
    //$mail->send();

    if ($mail->send()) {

        //error_log('ln 1041: sendEmail >>> Email send',3, '/var/www/html/v103/app/ws/cronGeneralError');

        //echo "CALL nextTransaction($id_transaction, 'yes', '0'";
        $obj_bdmysql->query("CALL nextTransaction($id_transaction, 'yes', '0')", $conn, FALSE, 'CALL');

        // Llenar History
        if ($transaction_type == 1) {
            //caso contact

            $campo = "id_user_crm, module_origin, id_email_server_setting, email_to, email_cc, email_bcc, email_subject, email_body, email_attachment, id_related, type_related,send_date, tracking_name";
            $valor = "$id_user_crm, 1, $id_email_server_setting, '$email_to', '$email_cc','$email_bcc', '$email_subject', '$email_message', '', $id_related, 1, now(), 'LogoPowered_$random_id'";
            $id_email = $obj_bdmysql->insert("email_board", $campo, $valor, $conn);

            $campo = "id_contacts, type, id_related, id_user_crm";
            $valor = "$id_related, 7, $id_email, $id_user_crm";
            $obj_bdmysql->insert("contacts_history", $campo, $valor, $conn);
        } elseif ($transaction_type == 2) {
            //caso lead

            $hora = gmdate("Y-m-d H:i:s");

            // $campo = "id_user_crm, id_email_server_setting, email_to, email_cc, email_bcc, email_subject, email_body, email_atachment, id_lead";
            // $valor = "$id_user_crm, $id_email_server_setting, '$email_to','$addCC','$addBCC', '$email_subject', '$email_message', '', $id_related";
            // $id_leads_history_email = $obj_bdmysql->insert("leads_history_email", $campo, $valor, $conn);

            $campo = "id_user_crm, module_origin, id_email_server_setting, email_to, email_cc, email_bcc, email_subject, email_body, email_attachment, id_related, type_related,send_date, tracking_name";
            $valor = "$id_user_crm, 3, $id_email_server_setting, '$email_to', '$email_cc','$email_bcc', '$email_subject', '$email_message', '', $id_related, 2, now(), 'LogoPowered_$random_id'";
            $id_email = $obj_bdmysql->insert("email_board", $campo, $valor, $conn);

            $campo = "id_leads, type, id_related, id_user_crm, id_agents, id_status_lead, response, migracion, date_created";
            $valor = "$id_related, 12, $id_email, $id_user_crm, 0, 0, 'From Automation','','$hora'";
            $obj_bdmysql->insert("leads_history", $campo, $valor, $conn);

            $campo = "updated = '$hora'";
            $where = "id= $id_related";
            $obj_bdmysql->update("leads", $campo, $where, $conn);
        } elseif ($transaction_type == 3) {
            //caso user crm

            $campo = "id_agent, type, id_related, id_user_crm";
            $valor = "'$id_related', '11', '$id_transaction','$id_user_crm'";
            $id_lead_history_call = $obj_bdmysql->insert("agents_history", $campo, $valor, $conn);
        }
    } else {
        error_log("ln 706: sendEmail >>> $email_sender >>>" . $mail->ErrorInfo . '\n', 3, '/var/www/html/v103/app/ws/cronGeneralError');

        $campo = "retries = retries + 1";
        $where = "id = '$id_transaction'";
        $obj_bdmysql->update("automation_transaction", $campo, $where, $conn);

        $mail_error = $mail->ErrorInfo;
        echo 'Message could not be sent.';
        echo 'Mailer Error: ' . $mail->ErrorInfo;
    }
}

function processEmail($query)
{
    global $conn, $obj_bdmysql;
    $email_to_user = '0';

    error_log('processEmail');

    foreach ($query as $row) {

        error_log(print_r($row));

        $id_related = $row['id_related'];
        $transaction_type = $row['transaction_type'];
        $id_query_transaction = $row['id_query_transaction'];
        $id_automation_node = $row['id_automation_node'];
        $id_email_server_setting = 0;
        $email_subject = 'Demo';
        $email_attachment = '';

        if ($transaction_type == 1) {
            //caso type Is Contact
            $sql = "SELECT atr.id AS id_transaction, ce.email AS email_to, ess.user AS email_sender,ane.cc_email AS email_cc, ane.email_attachment, ane.bcc_email AS email_bcc, ane.subbject as email_subject, ane.text AS email_plain_message, ane.html AS email_html_message, ess.name as sender_name, ess.host, ess.security AS SMTPSecure, ess.port, ess.is_smtp AS isSMTP, ess.smtp_auth AS SMTPAuth, ess.user AS email_senderess, ess.password AS password, ess.id AS id_email_server_setting, uc.id AS id_user_crm, ane.email_to_user, ane.bulk_email
        FROM automation_node_email ane
        JOIN automation_node an ON an.id = ane.id_automation_node
        JOIN automation aut ON aut.id = an.id_automation
        JOIN automation_transaction atr ON atr.id_automation_node = an.id
        JOIN email_server_setting ess ON ess.id = ane.id_email_server_setting
        JOIN contacts c ON c.id = atr.id_related
        JOIN (SELECT MAX(id) AS id, email, id_contacts FROM contacts_email GROUP BY id_contacts) ce ON ce.id_contacts = c.id
        JOIN user_crm uc ON c.id_user_crm = uc.id
        WHERE ane.id_automation_node = $id_automation_node AND atr.id = $id_query_transaction";

            $query = mysqli_query($conn, $sql) or die($sql);
            echo $sql;
            extract(mysqli_fetch_array($query));
        } elseif ($transaction_type == 2) {
            // caso type Is Lead

            $sql = "SELECT atr.id AS id_transaction, l.email AS email_to, ess.user AS email_sender,ane.cc_email AS email_cc, ane.email_attachment, ane.bcc_email AS email_bcc, ane.subbject as email_subject, ane.text AS email_plain_message, ane.html AS email_html_message, ess.name as sender_name, ess.host, ess.security AS SMTPSecure, ess.port, ess.is_smtp AS isSMTP, ess.smtp_auth AS SMTPAuth, ess.user AS email_senderess, ess.password AS password, ess.id AS id_email_server_setting, ane.email_to_user, ane.bulk_email
        FROM automation_node_email ane
        JOIN automation_node an ON an.id = ane.id_automation_node
        JOIN automation aut ON aut.id = an.id_automation
        JOIN automation_transaction atr ON atr.id_automation_node = an.id
        JOIN email_server_setting ess ON ess.id = ane.id_email_server_setting
        JOIN leads l ON l.id = atr.id_related
        WHERE ane.id_automation_node = $id_automation_node AND l.id = $id_related AND atr.id = $id_query_transaction";

            $query = mysqli_query($conn, $sql) or die($sql);
            extract(mysqli_fetch_array($query));

            $id_user_crm = 0;
        } elseif ($transaction_type == 3) {
            // caso type user crm
            $sql = "SELECT atr.id AS id_transaction, uc.email AS email_to, ess.user AS email_sender,ane.cc_email AS email_cc, ane.email_attachment, ane.bcc_email AS email_bcc, ane.subbject as email_subject, ane.text AS email_plain_message, ane.html AS email_html_message, ess.name as sender_name, ess.host, ess.security AS SMTPSecure, ess.port, ess.is_smtp AS isSMTP, ess.smtp_auth AS SMTPAuth, ess.user AS email_senderess, ess.password AS password, ess.id AS id_email_server_setting, uc.id AS id_user_crm, ane.email_to_user, ane.bulk_email
        FROM automation_node_email ane
        JOIN automation_node an ON an.id = ane.id_automation_node
        JOIN automation aut ON aut.id = an.id_automation
        JOIN automation_transaction atr ON atr.id_automation_node = an.id
        JOIN email_server_setting ess ON ane.id_email_server_setting = ess.id
        JOIN user_crm uc ON atr.id_related = uc.id
        WHERE ane.id_automation_node = $id_automation_node AND atr.id = $id_query_transaction";

            $query = mysqli_query($conn, $sql) or die($sql);
            extract(mysqli_fetch_array($query));
        }

        if ($email_to_user != '0') {

            //--------------------------Inicio Adicion de correo de owner de lead/contact-----------------------------

            $sql = "SELECT atrig.when_this_happens 
          FROM automation_trigger atrig
          LEFT JOIN automation_node an ON an.id_automation = atrig.id_automation 
          WHERE an.id = $id_automation_node";
            $query = mysqli_query($conn, $sql) or die($sql); // Buscar trigger de la automatizacion
            extract(mysqli_fetch_array($query));

            $conditions_lead = array(3, 4, 7); //triggers que son de lead
            $conditions_contact = array(1, 2, 8, 9); //triggers que son de contact

            if (in_array($when_this_happens, $conditions_lead)) { //buscar id owner caso lead

                $sql = "SELECT uc.id AS id_owner_email
          FROM user_crm uc
          LEFT JOIN leads_user lu ON lu.id_user_crm = uc.id
              WHERE lu.id_leads = $id_related LIMIT 1";
            }

            if (in_array($when_this_happens, $conditions_contact)) { //buscar id owner caso contact

                $sql = "SELECT uc.id AS id_owner_email
          FROM user_crm uc
          LEFT JOIN contacts c ON c.id_user_crm = uc.id
              WHERE c.id = $id_related LIMIT 1";
            }

            $sql = "SELECT email AS user_email FROM user_crm WHERE id = $email_to_user";
            $query = mysqli_query($conn, $sql) or die($sql);
            extract(mysqli_fetch_array($query));

            if ($email_html_message == '') {
                $email_message = $email_plain_message;
            } else {
                $email_message = $email_html_message;
            }

            $transaction_type = 3;

            sendEmail($id_transaction, $isSMTP, $host, $port, $SMTPSecure, $SMTPAuth, $email_cc, $email_bcc, $email_sender, $password, $sender_name, $email_to, $email_subject, $email_message, $transaction_type, $id_email_server_setting, $id_related, $id_user_crm, $email_attachment, $user_email, $bulk_email);
        } else {

            if ($id_email_server_setting != 0) {
                if ($email_html_message == '') {
                    $email_message = $email_plain_message;
                } else {
                    $email_message = $email_html_message;
                }

                sendEmail($id_transaction, $isSMTP, $host, $port, $SMTPSecure, $SMTPAuth, $email_cc, $email_bcc, $email_sender, $password, $sender_name, $email_to, $email_subject, $email_message, $transaction_type, $id_email_server_setting, $id_related, $id_user_crm, $email_attachment, '', $bulk_email);
            } else {
                $campo = "retries = retries + 1";
                $where = "id = '$id_query_transaction'";
                $obj_bdmysql->update("automation_transaction", $campo, $where, $conn);
                error_log('sendEmail >>> 0 > Email NOT send > Not Email Server Setting or not email_to on transaction: ' . print_r($id_query_transaction, true));
            }
        }
        //die();

    }
}
