<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sitio en Mantenimiento</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #1a2a6c, #b21f1f, #1a2a6c);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: white;
            overflow: hidden;
            position: relative;
        }
        
        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: white;
            z-index: 1;
        }
        
        .container {
            text-align: center;
            z-index: 2;
            max-width: 800px;
            padding: 30px;
            background: rgba(0, 0, 0, 0.6);
            border-radius: 20px;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.4);
            backdrop-filter: blur(10px);
            animation: fadeIn 1s ease-out;
        }
        
        .logo-container {
            margin: 0 auto 30px;
            width: 250px;
            height: 250px;
            background: white;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            border: 5px solid #2b599f;
        }
        
        .logo-container img {
            max-width: 100%;
            max-height: 100%;
        }
        
        h1 {
            font-size: 3.5rem;
            margin-bottom: 20px;
            text-transform: uppercase;
            letter-spacing: 3px;
            color: #ff9047;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        }
        
        p {
            font-size: 1.5rem;
            margin-bottom: 30px;
            line-height: 1.6;
        }
        
        .highlight {
            color: #2b599f;
            font-weight: bold;
        }
        
        .countdown {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin: 40px 0;
        }
        
        .countdown-item {
            background: rgba(255, 255, 255, 0.1);
            padding: 15px;
            border-radius: 10px;
            min-width: 90px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        
        .countdown-number {
            font-size: 2.5rem;
            font-weight: bold;
            color: #ff9047;
        }
        
        .countdown-label {
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .contact {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .contact p {
            font-size: 1.1rem;
            margin: 10px 0;
        }
        
        .social-icons {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 20px;
        }
        
        .social-icons a {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            justify-content: center;
            align-items: center;
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .social-icons a:hover {
            transform: translateY(-5px);
            background: #ff9047;
            color: #1a2a6c;
        }
        
        .progress-bar {
            height: 10px;
            width: 100%;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 5px;
            overflow: hidden;
            margin: 20px 0;
        }
        
        .progress {
            height: 100%;
            width: 65%;
            background: linear-gradient(90deg, #ff9047, #ff9800);
            border-radius: 5px;
            animation: progress-animation 3s infinite alternate;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes progress-animation {
            from { width: 65%; }
            to { width: 75%; }
        }
        
        @media (max-width: 768px) {
            .container {
                width: 90%;
                padding: 20px;
            }
            
            h1 {
                font-size: 2.5rem;
            }
            
            p {
                font-size: 1.2rem;
            }
            
            .logo-container {
                width: 180px;
                height: 180px;
            }
            
            .countdown {
                flex-wrap: wrap;
            }
        }
    </style>
</head>
<body>
    <div class="overlay"></div>
    
    <div class="container">
        <div class="logo-container">
            <img src="../../assets/img/logo_main2.png" alt="Logo de la Empresa">
        </div>
        
        <h1>Sitio en Mantenimiento</h1>
        
        <p>Actualmente estamos realizando <span class="highlight">tareas de mantenimiento</span>.</p>
        
        <div class="progress-bar">
            <div class="progress"></div>
        </div>
        
        <p>Volveremos en línea lo antes posible. Gracias por tu paciencia.</p>
        
        

    </div>

    <script>
        // Simulación de cuenta regresiva
        function updateCountdown() {
            const days = document.getElementById('days');
            const hours = document.getElementById('hours');
            const minutes = document.getElementById('minutes');
            const seconds = document.getElementById('seconds');
            
            // Valores aleatorios para la demostración
            days.textContent = Math.floor(Math.random() * 3).toString().padStart(2, '0');
            hours.textContent = Math.floor(Math.random() * 24).toString().padStart(2, '0');
            minutes.textContent = Math.floor(Math.random() * 60).toString().padStart(2, '0');
            seconds.textContent = Math.floor(Math.random() * 60).toString().padStart(2, '0');
        }
        
        // Actualizar cada segundo
        setInterval(updateCountdown, 1000);
        updateCountdown();
    </script>
</body>
</html>