<?php
    include '../../common/general.php';
    if (! in_array('concierge_agents_credits', $_SESSION['key_word'])) {
        require 'error_page.php';
        die();
    }
    $obj_common = new common();
    $bdmysql    = new coBdmysql();
    $con        = mysqli_connect(DBHOST, DBUSER, DBPASS, DBNOM) or die(header('Location: connection_failed.php'));

    // error_reporting(E_ALL);
    // ini_set('display_errors', '1');

    $id_user_crm  = $_SESSION["id_user_crm"];
    $id_client    = $_SESSION["id_client"];
    $id_principal = $_SESSION["id_principal"];
    $parents      = $_SESSION["parents"];
    $id_role      = $_SESSION['id_role'];
    $ids          = $_SESSION["ids"];
    $name         = $_SESSION["name"];

    $title_table = $id_role == 1 ? 'Total_Agents_Credits' : 'My_Team_Credits';

    $strUsersAgent = "";
    $query         = "SELECT uc.id, uc.name, uc.code_agent, c.name as name_client  FROM user_crm uc
                      inner join client c on uc.id_client = c.id
                      WHERE uc.id_client = $id_client";

    $available_credits        = 0;
    $total_credits            = 0;
    $used_credits             = 0;
    $current_user_has_credits = false;

    if ($id_role != 1) {
        $query .= " AND uc.id != $id_user_crm";
        $query .= " AND uc.id IN ({$ids})";

        // 1. se obtienen los creditos disponibles del agente logueado
        $sql_user = "SELECT available_credits
                     FROM agent_credits
                     WHERE id_user_crm = $id_user_crm AND id_service IN (187, 188)";
        $result_user = $bdmysql->query($sql_user, $con);
        if (! empty($result_user)) {
            $available_credits        = $result_user[0]['available_credits'] ?? 0;
            $current_user_has_credits = ($available_credits > 0);
        }

        // 2. Calcular el total de créditos asignados al usuario logueado
        $sql_total = "SELECT SUM(total_credits) as sum_total
                  FROM agent_credits
                  WHERE id_user_crm = $id_user_crm AND id_service IN (187, 188)";
        $result_total  = $bdmysql->query($sql_total, $con);
        $total_credits = $result_total[0]['sum_total'] ?? 0;

        // Calcular los creditos usados, excluyendo su propio id (id_user_crm)
        $used_credits_user = 0;
        $used_credits_team = 0;

        // 1) Créditos usados por el propio usuario
        $sql_used_user = "SELECT SUM(used_credits) as sum_used_user
                  FROM agent_credits
                  WHERE id_user_crm = $id_user_crm AND id_service IN (187, 188)";
        $result_used_user  = $bdmysql->query($sql_used_user, $con);
        $used_credits_user = $result_used_user[0]['sum_used_user'] ?? 0;

        // 2) Créditos usados por el resto del equipo (excluyendo al propio usuario)
        $team_ids                = explode(',', $ids);
        $team_ids_excluding_self = array_filter($team_ids, function ($id) use ($id_user_crm) {
            return trim($id) != $id_user_crm;
        });

        if (! empty($team_ids_excluding_self)) {
            $ids_for_used_query = implode(',', $team_ids_excluding_self);
            $sql_used_team      = "SELECT SUM(used_credits) as sum_used_team
                       FROM agent_credits
                       WHERE id_user_crm IN ({$ids_for_used_query}) AND id_service IN (187, 188)";
            $result_used_team  = $bdmysql->query($sql_used_team, $con);
            $used_credits_team = $result_used_team[0]['sum_used_team'] ?? 0;
        }

        //Assigned Team
        $assigned_team_total = 0;
        if (! empty($ids)) {
            $sql_assigned_team = "SELECT COALESCE(SUM(CASE WHEN transaction_type IN ('assignment','initial_load') THEN credits WHEN transaction_type = 'subtract' THEN -credits ELSE 0 END),0) as sum_assigned
                                      FROM credit_transactions
                                      WHERE from_user_id = $id_user_crm
                                      AND to_user_id IN ({$ids})
                                      AND id_service IN (187, 188)";
            $result_assigned     = $bdmysql->query($sql_assigned_team, $con);
            $assigned_team_total = ! empty($result_assigned) && isset($result_assigned[0]['sum_assigned']) ? $result_assigned[0]['sum_assigned'] : 0;
        }

    }

    $filas = $bdmysql->query($query, $con);
    foreach ($filas as $fila) {
        $strUsersAgent .= '<option value="' . $fila['id'] . '" >' . (($fila['name'])) . ' - ID: ' . strtolower($fila['id']) . '</option>';
    }

    $show_assignment_button = true;
    if ($id_role != 1 && ! $current_user_has_credits) {
        $show_assignment_button = false;
    }

?>
<!doctype html>
<html lang="en">
<?php $obj_common->head(); ?>

<body
    class="m-page--fluid m--skin- m-content--skin-light2 m-header--fixed m-header--fixed-mobile m-aside-left--enabled m-aside-left--skin-light m-aside-left--fixed m-aside-left--offcanvas m-aside-left--minimize m-brand--minimize m-footer--push m-aside--offcanvas-default">
    <div class="m-grid m-grid--hor m-grid--root m-page">
        <!-- BEGIN: Header -->
        <header id="m_header" class="m-grid__item    m-header " m-minimize-offset="200" m-minimize-mobile-offset="200">
            <?php $obj_common->header(); ?>
        </header>
        <!-- END: Header -->
        <!-- begin::Body -->
        <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
            <!-- BEGIN: Left Aside -->
            <button class="m-aside-left-close  m-aside-left-close--skin-light " id="m_aside_left_close_btn"><i
                    class="la la-close"></i></button>
            <?php $obj_common->left_col()?>
            <!-- END: Left Aside -->
            <div class="m-grid__item m-grid__item--fluid m-wrapper">
                <div class="m-content">
                    <div class="m-portlet m-portlet--mobile">
                        <div class="m-portlet__head">
                            <div class="m-portlet__head-caption">
                                <div class="m-portlet__head-title">
                                    <h3 class="m-portlet__head-text">
                                        <span class="tr" key="<?php echo $title_table ?>"></span>
                                        <?php if ($id_role != 1): ?>
                                        <span> &nbsp;-&nbsp; </span>
                                        <b><span class="tr" key=""><?php echo $name ?></span></b>

                                        <span> &nbsp; | &nbsp; </span>
                                        <span class="tr" key="Total">Total</span>:
                                        <b><span><?php echo $total_credits; ?></span></b>

                                        <span> &nbsp; | &nbsp; </span>
                                        <span class="tr" key="Assignment_Team">Assignment Team</span>:
                                        <b><span><?php echo $assigned_team_total; ?></span></b>


                                        <span> &nbsp; | &nbsp; </span>
                                        <span class="tr" key="Available">Available</span>:
                                        <b><span
                                                class="modal_available_credits"><?php echo $available_credits; ?></span></b>

                                        <?php endif; ?>
                                    </h3>
                                </div>
                            </div>
                            <div class="m-portlet__head-tools">
                                <ul class="m-portlet__nav">
                                    <?php if ($show_assignment_button): ?>
                                    <?php if ($id_role != 1): ?>
                                    <li>
                                        <a href="javascript:;"
                                            onclick="concierge_agents_credits_list.list_transactions(0, $id_user_crm)"
                                            class="btn btn-accent m-btn m-btn--custom m-btn--pill m-btn--icon m-btn--air mx-2 tr"
                                            key="Credits_Transactions">

                                        </a>
                                    </li>
                                    <?php endif; ?>
                                    <li>
                                        <button type="button" id="btn_add_credits_concierge"
                                            class="btn btn-accent m-btn m-btn--custom m-btn--pill m-btn--icon m-btn--air tr"
                                            key="Credits_Assignment">

                                        </button>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>

                        </div>
                        <div class="m-portlet__body">
                            <table class="table table-striped table-bordered table-hover table-checkable"
                                id="dtConciergeAgentCreditList" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center" width="50" key="Id"></th>
                                        <th class="text-center tr" width="420" key="Name"></th>
                                        <th class="text-center tr" width="220" key="Assignment"></th>
                                        <th class="text-center tr" width="220" key="Available"></th>
                                        <th class="text-center tr" width="220" key="Assignment_Team"></th>
                                        <th class="text-center tr" width="220" key="Used"></th>
                                        <!-- <th class="text-center tr" width="220" key="Expired_Date"></th> -->
                                        <th class="text-center tr" key="Actions">Actions</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Modal de Asignación de Créditos -->

                    <div class="modal fade" id="creditAssignmentModal" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><span id="titleModalLandingPage"
                                            class="tr" key="Add_Credits_Concierge">Credits
                                            Assignment</span>

                                        <?php if ($id_role != 1): ?>
                                        <span> &nbsp;-&nbsp; </span>
                                        <b><span class="tr" key=""><?php echo $name ?></span></b>
                                        <?php endif; ?>

                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">

                                    <?php if ($id_role != 1): ?>
                                    <div class="alert alert-info" role="alert">
                                        <strong class="tr" key="Information">Información:</strong>
                                        <span class="tr" key="textInformationAvailable">Estás asignando créditos desde
                                            tu saldo
                                            disponible.</span>
                                        <span class="tr" key="Available_Credits">Créditos disponibles</span>:
                                        <strong><span
                                                class="modal_available_credits"><?php echo $available_credits; ?></span></strong>
                                    </div>
                                    <?php endif; ?>
                                    <!-- Opciones de Asignación -->
                                    <ul class="nav nav-tabs m-tabs-line m-tabs-line--justify mr-3" role="tablist">
                                        <li class="nav-item m-tabs__item tab_individual_assignment">
                                            <a class="nav-link m-tabs__link active" href="#tab_individual_assignment"
                                                data-toggle="tab" role="tab">
                                                <span class="tr" key="Individual_Assignment">Asignación Individual<span>
                                            </a>
                                        </li>
                                        <li class="nav-item m-tabs__item tab_mass_assignment">
                                            <a class="nav-link m-tabs__link" href="#tab_mass_assignment"
                                                data-toggle="tab" role="tab">
                                                <span class="tr" key="Mass_Assignment">Asignación Masiva<span>
                                            </a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="tab_individual_assignment" role="tabpanel">
                                            <?php if ($id_role != 1): ?>
                                            <div class="alert alert-warning" role="alert">
                                                <strong class="tr" key="Attention">Attention:</strong>
                                                <span class="tr" key="Assignment_Warning_Message">
                                                    Once you assign the credits, they cannot be removed or refunded.
                                                </span>
                                            </div>
                                            <?php endif; ?>
                                            <form id="addFormIndividualAssignment">
                                                <!-- Agente Destino -->

                                                <div class="mb-4">
                                                    <label for="agentSearch" class="form-label tr"
                                                        key="Agent_To"></label>
                                                    <select id="select_user_crm_agent_individual"
                                                        name="select_user_crm_agent_individual"
                                                        class="form-control m-select2">
                                                        <?php echo $strUsersAgent ?>
                                                    </select>
                                                </div>

                                                <!-- Detalles de Asignación -->
                                                <div class="mb-4">
                                                    <h6 class="mb-3 tr" key="Assignment_Details">DETALLES DE ASIGNACIÓN
                                                    </h6>

                                                    <div class="mb-3">
                                                        <label for="credit_amount" class="form-label tr"
                                                            key="Credits_Quantity">Cantidad de
                                                            Créditos</label>
                                                        <input type="number" class="form-control" id="credit_amount"
                                                            value="1" min="1"
                                                            <?php if ($id_role != 1): ?>max="<?php echo $available_credits; ?>"
                                                            <?php endif; ?>>
                                                        <?php if ($id_role != 1): ?>
                                                        <small class="form-text text-muted"><span class="tr"
                                                                key="Max_Available">Máximo
                                                                disponible</span>:                                                                                   <?php echo $available_credits; ?>
                                                            créditos</small>
                                                        <?php endif; ?>
                                                        <!-- <div class="col-md-6">
                                                            <label for="expired_date" class="form-label tr"
                                                                key="Expired_Date">Fecha de
                                                                Vigencia</label>
                                                            <input type="text" class="form-control date_us"
                                                                id="expired_date" value="">
                                                        </div> -->
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="comment" class="form-label tr"
                                                            key="Comments">Comentario (opcional)</label>
                                                        <textarea class="form-control" id="comment" rows="3"
                                                            placeholder=""></textarea>
                                                    </div>
                                                </div>
                                            </form>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary tr" key="Close"
                                                    data-dismiss="modal"
                                                    onclick="concierge_agents_credits_list.clear();">Close</button>
                                                <button id="individual_assignment_button_add" type="button"
                                                    class="btn btn-primary tr" key="Assignment">Assignment</button>
                                            </div>

                                        </div>
                                        <div class="tab-pane" id="tab_mass_assignment" role="tabpanel">

                                            <div class="alert alert-warning" role="alert">
                                                <strong class="tr" key="Attention">Attention:</strong>
                                                <span class="tr" key="Assignment_Warning_Message">
                                                    Once you assign the credits, they cannot be removed or refunded.
                                                </span>
                                            </div>
                                            <form id="addFormMassiveAssignment">
                                                <!-- Agente Destino -->
                                                <div class="mb-4">
                                                    <label for="agentSearch" class="form-label tr"
                                                        key="Agent_To"></label>
                                                    <select id="select_user_crm_agent_massive"
                                                        name="select_user_crm_agent_massive"
                                                        class="form-control m-select2" multiple style="width: 100%;">
                                                        <?php echo $strUsersAgent ?>
                                                    </select>
                                                </div>

                                                <!-- Detalles de Asignación -->
                                                <div class="mb-4">
                                                    <h6 class="mb-3 tr" key="Assignment_Details">DETALLES DE ASIGNACIÓN
                                                    </h6>

                                                    <div class="mb-3">
                                                        <label for="credit_amount_massive" class="form-label tr"
                                                            key="Credits_Quantity">Cantidad
                                                            de Créditos</label>
                                                        <input type="number" class="form-control"
                                                            id="credit_amount_massive" value="1" min="1"
                                                            <?php if ($id_role != 1): ?>max="<?php echo $available_credits; ?>"
                                                            <?php endif; ?>>
                                                        <?php if ($id_role != 1): ?>
                                                        <small class="form-text text-muted"><span class="tr"
                                                                key="Max_Available">Máximo
                                                                disponible</span>:                                                                                   <?php echo $available_credits; ?>
                                                            créditos</small>
                                                        <?php endif; ?>
                                                        <!-- <div class="col-md-6">
                                                            <label for="expired_date_massive" class="form-label tr"
                                                                key="Expired_Date">Fecha de
                                                                Vigencia</label>
                                                            <input type="text" class="form-control date_us"
                                                                id="expired_date_massive" value="">
                                                        </div> -->
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="comment_massive" class="form-label tr"
                                                            key="Comments">Comentario
                                                            (opcional)</label>
                                                        <textarea class="form-control" id="comment_massive" rows="3"
                                                            placeholder=""></textarea>
                                                    </div>

                                                    <!-- Información de asignación masiva -->
                                                    <?php if ($id_role != 1): ?>
                                                    <div class="alert alert-warning" role="alert">
                                                        <strong class="tr" key="Note">Nota:</strong>
                                                        <span class="tr" key="Total_Credits_Wiil_Be">El total de
                                                            créditos a asignar será </span>:
                                                        <strong><span id="massive_total_credits">0</span> <span
                                                                class="tr" key="Credits">créditos</span></strong>
                                                        <span class="tr" key="Quantity_x_Agents">(Cantidad × Número de
                                                            agentes seleccionados)</span>
                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                            </form>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary tr" key="Close"
                                                    data-dismiss="modal"
                                                    onclick="concierge_agents_credits_list.clear();">Close</button>
                                                <button id="massive_assignment_button_add" type="button"
                                                    class="btn btn-primary tr" key=""><span class="tr"
                                                        key="Assignment">Assignment</span> <span
                                                        id="quantity_seleted_assignment"></span></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <!-- Modal de Edición de Créditos -->

                    <div class="modal fade" id="editCreditAssignmentModal" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><span id="titleModalLandingPage"
                                            class="tr" key="Edit_Credits_Concierge">Credits
                                            Assignment</span>

                                        <?php if ($id_role != 1): ?>
                                        <span> &nbsp;-&nbsp; </span>
                                        <b><span class="tr" key=""><?php echo $name ?></span></b>
                                        <?php endif; ?>

                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <?php if ($id_role != 1): ?>
                                    <div class="alert alert-info" role="alert">
                                        <strong class="tr" key="Information">Información:</strong>
                                        <span class="tr" key="textInformationAvailable">Estás asignando créditos desde
                                            tu saldo disponible.</span>
                                        <span class="tr" key="Available_Credits">Créditos disponibles</span>:
                                        <strong><?php echo $available_credits; ?></strong>
                                    </div>
                                    <?php endif; ?>

                                    <form id="addFormIndividualAssignment">
                                        <input type="hidden" name="edit_id_agent_credit" id="edit_id_agent_credit">
                                        <div class="mb-4">
                                            <label for="agentSearch" class="form-label tr" key="Agent_To"></label>
                                            <select id="edit_select_user_crm_agent_individual"
                                                name="edit_select_user_crm_agent_individual"
                                                class="form-control m-select2" disabled>
                                                <?php echo $strUsersAgent ?>
                                            </select>
                                        </div>

                                        <!-- Detalles de Asignación -->
                                        <div class="mb-4">
                                            <h6 class="mb-3 tr" key="Assignment_Details">DETALLES DE ASIGNACIÓN</h6>

                                            <div class="row mb-3">
                                                <div class="col-md-6">
                                                    <label for="expired_date" class="form-label tr"
                                                        key="Available_Credits_Agent">Available Credits</label>
                                                    <input type="text" class="form-control" id="edit_available_credits"
                                                        value="" disabled>
                                                    <input type="hidden" id="edit_original_credits" value="">
                                                </div>
                                                <div class="col-md-6">
                                                    <label for="credit_amount" class="form-label tr"
                                                        key="Add/Remove_Credits">Add/Remove Credits</label>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <button class="btn btn-danger" type="button"
                                                                id="btn_subtract_credit">-</button>
                                                        </div>
                                                        <input type="number" class="form-control"
                                                            id="edit_credit_amount" value="0">
                                                        <div class="input-group-append">
                                                            <button class="btn btn-success" type="button"
                                                                id="btn_add_credit">+</button>
                                                        </div>
                                                    </div>
                                                    <?php if ($id_role != 1): ?>
                                                    <small class="form-text text-muted"><span class="tr"
                                                            key="Max_Available">Máximo disponible</span>:
                                                        <span
                                                            class="modal_available_credits"><?php echo $available_credits; ?></span>
                                                        créditos</small>
                                                    <?php endif; ?>
                                                </div>
                                                <!-- <div class="col-md-6">
                                                    <label for="expired_date" class="form-label tr"
                                                        key="Expired_Date">Fecha de Vigencia</label>
                                                    <input type="text" class="form-control date_us"
                                                        id="edit_expired_date" value="">
                                                </div> -->
                                            </div>

                                            <!-- <div class="mb-3">
                                                <label for="comment" class="form-label tr" key="Comments">Comentario
                                                    (opcional)</label>
                                                <textarea class="form-control" id="edit_comment" rows="3"
                                                    placeholder=""></textarea>
                                            </div>  -->
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary tr" key="Close" data-dismiss="modal"
                                        onclick="concierge_agents_credits_list.clear();">Close</button>
                                    <button id="individual_assignment_button_edit" type="button"
                                        class="btn btn-primary tr" key="Assignment">Assignment</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal de Confirmación de Asignación -->
                    <div class="modal fade" id="confirmAssignmentModal" tabindex="-1" role="dialog"
                        aria-labelledby="confirmAssignmentModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="confirmAssignmentModalLabel">
                                        <span class="tr" key="Confirm_Assignment">Confirm Assignment</span>
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="alert alert-info" role="alert">
                                        <strong class="tr" key="Attention">Attention:</strong>
                                        <p id="confirmMessage"></p>
                                    </div>
                                    <?php if ($id_role != 1): ?>

                                    <div class="alert alert-warning" role="alert">
                                        <strong class="tr" key="Warning">Warning:</strong>
                                        <span class="tr" key="Assignment_Warning_Message">
                                            Once you assign the credits, they cannot be removed or refunded.
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary tr" key="Cancel"
                                        data-dismiss="modal">Cancel</button>
                                    <button type="button" class="btn btn-primary tr" key="Confirm"
                                        id="confirmAssignmentButton">Confirm</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Para listar las transacciones hechas -->
                    <div class="modal fade" id="listCreditsTransactionsModal" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><span id="titleModalLandingPage"
                                            class="tr" key="Credits_Transactions">Credits_Transactions</span>
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered table-hover table-checkable"
                                        id="dtConciergeCreditTransactionsList" cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th class="text-center" width="50" key="Id"></th>
                                                <th class="text-center tr" width="220" key="From_Name"></th>
                                                <th class="text-center tr" width="220" key="To_Name"></th>
                                                <th class="text-center tr" width="220" key="Credits"></th>
                                                <th class="text-center tr" width="220" key="Transaction_Type"></th>
                                                <th class="text-center tr" width="280" key="Note"></th>
                                                <th class="text-center tr" width="220" key="Created"></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary tr" key="Close" data-dismiss="modal"
                                        onclick="concierge_agents_credits_list.clear();">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $obj_common->footer(); ?>
    <div id="m_scroll_top" class="m-scroll-top">
        <i class="la la-arrow-up"></i>
    </div>


    </div>
    <?php $obj_common->script(); ?>
    <script src="../../assets/bower_components/gtreetable/dist/bootstrap-gtreetable.js"></script>
    <script src="../../language/concierge_agents_credits_lang.js"></script>

    <script>
    // Variables globales para el control de créditos
    const userRole =                     <?php echo $id_role; ?>;
    const availableCredits =                             <?php echo $available_credits; ?>;
    </script>
    <script src="../controllers/concierge_agents_credits.js"></script>


</body>

</html>