<?php
include '../../common/login_timeout.php';
include '../../common/general.php';
include '../../vendor/autoload.php';
require_once '../../assets/bower_components/dompdf/lib/html5lib/Parser.php';
require_once '../../assets/bower_components/dompdf/src/Autoloader.php';

Dompdf\Autoloader::register();
use Dompdf\Dompdf;
use PHPMailer\PHPMailer\PHPMailer;

$obj_common = new common();
$obj_bdmysql = new coBdmysql();
$obj_function = new coFunction();
error_reporting(E_ERROR);
$conn = mysqli_connect(DBHOST, DBUSER, DBPASS, DBNOM) or die("Connection failed: " . mysqli_connect_error()); /* Database connection end */
$conn->set_charset('utf8mb4');

use Plivo\RestClient;
$restClient = new RestClient(AUTH_ID, AUTH_TOKEN);

$id_role = $_SESSION["id_role"];
$parentBYClient = $_SESSION["parentBYClient"];
$id_client = $_SESSION["id_client"];
$id_principal = $_SESSION["id_principal"];
$id_user_crm = $_SESSION["id_user_crm"];
$user_name = $_SESSION['name'];
//$id_client = 125; // dev localhost testing
$ids = $_SESSION["ids"];

$action = "";

if (isset($_POST['action'])) {
    $action = $_POST['action'];
}

foreach ($_POST as $i_dato => $dato_) {
    if (!is_array($dato_)) {
        $$i_dato = addslashes($obj_function->evalua_array($_POST, $i_dato));
    } else {
        foreach ($dato_ as $innerKey => $innerValue) {
            $$i_dato = addslashes($obj_function->evalua_array($_POST, $innerKey));
        }
    }
}

lastUpdate($conn);
switch ($action) {
    case 'list':
        // storing  request (ie, get/post) global array to a variable
        $requestData = $_REQUEST;

        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'status',
            2 => 'cs.agreement_number',
            3 => 'c.last_name',
            4 => 'csp.plan_name',
            5 => 'csp.pay_type',
            6 => 'csp.amount',
            7 => 'csp.date_payment',
            8 => 'uc.name',
            9 => 'csp.commission',
            12 => 'csp.payment_type'
        );

        if (!empty($requestData['columns'][0]['search']['value'])) {
            $sql_where .= " AND ( csp.id LIKE '%" . $requestData['columns'][0]['search']['value'] . "%')";
        }        

        if (!empty($requestData['columns'][1]['search']['value'])) {
            $search = explode(";", $requestData['columns'][1]['search']['value']);
            $str = $search[0];
            if (strlen($str) <= 7) { //
                $status = 0;
                if (strlen(strstr('1 retry', $str)) > 0) {
                    $status = 1;
                }
                if (strlen(strstr('success', $str)) > 0) {
                    $status = 2;
                }
                if (strlen(strstr('2 retry', $str)) > 0) {
                    $status = 3;
                }
                if (strlen(strstr('no-card', $str)) > 0) {
                    $status = 4;
                }
                if (strlen(strstr('xxx', $str)) > 0) {
                    $status = 13;
                }
                //echo "status ". $status;
                $sql_where .= " AND ( csp.status LIKE '%" . $status . "%')";
            }
        }

        if (!empty($requestData['columns'][2]['search']['value'])) {
            $sql_where .= " AND ( cs.agreement_number LIKE '%" . $requestData['columns'][2]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][3]['search']['value'])) {
            $sql_where .= " AND ( CONCAT(c.name,' ', c.last_name) LIKE '%" . $requestData['columns'][3]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][4]['search']['value'])) {
            $sql_where .= " AND ( csp.plan_name LIKE '%" . $requestData['columns'][4]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][5]['search']['value'])) {
            $sql_where .= " AND ( csp.pay_type LIKE '%" . $requestData['columns'][5]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][6]['search']['value'])) {
            $sql_where .= " AND ( csp.amount LIKE '%" . $requestData['columns'][6]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][7]['search']['value'])) {
            $search = formatterDb($requestData['columns'][7]['search']['value']);
            $sql_where .= " AND (csp.date_payment LIKE '%" . $search . "%')";
        }

        if (!empty($requestData['columns'][8]['search']['value'])) {
            $fh = formatterViewDB($requestData['columns'][8]['search']['value']);
            $sql_where .= " AND (csp.date_payment LIKE '%" . $fh . "%')";
        }

        if (!empty($requestData['columns'][9]['search']['value'])) {
            $sql_where .= " AND (uc.name LIKE '%" . $requestData['columns'][9]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][10]['search']['value'])) {
            $sql_where .= " AND (csp.commission LIKE '%" . $requestData['columns'][10]['search']['value'] . "%')";
        }       

        if (!empty($requestData['columns'][13]['search']['value'])) {
            // if there is a search parameter
            $bsc = $requestData['columns'][13]['search']['value'];
            $dt = 0;
            
            if ((strpos('Bank', $bsc) === 0) || (strpos('bank', $bsc) === 0)){
                $dt = 1;
            }
            if ((strpos('Credit', $bsc) === 0) || (strpos('credit', $bsc) === 0)){
                $dt = 2;
            }
            if ((strpos('Other', $bsc) === 0) || (strpos('other', $bsc) === 0)){
                $dt = 3;
            }             

            $sql_where .= " AND (csp.payment_type LIKE '%" . $dt . "%')";
            
        }

        if (!empty($requestData['columns'][11]['search']['value'])) {
            // if there is a search parameter             
            $search = explode(";", $requestData['columns'][11]['search']['value']);
            ///////
            $newDatecreated1 = date("Y-m-d", strtotime($search[0]));
            $newDatecreated2 = date("Y-m-d", strtotime($search[1]));

            $sql_where .= " AND ( csp.date_payment BETWEEN '" . $newDatecreated1 . "' AND '" . $newDatecreated2 . "')";
        }

        $sql = "SELECT csp.note, csp.id, csp.id_contacts_services, csp.created, c.id as id_contacts, CONCAT(c.name,' ',c.last_name) as name_contact, cs.agreement_number , cs.id AS id_contacts_services, csp.plan_name, csp.pay_type, csp.amount, csp.date_payment, uc.name, csp.commission, csp.status, 
        CASE csp.payment_type
        WHEN 1 THEN 'Bank Account'
        WHEN 2 THEN 'Credit Card' 
        WHEN 3 THEN 'Other' 
        END payment_type 
        FROM contacts_services_payment csp 
        LEFT JOIN user_crm uc on csp.person_interacting = uc.id 
        INNER JOIN contacts_services cs on csp.id_contacts_services = cs.id 
        INNER JOIN opportunities o on cs.id_opportunities = o.id 
        LEFT JOIN contacts c on o.id_contacts = c.id";


        if ($id_role == 1 || $id_role == 3 || $id_role == 29 || $id_role == 31 || $id_role == 4) {
            $sql .= " WHERE uc.id_client IN($parentBYClient) ";
            //$sql .= " WHERE csp.id_client = $id_client"; //dev localhost testing
        } else {
            $sql .= " WHERE csp.person_interacting in($ids)";
        }
        //echo $sql;
        $query = mysqli_query($conn, $sql) or die($sql);
        $totalData = mysqli_num_rows($query);

        if (!empty($requestData['search']['value'])) {
            $str = $requestData['search']['value'];
            $status = 0;
            if (strlen(strstr('1 retry', $str)) > 0) {
                $status = 1;
            }
            if (strlen(strstr('success', $str)) > 0) {
                $status = 2;
            }
            if (strlen(strstr('2 retry', $str)) > 0) {
                $status = 3;
            }
            if (strlen(strstr('no-card', $str)) > 0) {
                $status = 4;
            }
            ////////////////////////////////////////
            $sql .= " AND ( csp.plan_name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR csp.status LIKE '%" . $status . "%'";
            $sql .= " OR c.name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR c.last_name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cs.agreement_number LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR csp.pay_type LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR csp.amount LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR csp.date_payment LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR csp.created LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR uc.name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR csp.commission LIKE '%" . $requestData['search']['value'] . "%' )";
        }
        $sql .= $sql_where;

        $query = mysqli_query($conn, $sql) or die($sql);

        $totalFiltered = mysqli_num_rows($query);
        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
        //print_r($sql);exit;
        $query = mysqli_query($conn, $sql) or die($sql);

        $data = array();
        while ($row = mysqli_fetch_array($query)) {

            $nestedData = array();
            $button = "";

            $note = utf8_encode($row["note"]);
            $pay = $row["pay_type"];
            if ($row["pay_type"] == "Monthly Payment")
                $pay = "Monthly";
            if ($row["pay_type"] == "BiAnnual Payment")
                $pay = "BiAnnual";
            if ($row["pay_type"] == "Annual Payment")
                $pay = "Annual";
            //////////////////////
            $date = formatterView($row["date_payment"]);

            $created = date("m/d/Y", strtotime($row["created"]));
            //////////////////////
            $status = getStatusBadge($row["status"], $note);

            $button = '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Detalles de Pago" data-placement="top" onclick="Payments.tableScheduledPayments(' . $row['id_contacts_services'] . ')"> <i class="fas fa-file-invoice-dollar" style="font-size:18px"></i></a>';
            

            // if($row["status"] == 10){
            //     $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Ver Reembolso" data-placement="top" onclick="Payments.viewRefund(' . $row['22222222'] . ')"> <i class="far fa-clipboard" style="font-size:18px"></i></a>';
            // }

            $nestedData[] = '<div class="text-center">' . $row["id"] . '</div>';
            $nestedData[] = '<div class="text-center">' . $status . '</div>';
            $nestedData[] = '<div class="text-center"><a href="#" onclick="Payments.findServicesById(' . $row["id_contacts_services"] . ')">' . $row["agreement_number"] . '</a></div>';
            $nestedData[] = '<div class="text-center">' . $row["name_contact"] . '</div>';
            $nestedData[] = '<div class="text-center">' . $row["plan_name"] . '</div>';
            $nestedData[] = '<div class="text-center">' . $pay . '</div>';
            $nestedData[] = '<div class="text-center">$ ' . $row["amount"] . ' </div>';
            $nestedData[] = '<div class="text-center">' . $date . '</div>';
            $nestedData[] = '<div class="text-center">' . $created . '</div>';
            $nestedData[] = '<div class="text-center">' . $row["name"] . '</div>';
            if($id_user_crm != 2521){
                $nestedData[] = '<div class="text-center">' . $row["commission"] . '</div>';
            }            
            $nestedData[] = ''; // para columna search fecha
            $nestedData[] = ''; // para columna search fecha
            $nestedData[] = '<div class="text-center">' . $row["payment_type"] . ' </div>';
            $nestedData[] = '<div>' . $button . '</div>';

            $data[] = $nestedData;
        }

        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
            "type_bussiness" => $type_bussiness
        );
        mysqli_close($conn);
        echo json_encode($json_data);
    break;

    case 'listScheduledPayments':
        // storing  request (ie, get/post) global array to a variable
        $requestData = $_REQUEST;

        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'status',
            2 => 'cs.agreement_number',
            3 => 'c.name',
            4 => 'csp.plan_name',
            5 => 'csp.pay_type',
            6 => 'csp.amount',
            7 => 'csp.date_payment',
            8 => 'uc.name',
            9 => 'csp.commission'
        );

        if (!empty($requestData['columns'][0]['search']['value'])) {
            $sql_where .= " AND ( csp.id LIKE '%" . $requestData['columns'][0]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][1]['search']['value'])) {
            $search = explode(";", $requestData['columns'][1]['search']['value']);
            $str = $search[0];
            if (strlen($str) <= 7) { //
                $status = 0;
                if (strlen(strstr('1 retry', $str)) > 0) {
                    $status = 1;
                }
                if (strlen(strstr('success', $str)) > 0) {
                    $status = 2;
                }
                if (strlen(strstr('2 retry', $str)) > 0) {
                    $status = 3;
                }
                if (strlen(strstr('no-card', $str)) > 0) {
                    $status = 4;
                }
                if (strlen(strstr('refund', $str)) > 0) {
                    $status = 10;
                }
                if (strlen(strstr('refund requested', $str)) > 0) {
                    $status = 13;
                }
                //echo "status ". $status;
                $sql_where .= " AND ( csp.status LIKE '%" . $status . "%')";
            }
        }

        if (!empty($requestData['columns'][2]['search']['value'])) {
            $sql_where .= " AND ( cs.agreement_number LIKE '%" . $requestData['columns'][2]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][3]['search']['value'])) {
            $sql_where .= " AND ( c.name LIKE '%" . $requestData['columns'][3]['search']['value'] . "%') OR ( c.last_name LIKE '%" . $requestData['columns'][3]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][4]['search']['value'])) {
            $sql_where .= " AND ( csp.plan_name LIKE '%" . $requestData['columns'][4]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][5]['search']['value'])) {
            $sql_where .= " AND ( csp.pay_type LIKE '%" . $requestData['columns'][5]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][6]['search']['value'])) {
            $sql_where .= " AND ( csp.amount LIKE '%" . $requestData['columns'][6]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][7]['search']['value'])) {
            $search = formatterDb($requestData['columns'][7]['search']['value']);
            $sql_where .= " AND (csp.date_payment LIKE '%" . $search . "%')";
        }

        if (!empty($requestData['columns'][8]['search']['value'])) {
            $sql_where .= " AND (uc.name LIKE '%" . $requestData['columns'][8]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][9]['search']['value'])) {
            $sql_where .= " AND (csp.commission LIKE '%" . $requestData['columns'][9]['search']['value'] . "%')";
        }

        if (!empty($requestData['columns'][10]['search']['value'])) {
            // if there is a search parameter             
            $search = explode(";", $requestData['columns'][10]['search']['value']);
            ///////
            $newDatecreated1 = date("Y-m-d", strtotime($search[0]));
            $newDatecreated2 = date("Y-m-d", strtotime($search[1]));

            $sql_where .= " AND ( csp.date_payment BETWEEN '" . $newDatecreated1 . "' AND '" . $newDatecreated2 . "')";
        }

        $sql = "SELECT csp.note, csp.id_contacts_payment_methods_stripe, csp.id_contacts_card_stripe, csp.id, csp.date_payment_success, csp.id_client, csp.retries, csp.id_contacts_services, c.id as id_contacts,
         CONCAT(c.name,' ',c.last_name)  as name_contact, cs.agreement_number, csp.plan_name, csp.pay_type, csp.amount, csp.date_payment, uc.name, csp.commission, csp.status , csp.payment_method, cspay.id as id_contacts_services_payment, cspay.payment_type
        FROM contacts_services_pending_payment csp 
        LEFT JOIN user_crm uc on csp.person_interacting = uc.id 
        INNER JOIN contacts_services cs on csp.id_contacts_services = cs.id 
        INNER JOIN opportunities o on cs.id_opportunities = o.id 
        LEFT JOIN contacts_services_payment cspay 
            ON cspay.id_contacts_services = csp.id_contacts_services
            AND cspay.date_payment = csp.date_payment
            AND cspay.status = 2
            AND cspay.id = 
            (
               SELECT MAX(id) 
               FROM contacts_services_payment cspay 
               WHERE cspay.id_contacts_services = csp.id_contacts_services AND cspay.date_payment = csp.date_payment
            )
        LEFT JOIN contacts c on o.id_contacts = c.id";

        if ($id_role == 1 || $id_role == 3 || $id_role == 29 || $id_role == 31 || $id_role == 4) {
            $sql .= " WHERE uc.id_client IN($parentBYClient) AND csp.id_contacts_services = $id_contacts_services";
        } else if ($id_role == 2) {
            $sql .= " WHERE uc.id_client IN($id_client) AND csp.id_contacts_services = $id_contacts_services";
        } else if($id_user_crm == 2803) {
            $sql .= " WHERE csp.person_interacting IN($ids) AND csp.id_contacts_services = $id_contacts_services";
        } else {
            $sql .= " WHERE csp.person_interacting = $id_user_crm AND csp.id_contacts_services = $id_contacts_services";
        }
        //echo $sql;exit;
        $query = mysqli_query($conn, $sql) or die($sql);
        $totalData = mysqli_num_rows($query);

        if (!empty($requestData['search']['value'])) {
            $str = $requestData['search']['value'];
            $status = "";
            if (strpos('without paying', $str) !== false) {
                $status = 0;
            } else if (strpos('retries', $str) !== false) {
                $status = "1,3";
            } else if (strpos('success', $str) !== false) {
                $status = 2;
            } else if (strpos('3 retries', $str) !== false) {
                $status = 3;
            } else if (strpos('no payment method', $str) !== false) {
                $status = 4;
            } else if (strpos('no keys stripe', $str) !== false) {
                $status = 5;
            } else if (strpos('unverified payment method', $str) !== false) {
                $status = 6;
            } else if (strpos('waiting confirmation', $str) !== false) {
                $status = 7;
            } else if (strpos('confirmation failed', $str) !== false) {
                $status = 8;
            } else if (strpos('canceled', $str) !== false) {
                $status = 9;
            } else if (strpos('refunded', $str) !== false) {
                $status = 10;
            } else if (strpos('canceled by admin', $str) !== false) {
                $status = 11;
            }else if (strpos('paused', $str) !== false) {
                $status = 12;
            }else if (strpos('refund requested', $str) !== false) {
                $status = 13;
            }else if (strpos('refunded partially', $str) !== false) {
                $status = 14;
            }else if (strpos('dispute', $str) !== false) {
                $status = 15;
            }
            ////////////////////////////////////////
            $sql .= " AND ( csp.plan_name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= $status != "" ? " OR csp.status IN ($status)" : "";
            $sql .= " OR c.name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR c.last_name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cs.agreement_number LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR csp.pay_type LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR csp.amount LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR csp.date_payment LIKE '%" . formatterDb($requestData['search']['value']) . "%' ";
            $sql .= " OR csp.date_payment_success LIKE '%" . formatterDb($requestData['search']['value']) . "%' ";
            $sql .= " OR uc.name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR csp.commission LIKE '%" . $requestData['search']['value'] . "%' )";
        }
        $sql .= $sql_where;
        //echo $sql;exit;
        $query = mysqli_query($conn, $sql) or die($sql);

        $totalFiltered = mysqli_num_rows($query);
        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";

        $query = mysqli_query($conn, $sql) or die($sql);

        $data = array();
        while ($row = mysqli_fetch_array($query)) {

            $nestedData = array();
            $button = "";

            $note = utf8_encode($row["note"]);
            $clients_array = array(110, 111, 112, 125, 140, 149); //clientes permitidos
            if (in_array($id_client, $clients_array)) {
                if ($id_role == 1 || $id_role == 29 || $id_role == 31) {
                    //print_r($row['payment_method']);exit;
                    if ($row['payment_method'] == 0) {
                        if ($row['status'] != 2 && $row['status'] != 7 && $row['status'] != 10 && $row['status'] != 11 && $row['status'] != 9 && $row['status'] != 13 && $row['status'] != 14) {
                            $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill btn_process_payment" data-toggle="m-tooltip" title="Procesar Pago" data-placement="top" > <i class="fas fa-money-check-alt"></i></a>';
                        }
                    }
                    if ($row['payment_method'] == 1 || $row['payment_method'] == 2) {
                        if ($row['status'] != 2 && $row['status'] != 10 && $row['status'] != 11 && $row['status'] != 9 && $row['status'] != 13 && $row['status'] != 14) {
                            $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill btn_process_payment" data-toggle="m-tooltip" title="Procesar Pago" data-placement="top" > <i class="fas fa-money-check-alt"></i></a>';
                        }
                    }

                    if ($row['status'] == 2 && ($note != "" || $note != null)) {
                        $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Ver nota de pago." data-placement="top" onclick="Payments.viewPaymentNote(' . $row["id"] . ')"> <i class="far fa-clipboard"></i></a>';
                        
                    }

                    if($row['status'] == 2){
                        $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Reporte" data-placement="top" onclick="Payments.showPdfReceipt(' . $row['id'] . ')"> <i class="fas fa-file-pdf" style="font-size:18px"></i></a>';
                    }

                    if ($row['status'] == 0 || $row['status'] == 1) {
                        $button .= ' <a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Cancel" data-placement="top" onclick="Payments.cancelPayment(' . $row["id"] . ')"> <i class="fas fa-ban"></i>';
                    }
                }

                if(($id_role == 1 || $id_role == 29) && $row["status"] == 2 && $row["id_contacts_services_payment"] > 0 && ($row["payment_type"] == 1 || $row["payment_type"] == 2)){
                    $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Reembolsar" data-placement="top" onclick="Payments.refundStripe(' . $row['id'] . ')"> <i class="fas fa-reply" style="font-size:18px"></i></a>';
                }

                if($row["status"] == 10 || $row["status"] == 13 || $row["status"] == 14){
                    $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Ver Reembolso" data-placement="top" onclick="Payments.viewRefund(' . $row['id'] . ')"> <i class="fas fa-clipboard" style="font-size:18px"></i></a>';
                }

                
                if($id_role == 4 || $id_role == 2 && $row['status'] == 2){
                    $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Reporte" data-placement="top" onclick="Payments.showPdfReceipt(' . $row['id'] . ')"> <i class="fas fa-file-pdf" style="font-size:18px"></i></a>';
                }
            }

            $type_method = "new_method";
            $pay = $row["pay_type"];
            if ($row["pay_type"] == "Monthly Payment")
                $pay = "Monthly";
            if ($row["pay_type"] == "BiAnnual Payment")
                $pay = "BiAnnual";
            if ($row["pay_type"] == "Annual Payment")
                $pay = "Annual";
            if ($row["pay_type"] == "3 payments")
                $pay = "3 Payments";

            //////////////////////
            $date = formatterView($row["date_payment"]);
            $successful_payment_date = $row["date_payment_success"] != "" ? date("m/d/Y", strtotime($row["date_payment_success"])) : "";
            //////////////////////
            $status = getStatusBadge($row["status"], $note);

            $nestedData[] = $row["id"];
            $nestedData[] = $status;
            $nestedData[] = $row["agreement_number"];
            $nestedData[] = $row["name_contact"];
            $nestedData[] = $row["plan_name"];
            $nestedData[] = $pay;
            $nestedData[] = $row["amount"];
            $nestedData[] = $date;
            $nestedData[] = $successful_payment_date;
            $nestedData[] = $row["name"];
            // if($id_user_crm != 2521){
              $nestedData[] = $row["commission"];  
            // }
            
            $nestedData[] = $button;
            $nestedData[] = $type_method;

            $data[] = $nestedData;
        }

        $sql = "SELECT c.id as id_contacts, CONCAT(c.name,' ',c.last_name) as holder_name, cs.agreement_number 
        FROM contacts_services cs
        INNER JOIN opportunities op ON op.id = cs.id_opportunities
        INNER JOIN contacts c ON c.id = op.id_contacts 
        WHERE cs.id = $id_contacts_services limit 1";
        $query = $obj_bdmysql->query($sql, $conn);
        $information = is_array($query) ? $query[0] : "";

        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
            "information" => $information
        );
        mysqli_close($conn);
        echo json_encode($json_data);
    break;

    case 'listDueToDay':
        // storing  request (ie, get/post) global array to a variable
        $requestData = $_REQUEST;

        $columns = array(
            // datatable column index  => database column name
            0 => 'cspp.id',
            1 => 'cspp.status',
            2 => 'cs.agreement_number',
            3 => 'c.name',
            4 => 'cspp.plan_name',
            5 => 'cspp.pay_type',
            6 => 'cspp.amount',
            7 => 'cspp.date_payment',
            8 => 'uc.name',
            9 => 'cspp.commission'
        );

        $date = new DateTime();
        $date = $date->format('Y-m-d');

        $sql = "SELECT cspp.id, cspp.id_client, 
        cspp.retries, cspp.id_contacts_services, c.id as id_contacts, CONCAT(c.name,' ',c.last_name) as name_contact, cs.agreement_number,
        cspp.plan_name, cspp.pay_type, cspp.amount, cspp.date_payment, uc.name, cspp.commission, cspp.status , cspp.payment_method, cspp.note
        FROM contacts_services_pending_payment cspp
        LEFT JOIN user_crm uc on cspp.person_interacting = uc.id 
        INNER JOIN contacts_services cs on cspp.id_contacts_services = cs.id 
        INNER JOIN opportunities o on cs.id_opportunities = o.id 
        LEFT JOIN contacts c on o.id_contacts = c.id
        WHERE cspp.date_payment = '$date' AND cspp.status IN (0,1,2,3,4,6,7,8)";

        if ($id_role == 1 || $id_role == 3 || $id_role == 29 || $id_role == 31 || $id_role == 4) {
            $sql .= " AND uc.id_client IN($parentBYClient)";
        } else {
            $sql .= " AND cspp.person_interacting = $id_user_crm";
        }
        //echo $sql;
        $query = mysqli_query($conn, $sql) or die($sql);
        $totalData = mysqli_num_rows($query);

        if (!empty($requestData['search']['value'])) {
            $str = $requestData['search']['value'];
            $status = "";
            if (strpos('without paying', $str) !== false) {
                $status = 0;
            } else if (strpos('retries', $str) !== false) {
                $status = "1,3";
            } else if (strpos('success', $str) !== false) {
                $status = 2;
            } else if (strpos('3 retries', $str) !== false) {
                $status = 3;
            } else if (strpos('no payment method', $str) !== false) {
                $status = 4;
            } else if (strpos('no keys stripe', $str) !== false) {
                $status = 5;
            } else if (strpos('unverified payment method', $str) !== false) {
                $status = 6;
            } else if (strpos('waiting confirmation', $str) !== false) {
                $status = 7;
            } else if (strpos('confirmation failed', $str) !== false) {
                $status = 8;
            } 
            ////////////////////////////////////////
            $sql .= " AND ( cspp.plan_name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= $status != "" ? " OR csp.status IN ($status)" : "";
            $sql .= " OR c.name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR c.last_name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cs.agreement_number LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cspp.pay_type LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cspp.amount LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR cspp.date_payment LIKE '%" . formatterDb($requestData['search']['value']) . "%' ";
            $sql .= " OR uc.name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR cspp.commission LIKE '%" . $requestData['search']['value'] . "%' )";
        }
        $sql .= $sql_where;
        //echo $sql;exit;
        $query = mysqli_query($conn, $sql) or die($sql);

        $totalFiltered = mysqli_num_rows($query);
        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";

        $query = mysqli_query($conn, $sql) or die($sql);

        $data = array();
        while ($row = mysqli_fetch_array($query)) {

            $nestedData = array();
            $button = "";

            $note = utf8_encode($row["note"]);

            $clients_array = array(110, 111, 112, 125, 149); //clientes permitidos
            if (in_array($id_client, $clients_array)) {
                if ($id_role == 1 || $id_role == 29 || $id_role == 31) {
                    if ($row['status'] != 2 && $row['status'] != 7 && $row['status'] != 9 && $row['status'] != 10 && $row['status'] != 11) {
                        $button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill btn_process_payment" data-toggle="m-tooltip" title="Procesar Pago" data-placement="top" > <i class="fas fa-money-check-alt"></i></a>';
                    }
                }
            }

            $pay = $row["pay_type"];
            if ($row["pay_type"] == "Monthly Payment")
                $pay = "Monthly";
            if ($row["pay_type"] == "BiAnnual Payment")
                $pay = "BiAnnual";
            if ($row["pay_type"] == "Annual Payment")
                $pay = "Annual";
            if ($row["pay_type"] == "3 payments")
                $pay = "3 Payments";

            //////////////////////
            $date = formatterView($row["date_payment"]);
            $updated = date("m/d/Y", strtotime($row["updated"]));
            //////////////////////
            $status = getStatusBadge($row["status"], $note);

            $nestedData[] = $row["id"];
            $nestedData[] = $status;
            $nestedData[] = $row["agreement_number"];
            $nestedData[] = $row["name_contact"];
            $nestedData[] = $row["plan_name"];
            $nestedData[] = $pay;
            $nestedData[] = $row["amount"];
            $nestedData[] = $date;
            $nestedData[] = $row["name"];
            $nestedData[] = $row["commission"];
            $nestedData[] = $button;
            $nestedData[] = $row["id_contacts"];

            $data[] = $nestedData;
        }

        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
        );
        mysqli_close($conn);
        echo json_encode($json_data);
    break;

    case 'listPastDue':
        // storing  request (ie, get/post) global array to a variable
        $requestData = $_REQUEST;

        $columns = array(
            // datatable column index  => database column name
            0 => 'cspp.id',
            1 => 'cspp.status',
            2 => 'cs.agreement_number',
            3 => 'c.name',
            4 => 'cspp.plan_name',
            5 => 'cspp.pay_type',
            6 => 'cspp.amount',
            7 => 'cspp.date_payment',
            8 => 'cspp.date_payment',
            9 => 'uc.name',
            10 => 'cspp.commission'
        );

        $sql = "SELECT cspp.id, cspp.id_client, 
        cspp.retries, cspp.id_contacts_services, c.id as id_contacts, CONCAT(c.name,' ',c.last_name) as name_contact, cs.agreement_number, st.name as status_name,
        cspp.plan_name, cspp.pay_type, cspp.amount, cspp.date_payment, uc.name, cspp.commission, cspp.status , cspp.payment_method, cspp.note
        FROM contacts_services_pending_payment cspp
        LEFT JOIN user_crm uc on cspp.person_interacting = uc.id 
        INNER JOIN contacts_services cs on cspp.id_contacts_services = cs.id 
        INNER JOIN opportunities o on cs.id_opportunities = o.id 
        INNER JOIN status_services st ON st.id = cs.id_status_services
        LEFT JOIN contacts c on o.id_contacts = c.id
        WHERE cspp.status IN (1,3,4,5,6,8) AND cs.id_status_services IN (24,31,27) AND (cs.status > 0 or cs.status IS NULL)";

        if ($id_role == 1 || $id_role == 3 || $id_role == 29 || $id_role == 31 || $id_role == 4) {
            $sql .= " AND uc.id_client IN($parentBYClient)";
            //$sql .= " WHERE csp.id_client = $id_client"; //dev localhost testing
        } else {
            $sql .= " AND cspp.person_interacting = $id_user_crm";
        }
        //echo $sql;
        $query = mysqli_query($conn, $sql) or die($sql);
        $totalData = mysqli_num_rows($query);

        if (!empty($requestData['search']['value'])) {
            $str = $requestData['search']['value'];
            $status = "";
            if (strpos('without paying', $str) !== false) {
                $status = 0;
            } else if (strpos('retries', $str) !== false) {
                $status = "1,3";
            } else if (strpos('success', $str) !== false) {
                $status = 2;
            } else if (strpos('3 retries', $str) !== false) {
                $status = 3;
            } else if (strpos('no payment method', $str) !== false) {
                $status = 4;
            } else if (strpos('no keys stripe', $str) !== false) {
                $status = 5;
            } else if (strpos('unverified payment method', $str) !== false) {
                $status = 6;
            } else if (strpos('waiting confirmation', $str) !== false) {
                $status = 7;
            } else if (strpos('confirmation failed', $str) !== false) {
                $status = 8;
            } 
            ////////////////////////////////////////
            $sql .= " AND ( cspp.plan_name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= $status != "" ? " OR csp.status IN ($status)" : "";
            $sql .= " OR c.name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR c.last_name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cs.agreement_number LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cspp.pay_type LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR cspp.amount LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR st.name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR cspp.date_payment LIKE '%" . formatterDb($requestData['search']['value']) . "%' ";
            $sql .= " OR uc.name LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR cspp.commission LIKE '%" . $requestData['search']['value'] . "%' )";
        }
        $sql .= $sql_where;
        //echo $sql;exit;
        $query = mysqli_query($conn, $sql) or die($sql);

        $totalFiltered = mysqli_num_rows($query);
        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";

        $query = mysqli_query($conn, $sql) or die($sql);

        $date_today = new DateTime();

        $data = array();
        while ($row = mysqli_fetch_array($query)) {

            $nestedData = array();
            $button = "";

            $note = utf8_encode($row["note"]);

            if ($id_role == 1 || $id_role == 29 || $id_role == 31) {
                if ($row['status'] != 2 && $row['status'] != 7 && $row['status'] != 9 && $row['status'] != 10 && $row['status'] != 11) {
                    //$button .= '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill btn_process_payment" data-toggle="m-tooltip" title="Procesar Pago" data-placement="top" > <i class="fas fa-money-check-alt"></i></a>';
                }
            }

            $pay = $row["pay_type"];
            if ($row["pay_type"] == "Monthly Payment")
                $pay = "Monthly";
            if ($row["pay_type"] == "BiAnnual Payment")
                $pay = "BiAnnual";
            if ($row["pay_type"] == "Annual Payment")
                $pay = "Annual";
            if ($row["pay_type"] == "3 payments")
                $pay = "3 Payments";

            //////////////////////
            $date = new DateTime($row["date_payment"]);
            $diff = $date_today->diff($date);

            $date_payment = $date->format('Y-m-d');
            $date_payment = formatterView($date_payment);

            //////////////////////
            $status = getStatusBadge($row["status"], $note);

            $nestedData[] = $row["id"];
            $nestedData[] = $status;
            $nestedData[] = $row["agreement_number"];
            $nestedData[] = $row["name_contact"];
            $nestedData[] = $row["plan_name"];
            $nestedData[] = $row["status_name"];
            $nestedData[] = $pay;
            $nestedData[] = $row["amount"];
            $nestedData[] = $date_payment;
            $nestedData[] = $diff->days;
            $nestedData[] = $row["name"];
            $nestedData[] = $button;
            //$nestedData[] = $row["id_contacts"];

            $data[] = $nestedData;
        }

        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
        );
        mysqli_close($conn);
        echo json_encode($json_data);
    break;

    case 'processPaymentStripe':
        $sql = "SELECT cs.id_status_services, cspp.* FROM contacts_services_pending_payment cspp INNER JOIN contacts_services cs ON cs.id = cspp.id_contacts_services where cspp.id = $id";
        $query = $obj_bdmysql->query($sql, $conn);

        if (is_array($query)) {

            $retries = $query[0]['retries'];
            $id_pending_payment = $query[0]['id'];
            $id_client = $query[0]['id_client'];
            $amount = $query[0]['amount'];
            $fee = $query[0]['fee'];
            $name_plan = $query[0]['plan_name'];
            $holder_name = $query[0]['holder_name'];
            $id_contacts_payment_methods_stripe = $query[0]['id_contacts_payment_methods_stripe'];
            $id_contacts_services = $query[0]['id_contacts_services'];

            $pay_type = $query[0]['pay_type'];
            $person_interacting = $query[0]['person_interacting'];
            $commission = $query[0]['commission'];
            $date_payment = $query[0]['date_payment'];

            $status_services = $query[0]['id_status_services'];

            $message_error = "";
            $extract_description = "";

            if ($id_client == 112) {
                $extract_description = "SERENITY FUNERAL";
            } else if ($id_client == 110) {
                $extract_description = "CAMBRIDGE FUNERAL";
            } else if ($id_client == 125) {
                $extract_description = "FUNERALDEMO"; // 10 caracteres máximo 
            } else if ($id_client == 149) {
                $extract_description = "RAICES";
            }

            $sqlk = "SELECT secret_key, publishable_key FROM client_key_stripe WHERE id_client = $id_client";
            $queryk = $obj_bdmysql->query($sqlk, $conn);

            if (is_array($queryk)) {
                $secret_key = $queryk[0]['secret_key'];
                $publishable_key = $queryk[0]['publishable_key'];

                $sql = "SELECT id_contacts, id_payment_method, status, type FROM contacts_payment_methods_stripe WHERE id = $id_contacts_payment_methods_stripe";
                $queryW = $obj_bdmysql->query($sql, $conn);

                //print_r($sql);exit;

                if (is_array($queryW)) {

                    if ($queryW[0]['status'] == 1) {
                        $id_contacts_customer = $queryW[0]['id_contacts'];
                        $id_payment_method = $queryW[0]['id_payment_method'];
                        $status_method = $queryW[0]['status'];
                        $type_payment_method = $queryW[0]['type'];

                        $sql = "SELECT id_customer_stripe FROM contacts WHERE id = $id_contacts_customer";
                        $queryR = $obj_bdmysql->query($sql, $conn);

                        $id_customer = $queryR[0]['id_customer_stripe'];
                        /// stripe joes test
                        $stripe = array(
                            "secret_key" => $secret_key,
                            "publishable_key" => $publishable_key,
                        );

                        \Stripe\Stripe::setApiKey($stripe['secret_key']);

                        try {

                            if ($type_payment_method == 1) {
                                $statement = "statement_descriptor";
                            } elseif ($type_payment_method == 2) {
                                $statement = "statement_descriptor_suffix";
                            }

                            $PaymentIntent = \Stripe\PaymentIntent::create([
                                'amount' => $amount * 100,
                                'currency' => 'usd',
                                'customer' => $id_customer,
                                'payment_method_types' => ['card', 'us_bank_account'],
                                'payment_method' => $id_payment_method,
                                'off_session' => true,
                                'confirm' => true,
                                'description' => 'Plan: ' . $name_plan . ' - customer: ' . $holder_name,
                                $statement => $extract_description,
                            ]);

                            //pendiente
                            //'mandate' => 'mandate_1LcyssIv3F6QpFe73t0jsR86'

                            $out['code'] = 200;
                            $out['message'] = "Successfully Paid";

                        } catch (Exception $e) {
                            $out['code'] = 204;
                            $message_error = addslashes($e->getMessage());
                            $out['message_error'] = $message_error;
                        }

                        if ($out['code'] == 200) {
                            if ($PaymentIntent["status"] == "processing") {
                                $campo = "status = 7, note='esperando confirmacion de pago'";
                                $where = "id = '$id_pending_payment'";
                                $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                                saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, 7, $type_payment_method, $PaymentIntent["id"]);

                                $out["code"] = 200;
                                $out["message"] = $lang == "es" ? "El pago está siendo procesado, ahora debes esperar una confirmación" : "The payment is being processed, now you must wait for a confirmation";

                            } elseif ($PaymentIntent["status"] == "succeeded") {
                                $date = new DateTime();
                                $date = $date->format('Y-m-d H:i:s');

                                $campo = "status = 2, note='succeeded', date_payment_success = '$date'"; //status 2 = pago 
                                $where = "id = '$id_pending_payment'";
                                $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                                saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, 2, $type_payment_method, $PaymentIntent["id"]);

                                if($person_interacting != 2467 && $person_interacting != 3304) {
                                    saveCommissions($id_pending_payment, $person_interacting, $commission, $date_payment, $amount, $id_client, $fee);
                                }

                                $sql = "SELECT agreement_number FROM contacts_services WHERE id = '$id_contacts_services'";
                                $query = $obj_bdmysql->query($sql, $conn);
                                if ($query[0]['agreement_number'] == null or $query[0]['agreement_number'] == "") {
                                    $sqlrs = "SELECT ss.id as id_status_service FROM status_services ss
                                    LEFT JOIN user_crm uc ON ss.id_client = uc.id_client
                                    LEFT JOIN contacts_services cs ON cs.person_interacting = uc.id
                                    WHERE ss.stage = 5 AND ss.id_client = getParentFromChild($id_client)";
                                    $query = $obj_bdmysql->query($sqlrs, $conn);
                                    $id_status_services = $query[0]['id_status_service'];

                                    $campo = "id_status_services = $id_status_services, date_sale = '$date'";
                                    $where = "id = '$id_contacts_services'";
                                    $query = $obj_bdmysql->update("contacts_services", $campo, $where, $conn);
                                    $obj_function->contactsServicesTimeLine($id_contacts_services,$id_status_services,'Usuario',$id_user_crm);

                                    if ($pay_type == "Monthly Payment" or $pay_type == "BiAnnual Payment" or $pay_type == "3 payments" or $pay_type == "Monthly" or $pay_type == "BiAnnual") {
                                        $payment_date = new DateTime();
                                        $payment_date_format = $payment_date->format('Y-m-d');
                                        $amount_next = findAmountNext($id_contacts_services);

                                        nextPendingPayments($pay_type, $payment_date_format, $amount_next, $id_contacts_payment_methods_stripe, $name_plan, $holder_name, $id_contacts_services, $id_client, $person_interacting, $commission, 0);
                                        //0 = payment method stripe
                                    }

                                    $salida = $obj_bdmysql->query("call spAgreementCode($id_contacts_services);", $conn, FALSE, 'CALL');
                                    
                                    $url = "https://serenity.gosmartcrm.com/app/model/global_model.php"; //Producción
                                    //$url = "http://localhost/frontend-crm/app/model/global_model.php"; //Para test Local
                                    $jsonData = [
                                        "method" => "sendPdfApplication",
                                        "id_contacts_services" => $id_contacts_services,
                                        "source" => "Payments Model",
                                    ];
                                    $curl_sendPdf = $obj_function->curlSetOptBasic($url, $jsonData);
                                }

                                //Ajuste 11-01-2024 Joes.
                                //Al pagar la cuota, se deben desactivar las notificaciones de pago para esta cuota. 
                                $campo = "status = 4";
                                $where = "id_related = '$id_pending_payment'";
                                $query = $obj_bdmysql->update("contacts_services_notification", $campo, $where, $conn);

                                //Y si la aplicacion está pausada y no tiene otra deuda, vuelve al status "SALE"
                                if($status_services == 31){
                                    $sql = "SELECT cspp.* FROM contacts_services_pending_payment cspp WHERE cspp.id_contacts_services = $id_contacts_services AND cspp.status = 3";
                                    $query = $obj_bdmysql->query($sql, $conn);

                                    if(!is_array($query)){
                                        $campo = "id_status_services = 24";
                                        $where = "id = '$id_contacts_services'";
                                        $query = $obj_bdmysql->update("contacts_services", $campo, $where, $conn);
                                        $obj_function->contactsServicesTimeLine($id_contacts_services,'24','Usuario',$id_user_crm);
                                    }
                                }
                                //Ajuste 11-01-2024 Joes.

                                $out["code"] = 200;
                                $out["message"] = $lang == "es" ? "El pago fue exitoso" : "Payment was successful";
                            } elseif ($PaymentIntent["status"] == "payment_failed") {
                                ///////////////////////////////
                                $message_error = $out["message_error"];
                                if ($retries < 2) {
                                    $status = 1;
                                    $campo = "retries = retries + 1, status = $status, note='$message_error'";//status 1 = pendiente para reintentar 
                                }else if($retries >= 2 ){
                                    $status = 3;
                                    $campo = "retries = retries + 1, status = $status, note='$message_error'";//status 3 = fallo por muchos intentos 
                                }

                                $where = "id = '$id_pending_payment'";
                                $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                                if ($status == 1) { 
                                    sendEmailInformation($id_contacts_services, $date_payment, "info");
                                    //sendSmsInformation($id_contacts_services, $date_payment, "info");
                                }elseif($status == 3){
                                    $campo = "id_status_services = 31"; //status 31 = paused
                                    $where = "id = $id_contacts_services";
                                    $query = $obj_bdmysql->update("contacts_services", $campo, $where, $conn);
                                    $obj_function->contactsServicesTimeLine($id_contacts_services,'31','Usuario',$id_user_crm);

                                    pausedApplication($id_contacts_services, $date_payment, $id_pending_payment);

                                    sendEmailInformation($id_contacts_services, $date_payment, "paused");
                                    //sendSmsInformation($id_contacts_services, $date_payment, "paused");
                                }

                                saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, $status, $type_payment_method, "");

                                $out["code"] = 204;
                                $out["message"] = $lang == "es" ? "Hubo un error al procesar su pago" : "There was an error processing your payment";
                                $out["message_error"] = $message_error;
                                /////////////////////////
                            }
                        } else if ($out['code'] == 204) {
                            ///////////////////////////////
                            $message_error = $out["message_error"];
                            if ($retries < 2) {
                                $status = 1;
                                $campo = "retries = retries + 1, status = $status, note='$message_error'";//status 1 = pendiente para reintentar 
                            }else if($retries >= 2 ){
                                $status = 3;
                                $campo = "retries = retries + 1, status = $status, note='$message_error'";//status 3 = fallo por muchos intentos 
                            }

                            $where = "id = '$id_pending_payment'";
                            $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                            if ($status == 1) { 
                                sendEmailInformation($id_contacts_services, $date_payment, "info");
                                //sendSmsInformation($id_contacts_services, $date_payment, "info");
                            }elseif($status == 3){
                                $campo = "id_status_services = 31"; //status 31 = paused
                                $where = "id = $id_contacts_services";
                                $query = $obj_bdmysql->update("contacts_services", $campo, $where, $conn);
                                $obj_function->contactsServicesTimeLine($id_contacts_services,'31','Usuario',$id_user_crm);

                                pausedApplication($id_contacts_services, $date_payment, $id_pending_payment);

                                sendEmailInformation($id_contacts_services, $date_payment, "paused");
                                //sendSmsInformation($id_contacts_services, $date_payment, "paused");
                            }

                            saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, $status, $type_payment_method, "");

                            $out["code"] = 204;
                            $out["message"] = $lang == "es" ? "Hubo un error al procesar su pago" : "There was an error processing your payment";
                            $out["message_error"] = $message_error;
                            /////////////////////////
                        }
                    } else {
                        $campo = "note = 'Metodo de pago no verificado', status = 6";
                        $where = "id = '$id_pending_payment'";
                        $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                        saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, 6, "", "");

                        $out["code"] = 204;
                        $out["message"] = $lang == "es" ? "Método de pago no verificado, debe verificar su método de pago actual o agregar uno nuevo e intentar el proceso nuevamente" : "Payment method not verified, you must verify your current payment method or add a new one and try the process again";
                    }
                } else {
                    $campo = "note = 'Metodo de pago no encontrado', status = 4";
                    $where = "id = '$id_pending_payment'";
                    $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                    saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, 4, "", "");

                    $out["code"] = 204;
                    $out["message"] = $lang == "es" ? "Metodo de pago no encontrado, deberá agregar un nuevo metodo de pago antes de ejecutar nuevamente este proceso" : "Payment method not found, you will need to add a new payment method before running this process again";
                }
            } else {
                $campo = "note = 'Llave de cliente no encontrada', status = 5";
                $where = "id = '$id_pending_payment'";
                $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, 5, "", "");

                $out["code"] = 204;
                $out["message"] = $lang == "es" ? "Llave de cliente no encontrada" : "Client key not found";
            } //else
        } else {
            $out["code"] = 204;
            $out["message"] = "Error";
        }
        echo json_encode($out);
    break;

    case 'processPaymentOthers':
        $sql = "SELECT cs.id_status_services, cspp.* FROM contacts_services_pending_payment cspp INNER JOIN contacts_services cs ON cs.id = cspp.id_contacts_services where cspp.id = $id";
        $query = $obj_bdmysql->query($sql, $conn);

        $out["code"] = 204;
        $out["message"] = "Error";

        if (is_array($query)) {

            $retries = $query[0]['retries'];
            $id_contacts_card_stripe = $query[0]['id_contacts_card_stripe'];
            $id_pending_payment = $query[0]['id'];
            $id_client = $query[0]['id_client'];
            $amount = $query[0]['amount'];
            $name_plan = $query[0]['plan_name'];
            $holder_name = $query[0]['holder_name'];
            $id_contacts_services = $query[0]['id_contacts_services'];

            $pay_type = $query[0]['pay_type'];
            $person_interacting = $query[0]['person_interacting'];
            $commission = $query[0]['commission'];
            $date_payment = $query[0]['date_payment'];
            $fee = $query[0]['fee'];

            $status_services = $query[0]['id_status_services'];

            $date = new DateTime();
            $date = $date->format('Y-m-d H:i:s');

            $campo = "status = 2, note = '$note', date_payment_success = '$date'"; //status 2 = pago 
            $where = "id = '$id_pending_payment'";
            //  echo "UPDATE contacts_services_pending_payment SET ".$campo." ".$where;        var_dump($sqlrs);die();
            $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

            saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, 2, 3, "");

            if($person_interacting != 2467 && $person_interacting != 3304) {
                saveCommissions($id_pending_payment, $person_interacting, $commission, $date_payment, $amount, $id_client, $fee);
            }            

            $sql = "SELECT agreement_number FROM contacts_services WHERE id = '$id_contacts_services'";
            $query = $obj_bdmysql->query($sql, $conn);
            if ($query[0]['agreement_number'] == null or $query[0]['agreement_number'] == "") {
                $sqlrs = "SELECT ss.id as id_status_service FROM status_services ss
                LEFT JOIN user_crm uc ON ss.id_client = uc.id_client
                LEFT JOIN contacts_services cs ON cs.person_interacting = uc.id
                WHERE ss.stage = 5 AND ss.id_client = getParentFromChild($id_client)";
                $query = $obj_bdmysql->query($sqlrs, $conn);
                $id_status_services = $query[0]['id_status_service'];

                $campo = "id_status_services = $id_status_services, date_sale = '$date'";
                $where = "id = '$id_contacts_services'";
                $query = $obj_bdmysql->update("contacts_services", $campo, $where, $conn);
                $obj_function->contactsServicesTimeLine($id_contacts_services,$id_status_services,'Usuario',$id_user_crm);

                if ($pay_type == "Monthly Payment" or $pay_type == "BiAnnual Payment" or $pay_type == "3 payments" or $pay_type == "Monthly" or $pay_type == "BiAnnual") {
                    $payment_date = new DateTime();
                    $payment_date_format = $payment_date->format('Y-m-d');
                    $amount_next = findAmountNext($id_contacts_services);

                    $type_payment_method = $type_method == "zelle" ? 1 : 2;

                    nextPendingPaymentsOthers($pay_type, $payment_date_format, $amount_next, $name_plan, $holder_name, $id_contacts_services, $id_client, $person_interacting, $commission, $type_payment_method);
                }

                $salida = $obj_bdmysql->query("call spAgreementCode($id_contacts_services);", $conn, FALSE, 'CALL');

                $url = "https://serenity.gosmartcrm.com/app/model/global_model.php"; //Producción
                //$url = "http://localhost/frontend-crm/app/model/global_model.php"; //Para test Local
                $jsonData = [
                    "method" => "sendPdfApplication",
                    "id_contacts_services" => $id_contacts_services,
                    "source" => "Payments Model",
                ];
                $curl_sendPdf = $obj_function->curlSetOptBasic($url, $jsonData);
            }

            //Ajuste 11-01-2024 Joes.
            //Al pagar la cuota, se deben desactivar las notificaciones de pago para esta cuota. 
            $campo = "status = 4";
            $where = "id_related = '$id_pending_payment'";
            $query = $obj_bdmysql->update("contacts_services_notification", $campo, $where, $conn);

            //Y si la aplicacion está pausada y no tiene otra deuda, vuelve al status "SALE"
            if($status_services == 31){
                $sql = "SELECT cspp.* FROM contacts_services_pending_payment cspp WHERE cspp.id_contacts_services = $id_contacts_services AND cspp.status = 3";
                $query = $obj_bdmysql->query($sql, $conn);

                if(!is_array($query)){
                    $campo = "id_status_services = 24";
                    $where = "id = '$id_contacts_services'";
                    $query = $obj_bdmysql->update("contacts_services", $campo, $where, $conn);
                    $obj_function->contactsServicesTimeLine($id_contacts_services,'24','Usuario',$id_user_crm);
                }
            }
            //Ajuste 11-01-2024 Joes.

            $out["code"] = 200;
            $out["message"] = $lang == "es" ? "El pago fue exitoso" : "Payment was successful";

        }
        echo json_encode($out);
    break;

    case 'listPaymentsMethods':

        $requestData = $_REQUEST;
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'type',
            2 => 'last4',
            3 => 'description',
            4 => 'principal',
        );
        $sql = "SELECT id, last4, type, principal, description FROM contacts_payment_methods_stripe WHERE id_contacts = $id_contacts";

        if (!empty($requestData['search']['value'])) {
            // if there is a search parameter, $requestData['search']['value'] contains search parameter
            $sql .= " AND ( id LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR type LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR last4 LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR description LIKE '%" . $requestData['search']['value'] . "%' ) ";
        }

        $query = mysqli_query($conn, $sql) or die($sql);
        $totalData = mysqli_num_rows($query);
        //echo $sql;exit;
        $query = mysqli_query($conn, $sql) or die($sql);
        $totalFiltered = mysqli_num_rows($query); // when there is a search parameter then we have to modify total number filtered rows as per search result.

        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
        $query = mysqli_query($conn, $sql) or die($sql);
        //print_r($sql);exit;
        $data = array();
        while ($row = mysqli_fetch_array($query)) {

            $nestedData = array();

            $s = array();
            $s[] = '<span title="change status" class="m-switch m-switch--outline m-switch--danger"><label><input m-switch m-switch--outline m-switch--danger onchange="Payments.statusPaymentMethod(' . $row["id"] . ')" type="checkbox"><span></span></label></span>';
            $s[] = '<span title="change status" class="m-switch m-switch--outline m-switch--success"><label><input class="m-switch m-switch--outline m-switch--success" onchange="Payments.statusPaymentMethod(' . $row["id"] . ')" checked="checked" type="checkbox"><span></span></label></span>';

            if ($row['type'] == 1) {
                $type = "<span class='badge badge-info'>Bank</span>";
            } else if ($row['type'] == 2) {
                $type = "<span class='badge badge-primary'>Card</span>";
            } else {
                $type = "<span class='badge badge-secondary'>Unverified</span>";
            }

            //print_r($switch);exit;

            $nestedData[] = '<center>' . $row['id'] . '</center>';
            $nestedData[] = '<center>' . $type . '</center>';
            $nestedData[] = '<center>' . $row['last4'] . '</center>';
            $nestedData[] = '<center>' . $row['description'] . '</center>';
            $nestedData[] = $s[$row["principal"]];

            $data[] = $nestedData;
        }

        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
            // total data array
            "code" => 200
        );
        mysqli_close($conn);
        echo json_encode($json_data);
    break;

    case 'changeStatusPaymentMethod':

        $campo = "principal='0'";
        $where = "id_contacts = $id_contacts";
        $query = $obj_bdmysql->update("contacts_payment_methods_stripe", $campo, $where, $conn);

        $campo = "principal='1'";
        $where = "id = $id";
        $query = $obj_bdmysql->update("contacts_payment_methods_stripe", $campo, $where, $conn);

        if ($id > 0) {
            //0: sin paga, 1: falló y se reintentara, 3: falló en varios intentos, 
            //4: sin tarjeta o banco, 6:metodo de pago no verificado
            $campo = "id_contacts_payment_methods_stripe = '$id', id_contacts_card_stripe = null";
            $where = "id_contacts_services = '$id_contacts_services' AND status IN (0,1,3,4,5,6,8)";
            $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);
        }

        $out['code'] = 200;
        $out['message'] = 'Ok!';

        echo json_encode($out);

        mysqli_close($conn);
    break;

    case 'getPkStripe':

        $sql = "SELECT secret_key, publishable_key FROM gosmart_v103.client_key_stripe WHERE id_client = " . findParentMain($id_client);
        $query = $obj_bdmysql->query($sql, $conn);

        if (is_array($query)) {
            $stripe_data = array(
                "secret_key" => $query[0]['secret_key'],
                "publishable_key" => $query[0]['publishable_key']
            );
            //print_r($stripe_data['secret_key']);exit;

            $stripe = new \Stripe\StripeClient($stripe_data['secret_key']);
            $setupIntents = $stripe->setupIntents->create(
                [
                    'payment_method_types' => ['us_bank_account', 'card'],
                    'payment_method_options' => [
                        'us_bank_account' => [
                            'financial_connections' => [
                                'permissions' => ['payment_method'],
                            ],
                        ],
                    ],
                ]
            );

            if ($setupIntents->client_secret != "") {
                $out['code'] = 200;
                $out['setupIntents'] = $setupIntents;
                $out['pk'] = $stripe_data['publishable_key'];
            } else {
                $out['code'] = 204;
            }
        } else {
            $out['message'] = "error";
            $out['code'] = 204;
        }

        echo json_encode($out);

        mysqli_close($conn);
    break;

    case 'savePaymentMethod':

        $sql = "SELECT secret_key, publishable_key FROM gosmart_v103.client_key_stripe WHERE id_client = " . findParentMain($id_client);
        $query = $obj_bdmysql->query($sql, $conn);

        if (is_array($query)) {

            $customer = '';
            $setupIntent = json_decode($_POST['setupIntent']);
            //print_r($setupIntent->payment_method);exit;
            $stripe = array(
                "secret_key" => $query[0]['secret_key'],
                "publishable_key" => $query[0]['publishable_key']
            );
            \Stripe\Stripe::setApiKey($stripe['secret_key']);

            $sql = "SELECT c.id_customer_stripe, concat(c.name, ' ',c.last_name) as name, ce.email FROM contacts c left join contacts_email ce ON ce.id_contacts = c.id WHERE c.id = $id_contacts";
            $query = $obj_bdmysql->query($sql, $conn);

            if (is_array($query)) {
                $id_customer_stripe = $query[0]['id_customer_stripe'];
                $name_contact = $query[0]['name'];
                $email_contact = $query[0]['email'];

                if ($id_customer_stripe == "") { //debe crearse el customer y vincularlo al contacto
                    try {
                        $customer = \Stripe\Customer::create(
                            array(
                                "name" => $name_contact,
                                "email" => $email_contact
                            )
                        );
                    } catch (Exception $e) {
                        //echo json_encode(array('code' => 400, 'message' => 'Error, card is not supported', 'messageError' => $e->getMessage()));
                    }

                    if ($customer->id != "") {
                        $id_customer_stripe = $customer->id;

                        $campo = "id_customer_stripe='$id_customer_stripe'";
                        $where = "id = $id_contacts";
                        $query = $obj_bdmysql->update("contacts", $campo, $where, $conn);
                    }
                }

                $id_payment_method = $setupIntent->payment_method;

                $out["id_customer"] = $id_customer_stripe;
                $out["payment_method"] = $id_payment_method;


                if ($setupIntent->status == "succeeded") {
                    //si el setup intent está en "succeded" quiere decir que el metodo de pago ya es valido
                    //y se puede adjuntar a un customer para ser utilizado 

                    $stripe = new \Stripe\StripeClient($stripe['secret_key']);
                    $attach = $stripe->paymentMethods->attach(
                        $id_payment_method,
                        ['customer' => $id_customer_stripe]
                    );
                    $method_status = 1; //succeeded

                    if ($attach['type'] == "us_bank_account") {
                        $financial_connections_account = $attach['us_bank_account']['financial_connections_account'];
                        $bank_name = $attach['us_bank_account']['bank_name'];
                        $last4 = $attach['us_bank_account']['last4'];
                        $type_payment = 1; //banco

                        $campo = "id_contacts, id_payment_method, type, principal, status, bank_name, last4, id_financial_connections, description";
                        $valor = "$id_contacts, '$id_payment_method', '$type_payment', 1, '$method_status', '$bank_name', '$last4', '$financial_connections_account', '$description'";
                    } else {

                        $month = $attach['card']['exp_month'];
                        $year = $attach['card']['exp_year'];
                        if (strlen($month) == 1) {
                            $expiration_date = '0' . $month . '/' . $year;
                        } else {
                            $expiration_date = $month . '/' . $year;
                        }
                        $last4 = $attach['card']['last4'];
                        $type_payment = 2; //tarjeta

                        $campo = "id_contacts, id_payment_method, type, principal, status, expiration_date, last4, description";
                        $valor = "$id_contacts, '$id_payment_method', '$type_payment', 1, '$method_status', '$expiration_date', '$last4', '$description'";
                    }

                    $campo_update = "principal = 0";
                    $where_update = "id_contacts = '$id_contacts'";
                    $query = $obj_bdmysql->update("contacts_payment_methods_stripe", $campo_update, $where_update, $conn);

                    $id = $obj_bdmysql->insert("contacts_payment_methods_stripe", $campo, $valor, $conn);

                    if ($id > 0) {
                        $out["code"] = 200;
                        $out["message"] = $lang == "es" ? "Método de pago creado" : "Payment method created";
                    } else {
                        $out["code"] = 204;
                        $out["message"] = $lang == "es" ? "Error al insertar" : "Error inserting";
                    }
                } else {
                    $method_status = 0; //no succeeded

                    $campo_update = "principal = 0";
                    $where_update = "id_contacts = '$id_contacts'";
                    $query = $obj_bdmysql->update("contacts_payment_methods_stripe", $campo_update, $where_update, $conn);

                    $campo = "id_contacts, id_payment_method, status, principal, description";
                    $valor = "$id_contacts, '$id_payment_method', '$method_status', '1', '$description'";
                    $id = $obj_bdmysql->insert("contacts_payment_methods_stripe", $campo, $valor, $conn);

                    if ($id > 0) {
                        $out["code"] = 200;
                        $out["message"] = $lang == "es" ? "Método de pago creado, sin embargo debes verificarlo con las instrucciones que se enviarán al correo electrónico que proporcionaste." : "Payment method created, however you must verify it with the instructions that will be sent to the email you provided.";
                    } else {
                        $out["code"] = 204;
                        $out["message"] = $lang == "es" ? "Error al insertar" : "Error inserting";
                    }
                }

                if ($id > 0) {
                    //0: sin paga, 1: falló y se reintentara, 3: falló en varios intentos, 
                    //4: sin tarjeta o banco, 6:metodo de pago no verificado
                    $campo = "id_contacts_payment_methods_stripe = '$id', id_contacts_card_stripe = null";
                    $where = "id_contacts_services = '$id_contacts_services' AND status IN (0,1,3,4,6)";
                    $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);
                }
            } else {
                $out['message'] = $lang == "es" ? "Contacto no encontrado." : "Contact not found.";
                $out['code'] = 204;
            }
        } else {
            $out['message'] = $lang == "es" ? "Llave de cliente no encontrada" : "Client key not found";
            $out['code'] = 204;
        }
        echo json_encode($out);

        mysqli_close($conn);
    break;

    case 'NotificationsPayments':
        $out = array('code' => 204, 'message' => 'client OR role no valid...!', 'id_principal' => $id_principal, 'id_cliente' => $id_client, 'id_role' => $id_role);
        if ($id_principal == 111) { // interlife
            if ($id_role == 1 || $id_role == 29 || $id_role == 31) { // administrator - Customer Support
                $sql = "SELECT * FROM contacts_services_pending_payment cspp 
                WHERE (cspp.status = 1 OR cspp.status = 3 OR cspp.status = 4 OR cspp.status = 8) 
                AND updated BETWEEN date_add(NOW(), INTERVAL - 7 DAY) AND NOW()"; // list notifications dev
                ///////////////////////////////////////// 
                if ($id_role == 1) {
                    $sql .= " AND cspp.id_client IN ($parentBYClient)";
                }
                if ($id_role == 29 || $id_role == 31) {
                    $sql .= " AND cspp.id_client IN ($parentBYClient)";
                }
                $sql .= ' ORDER BY cspp.id DESC ';
                /////////////////////////////////////////
                $query = $obj_bdmysql->query($sql, $conn);
                $q = mysqli_query($conn, $sql);
                $cant_noti_news = mysqli_num_rows($q); // cantidad

                $data = array();
                foreach ($query as $value) {

                    $nestedData = new stdClass(); // objeto base default PHP

                    $nestedData->id = $value['id'];
                    $nestedData->holder_name = $value['holder_name'];
                    $nestedData->amount = $value['amount'];
                    $nestedData->date_payment = $value['date_payment'];
                    $nestedData->plan_name = $value['plan_name'];
                    $nestedData->note = $value['note'];
                    $nestedData->status = $value['status'];

                    $data[] = $nestedData;
                }

                $out = array(
                    'code' => 200,
                    'message' => 'NotificationsPayments...!',
                    'id_principal' => $id_principal,
                    'id_cliente' => $id_client,
                    'id_role' => $id_role,
                    'news' => $cant_noti_news,
                    'listNotifications' => $data,
                    'sql' => $sql
                );
            }
        }
        mysqli_close($conn);
        echo json_encode($out);
    break;

    case 'cancelPayment':

        $date = date('Y-m-d');

        $campo = "status = 9, note = 'canceled'";
        $where = "id = $id";
        $test = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

        $out["code"] = 200;
        $out["message"] = "Ok";

        echo json_encode($out);
    break;

    case 'confirmPaymentMethod':
        $sql = "SELECT * FROM gosmart_v103.contacts_payment_methods_stripe WHERE id_contacts = $id AND principal = 1";
        $query = $obj_bdmysql->query($sql, $conn);
        // var_dump($sql);die();
        if (is_array($query)) {
            $out["code"] = 200;
            $out["message"] = "Ok";
        } else {
            $out['message'] = $lang == "es" ? "EL client no posee metodo de pago registrado en stripe !Debe agregarlo!  " : "The client does not have a payment method registered in stripe! You must add it!";
            $out['code'] = 204;
        }

        echo json_encode($out);
    break;

    case 'findPaymentsCalendar':
        $dates = $_POST['dates'];
        // var_dump($_POST);

        $sql = "SELECT DATE(cpm.date_payment) AS date, ROUND(SUM(cpm.amount),1) totalAmount, COUNT(cs.id_status_services) status_sales, COUNT(DISTINCT cpm.person_interacting) agents
        FROM contacts_services_pending_payment cpm
        LEFT JOIN contacts_services cs ON cs.id = cpm.id_contacts_services
        LEFT JOIN services s ON s.id = cs.id_services
        LEFT JOIN user_crm uc ON cs.person_interacting = uc.id";

        $sqlPast = "SELECT DATE(cps.updated) AS date, ROUND(SUM(cps.amount),1) totalAmount, COUNT(cs.id_status_services) status_sales, COUNT(DISTINCT cps.person_interacting) agents
        FROM contacts_services_payment cps
        LEFT JOIN contacts_services cs ON cs.id = cps.id_contacts_services
        LEFT JOIN services s ON s.id = cs.id_services
        LEFT JOIN user_crm uc ON cs.person_interacting = uc.id";

        $sql .= " WHERE cs.id_status_services = 24 AND s.id_client = $id_client AND ((s.id = $id_payment_label) OR (cs.person_interacting = $id_payment_label)) AND YEAR(cpm.date_payment) = YEAR('$fecha') AND date(cpm.date_payment) > date(now())";
        $sqlPast .= " WHERE cs.id_status_services = 24 AND s.id_client = $id_client AND ((s.id = $id_payment_label) OR (cs.person_interacting = $id_payment_label)) AND cps.status = 2  AND YEAR(cps.updated) = YEAR('$fecha') AND date(cps.updated) <= date(now())";


        $sql .= " GROUP BY DATE(cpm.date_payment)";
        $sqlPast .= " GROUP BY DATE(cps.updated)";
        // var_dump($sqlPast);
        // die();

        $resultado = $obj_bdmysql->query($sql, $conn);
        $resultadopast = $obj_bdmysql->query($sqlPast, $conn);
        // $resultado2 = array_merge($resultado,$resultadopast);  
        if($resultado == 'null') {
            $resultado2 = $resultadopast;
        }  else{
            $resultadopast == 'null';
        }   

        if($resultadopast == 'null'){
            $resultado2 = $resultado;
        }else{
            $resultado2 = array_merge($resultado, $resultadopast);
        }
        // $resultado == 'null' ? $resultado2 = $resultadopast : $resultadopast == 'null' ? $resultado2 = $resultado : $resultado2 = array_merge($resultado, $resultadopast);

        //var_dump($resultado);
        //var_dump($resultadopast);
        //die();

        $data = array();
        foreach ($resultado2 as $rows) {
            $name = utf8_encode($name);
            $row['date'] = $rows['date'];
            $row['totalAmount'] = floatval($rows['totalAmount']);
            $row['status_sales'] = $rows['status_sales'];
            $row['agents'] = $rows['agents'];
            $row['start'] = $rows['start'];
            $row['end'] = $rows['end'];
            $data[] = $row;
        }
        $typeArgument = $type;

        $resp = array('mss' => '1', 'data' => $data, 'typeArgument' => $type);

        mysqli_close($conn);
        echo json_encode($resp);
    break;

    case 'viewNotePayment':
        $sql = "SELECT note FROM gosmart_v103.contacts_services_pending_payment WHERE id = $id";
        $query = $obj_bdmysql->query($sql, $conn);
        // var_dump($sql);die();
        if (is_array($query)) {
            $out["code"] = 200;
            $out["note"] = $query[0]['note'];
        } else {
            $out["note"] = "";
            $out['code'] = 204;
        }

        echo json_encode($out);
    break;

    case 'refundStripe':
        $sql = "SELECT cspp.id as id_contacts_services_pending_payment, cspay.* 
            FROM contacts_services_pending_payment cspp 
            INNER JOIN contacts_services_payment cspay 
            ON cspay.id_contacts_services = cspp.id_contacts_services
            AND cspay.date_payment = cspp.date_payment
            AND cspay.id = 
            (
               SELECT MAX(id) 
               FROM contacts_services_payment cspay 
               WHERE cspay.id_contacts_services = cspp.id_contacts_services AND cspay.date_payment = cspp.date_payment
            )
        WHERE cspp.id = $id";
        $query = $obj_bdmysql->query($sql, $conn);
        //print_r($sql);exit;
        if (is_array($query)) {
            $id_contacts_services_pending_payment = $query[0]['id_contacts_services_pending_payment'];
            $id_contacts_services_payment = $query[0]['id'];
            $id_contacts_services = $query[0]['id_contacts_services'];
            $id_client = $query[0]['id_client'];
            $date_payment = $query[0]['date_payment'];
            $id_payment_intent = $query[0]['id_payment_intent'];
            $name_plan = $query[0]['plan_name'];
            $pay_type = $query[0]['pay_type'];
            $amount = $query[0]['amount'];
            $person_interacting = $query[0]['person_interacting'];
            $commission = $query[0]['commission'];
            $payment_type = $query[0]['payment_type'];
            $status = $query[0]['status'];
            
            if($id_role == 29){
                $campo = "reason_refund = '$reason', status = 13, note = '$note - Solicitado Por: $user_name'";
                $where = "id = '$id_contacts_services_pending_payment'";
                $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                $campo = "id_contacts_services, id_client, plan_name, pay_type, amount, date_payment, person_interacting, commission, status, payment_type, id_payment_intent, reason_refund, note";
                $valor = "$id_contacts_services, $id_client, '$name_plan', '$pay_type', '$amount', '$date_payment', '$person_interacting', '$commission', 13, '$payment_type', '$id_payment_intent', '$reason', '$note - Solicitado Por: $user_name'";
                $obj_bdmysql->insert("contacts_services_payment", $campo, $valor, $conn);

                $out["code"] = 200;
                $out["message"] = $lang == "es" ? "Su solicitud será procesada, un administrador la revisará" : "Your request will be processed, an administrator will review it";
            }
            else if($id_role == 1){
                $sqlk = "SELECT secret_key FROM client_key_stripe WHERE id_client = $id_client";
                $queryk = $obj_bdmysql->query($sqlk, $conn);

                if (is_array($queryk)) {
                    $secret_key = $queryk[0]['secret_key'];

                    \Stripe\Stripe::setApiKey($secret_key);

                    try {
                        $refund = \Stripe\Refund::create([
                            'payment_intent' => $id_payment_intent,
                            'reason' => $reason,
                        ]);

                        $out['code'] = 200;
                        $out['message'] = "Successfully Refund";
                        //$out['refund'] = $refund;

                    } catch (Exception $e) {
                        $out['code'] = 204;
                        $message_error = addslashes($e->getMessage());
                        $out['message_error'] = $message_error;
                    }

                    if ($out['code'] == 200) {
                        $campo = "reason_refund = '$reason', status = 10, note = '$note - Aprobado Por: $user_name'";
                        $where = "id = '$id_contacts_services_pending_payment'";
                        $query = $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);

                        $campo = "id_contacts_services, id_client, plan_name, pay_type, amount, date_payment, person_interacting, commission, status, payment_type, id_payment_intent, reason_refund, note";
                        $valor = "$id_contacts_services, $id_client, '$name_plan', '$pay_type', '$amount', '$date_payment', '$person_interacting', '$commission', 10, '$payment_type', '$id_payment_intent', '$reason', '$note - Aprobado Por: $user_name'";
                        $obj_bdmysql->insert("contacts_services_payment", $campo, $valor, $conn);

                        $out["code"] = 200;
                        $out["message"] = $lang == "es" ? "Reembolso exitoso" : "Successfully Refund";
                    } else if ($out['code'] == 204) {
                        $out["code"] = 204;
                        $out["message"] = $lang == "es" ? "Hubo un error al procesar su Reembolso" : "There was an error processing your Refund";
                        $out["message_error"] = $message_error;
                        /////////////////////////
                    }
                } else {
                    $out["code"] = 204;
                    $out["message"] = $lang == "es" ? "Llave de cliente no encontrada" : "Client key not found";
                } //else  
            }
        } else {
            $out["code"] = 204;
            $out["message"] = "Error";
        }
        echo json_encode($out);
    break;

    case 'viewRefundStripe':
        $sql = "SELECT cspp.id, cspp.note, cspp.reason_refund, cspp.status FROM contacts_services_pending_payment cspp WHERE id = $id";
        $query = $obj_bdmysql->query($sql, $conn);
        // var_dump($sql);die();
        if (is_array($query)) {
            $out["code"] = 200;
            $out["id_contacts_services_pending_payment"] = $query[0]['id'];
            $out["id_role"] = $id_role;
            $out["status"] = $query[0]['status'];
            $out["note"] = $query[0]['note'];
            $out["reason_refund"] = $query[0]['reason_refund'];
        } else {
            $out["note"] = "";
            $out['code'] = 204;
        }

        echo json_encode($out);
    break;
case 'showPdfReceipt':
    $sql = "SELECT cspp.*, cs.agreement_number, cs.date_sale, csp.id_payment_intent, 
        cs.data_json->>'$.beneficiaries' AS beneficiaries, 
        CASE 
            WHEN csp.payment_type = 1 THEN 'Bank Account'
            WHEN csp.payment_type = 2 THEN 'Credit Card'
            WHEN csp.payment_type = 3 THEN 'Other'
        END payment_method,
        cps.last4, cspp.id_contacts_services, c.crtificatePdfJson->'$.crtificatePdfJson.CertificadoHtml.$lang' AS certificate_html
        FROM contacts_services_pending_payment cspp
        INNER JOIN contacts_services cs ON cs.id = cspp.id_contacts_services
        INNER JOIN contacts_services_payment csp ON csp.id_contacts_services = cspp.id_contacts_services 
            AND csp.date_payment = cspp.date_payment
        LEFT JOIN contacts_payment_methods_stripe cps ON cps.id = cspp.id_contacts_payment_methods_stripe
            AND csp.payment_type IN (1, 2)
            INNER JOIN client c ON c.id = csp.id_client
        WHERE cspp.id = $id";
	//WHERE cspp.id = $id AND csp.id_client IN ($parentBYClient)";
    $query = $obj_bdmysql->query($sql, $conn);
    
    // print_r($sql);exit;
    $id_contacts_services = $query[0]['id_contacts_services'];

    $sqlNext = "SELECT cspp.date_payment, cspp.amount, u.agent_code, u.email, u.name
        FROM contacts_services_pending_payment cspp
        inner join user_crm u ON u.id = cspp.person_interacting
        WHERE cspp.id_contacts_services = $id_contacts_services AND cspp.id > $id 
        order by cspp.id asc limit 1";
    $queryNext = $obj_bdmysql->query($sqlNext, $conn);

    // -----------------------------
    // 🔹 Decodificar los beneficiarios
    // -----------------------------
    $beneficiaries = json_decode($query[0]['beneficiaries'], true);

    $beneficiariesHtml = "";
    foreach ($beneficiaries as $beneficiary) {
        if (!empty($beneficiary['name'])) {
            $fullName = trim($beneficiary['name']." ".$beneficiary['middleName']." ".$beneficiary['lastName']);
            $dob = !empty($beneficiary['birthdate']) ? date("m/d/Y", strtotime($beneficiary['birthdate'])) : "";
            $cityStateResidence = trim($beneficiary['city']."/".$beneficiary['state']."/".$beneficiary['residence']);

            $beneficiariesHtml .= "<tr>
                <td>".htmlspecialchars($fullName)."</td>
                <td>".htmlspecialchars($beneficiary['relationship'])."</td>
                <td>".htmlspecialchars($dob)."</td>
                <td>".htmlspecialchars($beneficiary['age'])."</td>
                <td>".htmlspecialchars($beneficiary['nationality'])."</td>
                <td>".htmlspecialchars($cityStateResidence)."</td>
                <td>".htmlspecialchars($query[0]['date_payment'])."</td>
            </tr>";
        }
    }
    // echo $beneficiariesHtml;
    // -----------------------------
    // Generar HTML base
    // -----------------------------
    $html = json_decode($query[0]['certificate_html'], true);
    $date = date("m-d-Y");
    

    $html = str_replace("{{DateNow}}", $date, $html);
    $html = str_replace("{{holder_name}}", $query[0]['holder_name'], $html);
    $html = str_replace("{{pay_type}}", $query[0]['pay_type'], $html);
    $html = str_replace("{{plan_name}}", $query[0]['plan_name'], $html);
    $html = str_replace("{{agreement_number}}", $query[0]['agreement_number'], $html);
    $html = str_replace("{{date_sale}}", date('m-d-Y', strtotime($query[0]['date_sale'])), $html);

    $html = str_replace("{{amount}}", '299', $html);
    $html = str_replace("{{date_payment}}", date('m-d-Y', strtotime($query[0]['date_payment'])), $html);
    $html = str_replace("{{date_payment_success}}", date('m-d-Y', strtotime($query[0]['date_payment_success'])), $html);
    $html = str_replace("{{payment_method}}", $query[0]['payment_method'], $html);
    $html = str_replace("{{last4}}", $query[0]['last4'], $html);
    
    $queryNextDatePayment =  $queryNext[0]['date_payment'];
    if ($queryNextDatePayment != ""){
        $html = str_replace("{{next_payment}}", date('m-d-Y', strtotime($queryNext[0]['date_payment'])), $html);
    } else {
        $html = str_replace("{{next_payment}}", '', $html);
    }
    // $html = str_replace("{{next_payment}}", date('m-d-Y', strtotime($queryNext[0]['date_payment'])), $html);
    $html = str_replace("{{amount_next}}", $queryNext[0]['amount'], $html);
    $html = str_replace("{{agent_code}}", $queryNext[0]['agent_code'], $html);
    $html = str_replace("{{email}}", $queryNext[0]['email'], $html);
    $html = str_replace("{{agent_name}}", $queryNext[0]['name'], $html);

    // 🔹 Insertar tabla de beneficiarios
    $html = str_replace("{{beneficiaries_table}}", $beneficiariesHtml, $html);

    // -----------------------------
    // Generar PDF
    // -----------------------------
    $dompdf = new Dompdf();
    $dompdf->load_html($html);
    ini_set("memory_limit", "100M");
    $dompdf->set_paper("letter", "portrait");
    $dompdf->render();
    $attachment_pdf_html = $dompdf->output();

    $receipt[] = strval(base64_encode($attachment_pdf_html));

    $resp = array('receipt' => ($receipt));
    echo json_encode($resp);
break;

}

function saveContactsServicesPayment($id_contacts_services, $id_client, $name_plan, $pay_type, $amount, $date_payment, $person_interacting, $commission, $status, $payment_type, $id_payment_intent)
{
    // función desarrollada, para registro de intentos de pago realizados con o sin exito. 
    //se guarda data en tabla ( contacts_services_payment). 
    global $conn, $obj_bdmysql, $obj_function;

    $campo = "id_contacts_services, id_client, plan_name, pay_type, amount, date_payment, person_interacting, commission, status, payment_type, note, id_payment_intent";
    $valor = "$id_contacts_services, $id_client, '$name_plan', '$pay_type', '$amount', '$date_payment', '$person_interacting', '$commission', '$status', '$payment_type', '$note', '$id_payment_intent'";
    $id = $obj_bdmysql->insert("contacts_services_payment", $campo, $valor, $conn);
    //$sql = "INSERT INTO contacts_services_payment ($campo) VALUES ($valor)";
    //echo $sql;exit();
}

function findParentMain($id_client)
{
    //la funcion "findParentMain" está hecha para encontrar el padre main de un cliente
    //actualmente solo funciona para serenity, cambridge y funeraldemo
    //by: Joes

    global $conn, $obj_bdmysql, $obj_function;

    $sql = "SELECT GROUP_CONCAT(id) AS parents
        FROM ( SELECT * FROM client ORDER BY id_parent, id) products_sorted,(
        SELECT @pv := 112) initialisation
        WHERE FIND_IN_SET(id_parent, @pv) > 0
        AND @pv := CONCAT(@pv, ',', id)";
    $query = $obj_bdmysql->query($sql, $conn);
    $serenity_sons = explode(",", $query[0]["parents"]);

    $sql = "SELECT GROUP_CONCAT(id) AS parents
        FROM ( SELECT * FROM client ORDER BY id_parent, id) products_sorted,(
        SELECT @pv := 110) initialisation
        WHERE FIND_IN_SET(id_parent, @pv) > 0
        AND @pv := CONCAT(@pv, ',', id)";
    $query = $obj_bdmysql->query($sql, $conn);
    $cambridge_sons = explode(",", $query[0]["parents"]);

    $sql = "SELECT GROUP_CONCAT(id) AS parents
        FROM ( SELECT * FROM client ORDER BY id_parent, id) products_sorted,(
        SELECT @pv := 125) initialisation
        WHERE FIND_IN_SET(id_parent, @pv) > 0
        AND @pv := CONCAT(@pv, ',', id)";
    $query = $obj_bdmysql->query($sql, $conn);
    $funeraldemo_sons = explode(",", $query[0]["parents"]);

    //print_r($serenity_sons);
    //echo "--- ".$id_client;exit();

    if (in_array($id_client, $serenity_sons)) {
        return 112;
    } else if (in_array($id_client, $cambridge_sons)) {
        return 110;
    } else if (in_array($id_client, $funeraldemo_sons)) {
        return 125;
    } else {
        return $id_client;
    }
}

function saveCommissions($id_payment_due, $person_interacting, $first_commission, $date_payment, $amount, $id_client, $fee){
    // función desarrollada, para registro de intentos de pago realizados con o sin exito.
    //se guarda data en tabla ( contacts_services_payment). 
    global $conn, $obj_bdmysql, $obj_function;

    $date = date("Y-m-d H:i:s");

    if ($fee > 0) {
        $amount = $amount - $fee;
    }

    if($amount > 0){
        $amount_commission = ($amount * $first_commission) / 100;
        $campo = "id_payment_due, amount, id_user, id_client, commission_percentage, commission_amount, type, date_create, date_payment, source";
        $valor = "$id_payment_due, $amount, $person_interacting, $id_client, $first_commission, $amount_commission, '1', '$date', '$date_payment', 'Payments Module'";
        $id = $obj_bdmysql->insert("commission_payments", $campo, $valor, $conn);
        
        $sql = "SELECT id, id_parent, commission, id_client FROM user_crm where id = $person_interacting";
        $query = $obj_bdmysql->query($sql, $conn);

        if ($query[0]['id_parent'] != 0 && $query[0]['id_parent'] != 2436) {
            $person_interacting = $query[0]['id_parent'];
            $check_id_parent = 1;
            $old_commission = $first_commission;
            $i = 0;
            do {
                $sql = "SELECT id, id_parent, commission, id_client FROM user_crm where id = $person_interacting";
                $query = $obj_bdmysql->query($sql, $conn);   

                $id_parent = $query[0]['id_parent'];
                $id_client = $query[0]['id_client'];
                $id_user = $query[0]['id'];        
                $commission = $query[0]['commission'];
                $person_interacting = $id_parent;

                if ($commission > $old_commission) {
                    $result_commission = $commission - $old_commission;
                    $amount_commission = ($amount * $result_commission) / 100;
                    $commission_percentage = $result_commission;
                }else if($commission <= $old_commission){
                    if($commission > 25){  
                        $commission_percentage = 5;
                        $amount_commission = ($amount * $commission_percentage) / 100;
                    }else{
                        $commission_percentage = 0;
                        $amount_commission = 0;
                    }
                }

                $campo = "id_payment_due, amount, id_user, id_client, commission_percentage, commission_amount, type, date_create, date_payment, source";        
                $valor = "$id_payment_due, $amount, $id_user, $id_client, $commission_percentage, $amount_commission, '2', '$date', '$date_payment', 'Payments Module'";
                $obj_bdmysql->insert("commission_payments", $campo, $valor, $conn);
            
                $old_commission = $commission;

                if ($id_parent == 0 || $id_parent == 2436 || $i == 20) {
                    $check_id_parent = 0;            
                }

                $i++;
                //cuando $i llegue a 20 iteraciones, se debe parar el do while
                //por seguridad para evita ciclo infinito
            } while ($check_id_parent == 1);   
        }
    }
}

function findAmountNext($id_contacts_services){
    global $conn, $obj_bdmysql;

    $sql = "SELECT cs.data_json->>'$.payment.nextPayment' AS nextPayment FROM contacts_services cs WHERE cs.id = $id_contacts_services";
    $query = $obj_bdmysql->query($sql, $conn);

    $amount_next = 0;
    if (is_array($query)) {
        $amount_next = $query[0]['nextPayment'];
    }
    return $amount_next;
}


function nextPendingPayments($pay_type, $payment_date_format, $amount_next, $id_contacts_payment_methods_stripe, $name_plan, $name, $id_contacts_services, $id_client, $person_interacting, $commission, $type_method)
{

    global $conn, $obj_bdmysql, $obj_function;

    if ($pay_type == "Monthly Payment" or $pay_type == "Monthly") {
        $months = 1;
        $count = 11;
    }
    if ($pay_type == "BiAnnual Payment" or $pay_type == "BiAnnual") {
        $months = 6;
        $count = 1;
    }
    if ($pay_type == "3 payments") {
        $months = 1;
        $count = 2;
    }

    $new_date_payment = $payment_date_format;

    for ($i = 0; $i < $count; $i++) {
        $day = date("d", strtotime($new_date_payment));
        if ($day >= 28) {
            $new_date_payment = date("Y-m-d", strtotime($new_date_payment . "last day of + $months month"));
        } else {
            $new_date_payment = date("Y-m-d", strtotime($new_date_payment . "+ $months month"));
        }

        $campo = "id_contacts_services, id_contacts_payment_methods_stripe, id_client, plan_name, holder_name, amount, date_payment, retries, status, pay_type, person_interacting, commission, payment_method";
        $valor = "$id_contacts_services, $id_contacts_payment_methods_stripe, $id_client, '$name_plan', '$name', '$amount_next', '$new_date_payment', 0, 0, '$pay_type', '$person_interacting', '$commission', $type_method";
        $obj_bdmysql->insert("contacts_services_pending_payment", $campo, $valor, $conn);
    }
}

function nextPendingPaymentsOthers($pay_type, $payment_date_format, $amount_next, $name_plan, $name, $id_contacts_services, $id_client, $person_interacting, $commission, $type_method)
{

    global $conn, $obj_bdmysql, $obj_function;


    if ($pay_type == "Monthly Payment" or $pay_type == "Monthly") {
        $months = 1;
        $count = 11;
    }
    if ($pay_type == "BiAnnual Payment" or $pay_type == "BiAnnual") {
        $months = 6;
        $count = 1;
    }
    if ($pay_type == "3 payments") {
        $months = 1;
        $count = 2;
    }

    $status = 0;
    $new_date_payment = $payment_date_format;
    for ($i = 0; $i < $count; $i++) {
        $day = date("d", strtotime($new_date_payment));
        if ($day >= 28) {
            $new_date_payment = date("Y-m-d", strtotime($new_date_payment . "last day of + $months month"));
        } else {
            $new_date_payment = date("Y-m-d", strtotime($new_date_payment . "+ $months month"));
        }

        $campo = "id_contacts_services, id_client, plan_name, holder_name, amount, date_payment, retries, status, pay_type, person_interacting, commission, payment_method";
        $valor = "$id_contacts_services, $id_client, '$name_plan', '$name', '$amount_next', '$new_date_payment', 0, $status, '$pay_type', '$person_interacting', '$commission', $type_method";
        $test = $obj_bdmysql->insert("contacts_services_pending_payment", $campo, $valor, $conn);
    }
}

function formatterViewDB($time) {
    // 09/22/2023
	if (!empty($time)) {
		$time = str_replace("'", "", $time);         
		list($mes, $dia, $ano) = explode("/", $time);
		return "$ano-$mes-$dia";
	}
}

function sendEmailInformation($id_contacts_services, $date_payment, $type){
    global $conn, $obj_bdmysql, $obj_function;

    $sql = "SELECT 
        c.id, 
        cs.id_services, 
        cs.data_json->>'$.holder.name' AS name,
        cs.data_json->>'$.holder.lastName' AS lastName, 
        cs.data_json->>'$.holder.email' AS email, 
        cs.data_json->>'$.payment.agentEmail' AS agentEmail
        FROM contacts_services cs
        JOIN user_crm uc ON cs.person_interacting = uc.id
        JOIN client c ON uc.id_client = c.id
        JOIN opportunities o ON cs.id_opportunities = o.id
        WHERE cs.id = $id_contacts_services";
    $query = $obj_bdmysql->query($sql, $conn);
    $id_client = $query[0]['id'];
    $id_service = $query[0]['id_services'];
    $correo = strtolower($query[0]['email']);
    $agent_email = strtolower($query[0]['agentEmail']);
    $first_name = ucfirst($query[0]['name']);
    $last_name = ucfirst($query[0]['lastName']);

    $new_date = new DateTime($date_payment);
    $new_date = $new_date->format('m-d-Y');

    if ($type == "info") {
        $subject = "Información sobre su pago correspondiente a la fecha $new_date .";
        $text = "$first_name $last_name, el pago correspondiente a la fecha $new_date ha fallado.";
    }else if($type == "paused"){
        $subject = "Atención! Su plan está Temporalmente Inactivo - Serenity Assistance";
        $contenido = '
                <h3 style="font-weight:100; color:#666">
                    <strong>
                        Estimado/a <span style="font-weight: bold"> '.$first_name . ' ' .$last_name.'</span>, su plan ha sido Suspendido.
                    </strong>
                </h3>

                <h3 style="font-weight:100; color:#666">
                    Le informamos que su plan ha sido temporalmente puesto en pausa debido a la falta de pago. Es muy importante que se comunique con nosotros lo antes posible, ya que, en caso de cualquier eventualidad, ninguno de sus beneficiarios estaría protegido.
                    <br><br>

                    Para resolver esta situación, por favor contáctenos a través de WhatsApp o llamada al 
                    <span style="font-weight: bold">307-888-0109.</span>

                    <br><br>
                    Estamos aquí para asistirle.
                </h3>
                <h4 style="font-weight:100; color:#666; padding:0 20px">
                    Atentamente,
                    <br>
                    Equipo de Servicio al Cliente
                    <br>
                    <span style="font-weight: bold">Serenity Assistance.</span>
                </h4>';
    }

    $message = '
        <!DOCTYPE html>
        <html lang="en">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Forgot Password</title>
                <style type="text/css">
                    .content{
                        width:100%; background:#eee; position:relative; font-family:sans-serif; padding-bottom:40px;
                    }
                    .body-email{
                        position:relative; margin:auto; width:700px; background:white; padding:20px
                    }
                    .img-email{
                        width:15%
                    }
                    @media (max-width: 768px) {
                       .body-email {
                         width: 80%;
                       }
                       .img-email{
                            width: 30%;
                       }
                    }
                </style>
            </head>
            <body>
                <div class="content">
                    <div class="body-email">
                        <center>
                        <img class="img-email" src="https://landing.gosmartcrm.com/common-preview/assets/media/img/images/LogoSerenityDiciembre400x200.jpg" style="width: 300px; height: 150px">
                        <div style="text-align: justify;">
                            ' . $contenido . '
                        </div>
                        </center>
                    </div>
                </div>
            </body>
    </html>';
    //$message = utf8_decode($message);

    $stmt = $conn->stmt_init();
    $stmt->prepare("call gosmart_v103.spSetParentsOut($id_client)");
    $stmt->execute();
    $stmt->bind_result($ids);
    $stmt->fetch();
    $id_client = $ids;
    $stmt->close();

    $sql = "SELECT name, host, security AS SMTPSecure, port, is_smtp AS isSMTP, smtp_auth AS SMTPAuth, user AS from_email, password
    FROM email_server_setting
    WHERE type_related = 3 AND id_client = $id_client";
    $results = $obj_bdmysql->query($sql, $conn);

    $isSMTP = $results[0]['isSMTP'];
    $host = $results[0]['host'];
    $port = $results[0]['port'];
    $SMTPSecure = $results[0]['SMTPSecure'];
    $SMTPAuth = $results[0]['SMTPAuth'];
    $from_email = $results[0]['from_email'];
    $name = $results[0]['name'];
    $password = $results[0]['password'];

    $sql = "SELECT opp.id_contacts AS id_related FROM contacts_services cs
    JOIN opportunities opp ON cs.id_opportunities = opp.id
    WHERE cs.id = $id_contacts_services";
    $result = $obj_bdmysql->query($sql, $conn);
    $id_related = $result[0]['id_related'];

    $bcc = $agent_email;

    $tracking = '0';
    $recipient_type = '1';
    $header = '0';
    $footer = '0';
    $count = '';
    $strg_pdf = '';
    $random_id = rand();

    //$correo = "joespruebas@gmail.com";
    $bcc .= ",joesquintero2014@gmail.com";
    //exit;

    $salida = $obj_function->sendEmail($isSMTP, $host, $port, $SMTPSecure, $SMTPAuth, $from_email, $name, $password, $correo, "", $bcc, $subject, $message, "", $tracking, $random_id, $count, $recipient_type, $id_related, $header, $footer, $strg_pdf);

    if ($salida == 'Email Sent') {
        //echo "si";
        contacts_service_wizard_log($id_contacts_services, "EMAIL", "OK: SEND EMAIL, PAYMENT FAILED", 1);
    } else {
        //echo "no";
        contacts_service_wizard_log($id_contacts_services, "EMAIL", "ERROR: SEND EMAIL, PAYMENT FAILED", 2);
    }
}

function sendSmsInformation($id_contacts_services, $date_payment, $type){

    global $conn, $obj_bdmysql, $obj_function, $restClient;

    $sql = "SELECT c.id, cpho.phone_number as contact_phone, ucp.phone_number as agent_phone 
        FROM contacts_services cs
        JOIN user_crm uc ON cs.person_interacting = uc.id
        JOIN client c ON uc.id_client = c.id
        JOIN opportunities o ON cs.id_opportunities = o.id
        LEFT JOIN contacts_phone cpho ON cpho.id_contacts = o.id_contacts
        LEFT JOIN user_crm_phone ucp ON ucp.id_user_crm = uc.id
        WHERE cs.id = $id_contacts_services";
    $query = $obj_bdmysql->query($sql, $conn);
    $id_client = $query[0]['id'];
    $contact_phone = $query[0]['contact_phone'];
    $agent_phone = $query[0]['agent_phone'];

    $text = "";

    $new_date = new DateTime($date_payment);
    $new_date = $new_date->format('m-d-Y');
    
    if($type == "info"){
        $text .= "El pago correspondiente a la fecha $new_date ha fallado. \n";
        $text .= "Equipo de Servicio al Cliente, Serenity Assistance. \n";
    }elseif($type == "paused"){
        $text .= "Estimado/a $first_name $last_name\n"; 
        $text .= "Su plan ha sido puesto en pausa por falta de pago. Es importante que nos contacte lo antes posible para asegurar la protección de sus beneficiarios. Puede llamarnos o enviarnos un WhatsApp al 307-888-0109. \n";
        $text .= "Equipo de Servicio al Cliente, Serenity Assistance. \n";
    } 

    $stmt = $conn->stmt_init();
    $stmt->prepare("call gosmart_v103.spSetParentsOut($id_client)");
    $stmt->execute();
    $stmt->bind_result($ids);
    $stmt->fetch();
    $id_client = $ids;
    $stmt->close();    

    $sql = "SELECT pn.number_phone FROM client_number_phone cnp
        JOIN provides_number pn ON cnp.id_provides_number = pn.id
        WHERE cnp.id_client = $id_client";
    $result = $obj_bdmysql->query($sql, $conn);
    $client_number_phone = $result[0]['number_phone'];

    //$contact_phone = '+584243786775';
    //$agent_phone = '';
    //print_r($contact_phone);exit();   
    
    try
    {
        $responseC = $restClient->messages->create([
                "src" => "$client_number_phone",
                "dst" => "$contact_phone",
                "text" => "$text"
            ]
        );

        contacts_service_wizard_log($id_contacts_services, "SMS", "OK: SEND SMS CONTACT, PAYMENT FAILED", 1);
    }
    catch(Throwable $ex)
    {
        contacts_service_wizard_log($id_contacts_services, "SMS", "ERROR: SEND SMS CONTACT, PAYMENT FAILED", 2);
    }

    if($agent_phone != ''){
        try
        {
            $responseA = $restClient->messages->create([  
                    "src" => "$client_number_phone",
                    "dst" => "$agent_phone",
                    "text" => "$text"
                ]
            );
            contacts_service_wizard_log($id_contacts_services, "SMS", "OK: SEND SMS AGENT, PAYMENT FAILED", 1);
        }
        catch(Throwable $ex)
        {
            contacts_service_wizard_log($id_contacts_services, "SMS", "ERROR: SEND SMS AGENT, PAYMENT FAILED", 2);
        }
    }else{
        contacts_service_wizard_log($id_contacts_services, "SMS", "WARNING: SEND SMS AGENT, PAYMENT FAILED (phone_number NOT FOUND)", 3);
    }
}

function pausedApplication($id_contacts_services, $date_payment, $id_pending_payment){
    global $conn, $obj_bdmysql, $obj_function, $jsondebug;

    $date = new DateTime();
    $date = $date->format('Y-m-d');

    $sql = "SELECT * FROM contacts_services_paused_cancelled WHERE id_contacts_services = $id_contacts_services AND created_at = '$date'";
    $query = $obj_bdmysql->query($sql, $conn);
    if(!is_array($query)){
        $status_services = 31; //paused
        $campo = "id_contacts_services, id_status_services, created_at";
        $valor = "$id_contacts_services, '$status_services', '$date'";
        $obj_bdmysql->insert("contacts_services_paused_cancelled", $campo, $valor, $conn);
    }

    $sql = "SELECT * FROM contacts_services_notification WHERE id_contacts_services = $id_contacts_services AND status = 1 AND date_payment = '$date_payment' AND id_related = $id_pending_payment";
    $query = $obj_bdmysql->query($sql, $conn);
    if(!is_array($query)){
        for ($i=0; $i < 3; $i++) {
            if ($i == 0) {
                $days = 30;
                $type = "1";
            }elseif ($i == 1) {
                $days = 60;
                $type = "2";
            }elseif ($i == 2) {
                $days = 90;
                $type = "3";
            }

            $date_notification = new DateTime($date_payment);
            $date_notification = $date_notification->format('Y-m-d');
            $date_notification = date("Y-m-d",strtotime($date_notification."+ $days day"));

            $campo = "id_contacts_services, type, status, date_notification, date_payment, id_related";
            $valor = "$id_contacts_services, '$type', '1', '$date_notification', '$date_payment', $id_pending_payment";
            $obj_bdmysql->insert("contacts_services_notification", $campo, $valor, $conn);
        }    
    }
}

function contacts_service_wizard_log($id_contacts_services, $type, $log, $flag){
    global $conn, $obj_bdmysql;

    $fc = date('Y-m-d h:i:s'); 

    $campo = "id_contact_service, type, log, date, flag, source";
    $valor = "$id_contacts_services, '$type', '$log', '$fc', $flag, 'Payments Model'";
     
    $obj_bdmysql->insert("contacts_service_wizard_log", $campo, $valor, $conn);
}

function getStatusBadge($status, $note = '') {
    switch ($status) {
        case 0:
            return '<span class="badge badge-info">without paying</span>';
        case 1:
            return '<span class="badge badge-warning" title="' . $note . '">' . $retries . ' retries</span>';
        case 2:
            return '<span class="badge badge-success">success</span>';
        case 3:
            return '<span class="badge badge-danger" title="' . $note . '">' . $retries . ' retries</span>';
        case 4:
            return '<span class="badge badge-info">no payment method</span>';
        case 5:
            return '<span class="badge badge-warning">no keys stripe</span>';
        case 6:
            return '<span class="badge badge-warning">unverified payment method</span>';
        case 7:
            return '<span class="badge badge-primary">waiting confirmation</span>';
        case 8:
            return '<span class="badge badge-danger" title="' . $note . '">confirmation failed</span>';
        case 9:
            return '<span class="badge badge-danger" title="' . $note . '">canceled</span>';
        case 10:
            return '<span class="badge badge-dark" title="' . $note . '">refunded</span>';
        case 11:
            return '<span class="badge badge-danger" title="' . $note . '">canceled by admin</span>';
        case 12:
            return '<span class="badge badge-warning" title="' . $note . '">paused</span>';
        case 13:
            return '<span class="badge" style="color: #000;background-color: #bebfc4;" title="' . $note . '">refund requested</span>';
        case 14:
            return '<span class="badge" style="color: #000;background-color: #bebfc4;" title="' . $note . '">refunded partially</span>';
        case 15:
            return '<span class="badge badge-dark" title="' . $note . '">dispute</span>';
        default:
            return '<span class="badge badge-secondary">unknown status</span>';
    }
}
