<?php
include '../../common/login_timeout.php';
include '../../common/general.php';
include '../../vendor/autoload.php';
require_once '../../assets/bower_components/dompdf/lib/html5lib/Parser.php';
require_once '../../assets/bower_components/dompdf/src/Autoloader.php';

Dompdf\Autoloader::register();
use Dompdf\Dompdf;
use PHPMailer\PHPMailer\PHPMailer;

$obj_common = new common();
$obj_bdmysql = new coBdmysql();
$obj_function = new coFunction();
error_reporting(E_ERROR);
$conn = mysqli_connect(DBHOST, DBUSER, DBPASS, DBNOM) or die("Connection failed: " . mysqli_connect_error()); /* Database connection end */

$id_role = $_SESSION["id_role"]; 
$parentBYClient = $_SESSION["parentBYClient"];
$id_client = $_SESSION["id_client"];
$id_principal = $_SESSION["id_principal"];
$id_user_crm = $_SESSION["id_user_crm"];
//$id_client = 125; // dev localhost testing

use Plivo\RestClient;
$restClient = new RestClient(AUTH_ID, AUTH_TOKEN);

$action = "";

if (isset($_POST['action'])) {
    $action = $_POST['action'];
}

foreach ($_POST as $i_dato => $dato_) {
    if (!is_array($dato_)) {
        $$i_dato = addslashes($obj_function->evalua_array($_POST, $i_dato));
    }else{
        foreach ($dato_ as $innerKey => $innerValue) {
            $$i_dato = addslashes($obj_function->evalua_array($_POST, $innerKey));
        }
    }
}

lastUpdate($conn);
switch ($action) {
    case 'list':
        // storing  request (ie, get/post) global array to a variable
        $requestData = $_REQUEST;        
    
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'cs.agreement_number',
            2 => 'cts.name',
            3 => 'uc.name',
            4 => 'csp.plan_name',
            5 => 'ss.name',
            6 => 'cspc.created_at',
        );
          
        $sql = "SELECT cspc.*, uc.name as owner, cs.id_services AS id_service, sta.name actual_status, CONCAT(cts.name,' ', cts.last_name) AS contact, cs.agreement_number AS policy_number, ss.name AS status, csp.plan_name AS plan_name
        FROM
            contacts_services_paused_cancelled cspc
        LEFT JOIN
        contacts_services cs ON cs.id = cspc.id_contacts_services
        LEFT JOIN
        opportunities opp ON opp.id = cs.id_opportunities
        LEFT JOIN
        contacts cts ON cts.id = opp.id_contacts
        LEFT JOIN
        services s ON cs.id_services = s.id
        LEFT JOIN
        user_crm uc ON cs.person_interacting = uc.id
        LEFT JOIN
        client c ON uc.id_client = c.id
        LEFT JOIN
        status_services ss ON cspc.id_status_services = ss.id
        LEFT JOIN
            (SELECT s.id_contacts_services, s.plan_name
                FROM contacts_services_payment s 
                GROUP BY s.id_contacts_services) csp ON csp.id_contacts_services = cspc.id_contacts_services
        LEFT JOIN 
            (SELECT sta.name, sta.id FROM status_services sta) sta ON sta.id = cs.id_status_services 
        WHERE 1 = 1";
        if ($id_role == 1 OR $id_role == 5 OR $id_role == 24 OR $id_role == 29) {
            $sql .= " AND uc.id_client IN($parentBYClient)";
        } else {
            $sql .= " AND cs.person_interacting =  $id_user_crm";
        }
        //print_r($sql);exit;
        $query = mysqli_query($conn, $sql) or die($sql);
        $totalData = mysqli_num_rows($query);
    
        if (!empty($requestData['search']['value'])) {
            $str = $requestData['search']['value'];
            $status = 0;      
            if (strlen(strstr('paused',$str))>0) {                    
                $status = 31;
            }           
            if (strlen(strstr('Active',$str))>0) {                    
                $status = 30;
            }
            ////////////////////////////////////////
            $sql .= " AND ( cs.agreement_number LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR cts.name LIKE '%" . $status . "%'";
            $sql .= " OR uc.name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR csp.plan_name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR sta.name LIKE '%" . $requestData['search']['value'] . "%'";
            $sql .= " OR ss.name LIKE '%" . $requestData['search']['value'] . "%'";          
            $sql .= " OR cspc.created_at LIKE '%" . formatterDb($requestData['search']['value']) . "%' )";
        }

        if (!empty($requestData['columns'][6]['search']['value'])) {
            // if there is a search parameter             
            $search = explode(";", $requestData['columns'][6]['search']['value']);             
            //print_r($search);exit;
            $newDatecreated1 = date("Y-m-d", strtotime($search[0]));
            $newDatecreated2 = date("Y-m-d", strtotime($search[1]));
            
            $sql_where .= " AND ( cspc.created_at BETWEEN '" . $newDatecreated1 . "' AND '" . $newDatecreated2 . "')";
        }
        $sql .= $sql_where;  
        //print_r($sql);exit;      
        
        $query = mysqli_query($conn, $sql) or die($sql);
    
        $totalFiltered = mysqli_num_rows($query);
        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
    
        $query = mysqli_query($conn, $sql) or die($sql);
    
        $data = array();
        while ($row = mysqli_fetch_array($query)) {           
             
            $nestedData = array();
            $button = '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Notificaciones" data-placement="top" onclick="Applications.dataTableNotification('.$row['id_contacts_services'].')"><i class="fas fa-list-alt" style="font-size:18px"></i>';

            $date_format = new DateTime($row["created_at"]);
            $date_format = $date_format->format('m/d/Y');

            $nestedData[] = $row["id"];
            $nestedData[] = '<div class="text-center">'.$row["policy_number"].'</div>';
            $nestedData[] = '<div class="text-center">'.utf8_encode($row["contact"]).'</div>';
            $nestedData[] = '<div class="text-center">'.utf8_encode($row["owner"]).'</div>';
            $nestedData[] = '<div class="text-center">'.utf8_encode($row["plan_name"]).'</div>';
            $nestedData[] = '<div class="text-center">'.$row["status"].'</div>';
            $nestedData[] = '<div class="text-center">'.$row["actual_status"].'</div>';
            $nestedData[] = '<div class="text-center">'.$date_format.'</div>';
            $nestedData[] = '<div class="text-center">'.$button.'</div>';
             
            $data[] = $nestedData;
        }
    
        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        mysqli_close($conn);
        echo json_encode($json_data);
    break;

    case 'listNotifications':
    
        $requestData = $_REQUEST;
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'type',
            2 => 'date_notification',
            3 => 'status',
        );
        $sql = "SELECT * FROM contacts_services_notification WHERE id_contacts_services = $id_contacts_services";
        //echo formatterDb("05/04/2023");exit;
        if (!empty($requestData['search']['value'])) {
            $str = $requestData['search']['value'];
            $status = 0;      
            if (strlen(strstr('pending',$str))>0) {                    
                $status = 1;
            }           
            if (strlen(strstr('sent',$str))>0) {                    
                $status = 2;
            }
            if (strlen(strstr('failured',$str))>0) {                    
                $status = 3;
            }
            if (strlen(strstr('cancelled',$str))>0) {                    
                $status = 4;
            }
            // if there is a search parameter, $requestData['search']['value'] contains search parameter
            $sql .= " AND ( type LIKE '%" . $requestData['search']['value'] . "%' ";
            $sql .= " OR date_notification LIKE '%" . formatterDb($requestData['search']['value']) . "%'";
            $sql .= " OR status LIKE '%" . $status . "%' ) ";
        }

        $query = mysqli_query($conn, $sql) or die($sql);
        $totalData = mysqli_num_rows($query);
        //echo $sql;exit;
        $query = mysqli_query($conn, $sql) or die($sql);
        $totalFiltered = mysqli_num_rows($query); // when there is a search parameter then we have to modify total number filtered rows as per search result.

        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
        $query = mysqli_query($conn, $sql) or die($sql);
        //print_r($sql);exit;
        $data = array();
        while ($row = mysqli_fetch_array($query)) {

            $nestedData = array();
            $button = "";

            if($row['status'] != 4){
                $button = '<a href="#" class="m-portlet__nav-link btn m-btn m-btn--hover-info m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="m-tooltip" title="Enviar" data-placement="top" onclick="Applications.sendNotification('.$row['id'].')"> <i class="fas fa-file-invoice-dollar" style="font-size:18px"></i></a>';
            }       

            $date_notification = new DateTime($row["date_notification"]);
            $date_notification = $date_notification->format('m/d/Y');

            if ($row['type'] == 1) {
                $type = "<span class='badge badge-warning'>30 Days</span>";
            }else if($row['type'] == 2){
                $type = "<span class='badge badge-warning'>60 Days</span>";
            }else if($row['type'] == 3){
                $type = "<span class='badge badge-danger'>90 Days</span>";
            }

            if ($row['status'] == 1) {
                $status = "<span class='badge badge-info'>Pending</span>";
            }else if($row['status'] == 2){
                $status = "<span class='badge badge-success'>Sent</span>";
            }else if($row['status'] == 3){
                $status = "<span class='badge badge-warning' title='".$row["note"]."'>Failed</span>";
            }else if($row['status'] == 4){
                $status = "<span class='badge badge-dark' title='".$row["note"]."'>Cancelled</span>";
            }
            
            //print_r($switch);exit;

            $nestedData[] = '<center>'. $row['id'] . '</center>';
            $nestedData[] = '<center>'. $type . '</center>';
            $nestedData[] = '<center>'. $date_notification . '</center>';
            $nestedData[] = '<center>'. $status . '</center>';
            $nestedData[] = '<center>'.$button.'</center>';

            $data[] = $nestedData;
        }

        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data, // total data array
            "code" => 200
        );
        mysqli_close($conn);
        echo json_encode($json_data);
    break;

    case 'sendNotification':    

        $sql = "SELECT * FROM contacts_services_notification WHERE id = $id";
        $query = $obj_bdmysql->query($sql, $conn);

        $out["code"] = 204;
        $out["message"] = "Error";

        if(is_array($query)){
            $id_contacts_services_notification = $query[0]['id'];
            $id_contacts_services = $query[0]['id_contacts_services'];
            $date_notification = $query[0]['date_notification'];
            $date_payment = $query[0]['date_payment'];
            $type = $query[0]['type'];
            $sendSms = 0;

            if ($type == 1 OR $type == 2) {
                $type_notification = "info";
            }else if($type == 3){
                $type_notification = "cancel";
            }

            $sendEmailInformation = sendEmailInformation($id_contacts_services, $date_payment, $type_notification, $type);   
            $sendSmsInformation = sendSmsInformation($id_contacts_services, $date_payment, $type_notification, $type);

            if ($sendSmsInformation == 1 OR $sendEmailInformation == 1) {
                $out["code"] = 200;
                $out["message"] = "The notification has been sent by";
                if($sendSmsInformation == 1){
                    $sendSms = 1;
                    $out["message"] .= " text SMS";
                }
                if($sendEmailInformation == 1) {
                    if ($sendSms == 1) {
                        $out["message"] .= " and email";
                    }else{
                        $out["message"] .= " email";
                    }
                }
                $out["message"] .= " successfully";

                $campo = "status = 2"; // status = 2 send
                $where = "id = $id_contacts_services_notification";
                $query = $obj_bdmysql->update("contacts_services_notification", $campo, $where, $conn);

                if ($type == 3) {
                    $campo = "id_status_services = 30";
                    $where = "id = $id_contacts_services";
                    $obj_bdmysql->update("contacts_services", $campo, $where, $conn);
                    $obj_function->contactsServicesTimeLine($id_contacts_services, '30', 'Usuario', $id_user_crm);

                    $campo = "status = 9, note = 'canceled'";
                    $where = "id_contacts_services = $id_contacts_services AND date_payment >= '$date_payment' AND status in (0,1)";
                    $obj_bdmysql->update("contacts_services_pending_payment", $campo, $where, $conn);
                }
            }else{
                $campo = "status = 3"; // status = 3 failure
                $where = "id = $id_contacts_services_notification";
                $query = $obj_bdmysql->update("contacts_services_notification", $campo, $where, $conn);
            }            
        }        

        mysqli_close($conn);
        echo json_encode($out);
    break;
}

function sendEmailInformation($id_contacts_services, $date_payment, $type_notification, $type){
    global $conn, $obj_bdmysql, $obj_function;

    $sql = "SELECT 
        c.id, 
        cs.id_services, 
        cs.data_json->>'$.holder.email' AS email, 
        cs.data_json->>'$.payment.agentEmail' AS agentEmail
        FROM contacts_services cs
        JOIN user_crm uc ON cs.person_interacting = uc.id
        JOIN client c ON uc.id_client = c.id
        JOIN opportunities o ON cs.id_opportunities = o.id
        WHERE cs.id = $id_contacts_services";
    $query = $obj_bdmysql->query($sql, $conn);
    $id_client = $query[0]['id'];
    $id_service = $query[0]['id_services'];

    $correo = strtolower($query[0]['email']);
    $agent_email = strtolower($query[0]['agentEmail']);

    $dias = 0;
    if($type == 1){
        $dias = 60;
    }else if ($type == 2) {
        $dias = 30;
    }

    $new_date = new DateTime($date_payment);
    $new_date = $new_date->format('m-d-Y');

    $other_text = "";
    if ($type_notification == "info") {
        $subject = "Información sobre su pago correspondiente a la fecha $new_date .";
        $text = "Le recordamos que el pago correspondiente a la fecha $new_date no se ha completado. Usted tiene $dias dias para hacer el pago correspondiente y evitar la cancelación del plan.";
    }else if($type_notification == "cancel"){
        $subject = "Información, su plan ha sido cancelado.";
        $text = "Su plan ha sido cancelado.";
        $other_text = '<h3 style="font-weight:100; color:#666"><strong>Contactenos a la brevedad si cree que a sido un error.</strong></h3><h3 style="font-weight:100; color:#666"><strong>307-888-0109</strong></h3>';
    }

    $message = '
        <!DOCTYPE html>
        <html lang="en">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Forgot Password</title>
                <style type="text/css">
                    .content{
                        width:100%; background:#eee; position:relative; font-family:sans-serif; padding-bottom:40px;
                    }
                    .body-email{
                        position:relative; margin:auto; width:700px; background:white; padding:20px
                    }
                    .img-email{
                        width:15%
                    }
                    @media (max-width: 768px) {
                       .body-email {
                         width: 80%;
                       }
                       .img-email{
                            width: 30%;
                       }
                    }
                </style>
            </head>
            <body>
                <div class="content">
                    <div class="body-email">
                        <center>
                        <img class="img-email" src="https://landing.gosmartcrm.com/serenity/assets/landing/images/logo/logo.png" style="width: 150px; height: 150px">

                        <h4 style="font-weight:100; color:#666; padding:0 20px">Serenity Asistencia Funeraria</h4>

                        <h3 style="font-weight:100; color:#666"><strong>Roy Najera,</strong></h3>

                        <h3 style="font-weight:100; color:#666"><strong>'.$text.'</strong></h3>

                        '.$other_text.'

                        </center>
                    </div>
                </div>
            </body>
    </html>';
    $message = utf8_decode($message);

    $stmt = $conn->stmt_init();
    $stmt->prepare("call gosmart_v103.spSetParentsOut($id_client)");
    $stmt->execute();
    $stmt->bind_result($ids);
    $stmt->fetch();
    $id_client = $ids;
    $stmt->close();

    $sql = "SELECT name, host, security AS SMTPSecure, port, is_smtp AS isSMTP, smtp_auth AS SMTPAuth, user AS from_email, password
    FROM email_server_setting
    WHERE type_related = 2 AND id_client = $id_client";
    $results = $obj_bdmysql->query($sql, $conn);

    $isSMTP = $results[0]['isSMTP'];
    $host = $results[0]['host'];
    $port = $results[0]['port'];
    $SMTPSecure = $results[0]['SMTPSecure'];
    $SMTPAuth = $results[0]['SMTPAuth'];
    $from_email = $results[0]['from_email'];
    $name = $results[0]['name'];
    $password = $results[0]['password'];

    $sql = "SELECT opp.id_contacts AS id_related FROM contacts_services cs
    JOIN opportunities opp ON cs.id_opportunities = opp.id
    WHERE cs.id = $id_contacts_services";
    $result = $obj_bdmysql->query($sql, $conn);
    $id_related = $result[0]['id_related'];

    $bcc = $agent_email;

    $tracking = '0';
    $recipient_type = '1';
    $header = '0';
    $footer = '0';
    $count = '';
    $strg_pdf = '';
    $random_id = rand();

    //$correo = "joesquintero2014@gmail.com";
    //$bcc = "joespruebas@gmail.com";
    //exit;

    $salida = $obj_function->sendEmail($isSMTP, $host, $port, $SMTPSecure, $SMTPAuth, $from_email, $name, $password, $correo, "", $bcc, $subject, $message, "", $tracking, $random_id, $count, $recipient_type, $id_related, $header, $footer, $strg_pdf);

    if ($salida == 'Email Sent') {
        contacts_service_wizard_log($id_contacts_services, "EMAIL", "OK: SEND EMAIL, NOTIFICATION TYPE: $type", 1);

        return 1;
    } else {
        contacts_service_wizard_log($id_contacts_services, "EMAIL", "ERROR: SEND EMAIL, NOTIFICATION TYPE: $type", 2);

        return 0;
    }
}


function sendSmsInformation($id_contacts_services, $date_payment, $type_notification, $type){

    global $conn, $obj_bdmysql, $obj_function, $restClient;

    $sql = "SELECT c.id, cpho.phone_number as contact_phone, ucp.phone_number as agent_phone 
        FROM contacts_services cs
        JOIN user_crm uc ON cs.person_interacting = uc.id
        JOIN client c ON uc.id_client = c.id
        JOIN opportunities o ON cs.id_opportunities = o.id
        LEFT JOIN contacts_phone cpho ON cpho.id_contacts = o.id_contacts
        LEFT JOIN user_crm_phone ucp ON ucp.id_user_crm = uc.id
        WHERE cs.id = $id_contacts_services";
    $query = $obj_bdmysql->query($sql, $conn);
    $id_client = $query[0]['id'];
    $contact_phone = $query[0]['contact_phone'];
    $agent_phone = $query[0]['agent_phone'];

    $text = "";
    $text .= "Serenity Asistencia Funeraria \n";
    $text .= "Roy Najera, \n";

    $dias = 0;
    if($type == 1){
        $dias = 60;
    }else if ($type == 2){
        $dias = 30;
    }

    $new_date = new DateTime($date_payment);
    $new_date = $new_date->format('m-d-Y');

    if($type_notification == "info"){
        $text .= "Recordamos que el pago correspondiente a la fecha $new_date no se ha completado. \n";
        $text .= "Le quedan $dias dias para pagar. \n";
    }elseif($type_notification == "cancel"){
        $text .= "Su plan ha sido cancelado. \n"; 
        $text .= "Contactenos a la brevedad si cree que a sido un error. \n";
        $text .= "307-888-0109. \n";
    } 

    $stmt = $conn->stmt_init();
    $stmt->prepare("call gosmart_v103.spSetParentsOut($id_client)");
    $stmt->execute();
    $stmt->bind_result($ids);
    $stmt->fetch();
    $id_client = $ids;
    $stmt->close();    

    $sql = "SELECT pn.number_phone FROM client_number_phone cnp
        JOIN provides_number pn ON cnp.id_provides_number = pn.id
        WHERE cnp.id_client = $id_client";
    $result = $obj_bdmysql->query($sql, $conn);
    $client_number_phone = $result[0]['number_phone'];

    //$contact_phone = '+584243786775';
    //$agent_phone = '';
    //print_r($contact_phone);exit();   
    
    try
    {
        $responseC = $restClient->messages->create([
                "src" => "$client_number_phone",
                "dst" => "$contact_phone",
                "text" => "$text"
            ]
        );

        $out['code'] = 200;

        contacts_service_wizard_log($id_contacts_services, "SMS", "OK: SEND SMS CONTACT, NOTIFICATION TYPE: $type", 1);
    }
    catch(Throwable $ex)
    {
        $out['code'] = 204;

        contacts_service_wizard_log($id_contacts_services, "SMS", "ERROR: SEND SMS CONTACT, NOTIFICATION TYPE: $type", 2);
    }

    if ($out['code'] == 200) {
        if($agent_phone != ''){
            try
            {
                $responseA = $restClient->messages->create([  
                        "src" => "$client_number_phone",
                        "dst" => "$agent_phone",
                        "text" => "$text"
                    ]
                );
                contacts_service_wizard_log($id_contacts_services, "SMS", "OK: SEND SMS AGENT, NOTIFICATION TYPE: $type", 1);
            }
            catch(Throwable $ex)
            {
                contacts_service_wizard_log($id_contacts_services, "SMS", "ERROR: SEND SMS AGENT, NOTIFICATION TYPE: $type", 2);
            }
        }else{
            contacts_service_wizard_log($id_contacts_services, "SMS", "WARNING: SEND SMS AGENT, NOTIFICATION TYPE: $type - (phone_number NOT FOUND)", 3);
        }

        return 1;
    }else{
        return 0;
    }
    
}

function contacts_service_wizard_log($id_contacts_services, $type, $log, $flag){
    global $conn, $obj_bdmysql;

    $fc = date('Y-m-d h:i:s'); 

    $campo = "id_contact_service, type, log, date, flag";
    $valor = "$id_contacts_services, '$type', '$log', '$fc', $flag";
     
    $obj_bdmysql->insert("contacts_service_wizard_log", $campo, $valor, $conn);
}
