'use strict';

var dataTable = '',
	formProfileData = $('#formProfileData'),
	formUploadDocument = $('#formUploadDocument');
var formEndPoint = $('#formEndPoint');
var formEditEmail = $('#formEditEmail');

var fileExtension = "";
var idEndPoint = $('#id_user_endpoint').val();

var dataTable2 = '';
var idUserEmail = '';
var myPhoto = '';

var profile = {
	init: () => {
		dataTable = $('#dtRequiredDocumentsList').DataTable({
			"paging": false,
			"searching": false,
			"processing": true,
			"serverSide": true,
			"responsive": !0,
			"ajax": {
				url: "../model/users_model.php", // json datasource
				data: {
					method: "dtRequiredDocumentsList"
				},
				type: "post", // method  , by default get
				error: function() { // error handling
				}
			},
			'columnDefs': [{
				"sClass": "dpass",
				"aTargets": [0]
			}],
			"order": [
				[2, "asc"]
			]
		});

		dataTable2 = $('#dtEmailList').DataTable({
			"paging": false,
			"searching": false,
			"processing": true,
			"serverSide": true,
			"responsive": !0,
			"ajax": {
				url: "../model/users_model.php", // json datasource
				data: {
					method: "dtEmailList"
				},
				type: "post", // method  , by default get
				error: function() { // error handling
				}
			},
			'columnDefs': [{
				"sClass": "dpass",
				"aTargets": [0]
			}],
			"order": [
				[2, "asc"]
			]
		});

		formProfileData.validate({});

		formUploadDocument.validate({});

		formEndPoint.validate({});

		formEditEmail.validate({});

		myPhoto = $('.img-thumbnail').prop('src'); // guarda la photo actual

		$(".card-number input[type='text']").keyup(function (event) {
			var len = $(this).val().toString().length;
	
			if (len == 1) {
			  $(this).next().focus();
			}
		  });

	},
	events: () => {

		$('input[type=radio][name=user_profile_active]').change(function() {
			var radio = $('input:radio[name=user_profile_active]:checked').val();
			if (radio === 'yes') {
				$('#newpass_profile').prop("disabled", false);
				$('#rnewpass_profile').prop("disabled", false);
				$('#newpass_profile').prop("required", true);
				$('#rnewpass_profile').prop("required", true);
			} else {
				profile.clearForm();
				$('#newpass_profile').val('');
				$('#rnewpass_profile').val('');
				$('#newpass_profile').prop("disabled", true);
				$('#rnewpass_profile').prop("disabled", true);
				$('#newpass_profile').prop("required", false);
				$('#rnewpass_profile').prop("required", false);
			}
		});

		$('#rnewpass_profile').blur(function() {
			var n = $('#newpass_profile').val();
			var a = $('#rnewpass_profile').val();
			if (n != a) {
				swal({
					position: "top-center",
					type: "error",
					title: 'The Keys Do Not Match...!',
					showConfirmButton: !1,
					timer: 1500
				});
				$('#rnewpass_profile').val('');
			}
		});

		$('#user_profile_apassword').blur(function() {
			var parametros = {
				"action": 'check_password',
				"id": $('#user_profile_id').val(),
				"actual_password": $('#user_profile_apassword').val()
			};
			var opt = {
				url: '../model/users_model.php',
				method: 'POST',
				data: parametros,
				dataType: 'json',
				error: function(jqXHR, textStatus, errorThrown) {
					console.log(jqXHR);
					console.log(textStatus);
					console.log(errorThrown);
				},
				success: function(response) {

					if (response.res === 'yes') {
						swal({
							position: "top-center",
							type: "error",
							title: 'Password Incorrect...!',
							showConfirmButton: !1,
							timer: 1500
						});
						//notification('password incorrect', 'danger');
						$('#user_profile_apassword').val('');

					}
				}
			};
			$.ajax(opt);
		});

		$('#cell_profile').blur(function() {
			var new_phone = $('#cell_profile').val();
			var actual_phone = $('#actual_user_cell').val();
			var lang = sessionStorage.getItem('lang');
			 
			if (new_phone != actual_phone) {
				swal({
					title: 'Are you sure?',
					text: "A message will be sent to confirm that the number placed is valid!",
					type: 'warning',
					showCancelButton: true,
					confirmButtonText: 'Yes, change it!'
				}).then(function(result) {
					if (result.value) {
						var parametros = {
							"method": 'check_phone_number',
							"id": $('#user_profile_id').val(),
							"cell_profile": $('#cell_profile').val(),
							"token": randString(5),
						};
						preloader('show');
						$.post('../model/users_model.php',parametros, function (data){
							// console.log(data)
							if (data.code == '440'){
								loginTimeout(data.message);
								return;
							} 
							else if (data.code === 200) {
								preloader('hide')
								$('#modalConfirmCode').modal({
									show: true,
									backdrop: "static",
									keyboard: false,
								});
								localStorage.setItem('code_token_sms', data.code_token)
								// dataTable.draw();
							}
							else if (data.code === 204) {
								preloader('hide')
								swal('Wrong', data.salida,'error');
								// dataTable.draw();
							}
						}, 'json');
					}});
			}
		});

		//validation phone number change
		$('#btnValidateCode').click(function(e) {
			e.preventDefault();
			var cc1 = $("#cc1").val(),
			cc2 = $("#cc2").val(),
			cc3 = $("#cc3").val(),
			cc4 = $("#cc4").val(),
			cc5 = $("#cc5").val();
			var code_input = cc1 + cc2 + cc3 + cc4 + cc5;
			var session_code = localStorage.getItem('code_token_sms');
			code_input = code_input.toLowerCase();
			session_code = session_code.toLowerCase();

			// console.log(code_input, session_code)

			if(session_code === code_input){
				$('#modalConfirmCode').modal('hide');
				swal('Validate', 'Code validate successfully, please continue updating ','success');
			}else{
				$('#add_code_user').val('');
				swal('Wrong', 'the code not match, please try again ','error');
			}
		})

		$('#btnSaveProfile').click(function(e) {
			e.preventDefault();
			if (formProfileData.valid()) {
				var passActual = $('#user_profile_apassword').val();
				if (passActual === '') {
					swal({
						position: "top-center",
						type: "error",
						title: 'You Must Indicate Your Current Key...!',
						showConfirmButton: !1,
						timer: 1500
					});
				}else {
					var image = $('.file-preview-image').attr('src') ? $('.file-preview-image').attr('src') : $('.m-card-profile__pic-wrapper > img').attr('src');

					var parametros = {
						"method": 'editProfile',
						"id": $('#user_profile_id').val(),
						"id_avatar": $('#user_input_id_avatar').val() == '' ? 1 : $('#user_input_id_avatar').val(),
						"name": $('#full_name').val(),
						"email": $('#email_profile').val(),
						"username": $('#username_profile').val(),
						"image": image,
						"status": $('#user_profile_status').val(),
						"check": $('input:radio[name=user_profile_active]:checked').val(),
						"password": $('#newpass_profile').val(),
						"phone": $('#cell_profile').val(),
						"display_name": $('#display_full_name').val(),
						"display_email": $('#display_email_profile').val(),
						"display_cell": $('#display_cell_profile').val()
					};
					//console.log(parametros);
					preloader('show');
					$.post('../model/users_model.php', parametros, function(data) {

						if (data == 1) {
							preloader('hide', 'Record Update...!', 'success');

						} else {
							preloader('hide', 'Could Not Update The Record...!', 'error');
						}
						setTimeout(function() {
							$(location).attr('href', '../view/user_profile.php');
						}, 2000);
					}, 'json');
				}
			}

		});

		$('#dtRequiredDocumentsList tbody').on('click', '.btnDocuments', function() {
			$('#id_document_required').val('');
			//console.log('pasoooo')
			var data = dataTable.row($(this).parents('tr')).data();
			var id = data[0];
			$('#id_document_required').val(id);
			//console.log(id)
			profile.clearForm();
			$("#upload_documents").modal('show');
		});

		$(':file').change(function() {
			//obtenemos un array con los datos del archivo
			var file = $("#documents_upload_select")[0].files[0];
			//obtenemos el nombre del archivo
			var fileName = file.name;
			//obtenemos la extensión del archivo
			fileExtension = fileName.substring(fileName.lastIndexOf('.') + 1);
			//obtenemos el tamaño del archivo
			var fileSize = file.size;
			//obtenemos el tipo de archivo image/png ejemplo
			var fileType = file.type;
			//mensaje con la información del archivo
			showMessage("<span class='info'>Archivo para subir: " + fileName + ", peso total: " + fileSize + " bytes.</span>");
		});

		$('#save_document_button').click(function() {
			if (formUploadDocument.valid()) {
				//preloader('show');
				var document_id = $('#id_document_required').val();
				var formData = new FormData($("#formUploadDocument")[0]);

				$.ajax({
					url: '../model/documents_upload.php',
					type: 'POST',
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					success: function() {
						$("#upload_documents").modal('hide');
						swal({
							position: "top-center",
							type: "success",
							title: "Image Uploaded!",
							showConfirmButton: !1,
							timer: 2000
						});
						dataTable.draw();
						//preloader('hide');
					},
					//si ha ocurrido un error
					error: function() {
						swal({
							position: "top-center",
							type: "error",
							title: "Can't upload image!",
							showConfirmButton: !1,
							timer: 2000
						});
					}
				});

			}
		});		

		$('#btnSaveEndPoint').click(function(e) {
			e.preventDefault();

			if (formEndPoint.valid()) {
				var datos = {
					method: 'EndPoint',
					idUser: $('#user_profile_id').val(),
					idEndPoint: idEndPoint,
					sip: $('#sip').val(),
					pass_endpoint: $('#pass_endpoint').val()
				};
				$.post('../model/users_model.php', datos, function(data) {
					if (data.res === 'yes') {
						idEndPoint = data.idEndPoint;
						swal({
							position: "top-center",
							type: "success",
							title: "EndPoint Save..!",
							showConfirmButton: !1,
							timer: 2000
						});
					}
					if (data.res === 'update') {
						swal({
							position: "top-center",
							type: "success",
							title: "EndPoint Update..!",
							showConfirmButton: !1,
							timer: 2000
						});
					}
				}, 'json');

			}

		});

		$('#btnNewEmail').click(function(e) {
			e.preventDefault();

			profile.clearForm();
			idUserEmail = '';
			$("#edit_email").modal('show');

		});

		$('#verPass').mouseover(function(e) {
			e.preventDefault();
			$('#pass_endpoint').attr('type', 'text');
		});

		$('#verPass').mouseout(function(e) {
			e.preventDefault()
			$('#pass_endpoint').attr('type', 'password');
		});

		$('#verEmailPass').mouseover(function(e) {
			e.preventDefault();
			$('#pass_email').attr('type', 'text');
		});

		$('#verEmailPass').mouseout(function(e) {
			e.preventDefault()
			$('#pass_email').attr('type', 'password');
		});

		$('#sip').focusout(function(e) {
			e.preventDefault()
			var datos = {
				method: 'checkSip',
				sip: $('#sip').val(),
				idUser: $('#user_profile_id').val()
			};
			$.post('../model/users_model.php', datos, function(data) {
				if (data.res === 'yes') {
					swal({
						position: "top-center",
						type: "error",
						title: "EndPoint it already exists..!",
						showConfirmButton: !1,
						timer: 2000
					});
					$('#sip').val('');
					//$('#pass_endpoint').val('');
				}
			}, 'json');

		});

		$('#loadSip').mouseover(function(e) {
			e.preventDefault();
			var datos = {
				method: 'loadSip',
				idUser: $('#user_profile_id').val()
			};
			$.post('../model/users_model.php', datos, function(data) {
				$('#sip').val(data.sip);
				$('#pass_endpoint').val(data.password);

			}, 'json');
		});

		$('#save_email').click(function() {

			var datos = {
				method: 'saveEmail',
				idUser: idUserEmail,
				name: $('#emailAlias').val(),
				host: $('#emailHost').val(),
				security: $('#emailSecurity').val(),
				port: $('#emailPort').val(),
				issmtp: $('#emailSMTP').val(),
				smtp_auth: $('#emailSMTPAUTH').val(),
				user: $('#emailAddress').val(),
				password: $('#pass_email').val(),

			};
			$.post('../model/users_model.php', datos, function(data) {
				if (data.code == 404) {
					idEndPoint = data.idEndPoint;
					swal({
						position: "top-center",
						type: "error",
						title: "Incorrect Parameter..!",
						showConfirmButton: !1,
						timer: 2000
					});
				}
				if (data.code == 200) {
					idEndPoint = data.idEndPoint;
					swal({
						position: "top-center",
						type: "success",
						title: "Email Save..!",
						showConfirmButton: !1,
						timer: 2000
					});
					$("#edit_email").modal('hide');
				}
				if (data.res == 'update') {
					swal({
						position: "top-center",
						type: "success",
						title: "Email Update..!",
						showConfirmButton: !1,
						timer: 2000
					});
					$("#edit_email").modal('hide');
				}
			}, 'json');
			dataTable2.draw();
		});

		$("#btnSaveUploadImage").click(function (e) { 
			e.preventDefault();			
			var parametros = {
				"method": 'editPhotoProfile',
				"id": $('#user_profile_id').val(),
				"image": $('.img-thumbnail').prop('src'),
			};
			myPhoto = $('.img-thumbnail').prop('src'); // guarda la photo anterior
			preloader("show");
			$.post('../model/users_model.php', parametros, function(data) {
				preloader('hide', data.message, 'success');
				clearPhoto();				 
			}, 'json');
		});
		
		$("#btnSaveUploadImageClear").click(function (e) { 
			e.preventDefault();
			clearPhoto();
			$(".img-thumbnail").prop("src",myPhoto);
		});

		$("#full_name").keyup(function (e) { 
			e.preventDefault();
			$("#display_full_name").val(e.target.value);
		});

		$("#email_profile").keyup(function (e) { 
			e.preventDefault();
			$("#display_email_profile").val(e.target.value);
		});

		$("#cell_profile").keyup(function (e) { 
			e.preventDefault();
			$("#display_cell_profile").val(e.target.value);
		});

	},
	clearForm: () => {
		formUploadDocument.validate().resetForm();
		formProfileData.validate().resetForm();
		formEditEmail.validate().resetForm();
	},
	editEmail: function(idUser) {
		idUserEmail = idUser;
		var datos = {
				method: 'loadEmail',
				idUser: idUser
		};
		$.post('../model/users_model.php', datos, function(data) {

			$("#emailAlias").val(data.name);
			$("#emailSecurity").val(data.security);
			$("#emailPort").val(data.port);
			$("#emailHost").val(data.host);
			$("#emailSMTP").val(data.is_smtp);
			$("#emailSMTPAUTH").val(data.smtp_auth);
			$("#emailAddress").val(data.user);
			$("#pass_email").val(data.password);

			$("#edit_email").modal('show');

		}, 'json');

		// $("#edit_email").modal('show');
		
	},
	deleteEmail: function(idUser) {

		swal({
			title: "Are you sure to delete Email?",
			text: "You won't be able to revert this!",
			type: "warning",
			showCancelButton: !0,
			confirmButtonText: "Yes, delete it!",
			cancelButtonText: "No, cancel!",
			reverseButtons: !0
		}).then(function(e) {

			if (e.dismiss) {
				swal({
					position: "top-center",
					type: "success",
					title: 'Email is safe :)',
					showConfirmButton: !1,
					timer: 1500
				});
				//swal("Cancelled", "Data is safe :)", "error");
			}
			if (e.value) {
				var datos = {
					method: 'deleteEmail',
					idUser: idUser
				};
				preloader('show');
				$.post('../model/users_model.php', datos, function() {
					preloader('hide', 'Email Has Been Deleted!', 'error');
					dataTable2.draw();
				});

			}
			//e.value ? swal("Deleted!", "Data has been deleted.", "success") : "cancel" === e.dismiss && swal("Cancelled", "Your imaginary file is safe :)", "error")
		});





		
	},	
	saveEmail: function(idUser) {

		var datos = {
				method: 'saveEmail',
				idUser: idUser,
				name: $('#name').val(),
				host: $('#host').val(),
				security: $('#security').val(),
				port: $('#port').val(),
				issmtp: $('#issmtp').val(),
				smtp_auth: $('#smtp_auth').val(),
				user: $('#user').val(),
				password: $('#password').val(),

			};
			$.post('../model/users_model.php', datos, function(data) {
				if (data.res === 'yes') {
					idNewEmail = data.id_email;
					swal({
						position: "top-center",
						type: "success",
						title: "Email Save..!",
						showConfirmButton: !1,
						timer: 2000
					});
				}
				if (data.res === 'update') {
					swal({
						position: "top-center",
						type: "success",
						title: "Email Update..!",
						showConfirmButton: !1,
						timer: 2000
					});
				}
			}, 'json');

	}
};

function getIdDocumentsType(id) {
	$.post("../model/users_model.php", {
				"method": 'findDocumentsImage',
				"id": id
			},
			function(data) {
				if (data.mss == '1') {
					//alert(data.image);
					swal({
						title: "Document Image",
						imageUrl: data.image,
					});
				} else {
					console.log(data.mss);
				}
			}, "json")
		.fail(
			function(error) {
				console.log(error.responseJSON)
			}
		);
}

function clearPhoto() {	 
	$('#upload').val(""); 
	$("#editor").html("");
	var canvas = document.getElementById("preview");
	var context = canvas.getContext('2d');
	context.clearRect(0, 0, canvas.width, canvas.height);
	$(".div_preview").hide();
	$("#btnSaveUploadImage").prop("disabled",true);
	$("#btnSaveUploadImageClear").prop("disabled",true);
}

function showMessage(message) {
	$(".messages").html("").show();
	$(".messages").html(message);
}

//comprobamos si el archivo a subir es una imagen
//para visualizarla una vez haya subido
function isImage(extension) {
	switch (extension.toLowerCase()) {
		case 'jpg':
		case 'gif':
		case 'png':
		case 'jpeg':
			return true;
			break;
		default:
			return false;
			break;
	}
}

$(function() {
	profile.init();
	profile.events();
});