var $formAddValidate = $('#frmAddAcconts'),
    dataTable = '';
var t;
t = mUtil.isRTL() ? {
    leftArrow: '<i class="la la-angle-right"></i>',
    rightArrow: '<i class="la la-angle-left"></i>'
} : {
    leftArrow: '<i class="la la-angle-left"></i>',
    rightArrow: '<i class="la la-angle-right"></i>'
};

var add_bank_acconts = {

    init: function() {

        $("#frmAddAcconts").validate({
            ignore:":hidden", 
            rules: {
                id_related: {
                    required: !0
                },
                type_related: {
                    required: !0
                },
                id_bank: {
                    required: !0
                },
                account_name: {
                    required: !0
                },
                account_number: {
                    required: !0
                },
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });


        $("#md_add_bank_acconts").on("shown.bs.modal", function() {
            $("#id_related").select2({
                placeholder: "Select user",
                dropdownParent: $("#md_add_bank_acconts")
            });
            $("#id_bank").select2({
                placeholder: "Select Bank",
                dropdownParent: $("#md_add_bank_acconts")
            });
            $("#type_related").select2({
                placeholder: "Select type related",
                dropdownParent: $("#md_add_bank_acconts")
            });
        });
        
          
    },
    add_accounts_bank: function() {
        preloader("show");
        add_bank_acconts.clearForm();
        preloader('hide');
        $("#md_add_bank_acconts").modal({
            show: true,
            backdrop: 'static',
            keyboard: false
        });
        $('#title').text('Add Bank Account');

    },
    list: function() {
        dataTable = $('#dt_bank_accounts').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "ajax": {
                url: "../model/ctCommissionsOfSale.php", // json datasource
                data: {
                    method: "dt_bank_accounts",
                    source: 2
                },
                type: "post",
                error: function() {}
            },
            "columnDefs": [{
                targets: [-1],
                orderable: false
            }],
            "order": [
                [0, "asc"]
            ],
            drawCallback: function(response) {
                dataTable.columns( [ 0, 1, 8, 9, 10, 11, 12, 13, 14, 15] ).visible( false, false );
            }
        });
    },
    events: function() {
        var $add_accounts = $('#button_add_accounts');
        $add_accounts.click(function() {
            if ($formAddValidate.valid()) {
                preloader('show');

                $.post("../model/ctCommissionsOfSale.php", {
                            "method": 'addAccounts',
                            "id": $('#add_acount_id').val() == '0' ? 0 : $('#add_acount_id').val(),
                            "id_related": $('#id_related').val(),
                            "type_related": $('#type_related').val(),
                            "id_bank": $('#id_bank').val(),
                            "account_name": $('#account_name').val(),
                            "account_nickname": $('#account_nickname').val(),
                            "account_number": $('#account_number').val(),
                            "account_start_number": $('#account_start_number').val(),
                            "phone": $('#phone').val(),
                            "address_line1": $('#address_line1').val(),
                            "address_line2": $('#address_line2').val(),
                            "city": $('#city').val(),
                            "state": $('#state').val(),
                            "zip": $('#zip').val()
                        },
                        function(data) {
                            if (data.mss === '1') {
                                $("#md_add_bank_acconts").modal('hide');
                                preloader('hide', data.salida, 'success');
                                dataTable.draw();
                            } else {
                                preloader('hide', data.salida, 'error');
                            }

                        }, "json")
                    .fail(
                        function(error) {
                            console.log(error.responseJSON);
                            preloader('hide');
                        }
                    );
            }
        });


        $('#dt_bank_accounts tbody').on('click', '.btnEdit', function () {

            $("#md_add_bank_acconts").modal({
                show: true,
                backdrop: 'static',
                keyboard: false
            });
            $('#title').text('Edit Bank Account');
            var data = dataTable.row($(this).parents('tr')).data(); 
                console.log(data)
                var type_related = '';
                if (data[7] == 'Agent') {
                       type_related = 1;
                }else{
                       type_related = 2;
                }
                $('#type_related').val(type_related),


                $('#add_acount_id').val(data[0]),
                $('#id_related').val(data[1]),
                $('#id_bank').val(data[8]),
                $('#account_name').val(data[3]),
                $('#account_nickname').val(data[9]),
                $('#account_number').val(data[4]),
                $('#account_start_number').val(data[10]),
                $('#phone').val(data[5]),
                $('#address_line1').val(data[11]),
                $('#address_line2').val(data[12]),
                $('#city').val(data[13]),
                $('#state').val(data[14]),
                $('#zip').val(data[15])
        });
        $('#dt_bank_accounts tbody').on('click', '.btnDelete', function () {
            var data = dataTable.row($(this).parents('tr')).data();  
            swal({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, delete it!"
            }).then(function(e) {
                if (e.dismiss === "cancel") {
                    swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {
                    preloader('show');
                    $.post('../model/ctCommissionsOfSale.php', {
                        method: 'deleteBankAccounts',
                        id: data[0]
                    }, function(data) {
                        if (data.mss == '1') {
                            preloader('hide', data.salida, 'success');
                            dataTable.draw(false);
                        } else {
                            preloader('hide', data.salida, 'error');
                            console.log(data.mss);
                        }
                    }, 'json');
                }
            });

        });
    },

    clearForm: function() {

    $('#add_acount_id').val(0),
    $('#id_related').val(''),
    $('#type_related').val(''),
    $('#id_bank').val(''),
    $('#account_name').val(''),
    $('#account_nickname').val(''),
    $('#account_number').val(''),
    $('#account_start_number').val(''),
    $('#phone').val(''),
    $('#address_line1').val(''),
    $('#address_line2').val(''),
    $('#city').val(''),
    $('#state').val(''),
    $('#zip').val('')
    }
};


function getHora() {
    var h = new Date();
    var hora = moment(h).format('YYYY-MM-DD HH:mm:ss');
    return hora
}

$(function() {

    add_bank_acconts.init();
    add_bank_acconts.clearForm();
    add_bank_acconts.list();
    add_bank_acconts.events();
    $.fn.modal.Constructor.prototype.enforceFocus = function () {
    $(document)
      .off('focusin.bs.modal') // guard against infinite focus loop
      .on('focusin.bs.modal', $.proxy(function (e) {
        if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {
          this.$element.focus()
        }
      }, this))
    }
});