var $fromAddStatusUser = $('#modal_add_status_user_from')
dataTable = '';

$(function() {  

    status_user.init();
    status_user.dt_status_user();
    status_user.events();

});

status_user = {
    init: function() {

        $("#modal_add_status_user_from").validate({
            rules: {
                modal_add_status_user_name: {
                    required: !0
                },
                modal_add_status_user_status_time: {
                    number: true
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) { }
        });
    },

    dt_status_user: function() {
        dataTable = $('#dtFlowList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "ajax": {
                url: "../model/status_user_model.php", // json datasource
                data: {
                    method: "listStatusUser",
                    lang: localStorage.getItem('settingLang')
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            "order": [
            [1, "asc"]
            ],
            drawCallback: function(response) {
                if (response.code == '440'){
                    loginTimeout(response.message);
                    return;
                }
            }
        });
    },
    events: function() {

        $("#modal_add_status_user_button_add").click(function() {
            if ($fromAddStatusUser.valid()) {
                preloader('show');

                if ($('#modal_add_status_user_display').is(':checked')) {
                    display = 1;
                } else {
                    display = 0;
                }
                $.post("../model/status_user_model.php", {
                    "method": 'addStatusUser',
                    "id": $("#modal_add_status_user_id").val() == ''? 0 : $('#modal_add_status_user_id').val(),
                    "name": $('#modal_add_status_user_name').val(),
                    "status_time": $('#modal_add_status_user_status_time').val() == ''? 0 : $('#modal_add_status_user_status_time').val(),
                    "color": $('#modal_add_status_user_color').find('input').val(),
                    "display": display
                }, function(data) {
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }   
                    else if(data.code == '200'){
                        preloader('hide', data.salida, 'success');
                        dataTable.draw();
                        $("#modal_add_status_user").modal('hide');
                    } else {
                        preloader('hide', data.salida, 'error');
                        console.log(data.mss);
                    }
                    preloader('hide');
                }, "json").fail(function(error) {
                    preloader('hide', 'FAIL', 'danger');
                    console.log(error.responseJSON)
                });
            }
        });

        $("#flow_button_delete").click(function(id) {
            preloader('show');
            $.post("../model/status_user_model.php", {
                "method": 'deleteStatusUser',
                "id": id
            }, function(data) {
                if (data.code == '440'){
                    loginTimeout(data.message);
                    return;
                }   
                else if(data.code == '200'){
                    preloader('hide', data.salida, 'success');
                    status_user.dt_status_user();
                } else {
                    preloader('hide', data.salida, 'error');
                    console.log(data.mss);
                }
                preloader('hide');
            }, "json").fail(function(error) {
                preloader('hide', 'FAIL', 'danger');
                console.log(error.responseJSON)
            });
        });

        $('body').on('click', '.cp_altair span', function() {
            console.log('body click');
            $(this).addClass('active_color').siblings().removeClass('active_color').end().closest('.cp_altair').find('input').val($(this).attr('data-color'));
        });

    },
    showModal: function(id){

        status_user.clear_status_user();
        checkeddDisplay = $("#modal_add_status_user_display").is(':checked');
        $.post("../model/status_user_model.php", {
            "method": 'findStatusUserById',
            "id": id
        }, function(data) {
            if (data.code == '440'){
                loginTimeout(data.message);
                return;
            } 
            else if (data.code === '200') {
                var status_user_detail = data.data[0];

                $('#modal_add_status_user_id').val(status_user_detail.id);
                $('#modal_add_status_user_name').val(status_user_detail.name);
                $('#modal_add_status_user_status_time').val(status_user_detail.status_time);

                if ((status_user_detail.display == 1 && checkeddDisplay == false) || (status_user_detail.display == 0 && checkeddDisplay == true)) {
                    $('#modal_add_status_user_display').click();
                }

                $('.cp_altair span').removeClass('active_color');
                $('.cp_altair > span').each(function() {
                    if ($(this).data('color') == status_user_detail.color) {
                        $(this).addClass("active_color");
                        $(this).addClass('active_color').siblings().removeClass('active_color').end().closest('.cp_altair').find('input').val($(this).attr('data-color'));
                    }
                });

                $("#modal_add_status_user").modal('show');
                preloader('hide');
            }
        }, "json").fail(function(error) {
            console.log(error.responseJSON)
        });
    },

    clear_status_user: function() {
        $('#modal_add_status_user_id').val('');
        $('#modal_add_status_user_name').val('');
        $('#modal_add_status_user_status_time').val('');
        $('.cp_altair span').removeClass('active_color');
        $fromAddStatusUser.validate().resetForm();

    },

    delete: function (id) {
        swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!'
        }).then(function(result) {
            if (result.value) {
                $.post('../model/status_user_model.php', {method: 'deleteStatusUser', id: id}, function (data){
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    } 
                    else if (data.code === '200') {
                        swal('Status  Deleted!','success');
                        dataTable.draw();
                    }
                }, 'json');
            }});
    },

    changeOrder: function (data){
        var parametros = {
            "method": "orderStage",
            "position": data
        };
        $.ajax({
            data: parametros,
            url:"../model/ctOpportunities.php",
            type:'post',
            success:function(){
                preloader('hide','POSITON ORDER UPDATE SUCCESSFULLY','success');
            }
        })
    }
};