var $frmAddStatusServices = $('#frmAddStatusServices'),
    dataTable = '',
    idService = '';

var status_services = {
    init: function() {

        dataTable = $('#dtStatusServicesList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive":!0,
            "ajax": {
                url: "../model/services_model.php", // json datasource
                data: {
                    action: "listStatusServices"
                },
                type: "post",
                error: function () { }
            },
            "columnDefs": [{
                    targets: [-1],
                    orderable: false
                }],
            "order": [
                [0, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });

        $frmAddStatusServices.validate({
            rules: {
                add_name: {
                    required: true, minlength: 3
                },
                add_idservices: {
                    required: true
                }
            }
        });

        $("#modalNewStatusServices").on("shown.bs.modal", function() {
            $("#add_idservices").select2({
                placeholder: "Select Service",
                minimumResultsForSearch:1/0 
            })
        });

    },
    event: () => {
        $('#btnSaveStatusServices').click(function () {
            var status = 0;
            if ($('#add_status').is(':checked')) {
                    status = 1;
                }else{
                    status = 2;
                }
            if ($frmAddStatusServices.valid()) {
                if (idService == '') {
                    var parametros = {
                        "action": "insertStatusServices",
                        "name": $("#add_name").val(),
                        "status": status
                    }
                    preloader('show');
                    $.post('../model/services_model.php', parametros, function (data) {
                        if (data.code == '440'){
                            loginTimeout(data.message);
                            return;
                        }
                        preloader('hide');
                        $('#modalNewStatusServices').modal('hide');
                        status_services.clear();
                        swal({
                            position: "top-center",
                            type: "success",
                            title: 'New Status Services Save...!',
                            showConfirmButton: !1,
                            timer: 1500
                        });
                        //swal("Good job!", 'New Category Save...!', "success");
                        dataTable.draw();
                    }, 'json');
                } else {
                    var parametros = {
                        "action": "updateStatusServices",
                        "id": idService,
                        "name": $("#add_name").val(),
                    }
                    preloader('show');
                    $.post('../model/services_model.php', parametros, function (data) {
                        if (data.code == '440'){
                            loginTimeout(data.message);
                            return;
                        }
                        preloader('hide');
                        $('#modalNewStatusServices').modal('hide');
                        status_services.clear();
                        swal({
                            position: "top-center",
                            type: "success",
                            title: 'Data Updated...!',
                            showConfirmButton: !1,
                            timer: 1500
                        });
                        //swal("Good job!", 'Data UPDATED...!', "success");
                        dataTable.draw();
                    }, 'json');
                }
            }
        });


        $('#btnNewStatusServices').click(function () {
            status_services.clear();
            $('#tittleStatusServices').text('Add Status Services');
            $('#modalNewStatusServices').modal('show');
        });

    },
    edit: function(id) {
        status_services.clear();
        idService = id;
        var parametros = {
            "action": "editStatusServices",
            "id": id
        }
        preloader('show');
        $.post('../model/services_model.php', parametros, function (data) {
            if (data.code == '440'){
                loginTimeout(data.message);
                return;
            }
            preloader('hide');
            idService = data[0].id;
            $('#add_name').val(data[0].name);
            $('#tittleStatusServices').text('Edit Status Services');
            $('#modalNewStatusServices').modal('show');

        }, 'json')
    },
    delete: function (id) {
        swal({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        type: "warning",
        showCancelButton: !0,
        confirmButtonText: "Yes, delete it!"
        }).then(function(e) {
            if (e.dismiss === "cancel") {
                swal("Cancelled", "Data is safe :)", "error");
            }
            if (e.value) {
                var parametros = {
                    "action": "deleteStatusServices",
                    "id": id
                };
                $.post('../model/services_model.php', parametros, function (data) {
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }             
                   if (data == 1) {
                        swal("Deleted!", "Your record has been deleted.", "success");
                        dataTable.draw();
                    }
                },'json');
            }
        });        
    },
    clear: () => {
        idService = '';
        $('#add_name').val('');
        $frmAddStatusServices.validate().resetForm();
    },
    status: (id) => {
        var parametros = {
            "action": "changeStatusServices",
            "ID": id
        }
        preloader('show');
        $.post('../model/services_model.php', parametros, function (data) {
            if (data.code == '440'){
                loginTimeout(data.message);
                return;
            }
            preloader('hide');
            if (data.res === 'yes') {
                swal({
                    position: "top-center",
                    type: "success",
                    title: 'Data Updated...!',
                    showConfirmButton: !1,
                    timer: 1500
                });
                //swal("Good job!", "Data Updated...!", "success");
                dataTable.draw();
            }
        }, 'json');
    }

};

$(function () {
    status_services.init();
    status_services.event();
});
