'use stritc';
var dataTable = '',
    formNewStatusLead = $('#formNewStatusLead'),
    idStatusLead = '';
status_lead_list = {
    init: () => {
        dataTable = $('#status_lead_list_table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/status_lead_model.php", // json datasource
                data: {
                    method: "status_lead_list_table"
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            "columnDefs": [{
                targets: [0],
                data: null,
                defaultContent: '<label class="m-checkbox m-checkbox--single m-checkbox--solid m-checkbox--brand"><input type="checkbox" class="m-checkable"><span></span></label>',
                orderable: false
            }],
            "order": [
                [1, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440') {
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });
        formNewStatusLead.validate({});
    },
    event: () => {
        $('#btnNewStatusLead').click(function() {
            status_lead_list.cleanForm();
            $('#modalNewStatudLead').modal('show');
        });
        $('#btnSaveNewStatusLead').click(function() {
            if (formNewStatusLead.valid()) {
                if (idStatusLead === '') {
                    var status_call = 0;
                    var show_color = 0;
                    if ($('#status_call').is(':checked')) status_call = 1;
                    if ($('#show_color').is(':checked')) show_color = 1;
                    var datos = {
                        method: 'insertStatusLead',
                        status_lead_input_id: idStatusLead,
                        id_cliente: $('#id_cliente').val(),
                        status_lead_input_name: $('#status_lead_input_name').val(),
                        status_lead_select_stage: $('#status_lead_select_stage').val(),
                        status_lead_input_stage: $('#status_lead_input_stage').val(),
                        status_call: status_call,
                        status_lead_select_status: 1,
                        color: $('#color').val(),
                        flag: $('#flag').val(),
                        show_color: show_color
                    };
                    preloader('show');
                    $.post('../model/status_lead_model.php', datos, function(data) {
                        if (data.code == '440') {
                            loginTimeout(data.message);
                            return;
                        } else {
                            if (data.code === '1') {
                                $('#modalNewStatudLead').modal('hide');
                                preloader('hide', data.message, 'success');
                                dataTable.draw();
                            } else {
                                $('#modalNewStatudLead').modal('hide');
                                preloader('hide', data.message, 'error');
                            }
                        }
                    }, 'json');
                } else {
                    var status_call = 0;
                    var show_color = 0;
                    if ($('#status_call').is(':checked')) status_call = 1;
                    if ($('#show_color').is(':checked')) show_color = 1;
                    var datos = {
                        method: 'insertStatusLead',
                        status_lead_input_id: idStatusLead,
                        id_cliente: $('#id_cliente').val(),
                        status_lead_input_name: $('#status_lead_input_name').val(),
                        status_lead_select_stage: $('#status_lead_select_stage').val(),
                        status_lead_input_stage: $('#status_lead_input_stage').val(),
                        status_call: status_call,
                        status_lead_select_status: $('#status_lead_select_status').val(),
                        color: $('#color').val(),
                        flag: $('#flag').val(),
                        show_color: show_color
                    };
                    preloader('show');
                    $.post('../model/status_lead_model.php', datos, function(data) {
                        if (data.code == '440') {
                            loginTimeout(data.message);
                            return;
                        } else {
                            if (data.mss === '1') {
                                $('#modalNewStatudLead').modal('hide');
                                preloader('hide', data.salida, 'success');
                                dataTable.draw();
                            } else {
                                $('#modalNewStatudLead').modal('hide');
                                preloader('hide', data.salida, 'error');
                            }
                        }
                    }, 'json');
                }
            } //fin del if
        }); //btnSave
        $('#flag').change(function() {
            var id_client = $('#id_cliente').val();
            var id_flag = $('#flag').val();
            var datos = {
                method: 'checkFlag',
                client: id_client,
                flag: id_flag
            };
            if (id_flag != '') {
                if (id_flag === '1') {
                    preloader('show');
                    $.post('../model/status_lead_model.php', datos, function(data) {
                        preloader('hide');
                        if (data.res == 'yes') {
                            preloader('hide', 'There Is Already A New State...!', 'error');
                            setTimeout(function() {
                                $('#flag').val('');
                                $('#fname').val(data.name);
                                $('#fcolor').val(data.color);
                                $('#fstage').val(data.stage);
                                $('#modalAlertFlag').modal('show');
                            }, 2000);
                        }
                    }, 'json');
                }
            }
        });
        $('#btnStatusColors').click(function(e) {
            e.preventDefault();
            swal({
                title: "Are you sure?",
                text: "This action will change the colors by status in leads!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, change it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: !0
            }).then(function(e) {
                if (e.dismiss) {
                    swal({
                        position: "top-center",
                        type: "error",
                        title: 'Data Is Safe :) ...!',
                        showConfirmButton: !1,
                        timer: 1500
                    });
                    //swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {
                    var parametros = {
                        "method": "changeColorsStatusLead"
                    };
                    preloader('show');
                    $.post('../model/status_lead_model.php', parametros, function(data) {
                    	console.log(data)
                        if (data.code == '440') {
                            loginTimeout(data.message);
                            return;
                        }
                        if (data.code == '200') {
                        	preloader('hide', data.message , 'success');
                        	dataTable.draw(false);
                        }

                    }, 'json');
                }
                //e.value ? swal("Deleted!", "Data has been deleted.", "success") : "cancel" === e.dismiss && swal("Cancelled", "Your imaginary file is safe :)", "error")
            })
        });
    },
    edit: (id) => {
        idStatusLead = id;
        var datos = {
            method: 'edit',
            ID: id
        };
        preloader('show');
        $.post('../model/status_lead_model.php', datos, function(data) {
            if (data.code == '440') {
                loginTimeout(data.message);
                return;
            } else {
                preloader('hide');
                $('#status_lead_input_name').val(data[0].name);
                $('#status_lead_select_stage').val(data[0].stage);
                $('#status_lead_input_stage').val(data[0].stage);
                if (data[0].status_call == 1) document.getElementById("status_call").checked = true;
                if (data[0].status_call == 0) document.getElementById("status_call").checked = false;
                $('#status_lead_select_status').val(data[0].status);
                $('#color').val(data[0].color);
                $('#flag').val(data[0].flag);
                if (data[0].show_color == 1) document.getElementById("show_color").checked = true;
                if (data[0].show_color == 0) document.getElementById("show_color").checked = false;
                $('#modalNewStatudLead').modal('show');
            }
        }, 'json');
    },
    status: (id) => {
        preloader('show');
        $.post('../model/status_lead_model.php', {
            method: 'changeStatus',
            ID: id
        }, function(data) {
            if (data.code == '440') {
                loginTimeout(data.message);
                return;
            } else {
                if (data.res === 'yes') {
                    preloader('hide', 'Data Updated...!', 'success');
                    dataTable.draw(false);
                }
            }
        }, 'json');
    },
    statuscall: (id) => {
        preloader('show');
        $.post('../model/status_lead_model.php', {
            method: 'changeStatusCall',
            ID: id
        }, function(data) {
            if (data.code == '440') {
                loginTimeout(data.message);
                return;
            } else {
                if (data.res === 'yes') {
                    preloader('hide', 'Data Updated...!', 'success');
                    dataTable.draw(false);
                }
            }
        }, 'json');
    },
    del: (id) => {
        swal({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel!",
            reverseButtons: !0
        }).then(function(e) {
            if (e.dismiss) {
                swal({
                    position: "top-center",
                    type: "error",
                    title: 'Data Is Safe :) ...!',
                    showConfirmButton: !1,
                    timer: 1500
                });
                //swal("Cancelled", "Data is safe :)", "error");
            }
            if (e.value) {
                var parametros = {
                    "method": "deleteStatusLead",
                    "id": id
                };
                preloader('show');
                $.post('../model/status_lead_model.php', parametros, function(data) {
                    if (data.code == '440') {
                        loginTimeout(data.message);
                        return;
                    }
                    preloader('hide', 'Data Has Been Deleted...!', 'success');
                    dataTable.draw();
                }, 'json');
            }
            //e.value ? swal("Deleted!", "Data has been deleted.", "success") : "cancel" === e.dismiss && swal("Cancelled", "Your imaginary file is safe :)", "error")
        })
    },
    cleanForm: () => {
        idStatusLead = '';
        $('#status_lead_input_name').val('');
        $('#status_lead_select_stage').val('');
        $('#status_lead_input_stage').val('');
        $('#status_lead_select_status').val('');
        $('#color').val('');
        $('#flag').val('');
        formNewStatusLead.validate().resetForm();
    }
};
$(function() {
    status_lead_list.init();
    status_lead_list.event();
});