var MODEL = "../model/model_sms_package.php";
var dataTable = $('#dtSmsAdministrationUserList'),
	add_change_status_form = $('#add_change_status_form');
var sms_administration_user = {
	init: function() {
		dataTable = $("#dtSmsAdministrationUserList").DataTable({
			processing: true,
			serverSide: true,
			responsive: !0,
			searching: true,
			ajax: {
				url: MODEL, // json datasource
				data: {
					method: "dtSmsAdministrationUserList"
				},
				type: "post",
				error: function() {}
			},
			columnDefs: [{
				targets: [-1],
				orderable: false
			}],
			order: [
				[1, "desc"]
			],
			drawCallback: function(response) {
				if (response.json.code == "440") {
					loginTimeout(response.json.message);
					return;
				}
			}
		});

		add_change_status_form.validate({
			rules: {
				select_add_change_status: {
					required: true
				}
			}
		});
	},
	events: function() {
		$('#check_all').on("change", ".m-group-checkable", function() {
			$("input:checkbox[name='check_sms_admin_user']").not(this).prop('checked', this.checked);
		});

		$('#btnChangeStatusAll').click(function() {
			if ($('input[name=check_sms_admin_user]:checked').length === 0) {
				preloader('hide', 'Select one or more users first!', 'warning');
			} else {
				$('#select_add_change_status').val('');
				$('#modalAddChangeStatus').modal('show');
			}
		});

		$('#btnSaveChangeStatusSms').click(function() {
			if (add_change_status_form.valid()) {
				var users = '';
				var status = '';
				preloader('show');
				$("input[name=check_sms_admin_user]").each(function(index) {
					if ($(this).is(':checked')) {
						users += $(this).val() + ',';
					}
				});
				status = $("#select_add_change_status").val();

				$.post(MODEL, {
					"method": 'setChangeStatusFromList',
					"status": status,
					"users": users.slice(0, -1)
				}, function(response) {
					if (response.code == '440') {
						loginTimeout(response.message);
						return;
					}
					if (response.code == '200') {
						preloader('hide', response.message, 'success');
						dataTable.draw();
						$('#modalAddChangeStatus').modal('hide');
					} else if (response.code == '204') {
						preloader('hide', response.message, 'error');
						console.log(response.message);
					}
				}, "json").fail(function(error) {
					preloader('hide', 'FAIL', 'error');
					console.log(error.responseJSON);
				});
			}
		});

	},
	status: function(id) {
		var parametros = {
			"method": "changeStatus",
			"id": id
		}
		preloader('show');
		$.post(MODEL, parametros, function(data) {
			if (data.code == 200) {
				preloader('hide', data.message, 'success');
				//notification('Data Updated', 'success');
				dataTable.draw(false);
			}
			preloader('hide');
		}, 'json');
	},
};
$(function() {
	sms_administration_user.init();
	sms_administration_user.events();
});