var $formAddValidate = $('#frmAddSettingPhoneNumber'),
dataTable = '';
$(function() {

    setting_phone_number.init();
    setting_phone_number.events();

});

setting_phone_number = {

    init: function() {
        $("#frmAddSettingPhoneNumber").validate({
            rules: {
                add_type: {
                    required: false
                },
                add_idrelated: {
                    required: false
                },
                add_idnumber: {
                    required: !0
                },
                add_idgroup: {
                    required: !0
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });
        $("#modalAddSettingPhoneNumber").on("shown.bs.modal", function() {
            $("#add_type").select2({
                placeholder: "Select Type",
                minimumResultsForSearch: 1 / 0
            });
            $("#add_idrelated").select2({
                placeholder: "Select Related",
                minimumResultsForSearch: 1 / 0
            });
            $("#add_idnumber").select2({
                placeholder: "Select Phone Number",
                minimumResultsForSearch: 1 / 0
            });
            $("#add_idgroup").select2({
                placeholder: "Select Group",
                minimumResultsForSearch: 1 / 0
            });
        });
        dataTable = $('#dtSettingsPhoneNumber').DataTable({            
            "searching": false,
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/setting_phone_number_model.php", // json datasource
                data: {method: "listSettingsPhoneNumber"},
                type: "post", // method  , by default get
                error: function () {  // error handling
                }
            },
            'columnDefs': [
            {"sClass": "dpass",
            "aTargets": [0]
        }
        ],
        "order": [[1, "asc"]]
    });
    },
    events: function(){
        $('#add_type').change(function(){
            var type = $(this).val();
            $(".add_idrelated").html('');
            if (type == 1) {
                $.post('../model/setting_phone_number_model.php', {method: 'findCategories'}, function(data) {
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }
                    $(".add_idrelated").html('');
                    $.each(data.salida, function() {
                        $('.add_idrelated').append('<option value="' + this.id + '">' + this.name + '</option>');
                    });
                }, 'json');
            }
            if(type == 2){
                $.post('../model/setting_phone_number_model.php', {method: 'findServices'}, function(response) {
                    console.log(response.salida)
                    $(".add_idrelated").html('');
                    $.each(response.salida, function() {
                        $('.add_idrelated').append('<option value="' + this.id + '">' + this.name + '</option>');
                    });
                }, 'json');
            }
        });

        $('#btnAddSettingPhoneNumber').click(function() {
            if ($formAddValidate.valid()) {
                var parametros = {
                    method: 'AddSettingPhoneNumber',
                    id: $("#id_setting").val(),
                    add_type: $('#add_type').val(),
                    add_idrelated: $('#add_idrelated').val(),
                    add_idnumber: $('#add_idnumber').val(),
                    add_idgroup: $('#add_idgroup').val()
                };
                $.post('../model/setting_phone_number_model.php', parametros, function(data) {
                	if (data.code == '440'){
	                    loginTimeout(data.message);
	                    return;
	                }
                    if (data.code == '200') {
                        $('#modalAddSettingPhoneNumber').modal('hide');
                        setting_phone_number.clear_modal();
                        preloader('hide', data.message, 'success');
                        dataTable.draw();
                    }
                    if (data.code == '201') {
                        $('#modalAddSettingPhoneNumber').modal('hide');
                        setting_phone_number.clear_modal();
                        preloader('hide', data.message, 'success');
                        dataTable.draw();
                    }
                }, 'json');
            }
            else {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            }
        });
    },
    edit: function(id){
        setting_phone_number.clear_modal();
        var parametros = {
            method: 'editSettingPhoneNumber',
            id: id
        };
        $.post('../model/setting_phone_number_model.php', parametros, function (data) {
        	if (data.code == '440'){
                loginTimeout(data.message);
                return;
            }

            if (data.code == 200) {
                $('#id_setting').val(data.id);
                $('#add_type').val(data.type);
                if (data.type == 1) {     
                    $.post('../model/setting_phone_number_model.php', {method: 'findCategories'}, function(response) {                       
                        $(".add_idrelated").html('');
                        $.each(response.salida, function() {
                            $('.add_idrelated').append('<option value="' + this.id + '">' + this.name + '</option>');
                        });
                        $('#add_idrelated').val(data.id_related);
                    }, 'json');         
                    
                }
                else if (data.type == 2) {                   
                    $.post('../model/setting_phone_number_model.php', {method: 'findServices'}, function(response) {                     
                        $(".add_idrelated").html('');
                        $.each(response.salida, function() {
                            $('.add_idrelated').append('<option value="' + this.id + '">' + this.name + '</option>');
                        });
                        $('#add_idrelated').val(data.id_related);
                    }, 'json');
                }

                $('#add_idnumber').val(data.number_phone);
                $('#add_idgroup').val(data.group_name);
                $('#modalAddSettingPhoneNumber').modal('show');
            }
        }, "json");
    },
    clear_modal: function(){
        $('#id_setting').val('');
        $('#add_type').val('');
        $('.add_idrelated').val('');
        $('.add_idrelated').html('');
        $('#add_idnumber').val('');
        $('#add_idgroup').val('');
        $('#frmAddSettingPhoneNumber').validate().resetForm();
    }
};