var $formValidate = $("#shedule_form_add_event");
($calendar_selectable = $("#calendar_selectable")),
  (calendarColorsWrapper = $('<div id="calendar_colors_wrapper"></div>')),
  (startDate = $("#schedule_input_event_start_date")),
  (endDate = $("#schedule_input_event_end_date")),
  (startHour = $("#schedule_input_event_start_hour")),
  (endHour = $("#schedule_input_event_end_hour")),
  ($start = ""),
  ($end = "");
var ttt = {};
var t;
t = mUtil.isRTL()
  ? {
      leftArrow: '<i class="la la-angle-right"></i>',
      rightArrow: '<i class="la la-angle-left"></i>',
    }
  : {
      leftArrow: '<i class="la la-angle-left"></i>',
      rightArrow: '<i class="la la-angle-right"></i>',
    };

var fecha_actual = ""; //var para fecha global

function stripHtml(html){
  // Crea un nuevo elemento div
  var temporalDivElement = document.createElement("div");
  // Establecer el contenido HTML con el dado
  temporalDivElement.innerHTML = html;
  // Recuperar la propiedad de texto del elemento (compatibilidad con varios navegadores)
  return temporalDivElement.textContent || temporalDivElement.innerText || "";
}

var schedule = {
  init: function () {
    $("#schedule_input_event_start_hour").timepicker();
    $("#schedule_input_event_end_hour").timepicker();
     
    CKEDITOR.replace( 'schedule_input_note' , {      
      height: 100,
      removeButtons: 'PasteFromWord'
    });

    $("#shedule_form_add_event").validate({
      rules: {
        /*schedule_input_note: {
          required: !0,
        },*/
      },
      invalidHandler: function (e, r) {
        $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop();
      },
      submitHandler: function (e) {},
    });

    $(".div_leads").hide();
    $(".div_contacts").hide();

    $("#schedule_input_event_start_date").datepicker({
      beforeShow: function (inputElem, inst) {
        var zi = Number($(inputElem).closest(".modal").css("z-index"));
        $(inputElem).css("z-index", zi + 1);
      },
    });

    $("#schedule_input_event_end_date").datepicker({
      beforeShow: function (inputElem, inst) {
        var zi = Number($(inputElem).closest(".modal").css("z-index"));
        $(inputElem).css("z-index", zi + 1);
      },
    });

    $("#schedule_input_event_start_date")
      .datepicker(startDate, {
        todayHighlight: true,
        orientation: "bottom left",
        templates: {
          leftArrow: '<i class="la la-angle-left"></i>',
          rightArrow: '<i class="la la-angle-right"></i>',
        },
      })
      .on("changeDate", function (e) {
        $(this).datepicker("hide");
      });
    $("#schedule_input_event_end_date")
      .datepicker(endDate, {
        //format: 'YYYY-MM-DD',
        rtl: mUtil.isRTL(),
        todayHighlight: !0,
        orientation: "bottom left",
        templates: t,
        weekstart: 0,
      })
      .on("changeDate", function (e) {
        $(this).datepicker("hide");
      });

    /*$("#schedule_modal_new_event").on("shown.bs.modal", function() {
            $("#schedule_select_leads, #m_select2_1_validate").select2({
                    placeholder: "Select Leads",
                    dropdownParent: $("#schedule_modal_new_event")
                }),
                $("#schedule_select_contacts, #m_select2_1_validate").select2({
                    placeholder: " Select contacts",
                    dropdownParent: $("#schedule_modal_new_event")
                });
        });*/
  },
  view_modal: function (id) {},
  view_new_modal: function () {},
  timepicker: function () {
    //$('#schedule_input_event_start_hour').timepicker();
    $("#schedule_input_event_end_hour").timepicker();
    $("#schedule_input_event_start_hour").timepicker({
      minuteStep: 1,
      showMeridian: !1,
      snapToStep: !0,
    });
    var $dp_start = $("#schedule_input_event_start_hour"),
      $dp_end = $("#schedule_input_event_end_hour");

    $dp_start.on("change", function () {
      var timeString = startHour.val();
      var hora = timeString.substring(0, 4);
      var dateStart = new Date(startDate.val() + " " + hora);
      $dp_end.val(moment(dateStart).add(30, "minutes").format("HH:mm"));
    });
  },
  events: function () {
    $("#btn_select_filter").click(function (e) {
      //Joes
      e.preventDefault();
      var id_schedule_label = $("#select_add_filter").val();
      schedule.find_events_filtered(id_schedule_label);
    });

    $("#btnschedule_modal_new_label").click(function (e) {
      //Joes
      e.preventDefault();
      schedule.initTableLabel();
      $("#schedule_modal_new_label").modal("show");
    });

    $("#btn_add_label").click(function () {
      //Joes
      if ($("#add_name_label").val() != "") {
        $.post(
          "../model/schedule_model.php",
          {
            method: "addLabel",
            name: $("#add_name_label").val(),
          },
          function (data) {
            if (data.mss == "0") {
              preloader("hide", data.salida, "warning");
            }
            if (data.mss == "1") {
              preloader("hide", data.salida, "success");
              dataTable.draw();
              schedule.findLabels("filter");
            }
          },
          "json"
        ).fail(function (error) {
          preloader("hide", "FAIL", "danger");
          console.log(error);
        });
      } else {
        preloader("hide", "Name Label is required", "warning");
      }
    });

    $("#btnschedule_modal_new_event").click(function (e) {
      e.preventDefault();
      schedule.clear_modal();
      schedule.findLabels("modal");
      $("#schedule_modal_new_event").modal("show");
    });

    $("#schedule_button_add_event").click(function () {
      var disabled_sound = "";
      var disabled_notification = "";
      if ($formValidate.valid()) {
        var reminder,
          totalMinute,
          dateReminder = "NULL",
          typeReminder = parseInt($("#schedule_select_type_reminder").val()),
          valueReminder = parseInt($("#schedule_input_value_reminder").val()),
          color = $("#schedule_div_color > .active_color").attr("data-color");
        dateStart = new Date(startDate.val() + " " + startHour.val());
        dateEnd = new Date(endDate.val() + " " + endHour.val());
        var $event_date = $("#schedule_input_event_date").val();
        var $event_start = $("#schedule_input_event_start_hour").val();
        var $event_end = $("#schedule_input_event_end_hour").val();
        preloader("show");
        if ($("#schedule_checkbox_reminder").is(":checked")) {
          reminder = 1;
          //calculo
          if (typeReminder == 1) {
            totalMinute = 1440 * valueReminder;
          } else if (typeReminder == 2) {
            totalMinute = 60 * valueReminder;
          } else if (typeReminder == 3) {
            totalMinute = valueReminder;
          }
          dateReminder = moment(dateStart)
            .subtract(totalMinute, "minutes")
            .format("YYYY-MM-DD HH:mm");
        } else {
          reminder = 0;
        }
        //var id_leads = $('#schedule_select_leads').val();
        //var id_contacts = $('#schedule_select_contacts').val();
        var id_leads = $("#schedule_select_leads").attr("data-id");
        var id_contacts = $("#schedule_select_contacts").attr("data-id");
        type = 1;
        if ($("#schedule_radio_personal").is(":checked")) {
          type = 1;
          id_leads = "NULL";
          id_contacts = "NULL";
        } else if ($("#schedule_radio_leads").is(":checked")) {
          type = 2;
          id_leads = id_leads;
          id_contacts = "NULL";
        } else if ($("#schedule_radio_contacts").is(":checked")) {
          type = 3;
          id_leads = "NULL";
          id_contacts = id_contacts;
        }

        if ($("#schedule_checkbox_notification").is(":checked")) {
          disabled_notification = 1;
        } else {
          disabled_notification = 0;
        }
        if ($("#schedule_checkbox_sound").is(":checked")) {
          disabled_sound = 1;
        } else {
          disabled_sound = 0;
        }
        let note_txt = CKEDITOR.instances['schedule_input_note'].getData();
        let dt = {
          method: "addEvent",
          id:
            $("#schedule_input_id").val() == "0"
              ? 0
              : $("#schedule_input_id").val(),
          type: type,
          id_leads: id_leads,
          id_contacts: id_contacts,
          note: note_txt,
          id_schedule_label: $("#select_add_label").val(),
          color: color,
          start: moment(dateStart).format("YYYY-MM-DD HH:mm"),
          end: moment(dateEnd).format("YYYY-MM-DD HH:mm"),
          reminder: reminder,
          type_reminder: isNaN(typeReminder) ? "NULL" : typeReminder,
          value_reminder: isNaN(valueReminder) ? "NULL" : valueReminder,
          date_reminder: dateReminder,
          code_reminder: randString(8),
          disabled_sound: disabled_sound,
          disabled_notification: disabled_notification,
          id_user_share:
            $("#select_user_share").attr("data-id") == "0"
              ? "NULL"
              : $("#select_user_share").attr("data-id") == undefined
              ? "NULL"
              : $("#select_user_share").attr("data-id"),
        };
        
        $.post(
          "../model/schedule_model.php",
          dt,
          function (data) {
            if (data.mss == "1") {
              schedule.find_events(fecha_actual);
              $("#schedule_modal_new_event").modal("hide");
              preloader("hide", data.salida, "success");
            } else {
              preloader("hide", "FAIL", "danger");
            }
          },
          "json"
        ).fail(function (error) {
          preloader("hide", "FAIL", "danger");
          console.log(error);
        });
      }
    });

    $("#schedule_button_remove_event").click(function () {
      schedule.delete_schedule($("#schedule_input_id").val());
    });

    $("body").on("click", ".cp_altair span", function () {
      $(this)
        .addClass("active_color")
        .siblings()
        .removeClass("active_color")
        .end()
        .closest(".cp_altair")
        .find("input")
        .val($(this).attr("data-color"));
    });

    $("input").on("change", function (event) {
      //console.log(event.target.id)
      if (event.target.id === "schedule_radio_personal") {
        $(".div_leads").hide();
        $(".div_contacts").hide();
        //
        $("#schedule_select_leads").val("");
        $("#schedule_select_leads").attr("data-id", 0);
        //
        $("#schedule_select_contacts").val("");
        $("#schedule_select_contacts").attr("data-id", 0);
      }
      if (event.target.id === "schedule_radio_leads") {
        $(".div_leads").show();
        $(".div_contacts").hide();
        $("#schedule_select_contacts").val("");
        $("#schedule_select_contacts").attr("data-id", 0);
      }
      if (event.target.id === "schedule_radio_contacts") {
        $(".div_leads").hide();
        $(".div_contacts").show();
        $("#schedule_select_leads").val("");
        $("#schedule_select_leads").attr("data-id", 0);
      }
    });
  },
  calendar_selectable: function () {
    var calendarColorPicker = metronic_helpers
      .color_picker(calendarColorsWrapper)
      .prop("outerHTML");
    if ($calendar_selectable.length) {
      $calendar_selectable.fullCalendar({
        header: {
          left: "prev,next today",
          center: "title",
          right: "month,agendaWeek,agendaDay,listWeek",
        },
        iconClasses: {
          close: "fc-icon-x",
          prev: "fc-icon-left-single-arrow",
          next: "fc-icon-right-single-arrow",
          prevYear: "fc-icon-left-double-arrow",
          nextYear: "fc-icon-right-double-arrow",
        },
        buttonText: {
          today: "today",
          month: "month",
          week: "week",
          day: "day",
          list: "list",
        },
        aspectRatio: 1.5,
        defaultDate: moment(),
        selectable: true,
        selectHelper: true,
        select: function (start, end) {
          //console.log('start = ' + start + ', end =' + end);
          schedule.clear_modal();
          $start = start;
          $end = end;
          $diff = $end.diff($start, "days");

          if (
            $start.format("HH:mm") == "00:00" &&
            $end.format("HH:mm") == "00:00" &&
            $diff == 1
          ) {
            $endDateView = $start;
          } else {
            $endDateView = $end;
          }
          startDate.val($start.format("MM/DD/YYYY"));
          endDate.val($endDateView.format("MM/DD/YYYY"));
          $("#schedule_input_event_start_hour").val($start.format("HH:mm"));
          $("#schedule_input_event_end_hour").val($end.format("HH:mm"));
          $("#schedule_button_remove_event").addClass("m--hide");
          $("#schedule_modal_new_event").modal("show");
          schedule.findLabels("modal");
        },
        editable: true,
        eventLimit: true,
        eventClick: function (event) {
          //console.log(event);
          //console.log(event.start + ',' + event.end);
          //console.log(event.id_leads);
          $(".button_edit_event").attr(
            "onclick",
            "schedule.show_modal(" + event.id + ")"
          );
          $(".schedule_delete").attr(
            "onclick",
            "schedule.delete_schedule(" + event.id + ")"
          );
          ////////////////////////////////////////////
          if (event.type == "2") {
            //console.log('ln 331')
            $(".button_go_to_leads").attr(
              "onclick",
              "schedule.show_modal_leads(" + event.id_leads + ")"
            );
            $(".button_go_to_leads").removeClass("disabled");
            $(".button_go_to_contacts").addClass("disabled");
          } else if (event.type == "3") {
            $(".button_go_to_contacts").attr(
              "onclick",
              "schedule.show_contacts(" + event.id_contacts + ")"
            );
            $(".button_go_to_leads").addClass("disabled");
            $(".button_go_to_contacts").removeClass("disabled");
          }
          $("#schedule_modal_do").modal("show");
        },
        editable: true,
        eventDrop: function (event, delta, revertFunc) {
          swal({
            title: "Are you sure?",
            type: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, move it!",
          }).then(function (result) {
            if (result.value) {
              preloader("show");
              $.post(
                "../model/schedule_model.php",
                {
                  method: "dragAndDropEvent",
                  id: event.id,
                  start: moment(event.start).format("YYYY-MM-DD HH:mm"),
                  //"end": moment(event.end).format('YYYY-MM-DD HH:mm')
                },
                function (data) {
                  if (data.mss == "1") {
                    schedule.find_events();
                    preloader("hide", data.salida, "success");
                  } else {
                    preloader("hide", data.salida, "warning");
                  }
                },
                "json"
              ).fail(function (error) {
                preloader("hide", "FAIL", "error");
              });
            } else if (result.dismiss === "cancel") {
              revertFunc();
            }
          });
        },
        eventResize: function (event, delta, revertFunc) {
          swal({
            title: "Are you sure?",
            type: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, do it!",
          }).then(function (result) {
            if (result.value) {
              preloader("show");
              $.post(
                "../model/schedule_model.php",
                {
                  method: "dragAndDropEvent",
                  id: event.id,
                  start: moment(event.start).format("YYYY-MM-DD HH:mm"),
                  end: moment(event.end).format("YYYY-MM-DD HH:mm"),
                },
                function (data) {
                  if (data.mss == "1") {
                    schedule.find_events();
                    preloader("hide", data.salida, "success");
                  } else {
                    preloader("hide", data.salida, "warning");
                  }
                },
                "json"
              ).fail(function (error) {
                preloader("hide", "FAIL", "danger");
              });
            } else if (result.dismiss === "cancel") {
              revertFunc();
            }
          });
        },
        timeFormat: "(HH)(:mm)",
        viewRender: function (view, element) {
          var b = $calendar_selectable.fullCalendar("getDate");
          fecha_actual = b.format("YYYY-MM-DD");
          if (view.type == "agendaWeek") {
            let start = moment(view.start._d)
              .add("days", 1)
              .format("YYYY-MM-DD");
            let end = moment(view.end._d).format("YYYY-MM-DD");
            let dates = { start: start, end: end };
            schedule.find_events(fecha_actual, dates);
          } else {
            schedule.find_events(fecha_actual);
          }
        },
      });
    }
  },
  find_events: function (fecha, dates) {
    preloader("show");
    $.post(
      "../model/schedule_model.php",
      {
        method: "findEvents",
        fecha: fecha,
        id_schedule_label: $("#select_add_filter option:selected").val(),
        dates: dates == "" ? 0 : dates,
      },
      function (response) {
        preloader("hide");

        $calendar_selectable.fullCalendar("removeEvents");
        var eventsArray = new Array();

        $.each(response.data, function (cant_reg, row) {
          //console.log(row);
          //se recorre el json.
          var eventData,
            type,
            owner = row.owner,
            eventColor = row.color;
          var label = "";
          if (row.type === "1") {
            type = "";
          } else if (row.type === "2" || row.type === "3") {
            type = row.name + " \n";
          }
          if (row.label != null && row.label != "") {
            label = " \n Label:" + row.label + "";
          }

          eventData = {
            className: row.className,
            title:
              type + " Owner: " + owner + " \n" + " " + stripHtml(row.note_30) + label,
            start: row.start,
            end: row.end,
            color: eventColor ? eventColor : "",
            url: "#schedule_modal_edit_event",
            id: row.id,
            type: row.type,
            id_leads: row.id_leads,
            id_contacts: row.id_contacts,
          };
          eventsArray.push(eventData);
        }); //Fin $.each
        $calendar_selectable.fullCalendar("addEventSource", eventsArray);
      },
      "json"
    );
  },
  find_leads: function () {
    var scheduleSelectLeads = $("#schedule_select_leads");
    $.post(
      "../model/ctLeadsAds.php",
      {
        method: "findLeadsByUser",
      },
      function (response) {
        scheduleSelectLeads.html(response.html);
      },
      "json"
    );
  },
  show_modal: function (id) {
    $("#schedule_modal_do").modal("hide");
    preloader("show");
    schedule.clear_modal();
    $("#schedule_input_id").val(id);
    var checkedReminder = $("#schedule_checkbox_reminder").is(":checked"),
      checkedSound = $("#schedule_checkbox_sound").is(":checked"),
      checkedNotification = $("#schedule_checkbox_notification").is(":checked");
    $.post(
      "../model/schedule_model.php",
      {
        method: "findScheduleById",
        id: id,
      },
      function (data) {
        console.log(data.id_contacts);
        $(".m-radio").removeClass("checked");
        $(".div_leads").hide();
        $(".div_contacts").hide();
        $(".cp_altair span").removeClass("active_color");
        if (data.type == 1) {
          $("#schedule_radio_personal").prop("checked", true);
        } else if (data.type == 2) {
          $("#schedule_radio_leads").prop("checked", true);
          $(".div_leads").show();
        } else if (data.type == 3) {
          $("#schedule_radio_contacts").prop("checked", true);
          $(".div_contacts").show();
        }
        CKEDITOR.instances['schedule_input_note'].setData(data.note);
        //$("#schedule_input_note").val(data.note);
        setTimeout(function () {
          if (data.id_schedule_label == null) {
            //joes
            $("#select_add_label").val(0);
          } else {
            $("#select_add_label").val(data.id_schedule_label);
          }
        }, 1000);

        $(".cp_altair > span").each(function () {
          if ($(this).data("color") == data.color) {
            $(this).addClass("active_color");
          }
        });
        dateStart = new Date(data.start);
        dateEnd = new Date(data.end);
        $("#schedule_input_event_start_date").val(
          moment(dateStart).format("MM/DD/YYYY")
        );
        $("#schedule_input_event_end_date").val(
          moment(dateEnd).format("MM/DD/YYYY")
        );
        $("#schedule_input_event_start_hour").val(
          moment(dateStart).format("HH:mm")
        );
        $("#schedule_input_event_end_hour").val(
          moment(dateEnd).format("HH:mm")
        );
        if (
          (data.reminder == 1 && checkedReminder == false) ||
          (data.reminder == 2 && checkedReminder == true)
        ) {
          $("#schedule_checkbox_reminder").click();
        }
        //console.log('data.disabled_sound :' + data.disabled_sound + ' checkedSound :' + checkedSound);
        if (
          (data.disabled_sound == 1 && checkedSound == false) ||
          (data.disabled_sound == 0 && checkedSound == true)
        ) {
          $("#schedule_checkbox_sound").click();
        }
        //console.log('data.disabled_notification :' + data.disabled_notification + ' checkedNotification :' + checkedNotification);
        if (
          (data.disabled_notification == 1 && checkedNotification == false) ||
          (data.disabled_notification == 0 && checkedNotification == true)
        ) {
          $("#schedule_checkbox_notification").click();
        }
        $("#schedule_select_type_reminder").val(data.type_reminder);
        $("#schedule_input_value_reminder").val(data.value_reminder);

        $("#schedule_select_leads").val(data.name_lead);
        $("#schedule_select_leads").attr("data-id", data.id_leads);
        //
        $("#schedule_select_contacts").val(data.name_contact);
        $("#schedule_select_contacts").attr("data-id", data.id_contacts);
        //
        $("#select_user_share").val(data.user_name_share);
        $("#select_user_share").attr("data-id", data.id_user_share);

        $("#schedule_button_remove_event").show();
        $("#schedule_modal_new_event").modal("show");
        $("#titleModalShedule").text("Edit Event");
        preloader("hide");
      },
      "json"
    ).fail(function (error) {
      preloader("hide", "FAIL", "danger");
    });
  },
  show_modal_leads: function (id_leads) {
    preloader("show");
    $.post(
      "../model/ctLeadsAds.php",
      {
        method: "findLeadById",
        id: id_leads,
      },
      function (data) {
        $("#schedule_modal_leads_name").html(data.full_name);
        $("#schedule_modal_leads_phone").html(data.email);
        $("#schedule_modal_leads_email").html(data.phone);
        $("#schedule_modal_leads").modal("show");
        preloader("hide");
      },
      "json"
    ).fail(function (error) {
      preloader("hide", "FAIL", "danger");
    });
  },
  show_contacts: function (id_contacts) {
    $(location).attr("href", "contacts.php?idContact=" + id_contacts);
  },
  clear_modal: function () {
    //console.log('clear_modal')

    $("#schedule_input_event_start_hour").val(moment("00:00").format("HH:mm"));
    $("#schedule_input_event_end_hour").val(moment("00:00").format("HH:mm"));
    $("#schedule_input_id").val(0);
    $(".div_leads").hide();
    $(".div_contacts").hide();
    CKEDITOR.instances['schedule_input_note'].setData("");
    $("#schedule_input_note").val("");
    $("#schedule_input_note").parent().removeClass("md-input-filled");
    $("#schedule_select_leads").val("");
    $("#schedule_select_contacts").val("");
    $(".cp_altair span").removeClass("active_color");
    $("#schedule_input_event_start_date").val("");
    $("#schedule_input_event_end_date").val("");
    $("#schedule_input_event_start_hour").val("");
    $("#schedule_input_event_end_hour").val("");
    var checked = $("#schedule_checkbox_reminder").is(":checked"),
      checkedSound = $("#schedule_checkbox_sound").is(":checked"),
      checkedNotification = $("#schedule_checkbox_notification").is(":checked");
    if (checked == true) {
      $("#schedule_checkbox_reminder").click();
    }
    if (checkedSound == true) {
      $("#schedule_checkbox_sound").click();
    }
    if (checkedNotification == true) {
      $("#schedule_checkbox_notification").click();
    }
    $("#schedule_select_type_reminder").val("");
    $("#schedule_input_value_reminder").val("");
    $("#schedule_input_value_reminder").parent().removeClass("md-input-filled");
    $("#schedule_checkbox_notification").click();
    $("#schedule_checkbox_sound").click();
    $("#schedule_radio_personal").prop("checked", true).iCheck("update");
    $("#schedule_radio_leads").prop("checked", false).iCheck("update");
    $("#schedule_radio_contacts").prop("checked", false).iCheck("update");

    $("#schedule_select_leads").val("");
    $("#schedule_select_leads").attr("data-id", 0);
    //
    $("#schedule_select_contacts").val("");
    $("#schedule_select_contacts").attr("data-id", 0);
    //
    $("#select_user_share").val("");
    $("#select_user_share").attr("data-id", 0);

    $(".global").hide();

    $formValidate.validate().resetForm();
  },
  delete_schedule: function (id) {
    preloader("show");
    $.post(
      "../model/schedule_model.php",
      {
        method: "deleteSchedule",
        id: id,
      },
      function (data) {
        schedule.find_events();
        $("#schedule_modal_do").modal("hide");
        preloader("hide", data.salida, "success");
      },
      "json"
    ).fail(function (error) {
      preloader("hide", "FAIL", "danger");
    });
  },
  initTableLabel: function () {
    //Joes
    if ($.fn.DataTable.isDataTable($("#dtLabelList"))) {
      $("#dtLabelList").DataTable().clear().destroy();
    }

    dataTable = $("#dtLabelList").DataTable({
      processing: true,
      serverSide: true,
      responsive: true,
      paging: false,
      info: false,
      serverMethod: "post",
      ajax: {
        url: "../model/schedule_model.php",
        data: {
          method: "dtLabelList",
        },
        error: function () {},
      },
      columns: [
        {
          data: "id",
        },
        {
          data: "name",
        },
        {
          data: "actions",
        },
      ],
      order: [[0, "asc"]],
    });

    $("#dtLabelList_filter").hide();
  },
  delete_label: function (id) {
    //Joes
    preloader("show");
    $.post(
      "../model/schedule_model.php",
      {
        method: "deleteLabel",
        id: id,
      },
      function (data) {
        preloader("hide", data.salida, "success");
        dataTable.draw();
      },
      "json"
    );
  },
  findLabels: function (type) {
    //Joes
    $.post(
      "../model/schedule_model.php",
      {
        method: "findLabels",
        type: type,
      },
      function (data) {
        if (data.type == 1) {
          $("#select_add_label").html(data.html);
        }
        if (data.type == 2) {
          $("#select_add_filter").html(data.html);
        }
      },
      "json"
    );
  },
  find_events_filtered: function (id_schedule_label) {
    //Joes
    preloader("show");
    $.post(
      "../model/schedule_model.php",
      {
        method: "findEventsFiltered",
        id_schedule_label: id_schedule_label,
        fecha: fecha_actual,
      },
      function (response) {
        $calendar_selectable.fullCalendar("removeEvents");
        var eventsArray = new Array();

        $.each(response.data, function (cant_reg, row) {
          //se recorre el json.
          var eventData,
            type,
            owner = row.owner,
            eventColor = row.color;
          var label = "";
          if (row.type === "1") {
            type = "";
          } else if (row.type === "2" || row.type === "3") {
            type = row.name + " \n";
          }
          if (row.label != null && row.label != "") {
            label = " \n Label:" + row.label + "";
          }
          eventData = {
            className: row.className,
            title:
              type + " Owner: " + owner + " \n" + " " + row.note_30 + label,
            start: row.start,
            end: row.end,
            color: eventColor ? eventColor : "",
            url: "#schedule_modal_edit_event",
            id: row.id,
            type: row.type,
            id_leads: row.id_leads,
            id_contacts: row.id_contacts,
          };

          eventsArray.push(eventData);
        }); //Fin $.each

        $calendar_selectable.fullCalendar("addEventSource", eventsArray); // add list events al calendar
        preloader("hide");
      },
      "json"
    );
  },
  eventsAutocomplete: function () {
    $("#schedule_select_leads").keyup(function () {
      $(".global").hide();
      $("#box_leadss").html("");
      let lead_name = $(this).val().trim();
      lead_name = lead_name.trim();
      if (lead_name.length >= 3) {
        let dt = {
          method: "loadAutocompletaLeads",
          lead_name: $(this).val(),
        };
        preloader("show");
        $.post(
          "../model/schedule_model.php",
          dt,
          function (response, textStatus, jqXHR) {
            if (response.listLieads == null) {
              preloader("hide");
            }
            if (response.listLieads.length > 0) {
              $(".global").show();
              let list = '<ul id="country-list" style="list-style:none">';
              response.listLieads.forEach((element) => {
                list += `<li onClick="selectLead(${element.id},'${element.name}');"><span style="cursor:pointer">${element.name}</span></li>`;
              });
              list += "</ul>";
              preloader("hide");
              $("#box_leads").html(list);
            }
          },
          "json"
        );
      }
      if (lead_name.length > 3) {
        $("#schedule_select_leads").attr("data-id", 0);
      }
    });
    /////////////
    $("#schedule_select_contacts").keyup(function () {
      $(".global").hide();
      $("#box_contacts").html("");
      let contact_name = $(this).val().trim();
      contact_name = contact_name.trim();
      if (contact_name.length >= 3) {
        let dt = {
          method: "loadAutocompletaContact",
          contact_name: $(this).val(),
        };
        preloader("show");
        $.post(
          "../model/schedule_model.php",
          dt,
          function (response, textStatus, jqXHR) {
            if (response.listContacts == null) {
              preloader("hide");
            }
            if (response.listContacts.length > 0) {
              $(".global").show();
              let list = '<ul id="country-list" style="list-style:none">';
              response.listContacts.forEach((element) => {
                list += `<li onClick="selectConatact(${element.id},'${element.name}');"><span style="cursor:pointer">${element.name}</span></li>`;
              });
              list += "</ul>";
              preloader("hide");
              $("#box_contacts").html(list);
            }
          },
          "json"
        );
      }
      if (contact_name.length > 3) {
        $("#schedule_select_contacts").attr("data-id", 0);
      }
    });
    /////////////
    $("#select_user_share").keyup(function () {
      $(".global").hide();
      $("#box_user").html("");
      let name = $(this).val().trim();
      name = name.trim();
      if (name.length >= 3) {
        let dt = {
          method: "loadAutocompletaUser",
          user_name: $(this).val(),
        };
        preloader("show");
        $.post(
          "../model/schedule_model.php",
          dt,
          function (response, textStatus, jqXHR) {
            if (response.listUser == null) {
              preloader("hide");
            }
            if (response.listUser.length > 0) {
              $(".global").show();
              let list = '<ul id="country-list" style="list-style:none">';
              response.listUser.forEach((element) => {
                list += `<li onClick="selectUser(${element.id},'${element.name}');"><span style="cursor:pointer">${element.name}</span></li>`;
              });
              list += "</ul>";
              preloader("hide");
              $("#box_user").html(list);
            }
          },
          "json"
        );
      }
      if (name.length > 3) {
        $("#select_user_share").attr("data-id", 0);
      }
    });
  },
};

$(function () {
  schedule.init();
  schedule.findLabels("filter");
  schedule.events();
  schedule.calendar_selectable();
  //schedule.find_events();
  schedule.timepicker();
  $.fn.modal.Constructor.prototype._enforceFocus = function () {};
  $.fn.select2.defaults.set("width", "100%");
  schedule.eventsAutocomplete();
});

function selectLead(id, name) {
  $("#schedule_select_leads").val(name);
  $("#schedule_select_leads").attr("data-id", id);
  $(".global").hide();
  $("#box_leads").html("");
}

function selectConatact(id, name) {
  $("#schedule_select_contacts").val(name);
  $("#schedule_select_contacts").attr("data-id", id);
  $(".global").hide();
  $("#box_contacts").html("");
}

function selectUser(id, name) {
  $("#select_user_share").val(name);
  $("#select_user_share").attr("data-id", id);
  $(".global").hide();
  $("#box_user").html("");
}

/* para testing de autocomplete
$('#select_user_share').focusout(function (e) { 
    e.preventDefault();
    let name =$("#select_user_share").val()
    let id = $('#select_user_share').attr('data-id');;
    console.log(name,id);
});

$('#schedule_select_leads').focusout(function (e) { 
    e.preventDefault();
    let name =$("#schedule_select_leads").val()
    let id = $('#schedule_select_leads').attr('data-id');;
    console.log(name,id);
});

$('#schedule_select_contacts').focusout(function (e) { 
    e.preventDefault();
    let name =$("#schedule_select_contacts").val()
    let id = $('#schedule_select_contacts').attr('data-id');;
    console.log(name,id);
});
*/
