var dataTable = '';

$(function() {  

    sales_list.init();
    sales_list.dt_sales_list();
    sales_list.events();

});

sales_list = {
    init: function() {

        $("#leads_ads_list_date_from").datepicker({
            rtl: mUtil.isRTL(),
            todayHighlight: !0,
            orientation: "bottom left",
            dateFormat: 'yy-mm-dd',

        });

        $("#leads_ads_list_date_to").datepicker({
            rtl: mUtil.isRTL(),
            todayHighlight: !0,
            orientation: "bottom left",
            dateFormat: 'yy-mm-dd',
        });

    },

    dt_sales_list: function() {
        // Setup - add a text input to each footer cell
        var i = 0;
        $('#dtSales tfoot th').each(function() {
            var title = $(this).text();
            $(this).html('<input type="text" placeholder="' + title + '" style="width:100%;" />');
            i++;
        });

        dataTable = $('#dtSales').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "scrollX": 200,
            "scrollCollapse": true,
            "ajax": {
                url: "../model/ctLeadsAds.php", // json datasource
                data: {
                    method: "SalesList"
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            'columnDefs': [
                {
                    "targets": [10],
                    "visible": false
                }
            ],
            "order": [
                [8, "DESC"]
            ]
        });

        // Apply the search
        dataTable.columns().every(function() {
            var that = this;
            $('input', this.footer()).on('keyup change', function() {
                if (that.search() !== this.value) {
                    that.search(this.value).draw();
                }
            });
        });

        dataTable.on("change", "tbody tr .m-checkbox", function() {
            $(this).parents("tr").toggleClass("active")
        });
    },
    events: function() {

        $('#leads_ads_list_date_to').change(function() {
            if ($('#leads_ads_list_date_to').val() != '' && $('#leads_ads_list_date_to').val() != '') {
                createRange =  $('#leads_ads_list_date_from').val() + ';' + $('#leads_ads_list_date_to').val();
                dataTable.columns([10]).search(createRange).draw();
            }
        });

        $('#btn_clear_date_range').click(function() {
            $('#leads_ads_list_date_from').val('');
            $('#leads_ads_list_date_to').val('');
            dataTable.columns([10]).search('').draw();
        });

        $('input.toggle-vis').on('change', function(e) {
            e.preventDefault();
            var column = dataTable.column($(this).attr('data-column'));
            column.visible(!column.visible());
        });

    },
    showContactsServices: function(id_contacts_services, id_contacts){

        redirect_by_post('../view/contacts.php?idContact='+id_contacts, {
            id_contacts_services: id_contacts_services
        }, true);

    }
};