"use strict";
var lang = localStorage.getItem("settingLang");
var stripe, elements, paymentElement, clientSecret;
var URLdomain = window.location.host.split(".");
var message_loading = "";

$(function () {
  application_firm.events();
});

var application_firm = {
  events: function() {

    $("body").on("click", ".export-btn", function() {
      let client = $("#select_client").val();
      if(client == "" || client == null) {
        preloader("hide", "Select an option", "warning"); 
        return;
      }

      preloader("show");
      const format = $(this).data('format');
      var data = {
        method: "exportReport",
        format: format,
        client: client
      };
      
      $.post("../model/reports_model.php", data, function (response) {
        preloader("hide");
        if (format === 'csv') {
          application_firm.downloadCSV(response, 'report.csv');
        } else if (format === 'excel') {
          application_firm.downloadExcel(response, 'report.xlsx');
        }
      }, "json");
    });

  },

  downloadCSV: function(data, filename) {
    const csv = this.convertToCSV(data);
    const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
    this.downloadFile(blob, filename);
  },

  convertToCSV: function(objArray) {
    if (objArray.length === 0) return '';
    
    const headers = Object.keys(objArray[0]);
    let csv = headers.map(header => `"${header.replace(/"/g, '""')}"`).join(',') + '\r\n';
    
    objArray.forEach(item => {
      const row = headers.map(header => {
        let value = item[header];
        if (value === null || value === undefined) value = '';
        return `"${value.toString().replace(/"/g, '""')}"`;
      });
      csv += row.join(',') + '\r\n';
    });
    
    return csv;
  },

  downloadExcel: function(data, filename) {
    // Crear libro de trabajo
    const wb = XLSX.utils.book_new();
    const ws = XLSX.utils.json_to_sheet(data);
    
    // Agregar hoja al libro
    XLSX.utils.book_append_sheet(wb, ws, "Report");
    
    // Generar archivo binario
    const wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });
    
    // Convertir a Blob
    const buffer = new ArrayBuffer(wbout.length);
    const view = new Uint8Array(buffer);
    for (let i = 0; i < wbout.length; i++) {
      view[i] = wbout.charCodeAt(i) & 0xFF;
    }
    
    const blob = new Blob([buffer], { type: 'application/octet-stream' });
    this.downloadFile(blob, filename);
  },

  downloadFile: function(blob, filename) {
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();
    
    // Limpiar
    setTimeout(() => {
      document.body.removeChild(a);
      URL.revokeObjectURL(url);
    }, 100);
  }
};