$(function() {

    receive_messages.init();
    receive_messages.dt_receive_messages_list();

    var locojo = document.getElementById('id_receiveSMS');
    var id_SMS_selected = locojo.getAttribute('idSource');

    if (id_SMS_selected > 0) {
        receive_messages.findSMSById(id_SMS_selected);
    }
});

var receive_messages = {
    init: function() {

    },
    getIdSMS: function(id_sms) {
        $('#id_sms').val(id_sms);
    },
    dt_receive_messages_list: function() {
        var i = 0;
        $('#dtReceiveMessageList tfoot th').each(function() {
            if (i != 0 && i != 1 && i != 8) {
                var title = $(this).text();
                $(this).html('<input type="text" placeholder="' + title + '" style="width:100%;" />');
            }
            i++;
        });
        dataTable = $('#dtReceiveMessageList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            // "sDom": "Rlfrtip",
            "scrollX": 200,
            "scrollCollapse": true,
            "ajax": {
                url: "../model/ctReceiveMessages.php", // json datasource
                data: {
                    method: "dtReceiveMessageList"
                },
                type: "post", // method  , by default get
                error: function() { // error handling

                }
            },
            "columnDefs": [{
                targets: [0],
                data: null,
                defaultContent: '<label class="m-checkbox m-checkbox--single m-checkbox--solid m-checkbox--brand"><input type="checkbox" value="" class="check_row"><span></span></label>',
                orderable: false
            }, {
                targets: 1,
                orderable: false,
                width: "5%"
            }],
            "order": [
                [1, "desc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });
        dataTable.columns().every(function() {
            var that = this;
            console.log('paso')
            $('input', this.footer()).on('keyup change', function() {
                if (that.search() !== this.value) {
                    that.search(this.value).draw();
                }
            });
        });
    },
    findSMSById: function(id) {
        var id_sms = id
        preloader('show');
        $.post("../model/ctReceiveMessages.php", {
                    "method": 'findSMSById',
                    "id": id_sms
                },
                function(response) {
                    if (response.code == '440'){
                        loginTimeout(response.message);
                        return;
                    }else{
                        preloader('hide');
                        $('#view_message_name_awswer').val(response.full_name);
                        $('#view_message_awswer').val(response.message);
                        $("#view_message").modal('show');
                    }
                }, "json")
            .fail(
                function(error) {
                    console.log(error.responseJSON);
                    preloader('hide');
                }
            );
    }
};