'use strict';

var frmAddRole = $('#frmAddRole'),
    frmEditRole = $('#frmEditRole'),
    frmAddModuleValidate = $('#frmAddModule'),
    dataTable = '',
    dataTableByModule = '';


var Permissions_by_role_view = {
    init: () => {

        $("#clone_role_module").on("shown.bs.modal", function() {
            $("#select_clone_role_module").select2({
                placeholder: "Select number.."
            });
        });
        dataTable = $('#dtRoole').DataTable({
            "processing": true,
            "serverSide": true,
            "searching": false,
            "responsive": !0,
            "ajax": {
                url: "../model/ctPermissions_by_role.php", // json datasource
                data: {
                    method: "listByRole"
                },
                type: "post",
                error: function() {}
            },
            "columnDefs": [{
                targets: [-1],
                orderable: false
            }, {
                targets: [-2],
                orderable: false
            }],
            "order": [
                [0, "asc"]
            ]
        });



        frmAddRole.validate({
            rules: {
                add_name: {
                    required: true,
                    maxlength: 40
                }
            }
        });

        frmEditRole.validate({
            rules: {
                editname: {
                    required: true,
                    maxlength: 40
                }
            }
        });


    },
    events: () => {

        $('#btnNewRole').click(function() {
            Permissions_by_role_view.cleanForm();
            $('#add_role').modal('show');
        });

        $('#btnNewModule').click(function() {
            var d = {
                method: 'combo_module',
                id: $("#id_role").val()
            };
            if (d.id === '') {
                swal({
                    position: "top-center",
                    type: "error",
                    title: 'Must Choose Role...!',
                    showConfirmButton: !1,
                    timer: 1500
                });
            } else {

                $('#nameModulo').html($("#headtablemodulebyrole").html());
                $('#modulo').html('');
                preloader('show');
                $.post("../model/ctPermissions_by_role.php", d, function(data) {
                    preloader('hide');
                    $.each(data.salida, function() {
                        $('#modulo').append('<option value="' + this.id + '">' + this.id + ' - ' + this.name + '</option>');
                    });
                    //$('#modulo').val(s);
                }, "json");
                $('#modal_module').modal('show');
            }

        });

        $('#btnSaveNewRole').click(function() {
            if (frmAddRole.valid()) {
                var parametros = {
                    "method": "insert",
                    "name": $("#add_name").val(),
                    "status": 1
                };
                preloader('show');
                $.post('../model/ctPermissions_by_role.php', parametros, function(data) {
                    preloader('hide');
                    if (data.mss == '1') {
                        $('#add_role').modal('hide');
                        swal({
                            position: "top-center",
                            type: "success",
                            title: 'New Role Save...!',
                            showConfirmButton: !1,
                            timer: 1500
                        });
                        dataTable.draw();
                        //$('#add_role').modal('hide');
                    }
                }, 'json');
            }
        });

        $('#btnSaveEditRole').click(function() {
            if (frmEditRole.valid()) {
                var parametros = {
                    "method": "update",
                    "name": $("#editname").val(),
                    id: $('#id_role').val()
                };
                preloader('show');
                $.post('../model/ctPermissions_by_role.php', parametros, function(data) {
                    preloader('hide');
                    if (data.mss == '1') {
                        $('#edit_role').modal('hide');
                        swal({
                            position: "top-center",
                            type: "success",
                            title: 'New Role Save...!',
                            showConfirmButton: !1,
                            timer: 1500
                        });
                        dataTable.draw();
                        // $('#edit_role').modal('hide');
                    }
                }, 'json');
            }
        });

        $('#dtRoole tbody').on('click', '.btnViewModules', function() {
            var data = dataTable.row($(this).parents('tr')).data();
            var id_role = data[0];
            var title = data[1];
            $('#id_role').val(id_role);
            $('#addNewModuleByRole').show();
            $("#headtablemodulebyrole").html('');

            $("#headtablemodulebyrole").append('Module by Role  (' + title + ')');

            $("#addNewModuleByRole").attr({
                "title": 'Module By Role  ' + title
            });

            if ($.fn.DataTable.isDataTable("#dtRooleByModule")) {
                $('#dtRooleByModule').DataTable().clear().destroy();
            }
            Permissions_by_role_view.listByModuleRole(id_role);
        });

        $('#dtRooleByModule tbody').on('click', '.view', function() {
            var data = dataTableByModule.row($(this).parents('tr')).data();
            var id = data[1];
            if ($(this).is(':checked') == true) {
                $view = 1;
            } else {
                $view = 0;
            }
            preloader('show');
            $.post("../model/ctPermissions_by_role.php", {
                        "method": 'updateView',
                        "view": $view,
                        "id": id
                    },
                    function(response) {
                        preloader('hide')
                        swal({
                            position: "top-center",
                            type: "success",
                            title: response.salida,
                            showConfirmButton: !1,
                            timer: 1500
                        });
                        //notification(response.salida, 'success');
                    }, "json")
                .fail(
                    function(error) {
                        console.log(error.responseJSON);
                        preloader('hide');
                    }
                );
            dataTableByModule.draw()


        });

        $('#dtRooleByModule tbody').on('click', '.btnDeleteModule', function() {
            var data = dataTableByModule.row($(this).parents('tr')).data();
            var id = data[1];
            var parametros = {
                "method": "deleteModule",
                "id": id
            };

            swal({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: !0
            }).then(function(e) {

                if (e.dismiss) {
                    swal({
                        position: "top-center",
                        type: "success",
                        title: 'Data is safe :)',
                        showConfirmButton: !1,
                        timer: 1500
                    });
                    //swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {

                    preloader('show');
                    $.post('../model/ctPermissions_by_role.php', parametros, function() {
                        preloader('hide');
                        swal({
                            position: "top-center",
                            type: "success",
                            title: 'Data Has Been Deleted...!',
                            showConfirmButton: !1,
                            timer: 1500
                        });
                        //swal("Deleted!", "Data has been deleted.", "success");
                        dataTableByModule.draw();
                    });

                }
                //e.value ? swal("Deleted!", "Data has been deleted.", "success") : "cancel" === e.dismiss && swal("Cancelled", "Your imaginary file is safe :)", "error")
            });
        });

        $('#dtRoole tbody').on('click', '.btnCloneRole', function() {
            var data = dataTable.row($(this).parents('tr')).data();
            var id = data[0];
             $('#id_role').val(id);

            $('#id_contacts').val(id);
            var parametros = {
                "method": "edit_clone_role_module",
                "id_role": id
            };
            //preloader('show');
            $.post('../model/ctPermissions_by_role.php', parametros, function(data) {
                //preloader('hide');
                $('#select_clone_role_module').val('');
                var clone_role_module = data.clone_role_module.split(',');
                $('#select_clone_role_module').val(clone_role_module);
            }, 'json');

            $('#clone_role_module').modal({
                show: true,
                backdrop: 'static',
                keyboard: false,
                refresh: true
            });
        });

        $("#btnSavecloneRoleModule").click(function() {
            swal({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, Clone it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: !0
            }).then(function(e) {

                if (e.dismiss) {
                    swal({
                        position: "top-center",
                        type: "success",
                        title: 'Data is safe :)',
                        showConfirmButton: !1,
                        timer: 1500
                    });
                    //swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {

                    preloader('show');
                    var select_clone_role_module = '';
                    $('select[name^="select_clone_role_module"]').each(function() {
                        select_clone_role_module += $(this).val() + ',';
                    });
                        console.log(select_clone_role_module)
                    var parametros = {
                        method: 'clone_role_module',
                        select_clone_role_module: select_clone_role_module.slice(0, -1),
                        id_role: $('#id_role').val()
                    };

                    $.post("../model/ctPermissions_by_role.php", parametros, function(data) {
                        preloader('hide');
                    }, "json").fail(function(error) {
                        console.log(error);
                        preloader('hide');
                    });

                }
                //e.value ? swal("Deleted!", "Data has been deleted.", "success") : "cancel" === e.dismiss && swal("Cancelled", "Your imaginary file is safe :)", "error")
            });
        });

        $('#dtRoole tbody').on('click', '.btnEditRole', function(e) {
            e.preventDefault();
            Permissions_by_role_view.cleanForm();
            var data = dataTable.row($(this).parents('tr')).data();
            var id = data[0];
            var parametros = {
                "method": "edit",
                "id": id
            };
            preloader('show');
            $.post('../model/ctPermissions_by_role.php', parametros, function(data) {
                preloader('hide');
                $('#id_role').val(data[0].id);
                $('#editname').val(data[0].name);
                $('#edit_role').modal('show');
            }, 'json');

        });


        $('#dtRoole tbody').on('click', '.btnDeleteRole', function(e) {
            e.preventDefault();
            var data = dataTable.row($(this).parents('tr')).data();
            var id = data[0];

            var parametros = {
                "method": "delete",
                "id": id
            };

            swal({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: !0
            }).then(function(e) {

                if (e.dismiss) {
                    swal({
                        position: "top-center",
                        type: "success",
                        title: 'Data is safe :)',
                        showConfirmButton: !1,
                        timer: 1500
                    });
                    //swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {

                    preloader('show');
                    $.post('../model/ctPermissions_by_role.php', parametros, function() {
                        preloader('hide');
                        swal({
                            position: "top-center",
                            type: "success",
                            title: 'Data Has Been Deleted...!',
                            showConfirmButton: !1,
                            timer: 1500
                        });
                        //swal("Deleted!", "Data has been deleted.", "success");
                        dataTable.draw();
                    });

                }
                //e.value ? swal("Deleted!", "Data has been deleted.", "success") : "cancel" === e.dismiss && swal("Cancelled", "Your imaginary file is safe :)", "error")
            });
        });


        $('#btnSaveNewModule').on('click', function(e) {
            e.preventDefault();
            var parametros = {
                "method": "insert_module",
                "id_role": $("#id_role").val(),
                "id_module": $("#modulo").val()
            };
            preloader('show');
            $.post('../model/ctPermissions_by_role.php', parametros, function(data) {
                preloader('hide');
                if (data.mss == '1') {
                    swal({
                        position: "top-center",
                        type: "success",
                        title: 'Added Module...!',
                        showConfirmButton: !1,
                        timer: 1500
                    });
                    // notification('success', 'insert...!');
                    dataTableByModule.draw();
                    $('#modal_module').modal('hide');

                }
            }, 'json');
        });
    },
    listByModuleRole: (id_role) => {
        dataTableByModule = $('#dtRooleByModule').DataTable({
            "processing": true,
            "serverSide": true,
            "searching": false,
            "responsive": !0,
            "ajax": {
                url: "../model/ctPermissions_by_role.php", // json datasource
                data: {
                    method: "listByModuleRole",
                    id_role: id_role
                },
                type: "post",
                error: function() {}
            },
            "columnDefs": [{
                targets: [3, 4],
                orderable: false
            }, {
                targets: [1],
                orderable: true
            }, {
                "targets": [0],
                "visible": false
            }],
            "order": [
                [0, "asc"]
            ],
            rowCallback: function(row, data, index) {
                //alert('paso')
                //switches(row)
            }
        });
    },
    statusRole: (id) => {
        var parametros = {
            "method": "changeStatusRole",
            "ID": id
        }
        preloader('show');
        $.post('../model/ctPermissions_by_role.php', parametros, function(data) {
            preloader('hide');
            if (data.res === 'yes') {
                swal({
                    position: "top-center",
                    type: "success",
                    title: 'Data Updated...!',
                    showConfirmButton: !1,
                    timer: 1500
                });
                //swal("Good job!", "Data Updated...!", "success");
                dataTable.draw();
            }
        }, 'json');
    },
    statusModule: (id) => {
        var parametros = {
            "method": "changeStatusModule",
            "ID": id
        }
        preloader('show');
        $.post('../model/ctPermissions_by_role.php', parametros, function(data) {
            preloader('hide');
            if (data.res === 'yes') {
                swal({
                    position: "top-center",
                    type: "success",
                    title: 'Data Updated...!',
                    showConfirmButton: !1,
                    timer: 1500
                });
                //swal("Good job!", "Data Updated...!", "success");
                dataTable.draw();
            }
        }, 'json');
    },
    cleanForm: () => {

        $('#add_name').val('');
        frmAddRole.validate().resetForm();
        frmEditRole.validate().resetForm();
    }
};

$(function() {

    Permissions_by_role_view.init();

    Permissions_by_role_view.events();

});


function switches(parent) {
    var $elem = parent ? $(parent).find('[data-switchery]') : $('[data-switchery]');
    if ($elem.length) {
        $elem.each(function() {
            if (!$(this).siblings('.switchery').length) {
                var $this = this,
                    this_size = $($this).attr('data-switchery-size'),
                    this_color = $($this).attr('data-switchery-color'),
                    this_secondary_color = $($this).attr('data-switchery-secondary-color');

                new Switchery($this, {
                    color: (typeof this_color !== 'undefined') ? hex2rgba(this_color, 50) : hex2rgba('#009688', 50),
                    jackColor: (typeof this_color !== 'undefined') ? hex2rgba(this_color, 100) : hex2rgba('#009688', 100),
                    secondaryColor: (typeof this_secondary_color !== 'undefined') ? hex2rgba(this_secondary_color, 50) : 'rgba(0, 0, 0,0.26)',
                    jackSecondaryColor: (typeof this_secondary_color !== 'undefined') ? hex2rgba(this_secondary_color, 50) : '#fafafa',
                    className: 'switchery' + ((typeof this_size !== 'undefined') ? ' switchery-' + this_size : '')
                });
            }
        })
    }
}