var dataTable = "";
var wrapper = document.getElementById("signature-pad");
var clearButton = wrapper.querySelector("[data-action=clear]");
var savePNGButton = wrapper.querySelector("[data-action=save-png]");
var canvas = wrapper.querySelector("canvas");
localStorage.setItem("lang", "en");
var blobf = {};
var signaturePad = new SignaturePad(canvas, {
  // It's Necessary to use an opaque color when saving image as JPEG;
  // this option can be omitted if only saving as PNG or SVG
  backgroundColor: "rgb(255, 255, 255)",
});

$(function () {
  signature.init();
});

firebaseInit();

var signature = {
  showPdf: function (data) {
    document.querySelector("object") === null
      ? true
      : document.querySelector("object").remove();
    document.querySelector("object") === null
      ? true
      : document.querySelector("object").remove();

    $("#showPdf").modal({
      show: true,
      backdrop: "static",
      keyboard: false,
    });
    var objp = document.createElement("object");
    objp.style.width = "100%";
    objp.style.height = "842pt";
    objp.type = "application/pdf";
    objp.setAttribute("id", "card");
    objp.data = "data:application/pdf;base64," + [data];
    $("#content").after(objp);
  },
  init: function () {
    $("#btnaceptar").click(function () {
      $("#svgSignature").modal("show");
      setTimeout(function () {
        resizeCanvas();
      }, 200);
    });

    dataTable = $("#documensList").DataTable({
      paging: false,
      searching: false,
      processing: true,
      serverSide: true,
      responsive: {
        details: {
          display: $.fn.dataTable.Responsive.display.childRowImmediate,
          type: "none",
          target: "",
        },
      },
      ajax: {
        url: "../model/required_documents_by_service_model.php", // json datasource
        data: {
          method: "dtRequiredDocumentsContactsByService",
          id_contact: $("#id_contact").val(),
          id_service: $("#id_service").val(),
        },
        type: "post", // method  , by default get
        error: function () {
          // error handling
        },
      },

      columnDefs: [
        {
          sClass: "dpass",
          aTargets: [0],
        },
        {
          targets: [0],
          visible: false,
        },
      ],

      order: [[2, "asc"]],
    });
  },
  getDocumentInfo: function (id, filename) {
    $("#formUpDocuments")[0].reset();
    if (filename != "") {
      swal(
        'A file "' + filename + '" is already loaded!',
        " Please delete it first",
        "error"
      ).then(function () {
        $("#upload_documents").modal("hide");
      });
    } else {
      $("#document_required").val(id);
      $("#document_filename").val(filename);
    }
  },

  noFileAlert: function (id) {
    swal("File Not Found!", "Not Uploaded Yet", "warning");
  },
};

function preloader(type, message = "", status = "") {
  console.log("preloader");
  lang = sessionStorage.getItem("lang");
  swal({
    title: lang == "en" ? "Loading!" : "Procesando!",
    showConfirmButton: false,
    showCancelButton: false,
    allowOutsideClick: false,
    onOpen: function () {
      if (type == "show") {
        swal.showLoading();
      } else {
        if (message != "") {
          swal({
            title: message,
            type: status,
            timer: 2000,
          });
        } else {
          swal.close();
        }
      }
    },
  }).then(function (e) {
    "timer" === e.dismiss && console.log("I was closed by the timer");
  });
}
function firebaseInit() {
  var config = {
    apiKey: "AIzaSyCP0Ac-otaPwQvhITVnafAjQqce36jYQvE",
    authDomain: "gosmartcrm-f37ac.firebaseapp.com",
    databaseURL: "https://gosmartcrm-f37ac.firebaseio.com",
    projectId: "gosmartcrm-f37ac",
    storageBucket: "gosmartcrm-f37ac.appspot.com",
    messagingSenderId: "61573422266",
    appId: "1:61573422266:web:f90a908caf85c0f3",
  };

  if (!firebase.apps.length) {
    //verifica si ya esta cargada app para evitar error por duplicacion
    firebase.initializeApp(config);
  }

  var email = "gosmartcrm@gmail.com";
  var password = "/*AVerSiAdivinasEsta963-)";

  firebase
    .auth()
    .signInWithEmailAndPassword(email, password)
    .catch(function (error) {
      var errorCode = error.code;
      var errorMessage = error.message;
      alert(
        "Error autenticating Firebase!",
        errorCode + " - " + errorMessage,
        "error"
      );
    });
}

function firebaseUploadFile(
  typeRelated,
  id_client = "",
  id = "",
  modules,
  callback
) {
  //typeRelated: 1:Client , 2:Contact, 3:User, 4:Provider
  var modulo = modules;
  //console.log('typeRelated >>> ', typeRelated, 'id_client >>> ', id_client, 'id >>> ', id,'modules >>> ', modules)
  if (modulo == "signing_agreement") {
    var blobf = {};
    blobf = id;
    blobf.name = randString(8);
    var file = blobf;
  }

  var mainDir = "signing_agreement/";
  var idRelated = id_client;

  if (file.length != 0) {
    //callback(1);
    var ext = ".png";
    var randomStr = randString(8); // Para añadir srting aleatorio es caso de nombres de archivos repetidos
    var file_path =
      mainDir + idRelated + "/" + randomStr + "/" + file.name + ext;
    //var file_path = mainDir + idRelated + '/' + file.name
    console.log(file);
    var storageRef = firebase.storage().ref();
    var uploadTask = storageRef.child(file_path).put(file);
    uploadTask.on(
      firebase.storage.TaskEvent.STATE_CHANGED,
      function (snapshot) {
        var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
        console.log("Upload is " + progress + "% done");
        switch (snapshot.state) {
          case firebase.storage.TaskState.PAUSED: // or 'paused'
            console.log("Upload is paused");
            break;
          case firebase.storage.TaskState.RUNNING: // or 'running'
            console.log("Upload is running");
            break;
        }
      },
      function (error) {
        alert("Error Uploading!\r\nError Code: " + error.code);
      },
      function () {
        uploadTask.snapshot.ref.getDownloadURL();
        uploadTask.snapshot.ref.getDownloadURL().then(function (downloadURL) {
          console.log("downloadURL: ", downloadURL);

          savepdf(downloadURL);
          lang = sessionStorage.getItem("lang");
          var datos = {
            method: "saveImgSignature",
            idcontactService: $("#idcontactService").val(),
            url_signing_agreement: downloadURL,
            id_client: $("#id_client").val(),
          };
          $.post(
            "../model/required_documents_by_service_model.php",
            datos,
            function (data) {
              if (data.status == 1) {
                //callback(1);
              }
            },
            "json"
          );
        });
      }
    );
  } else {
    //callback(0);
  }
}

function firebaseDeleteFile(file_path, file_name, typeRelated) {
  if (file_path != "") {
    firebaseInit();

    swal({
      title: "Are you sure?",
      text: "You can't revert this!",
      type: "warning",
      showCancelButton: !0,
      confirmButtonText: "Yes, delete it!",
    }).then(function (e) {
      if (e.dismiss === "cancel") {
        swal("Cancelled", "File is safe :)", "error");
      }
      if (e.value) {
        var storageRef = firebase.storage().ref();
        storageRef.child(file_path).delete();

        var parametros = {
          method: "deleteFilesUrl",
          file_path: file_path,
          file_name: file_name,
          typeRelated: typeRelated,
        };
        $.ajax({
          data: parametros,
          url: "../../app/model/required_documents_by_service_model.php",
          method: "post",
          dataType: "json",
          success: function (data) {
            if (data.code == "440") {
              loginTimeout(data.message);
              return;
            }
            if (data.response == "200") {
              swal("File Deleted!", "", "success");
              dataTable.draw();
            }
            if (data.response == "204") {
              swal("Can't delete file!", "Please try again", "error");
            }
          },
          //si ha ocurrido un error
          error: function () {
            swal("File Not Deleted!", "Please try again", "error");
          },
        });
      }
    });
  } else {
    swal("No File to Delete!", "Please check", "error");
  }
}

function showImage(file_url) {
  swal({
    title: "File Preview/Download",
    html:
      "<div><embed src=" +
      file_url +
      ' width="338px"/></div><div><a href="' +
      file_url +
      '" download target="_blank"> Download File</a></div>',
  });
}
function resizeCanvas() {
  // When zoomed out to less than 100%, for some very strange reason,
  // some browsers report devicePixelRatio as less than 1
  // and only part of the canvas is cleared then.
  var ratio = Math.max(window.devicePixelRatio || 1, 1);

  // This part causes the canvas to be cleared
  canvas.width = canvas.offsetWidth * ratio;
  canvas.height = canvas.offsetHeight * ratio;
  canvas.getContext("2d").scale(ratio, ratio);
  // This library does not listen for canvas changes, so after the canvas is automatically
  // cleared by the browser, SignaturePad#isEmpty might still return false, even though the
  // canvas looks empty, because the internal data of this library wasn't cleared. To make sure
  // that the state of this library is consistent with visual state of the canvas, you
  // have to clear it manually.
  signaturePad.clear();
}

resizeCanvas();

function download(dataURL, filename) {
  if (
    navigator.userAgent.indexOf("Safari") > -1 &&
    navigator.userAgent.indexOf("Chrome") === -1
  ) {
    window.open(dataURL);
  } else {
    var blob = dataURLToBlob(dataURL);
    console.log(blob);

    var url = window.URL.createObjectURL(blob);

    var a = document.createElement("a");
    a.style = "display: none";
    a.href = url;
    a.download = filename;

    document.body.appendChild(a);
    a.click();

    window.URL.revokeObjectURL(url);
  }
}

function dataURLToBlob(dataURL) {
  console.log(dataURL);
  var parts = dataURL.split(";base64,");
  var contentType = parts[0].split(":")[1];
  var raw = window.atob(parts[1]);
  var rawLength = raw.length;
  var uInt8Array = new Uint8Array(rawLength);

  for (var i = 0; i < rawLength; ++i) {
    uInt8Array[i] = raw.charCodeAt(i);
  }

  return new Blob([uInt8Array], {
    type: contentType,
  });
}

clearButton.addEventListener("click", function (event) {
  signaturePad.clear();
});

savePNGButton.addEventListener("click", function (event) {
  lang = sessionStorage.getItem("lang");
  Swal.fire({
    title:
      lang == "en"
        ? "You Want To Save Your Signature?"
        : "¿Quiere guardar su firma?",
    text:
      lang == "en"
        ? "Once it's applied, you won't be able to make changes."
        : "Una vez aplicado, no podrás realizar cambios.",
    showCancelButton: true,
    cancelButtonText: lang == "en" ? "Cancel" : "Cancelar",
    confirmButtonText: lang == "en" ? "Yes" : "Si",
  }).then((result) => {
    /* Read more about isConfirmed, isDenied below */
    if (result.value) {
      if (signaturePad.isEmpty()) {
        //alert("Please provide a signature first.");
        swal("Warning", "Please provide a signature first", "warning");
      } else {
        var img_data = signaturePad.toDataURL("image/png");
        blobf = dataURLToBlob(img_data);
        var idService = sessionStorage.getItem("idService");
        preloader("show");
        firebaseUploadFile(10, idService, blobf, "signing_agreement");
      }
    }
  });
});

function randString(size) {
  var possible =
    "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
  var text = "";
  for (var i = 0; i < size; i++) {
    text += possible.charAt(Math.floor(Math.random() * possible.length));
  }
  return text;
}
function downloadPDF(pdf) {
  const linkSource = `data:application/pdf;base64,${pdf}`;
  const downloadLink = document.createElement("a");
  const fileName = "SignaturePdf.pdf";

  downloadLink.href = linkSource;
  downloadLink.download = fileName;
  downloadLink.click();
}
var typeRelated = 2;
function firebaseUploadFilepdf(typeRelated, blobf) {
  //typeRelated: 1:Client , 2:Contact, 3:User

  lang = sessionStorage.getItem("lang");
  var id_required_documents = "";

  const name =
    $("#service").val() +
    "-" +
    $("#description").val() +
    "-" +
    $("#contactsName").val() +
    "-" +
    "signaturePdf";
  var mainDir = "contacts/";
  var idRelated = $("#id_contact").val();

  if (blobf.length != 0) {
    preloader("show");

    firebaseInit();
    var file_path = mainDir + idRelated + "/" + name;
    var storageRef = firebase.storage().ref();
    var uploadTask = storageRef.child(file_path).put(blobf);
    uploadTask.on(
      "state_changed",
      function (snapshot) {
        var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
        console.log("Upload is " + progress + "% done");
        switch (snapshot.state) {
          case firebase.storage.TaskState.PAUSED: // or 'paused'
            console.log("Upload is paused");
            break;
          case firebase.storage.TaskState.RUNNING: // or 'running'
            console.log("Upload is running");
            break;
        }
      },
      function (error) {
        swal("Error Uploading!\r\nError Code: " + error.code);
      },
      function () {
        uploadTask.snapshot.ref.getDownloadURL().then(function (downloadURL) {
          var parametros = {
            method: "savesignatureUrl",
            type: typeRelated,
            id_related: idRelated,
            id_required_documents: id_required_documents,
            file_name: name,
            file_path: file_path,
            file_url: downloadURL,
            id_contacts_services: $("#idcontactService").val(),
          };
          preloader("show");
          $.post(
            "../model/required_documents_by_service_model.php",
            parametros,
            function (data) {
              if (data.code == "440") {
                loginTimeout(data.message);
                return;
              }
              if (data.response == "200") {
                $("#svgSignature").modal("hide");
                swal(
                  lang == "en" ? "Signed Document!" : "Documento Firmado!",
                  "",
                  "success"
                ).then(() => {
                  window.location.href = "./thanks.php";
                });
                $("#parent").remove();
              }
              if (data.response == "204") {
                preloader("hide", data.message, "sucess");
                swal(
                  "File Loaded with error!",
                  "Please try again. DB Error",
                  "error"
                );
              }
            },
            "json"
          ).fail(function (error) {
            preloader("hide");
            console.log(error.responseJSON);
          });
        });
      }
    );
  } else {
    swal("No File to Upload!", "Please try again", "error");
  }
}
function b64toBlob(dataURI) {
  var byteString = atob(dataURI.split(",")[1]);
  var ab = new ArrayBuffer(byteString.length);
  var ia = new Uint8Array(ab);

  for (var i = 0; i < byteString.length; i++) {
    ia[i] = byteString.charCodeAt(i);
  }
  return new Blob([ab], { type: "application/pdf" });
}
function savepdf(url_signing_agreement) {
  var parametros = {
    method: "sendSignatureCardPdfMail",
    id_service: $("#id_service").val(),
    id_contact: $("#id_contact").val(),
    service: $("#service").val(),
    id_client: $("#id_client").val(),
    url_logo: $("#url_logo").val(),
    contactsName: $("#contactsName").val(),
    contactEmail: $("#contactEmail").val(),
    userEmail: $("#userEmail").val(),
    agentName: $("#agentName").val(),
    agentCode: $("#agentCode").val(),
    amount: $("#amount").val(),
    members: $("#members").val(),
    description: $("#description").val(),
    date: $("#date").val(),
    registeredSignature: $("#registeredSignature").val(),
    url_signing_agreement: url_signing_agreement,
  };

  $.ajax({
    data: parametros,
    url: "../model/required_documents_by_service_model.php",
    type: "post",
    success: function (response) {
      var data = JSON.parse(response);
      var pdf = "data:application/pdf," + data.preview[0] + "";
      var blob = b64toBlob(pdf);
      firebaseUploadFilepdf(2, blob);
    },
  });
}
