var $formValidate = $("#shedule_form_add_event");
($calendar_selectable = $("#calendar_selectable")),
  (calendarColorsWrapper = $('<div id="calendar_colors_wrapper"></div>'));
var ttt = {};
var array = [];
var t;
t = mUtil.isRTL()
  ? {
      leftArrow: '<i class="la la-angle-right"></i>',
      rightArrow: '<i class="la la-angle-left"></i>',
    }
  : {
      leftArrow: '<i class="la la-angle-left"></i>',
      rightArrow: '<i class="la la-angle-right"></i>',
    };

var fecha_actual = "",
  type = ""; //var para fecha global
let dates = "";
var payments_calendar = {
  init: function () {},
  events: function () {
    $("#btn_select_filter").click(function (e) {
      e.preventDefault();
      var id_payment_label = $("#select_add_filter").val();
      payments_calendar.find_events_filtered(id_payment_label);
    });
  },
  calendar_selectable: function () {
    var calendarColorPicker = metronic_helpers
      .color_picker(calendarColorsWrapper)
      .prop("outerHTML");
    if ($calendar_selectable.length) {
      $calendar_selectable.fullCalendar({
        header: {
          left: "prev,next today",
          center: "title",
          right: "month,agendaWeek,agendaDay,listWeek",
        },
        iconClasses: {
          close: "fc-icon-x",
          prev: "fc-icon-left-single-arrow",
          next: "fc-icon-right-single-arrow",
          prevYear: "fc-icon-left-double-arrow",
          nextYear: "fc-icon-right-double-arrow",
        },
        buttonText: {
          today: "today",
          month: "month",
          week: "week",
          day: "day",
          list: "list",
        },
        aspectRatio: 1.5,
        defaultDate: moment(),
        selectable: true,
        selectHelper: true,
        select: function (start, end) {
          //console.log('start = ' + start + ', end =' + end);
          $start = start;
          $end = end;
          $diff = $end.diff($start, "days");

          if (
            $start.format("HH:mm") == "00:00" &&
            $end.format("HH:mm") == "00:00" &&
            $diff == 1
          ) {
            $endDateView = $start;
          } else {
            $endDateView = $end;
          }
        },
        editable: true,
        eventLimit: true,
        eventClick: function (event) {
          //console.log(event.start + ',' + event.end);
          //console.log(event.id_leads);
        },
        editable: false,
        timeFormat: "(HH)(:mm)",
        viewRender: function (view, element) {
          // console.log(view, element);
          var b = $calendar_selectable.fullCalendar("getDate");
          let start = "",
            end = "";
          fecha_actual = b.format("YYYY-MM-DD");
          type = view.type;
          if (type == "agendaWeek" || type == "agendaDay") {
            start = moment(view.start._d).add("days", 1).format("YYYY-MM-DD");
            end = moment(view.end._d).format("YYYY-MM-DD");
            dates = { start: start, end: end };
            payments_calendar.find_events(fecha_actual, dates, type);
          } else if (type == "listWeek") {
            start = moment(view.start._d).add("days", 1).format("YYYY-MM-DD");
            end = moment(view.end._d).format("YYYY-MM-DD");
            dates = { start: start, end: end };
            payments_calendar.find_events(fecha_actual, dates, type);
          } else if (type == "month") {
            payments_calendar.find_events(fecha_actual, "", type);
          }
        },
        eventRender: function (event, eventElement) {
          // console.log(event.agents);
          let html = "";
          if (event.title) {
            html = `<span style="${event.titleStyle}">${event.title}</span><br>`;
            html += `${event.agents} <small style='font-size:11px'>agents</small> / `;
            html += `${event.status_sales} <small style='font-size:11px'>aplications</small></span>`;
            eventElement.find("span.fc-title").html(html);
          }
        },
      });
    }
  },
  find_events: function (fecha, dates, typeEvent = "") {
    preloader("show");

    let start = dates.start,
      end = dates.end;
    $("#totalByMonth").html("");
    $.post(
      "../model/payments_model.php",
      {
        action: "findPaymentsCalendar",
        fecha: fecha,
        id_payment_label: $("#select_add_filter option:selected").val(),
        dates: dates == "" ? 0 : dates,
        type: typeEvent,
      },
      function (response) {
        preloader("hide");
        $calendar_selectable.fullCalendar("removeEvents");
        var eventsArray = new Array();

        $("#totalByArgument").html("");
        let typeA = "",
          totalA = 0,
          totalByMonth = 0;
        switch (response.typeArgument) {
          case "agendaWeek":
            typeA = "Week";
            break;
          case "agendaDay":
            typeA = "Day";
            break;
          case "listWeek":
            typeA = "List";
            break;
        }
        if (response.data.length) {
          $.each(response.data, function (cant_reg, row) {
            if (moment(row.date).isBetween(start, end, null, "[]")) {
              totalA += row.totalAmount;
            }
            if (
              moment(fecha).isBetween(
                moment(row.date).startOf("month").format("YYYY-MM-DD"),
                moment(row.date).endOf("month").format("YYYY-MM-DD"),
                null,
                "[]"
              )
            ) {
              totalByMonth += row.totalAmount;
            }
            //se recorre el json.
            var eventData;
            eventData = {
              title: "$ " + row.totalAmount,
              titleStyle: "font-size:14px;text-align: center;",
              start: row.start,
              end: row.end,
              date: row.date,
              status_sales: row.status_sales,
              agents: row.agents,
              totalByArgument: totalByArgument,
              // id_user: row.id_user,
            };
            eventsArray.push(eventData);
          }); //Fin $.each
          $calendar_selectable.fullCalendar("addEventSource", eventsArray);
        }
        console.log(totalByMonth);
        $("#totalByMonth").html(totalByMonth);
        if (response.typeArgument != "month") {
          $("#totalByArgument").html(`|| Total ${typeA}  $ ${totalA}`);
        }
      },
      "json"
    );
  },
  find_events_filtered: function (id_payment_label) {
    preloader("show");
    let start = dates.start,
      end = dates.end;
    $("#totalByMonth").html("");
    $.post(
      "../model/payments_model.php",
      {
        action: "findPaymentsCalendar",
        fecha: fecha_actual,
        id_payment_label: id_payment_label,
        type: type,
      },
      function (response) {
        preloader("hide");
        $calendar_selectable.fullCalendar("removeEvents");
        var eventsArray = new Array();
        $("#totalByArgument").html("");
        let typeA = "",
          totalA = 0,
          totalByMonth = 0;
        switch (response.typeArgument) {
          case "agendaWeek":
            typeA = "Week";
            break;
          case "agendaDay":
            typeA = "Day";
            break;
          case "listWeek":
            typeA = "List";
            break;
        }
        if (response.data.length) {
          $.each(response.data, function (cant_reg, row) {
            if (moment(row.date).isBetween(start, end, null, "[]")) {
              totalA += row.totalAmount;
            }
            if (
              moment(fecha_actual).isBetween(
                moment(row.date).startOf("month").format("YYYY-MM-DD"),
                moment(row.date).endOf("month").format("YYYY-MM-DD"),
                null,
                "[]"
              )
            ) {
              totalByMonth += row.totalAmount;
            }
            //se recorre el json.
            var eventData;

            eventData = {
              title: "$ " + row.totalAmount,
              titleStyle: "font-size:14px;text-align: center;",
              start: row.start,
              end: row.end,
              date: row.date,
              status_sales: row.status_sales,
              agents: row.agents,
              // owner: owner,
              // id_user: row.id_user,
            };
            eventsArray.push(eventData);
          }); //Fin $.each

          $calendar_selectable.fullCalendar("addEventSource", eventsArray);
        }

        $("#totalByMonth").html(totalByMonth);
        if (response.typeArgument != "month") {
          $("#totalByArgument").html(`|| Total ${typeA}  $ ${totalA}`);
        }
      },
      "json"
    );
  },
};

$(function () {
  payments_calendar.init();
  payments_calendar.events();
  payments_calendar.calendar_selectable();
});
