var $formAddValidate = $('#frmAddPayee'),
    dataTable = '';
var t;
t = mUtil.isRTL() ? {
    leftArrow: '<i class="la la-angle-right"></i>',
    rightArrow: '<i class="la la-angle-left"></i>'
} : {
    leftArrow: '<i class="la la-angle-left"></i>',
    rightArrow: '<i class="la la-angle-right"></i>'
};

var payee = {

    init: function() {

        $("#frmAddPayee").validate({
            ignore:":hidden", 
            rules: {
                name: {
                    required: !0
                },
                company_name: {
                    required: !0
                },
                phone: {
                    required: !0
                },
                email: {
                    required: !0
                },
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });

          
    },
    add_payee: function() {
        preloader("show");
        payee.clearForm();
        preloader('hide');
        $("#md_add_payee").modal({
            show: true,
            backdrop: 'static',
            keyboard: false
        });
        $('#title').text('Add Bank Account');

    },
    list: function() {
        dataTable = $('#dt_Pyee').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "ajax": {
                url: "../model/ctCommissionsOfSale.php", // json datasource
                data: {
                    method: "dt_Pyee",
                    source: 2
                },
                type: "post",
                error: function() {}
            },
            "columnDefs": [{
                targets: [-1],
                orderable: false
            }],
            "order": [
                [0, "asc"]
            ],
            drawCallback: function(response) {
                dataTable.columns( [ 0, 3 ,4 ,5 ,8 ,9 ,10]).visible( false, false );
            }
        });
    },
    events: function() {
       //  var monto = 46.73;
       // var letras = numeroALetras(monto, {
       //    //plural: "DOLLARs",
       //    singular: "DOLLAR",
       //    centPlural: "CENTS",
       //    centSingular: "CENTS"
       //  });
         
       //  console.log(letras)

        var $add_accounts = $('#button_add_accounts');
        $add_accounts.click(function() {
            if ($formAddValidate.valid()) {
                preloader('show');

                $.post("../model/ctCommissionsOfSale.php", {
                            "method": 'addPayee',
                            "id": $('#id').val() == '0' ? 0 : $('#id').val(),
                            "name": $('#name').val(),
                            "company_name": $('#company_name').val(),
                            "address1": $('#address1').val(),
                            "address2": $('#address2').val(),
                            "city": $('#city').val(),
                            "state": $('#state').val(),
                            "zip": $('#zip').val(),
                            "country": $('#country').val(),
                            "phone": $('#phone').val(),
                            "email": $('#email').val()
                        },
                        function(data) {
                            if (data.mss === '1') {
                                $("#md_add_payee").modal('hide');
                                preloader('hide', data.salida, 'success');
                                dataTable.draw();
                            } else {
                                preloader('hide', data.salida, 'error');
                            }

                        }, "json")
                    .fail(
                        function(error) {
                            console.log(error.responseJSON);
                            preloader('hide');
                        }
                    );
            }
        });


        $('#dt_Pyee tbody').on('click', '.btnEdit', function () {

            $("#md_add_payee").modal({
                show: true,
                backdrop: 'static',
                keyboard: false
            });
            $('#title').text('Edit payee Account');
            var data = dataTable.row($(this).parents('tr')).data(); 
                $('#id').val(data[0]);
                $('#name').val(data[1]);
                $('#company_name').val(data[2]);
                $('#address1').val(data[3]);
                $('#address2').val(data[4]);
                $('#city').val(data[5]);
                $('#state').val(data[6]);
                $('#zip').val(data[7]);
                $('#country').val(data[8]);
                $('#phone').val(data[9]);
                $('#email').val(data[10]);
        });
        $('#dt_Pyee tbody').on('click', '.btnDelete', function () {
            var data = dataTable.row($(this).parents('tr')).data();  
            swal({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, delete it!"
            }).then(function(e) {
                if (e.dismiss === "cancel") {
                    swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {
                    preloader('show');
                    $.post('../model/ctCommissionsOfSale.php', {
                        method: 'deletePayee',
                        id: data[0]
                    }, function(data) {
                        if (data.mss == '1') {
                            preloader('hide', data.salida, 'success');
                            dataTable.draw(false);
                        } else {
                            preloader('hide', data.salida, 'error');
                            console.log(data.mss);
                        }
                    }, 'json');
                }
            });

        });
    },

    clearForm: function() {
        $('#id').val(0);
        $('#name').val('');
        $('#company_name').val('');
        $('#address1').val('');
        $('#address2').val('');
        $('#city').val('');
        $('#state').val('');
        $('#zip').val('');
        $('#country').val('');
        $('#phone').val('');
        $('#email').val('');
    }
};


function getHora() {
    var h = new Date();
    var hora = moment(h).format('YYYY-MM-DD HH:mm:ss');
    return hora
}

$(function() {

    payee.init();
    payee.clearForm();
    payee.list();
    payee.events();
    $.fn.modal.Constructor.prototype.enforceFocus = function () {
    $(document)
      .off('focusin.bs.modal') // guard against infinite focus loop
      .on('focusin.bs.modal', $.proxy(function (e) {
        if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {
          this.$element.focus()
        }
      }, this))
    }
});