var dataTable = "";
var formAddNews = $("#formAddNews");
var formEditNews = $("#formEditNews");

$(function () {
  news_list.init();
  news_list.events();
});

news_list = {
  idUser: "",
  init: function () {
    //select multiple

    formAddNews.validate({
      rules: {
        add_title: {
          required: true,
        },
        add_description: {
          required: true,
        },
        add_publication_date: {
          required: true,
        },
        select_type: {
          required: true,
        }
      },
    });

    formEditNews.validate({
      rules: {
        edit_title: {
          required: true,
        },
        edit_description: {
          required: true,
        },
        edit_publication_date: {
          required: true,
        }
      },
    });

    dataTable = $("#dtNewsList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      searchDelay: 2000,
      ajax: {
        url: "../model/news_model.php", // json datasource
        data: {
          method: "list",
          lang: localStorage.getItem("settingLang"),
        },
        type: "post", // method  , by default get
        error: function () {
          // error handling
        },
      },
      success: function (response) {
        //alert("ready DT");
      },
      columnDefs: [
        { "width": "20%", "targets": 2 },
        { "width": "30%", "targets": 3 },
        { "width": "15%", "targets": 4 },
        { "width": "10%", "targets": 6 },
        { targets: [0], orderable: false },
        { targets: [5], orderable: false },
        { targets: [6], orderable: false },
        { targets: [1], visible: false },
      ],
      order: [[1, "asc"]],
      drawCallback: function (response) {
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
      },
    });

    $(".date").datepicker({
      appendText: "MM/DD/YYYY",
      changeMonth: true,
      changeYear: true,
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
    })
    .on("changeDate", function (e) {
      $(this).datepicker("hide");
    });
  },
  events: function () {

    $("#select_type").change(function () {
      $("#add_url_video").val("");
      $("#add_img_file").val("");
      $("#add_img_preview").attr("src","");
      $(".div_video").hide();
      $(".div_image").hide();
      $("#add_url_video").rules( "add", { required: false });
      $("#add_img_file").rules( "add", { required: false });  
      
      var type = $("#select_type").val();

      if (type == 1) {
        $( "#add_img_file" ).rules( "add", { required: true }); 
        $(".div_image").show();
      }else if(type == 2){
        $( "#add_url_video" ).rules( "add", { required: true });
        $(".div_video").show();
      } 
    });

    $("#check_all").on("change", ".m-group-checkable", function () {
      $("input:checkbox[name='check_news']")
        .not(this)
        .prop("checked", this.checked);
    });

    $("#btnNewNews").click(function (e) {
      e.preventDefault();
      news_list.clear_modals();
      $("#modalNewNews").modal("show");
    });

    $("#btnSaveNews").click(function () {
      console.log("click")
      if ($("#formAddNews").valid()) {
        preloader("show");
        uploadImageFireBase(function (response) {
          console.log("response: ")
          console.log(response)
          var url_image = response == 0 ? "" : response.url;
          var path = response == 0 ? "" : response.path;
          var url_video = $("#select_type").val() == 2 ? $("#add_url_video").val() : "";
          
          var parametros = {
            method: "insertNews",
            title: $("#add_title").val(),
            description: $("#add_description").val(),
            publication_date: $("#add_publication_date").val(),
            type: $("#select_type").val(),
            url_image: url_image,
            path: path,
            url_video: url_video,
            lang: localStorage.getItem("settingLang")
          };

          preloader("show");
          $.post("../model/news_model.php", parametros,
            function (response) {
              if (response.code == "440") {
                loginTimeout(response.message);
                return;
              }
              if (response.code == "200") {
                preloader("hide", response.message, "success");
                dataTable.draw();
                $("#modalNewNews").modal("hide");
              }
            },
            "json"
          );          
        });
      }else{
        console.log("no")
      }
    });

    $("#btnEditNews").click(function () {

      if ($("#formEditNews").valid()) {
        preloader("show");
        
        if($("#type_edit").val() == 1){
          var path = $("#path_image_view").val();
          editImageFireBase(path, function (response) {
            var url_image = response == 0 ? "" : response.url;
            var path = response == 0 ? "" : response.path;
            
            var parametros = {
              method: "updateNews",
              id_news: $("#id_news").val(),
              title: $("#edit_title").val(),
              description: $("#edit_description").val(),
              publication_date: $("#edit_publication_date").val(),
              url_image: url_image,
              path: path,
              type_edit: 1,
              lang: localStorage.getItem("settingLang")
            };
            $.post("../model/news_model.php", parametros,
              function (response) {
                if (response.code == "440") {
                  loginTimeout(response.message);
                  return;
                }
                if (response.code == "200") {
                  dataTable.draw();
                  preloader("hide", response.message, "success");                  
                  $("#modalEditNews").modal("hide");
                }
              },
              "json"
            );                         
          });
        }else{
          if($("#edit_video_url").val() != ""){
            var parametros = {
              method: "updateNews",
              id_news: $("#id_news").val(),
              title: $("#edit_title").val(),
              description: $("#edit_description").val(),
              publication_date: $("#edit_publication_date").val(),
              url_video: $("#edit_video_url").val(),
              type_edit: 2,
              lang: localStorage.getItem("settingLang")
            };
            $.post("../model/news_model.php", parametros,
              function (response) {
                if (response.code == "440") {
                  loginTimeout(response.message);
                  return;
                }
                if (response.code == "200") {
                  dataTable.draw();
                  preloader("hide", response.message, "success");                  
                  $("#modalEditNews").modal("hide");
                }
              },
              "json"
            ); 
          }else{
            var message = localStorage.getItem("settingLang") == "es" ? "La url del video es requerida" : "The video url is required";
            preloader("hide", message, "warning"); 
          }
        }
      }
    });

    $("#add_img_file").change(function(e){
      event.preventDefault();
      var fileInput = document.getElementById('add_img_file');
      var imagen = this.files[0];
      var filePath = fileInput.value;
      var allowedExtensions = /(.jpg|.jpeg|.png|.gif)$/i;
      if (!allowedExtensions.exec(filePath)) {
        Swal.fire("Ups..", 'Please upload file having extensions .jpeg/.jpg/.png/.gif Only.', "warning");
        $("#add_img_file").val("");
      }
      var datosImagen = new FileReader();
      datosImagen.readAsDataURL(imagen);
      $(datosImagen).on("load", function(event) {
        var rutaImagen = event.target.result;
        $("#add_img_preview").attr("src", rutaImagen);
      });
    });

    $("#edit_img_file").change(function(e){
      event.preventDefault();
      var fileInput = document.getElementById('edit_img_file');
      var imagen = this.files[0];
      var filePath = fileInput.value;
      var allowedExtensions = /(.jpg|.jpeg|.png|.gif)$/i;
      if (!allowedExtensions.exec(filePath)) {
        Swal.fire("Ups..", 'Please upload file having extensions .jpeg/.jpg/.png/.gif Only.', "warning");
        $("#edit_img_file").val("");
      }
      var datosImagen = new FileReader();
      datosImagen.readAsDataURL(imagen);
      $(datosImagen).on("load", function(event) {
        var rutaImagen = event.target.result;
        $("#img_news_view").attr("src", rutaImagen);
      });
    });
  },
  status: function (id) {
    event.preventDefault();
    var parametros = {
      method: "changeStatus",
      id: id,
      lang: localStorage.getItem("settingLang")
    };
    preloader("show");
    $.post(
      "../model/news_model.php",
      parametros,
      function (response) {
        if (response.code == "440") {
          loginTimeout(response.message);
          return;
        }
        if (response.code === "200") {
          preloader("hide", response.message, "success");
          dataTable.draw();
        }
      },
      "json"
    );
  },
  edit: function (id) {
    event.preventDefault();
    news_list.clear_modals();

    preloader("show");
    $.post("../model/news_model.php",{method: "findNews", id: id},
      function (data) {
        $("#id_news").val(data.news[0].id)
        $("#edit_title").val(data.news[0].title);
        $("#edit_description").val(data.news[0].description);
        $("#edit_publication_date").val(moment(data.news[0].publication_date).format("MM/DD/YYYY"));
        $("#edit_select_type").val(data.news[0].type);
        
        $(".div_image_view").hide();
        $(".div_video_view").hide();
        if(data.news[0].type == 1){
          $("#type_edit").val(1);
          $("#img_news_view").attr("src",data.news[0].url_image);
          $("#path_image_view").val(data.news[0].path);
          $(".div_image_view").show();
        }else{
          $("#type_edit").val(2);
          $("#edit_video_url").val(data.news[0].url_video);
          autoPlayVideo('div_video_view', data.news[0].url_video, '500', '500', '');
          $(".div_video_view").show();
        } 

        $("#modalEditNews").modal("show");

        preloader("hide");
      },
      "json"
    );
  },
  del: function (id) {
    event.preventDefault();
    swal({
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      type: "warning",
      showCancelButton: !0,
      confirmButtonText: "Yes, delete it!",
      cancelButtonText: "No, cancel!",
      reverseButtons: !0,
    }).then(function (e) {
      if (e.dismiss) {
        swal({
          position: "top-center",
          type: "success",
          title: "Data is safe :)",
          showConfirmButton: !1,
          timer: 1500,
        });
      }
      if (e.value) {
        var parametros = {method: "delete", id: id };
        preloader("show");
        $.post("../model/news_model.php", parametros,
          function (response) {
            console.log(response.code);
            if (response.code == "440") {
              loginTimeout(response.message);
              return;
            }
            if (response.code === "200") {
              preloader("hide", "Data Has Been Deleted", "success");
              dataTable.draw();
              if (response.path != null && response.path != "") {
                var storageRef = firebase.storage().ref();
                var desertRef = storageRef.child(response.path);
                desertRef.delete().then(function(){}).catch(function(error) {
                  //preloader('hide', "Error firebase", 'warning');
                });
              }
            }
          },
          "json"
        );
      }
    });
  },
  clear_modals: () => {
    $("#add_title").val("");
    $("#add_description").val("");
    $("#add_publication_date").val("");

    $("#add_url_video").val("");
    $("#add_img_file").val("");

    $(".div_video").hide();
    $(".div_image").hide();
    $("#add_img_preview").val("");

    $( "#add_url_video" ).rules( "add", { required: false });
    $( "#add_img_file" ).rules( "add", { required: false });  

    //edit
    $("#id_news").val("");
    $("#edit_title").val("");
    $("#edit_description").val("");
    $("#edit_publication_date").val("");
    $("#edit_select_type").val("");

    $("#path_image_view").val("");
    $("#edit_img_file").val("");
    $("#img_news_view").attr("src","");
    $("#edit_video_url").val("");
    $("#div_video_view").html("");

    $("#formAddNews").validate().resetForm();
  }
};

function uploadImageFireBase(callback) {
  if($("#select_type").val() == 1){
    var file = document.getElementById("add_img_file").files;

    Swal.fire({
      allowOutsideClick: false,
      html: "Por favor espere...",
      didOpen: () => {
        Swal.showLoading();
      },
    });

    var storageRef = firebase.storage().ref();
    var ext = file[0].name.split('.').pop();
    var name_file = file[0].name.split('.').slice(0, -1).join('.');
    var randonfunction = (min, max) => Math.floor(Math.random() * (max - min)) + min;
    var numero = randonfunction(10000, 99999);
    var new_name = name_file+'_'+numero+'.'+ext;
    var path = 'news/'+new_name;
    
    var uploadTask = storageRef.child(path).put(file[0]);
    uploadTask.on('state_changed', function(snapshot){
      var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
      console.log('Upload is ' + progress + '% done');
      switch (snapshot.state) {
          case firebase.storage.TaskState.PAUSED: // or 'paused'
              console.log('Upload is paused');
          break;
          case firebase.storage.TaskState.RUNNING: // or 'running'
              console.log('Upload is running');
          break;
      }
    }, function(error) {
      console.log(error);
      callback(0);
      preloader("hide","Ha ocurrido un error, intente nuevamente...",'warning');
    }, function() {
      uploadTask.snapshot.ref.getDownloadURL().then(function(downloadURL) {
        var data_image = { url: downloadURL, path: path };
        callback(data_image);           
      });
    });
  }else{
    callback(0);
  }    
}

function editImageFireBase(path, callback) {
  if($("#edit_img_file").val() != ""){
    var file = document.getElementById("add_img_file").files;
    Swal.fire({
      allowOutsideClick: false,
      html: "Por favor espere...",
      didOpen: () => {
        Swal.showLoading();
      },
    });

    var storageRef = firebase.storage().ref();
    if(path != ""){
      var desertRef = storageRef.child(path);
      desertRef.delete().then(function(){
        console.log("BORRADA EXITOSAMENTE")
      }).catch(function(error) { 
        console.log("NO FUE BORRADA")
      });
    }
    var file = document.getElementById("edit_img_file").files;
    var ext = file[0].name.split('.').pop();
    var name_file = file[0].name.split('.').slice(0, -1).join('.');
    var randonfunction = (min, max) => Math.floor(Math.random() * (max - min)) + min;
    var numero = randonfunction(10000, 99999);
    var new_name = name_file+'_'+numero+'.'+ext;
    var path = 'news/'+new_name;
    
    var uploadTask = storageRef.child(path).put(file[0]);
    uploadTask.on('state_changed', function(snapshot){
      var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
      console.log('Upload is ' + progress + '% done');
      switch (snapshot.state) {
          case firebase.storage.TaskState.PAUSED: // or 'paused'
              console.log('Upload is paused');
          break;
          case firebase.storage.TaskState.RUNNING: // or 'running'
              console.log('Upload is running');
          break;
      }
    }, function(error) {
      callback(0);
    }, function() {
      uploadTask.snapshot.ref.getDownloadURL().then(function(downloadURL) {
        var data_image = { url: downloadURL, path: path };
        callback(data_image);           
      });
    });
  }else{
    callback(0);
  }
}

function autoPlayVideo(div_video, idurl, width, height, isVimeo) {
  var ok = false 
  if (isVimeo == 'isVimeo') {
    let html_container = document.getElementById(div_video);
    html_container.innerHTML = '';
    var  htmlCompany  = `<iframe class="vimeoXtra" id="videoFragment" width="${width}" height="${height}" src="https://player.vimeo.com/video/${idurl}?controls=false&title=0&byline=0&portrait=0&badge=0" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>`;
    html_container.insertAdjacentHTML('beforeend',htmlCompany);
    IDvideoFrah = "videoFragment" + new Date().getTime();
    var el = jQuery("#videoFragment").get(0);
    jQuery("#videoFragment").attr("id", IDvideoFrah);
    var iframe = document.querySelector(IDvideoFrah);
    ply = new Vimeo.Player(jQuery("#"+IDvideoFrah));
    ply.ready().then(function(e) {
      if (ok === false ) {
      }
    });
  } 
  else {
    let html_container_video = document.getElementById(div_video);
    html_container_video.innerHTML = '';
    var  htmlVideo  = `<div  class="player embed-responsive" id="videoFragment" data-property="{videoURL:'${idurl}',containment:'self',modestbranding:'1', autoPlay:false, mute:false, startAt:0, opacity:1}"></div>`;
    html_container_video.insertAdjacentHTML('beforeend',htmlVideo);
    IDvideoFrah = "videoFragment" + new Date().getTime();
    var el = jQuery("#videoFragment").get(0);
    jQuery("#videoFragment").attr("id", IDvideoFrah);
    $.getScript( "../../assets/plugins/YTPlayer/js/jquery.mb.YTPlayer.js", function( data, textStatus, jqxhr ) {
      if (textStatus === 'success') {
        ply = jQuery("#"+IDvideoFrah).mb_YTPlayer();
        ply.on("YTPReady", function (e) {
          $(".mb_YTPUrl").hide()
        });
        ply.on("YTPPlay", function (e) {
        });
      }
    });
  }
}

function getBase64Callback(callback) {
    
}

document.addEventListener("DOMContentLoaded", function(event) {

    var firebaseConfig = {
      apiKey: "AIzaSyCP0Ac-otaPwQvhITVnafAjQqce36jYQvE",
      authDomain: "gosmartcrm-f37ac.firebaseapp.com",
      databaseURL: "https://gosmartcrm-f37ac.firebaseio.com",
      projectId: "gosmartcrm-f37ac",
      storageBucket: "gosmartcrm-f37ac.appspot.com",
      messagingSenderId: "61573422266",
      appId: "1:61573422266:web:f90a908caf85c0f3"
    };

    if (!firebase.apps.length) { 
        // Initialize Firebase
        firebase.initializeApp(firebaseConfig);
    }

    var email = 'gosmartcrm@gmail.com';
    var password = '/*AVerSiAdivinasEsta963-)';

    firebase.auth().signInWithEmailAndPassword(email, password).catch(function(error) {
        var errorCode = error.code;
        var errorMessage = error.message;
        console.log("Error autenticating Firebase!"+ errorCode + ' - ' + errorMessage, "error");
    });

});