var formAddAdjustment = $("#formAddAdjustment");

$.fn.select2.defaults.set("width", "100%");
$.fn.modal.Constructor.prototype.enforceFocus = function () {};

var dataTableCommissions = "";
var dataTableSummary = "";

var lang = localStorage.getItem("settingLang");

var yearActual = new Date().getFullYear();
var monthActual = moment().format('M') < 10 ? '0' + moment().format('M') : moment().format('M');

let Conciliation = {
  event: () => {

    $('#payments_date_year').val(yearActual);

    $(document).on('click', ".dropdown-month", function(){
      monthActual = $(this).attr("data-month"); // actualizar monthActual

      setTimeout(() => { //Dar chance para que las traducciones se apliquen
        var itemText = $(this).text();
        $('#dropdownMenuButton').text(itemText);
      }, "3000");

      if (yearActual == "" || monthActual == "") {
        swal("Error", "must indicate date from!", "error");
        return;
      }
      var date = "01-" + monthActual + '-' + yearActual;
      Conciliation.tableCommissions(date);
      Conciliation.tableSummary(date);
    });

    $(`*[data-month="${monthActual}"]`).trigger('click');

    $("#payments_date_year").change(function(){
      yearActual = $(this).val(); // actualizar yearActual
      $(".dropdownSelectMonth").text("Select");
      monthsConciliations();
    })

    formAddAdjustment.validate({
      rules: {
        add_user: {
          required: true,
        },
        add_amount: {
          required: true,
          number: true,
        },
        add_adjustment_date: {
          required: true,
        },
        add_type: {
          required: true,
        },
        add_note: {
          required: false,
        },
      },
    });

    $("#payments_date_from").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm-yy",
    });

    $("#payments_date_from").datepicker("setDate", "today");

    $("#add_adjustment_date").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm/dd/yy",
    });

    $("#btn_clear_date_range").click(function () {
      $("#payments_date_from").val("");
    });

    $("#payments_date_from").change(function (e) {
      e.preventDefault();
      let payments_date_from = $("#payments_date_from").val();
      if (payments_date_from == "") {
        swal("Error", "must indicate date from!", "error");
        return;
      }
      var date = "01-" + monthActual + '-' + yearActual;
      dataTableCommissions.columns([13]).search("");
      dataTableCommissions.columns([12]).search(date).draw();
      dataTableSummary.columns([8]).search(date).draw();
    });

    $(".tab_commissions").click(function (e) {
      e.preventDefault();
      $("#buttonsDataTableSummary").show();
      $("#buttonsDataTableCommissions").hide();
    });

    $(".tab_summary").click(function (e) {
      e.preventDefault();
      $("#buttonsDataTableCommissions").show();
      $("#buttonsDataTableSummary").hide();
    });

    $("#btn_reprocesses").click(function (e) {
      var lang = localStorage.getItem("settingLang");
      Swal.fire({
        title: lang == "en" ? "Are you sure?" : "Estas seguro?",
        icon: "warning",
        input: "text",
        inputPlaceholder: "00/0000",
        showCancelButton: true,
        confirmButtonText: lang == "en" ? "Yes" : "Si",
        onOpen: function () {
          console.log("on Open");
          $(".swal2-input").datepicker({
            rtl: mUtil.isRTL(),
            todayHighlight: !0,
            orientation: "bottom left",
            dateFormat: "mm-yy",
          });
          $(".swal2-input").blur();
        },
        inputValidator: (value) => {
          return new Promise((resolve) => {
            if (value != "") {
              var data = {
                action: "reprocesses",
                date: "01-" + $(".swal2-input").val(),
                lang: lang,
              };
              $.post(
                "../model/conciliation_model.php",
                data,
                function (data) {
                  if (data.code == 201) {
                    Swal.fire({
                      title: lang == "en" ? "Are you sure?" : "Estas seguro?",
                      text: data.message,
                      showCancelButton: true,
                      icon: "warning",
                      confirmButtonText: lang == "en" ? "Yes" : "Si",
                    }).then((result) => {
                      if (result.value) {
                        preloader("show");
                        var params = {
                          action: "deletedAndReprocesses",
                          date: data.date,
                        };
                        $.post(
                          "../model/conciliation_model.php",
                          params,
                          function (data) {
                            if (data.code == 200) {
                              dataTableCommissions.draw();
                              dataTableSummary.draw();
                              preloader("hide", data.message, "success");
                            } else {
                              preloader("hide", data.message, "info");
                            }
                          },
                          "json"
                        );
                      }
                    });
                  } else if (data.code == 204) {
                    preloader("hide", data.message, "info");
                  } else if (data.code == 200) {
                    dataTableCommissions.draw();
                    dataTableSummary.draw();
                    preloader("hide", data.message, "success");
                  }
                },
                "json"
              );
            } else {
              resolve("You need to select date");
            }
          });
        },
      });
    });

    $("#btn_add_adjustment").click(function (e) {
      Conciliation.cleanAdjustment();
      $("#modalAddAdjustment").modal("show");
    });

    $("#btn_close_conciliation").click(function (e) {
      var lang = localStorage.getItem("settingLang");
      Swal.fire({
        title: lang == "en" ? "Are you sure?" : "Estas seguro?",
        text:
          lang == "en"
            ? "Once it's applied, you won't be able to make changes to this month's records."
            : "Una vez que se aplique, no podrá realizar cambios en los registros de este mes.",
        showCancelButton: true,
        confirmButtonText: lang == "en" ? "Yes" : "Si",
      }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.value) {
          var params = {
            action: "closeConciliation",
            date: "01-" + monthActual + '-' + yearActual
          };
          $.post(
            "../model/conciliation_model.php",
            params,
            function (data) {
              if (data.code == 200) {
                dataTableCommissions.draw();
                dataTableSummary.draw();
                preloader("hide", data.message, "success");
              } else if (data.code == 204) {
                preloader("hide", data.message, "info");
              } else {
                preloader("hide", "Error", "error");
              }
            },
            "json"
          );
        }
      });
    });

    $("#btnSaveAdjustment").click(function () {
      if ($("#formAddAdjustment").valid()) {
        var params = {
          action: "addAdjustment",
          id_user: $("#add_user").attr("data-id"),
          id_client: $("#add_user").attr("data-id_client"),
          amount: $("#add_amount").val(),
          adjustment_date: $("#add_adjustment_date").val(),
          type: $("#add_type").val(),
          note: $("#add_note").val(),
        };
        preloader("show");
        $.post(
          "../model/conciliation_model.php",
          params,
          function (data) {
            if (data.code == 200) {
              dataTableCommissions.draw();
              dataTableSummary.draw();
              $("#modalAddAdjustment").modal("hide");
              preloader("hide", data.message, "success");
            } else if (data.code == 204) {
              preloader("hide", data.message, "error");
            } else {
              preloader("hide", "Error", "error");
            }
          },
          "json"
        );
      }
    });

    $("#add_user").keyup(function () {
      $(".global").hide();
      $("#box_users").html("");
      let name = $(this).val().trim();
      name = name.trim();
      if (name.length >= 3) {
        let dt = {
          action: "loadAutoCompletUser",
          name: $(this).val(),
        };
        preloader("show");
        $.post(
          "../model/conciliation_model.php",
          dt,
          function (response, textStatus, jqXHR) {
            if (response.listUsers == null) {
              preloader("hide");
            }
            if (response.listUsers.length > 0) {
              $(".global").show();
              let list = '<ul id="country-list" style="list-style:none">';
              response.listUsers.forEach((element) => {
                list += `<li onClick="selectUser(${element.id},${element.id_client},'${element.name}');"><span style="cursor:pointer">${element.name} - ${element.agent_code}</span></li>`;
              });
              list += "</ul>";
              preloader("hide");
              $("#box_users").html(list);
            }
          },
          "json"
        );
      }
      // if (contact_name.length > 3) {
      //   $("#add_user").attr("data-id", 0);
      // }
    });
  },
  tableCommissions: (date) => {
    var i = 0;
    var date = "01-" + monthActual + '-' + yearActual;

    if ($.fn.DataTable.isDataTable("#dtCommissionsList")){
      $("#dtCommissionsList").DataTable().destroy();
    }
    $("#dtCommissionsList tbody").empty();

    $("#dtCommissionsList tfoot th").each(function () {
      if (!(i == 0) && i != 15) {
        var title = $(this).text();
        $(this).html(
          '<input type="text" placeholder="' +
            title +
            '" style="width:100%;" />'
        );
      }
      i++;
    });

    dataTableCommissions = $("#dtCommissionsList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      lengthMenu: [20, 35, 50, 75, 100],
      dom: "Bfrltip",
      ajax: {
        url: "../model/conciliation_model.php", // json dataholder
        data: {
          action: "listMyCommissions",
          lang: localStorage.getItem("settingLang"),
        },
        type: "post",
        error: function () {},
      },
      columnDefs: [
        {
          targets: [0],
          visible: false,
        },
      ],
      searchCols: [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        { search: date },
      ],
      order: [[0, "desc"]],
      buttons: [
        {
          extend: "csvHtml5",
          footer: true,
          text: '<i class="la la-file-text-o"></i> CSV',
          titleAttr: "CSV",
          title: "Commissions",
        },
        {
          extend: "pdfHtml5",
          footer: true,
          text: '<i class="la la-file-pdf-o"></i> PDF',
          titleAttr: "PDF",
          download: "open",
          title: "Commissions",
        },
      ],
      drawCallback: function (response) {
        // var id_role = $("#role_id").val();
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
        if (response.json.data_total != null) {
          $(".span_total_payments").text(response.json.data_total.total_amount);
          $(".span_serenity_total").text(
            (response.json.data_total.total_amount / 2).toFixed(2)
          );
          $(".span_all_commission").text(
            response.json.data_total.total_commission
          );
          $(".span_direct_commission").text(
            response.json.data_total.direct_commission
          );
          $(".span_override_commission").text(
            response.json.data_total.override_commission
          );
          $(".span_adjustment").text(response.json.data_total.adjustment);
        }
      },
    });

    dataTableCommissions
      .buttons()
      .container()
      .appendTo("#buttonsDataTableCommissions");

    //Apply the search
    dataTableCommissions.columns().every(function () {
      var that = this;
      $("input", this.footer()).on("keyup change", function () {
        if (that.search() !== this.value) {
          that.search(this.value).draw();
        }
      });
    });
    dataTableCommissions.on("change", "tbody tr .m-checkbox", function () {
      $(this).parents("tr").toggleClass("active");
    });
  },
  tableSummary: (date) => {
    var i = 0;
    var date = "01-" + monthActual + '-' + yearActual;

    if ($.fn.DataTable.isDataTable("#dtSummaryList")){
      $("#dtSummaryList").DataTable().destroy();
    }
    $("#dtSummaryList tbody").empty();

    $("#dtSummaryList tfoot th").each(function () {
      if (!(i == 0) && i != 7) {
        var title = $(this).text();
        $(this).html(
          '<input type="text" placeholder="' +
            title +
            '" style="width:100%;" />'
        );
      }
      i++;
    });

    dataTableSummary = $("#dtSummaryList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      lengthMenu: [20, 35, 50, 75, 100],
      dom: "Bfrltip",
      ajax: {
        url: "../model/conciliation_model.php", // json dataholder
        data: {
          action: "listMySummary",
          lang: localStorage.getItem("settingLang"),
        },
        type: "post",
        error: function () {},
      },
      columnDefs: [
        {
          targets: [0],
          visible: false,
        },
        {
          targets: [8],
          visible: false,
        },
        {
          targets: [7],
          orderable: false,
        },
        {
          className: "dt-center",
          targets: [1, 2, 3, 4, 5, 6],
        },
      ],
      searchCols: [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        { search: date },
      ],
      order: [[0, "desc"]],
      buttons: [
        {
          extend: "csvHtml5",
          footer: true,
          text: '<i class="la la-file-text-o"></i> CSV',
          titleAttr: "CSV",
          title: "Summary",
        },
        {
          extend: "pdfHtml5",
          footer: true,
          text: '<i class="la la-file-pdf-o"></i> PDF',
          titleAttr: "PDF",
          download: "open",
          title: "Summary",
        },
      ],
      drawCallback: function (response) {
        // var id_role = $("#role_id").val();
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
        // if (id_role == "29")
        // {
        //   dataTable.columns([9]).visible(false, false);
        // }
      },
    });

    dataTableSummary.buttons().container().appendTo("#buttonsDataTableSummary");

    //Apply the search
    dataTableSummary.columns().every(function () {
      var that = this;
      $("input", this.footer()).on("keyup change", function () {
        if (that.search() !== this.value) {
          that.search(this.value).draw();
        }
      });
    });
    dataTableSummary.on("change", "tbody tr .m-checkbox", function () {
      $(this).parents("tr").toggleClass("active");
    });
  },
  viewNote: (id) => {
    event.preventDefault();
    preloader("show");
    $("#view_note").val("");
    var params = {
      action: "viewNote",
      id: id,
    };
    $.post(
      "../model/conciliation_model.php",
      params,
      function (data) {
        if (data.code == 200) {
          console.log(data);
          $("#modalViewNote").modal("show");
          $("#view_note").val(data.note);
          preloader("hide");
        } else {
          preloader("hide", data.message, "info");
        }
      },
      "json"
    );
  },
  cleanAdjustment: (id) => {
    $("#add_user").val("");
    $("#add_user").attr("data-id", "");
    $("#add_user").attr("data-id_client", "");
    $("#add_amount").val("");
    $("#add_adjustment_date").val("");
    $("#add_type").val("");
    $("#add_note").val("");
  },
};

$(function () {
  monthsConciliations();
  Conciliation.event();
});

function selectUser(id, id_client, name) {
  $("#add_user").val(name);
  $("#add_user").attr("data-id", id);
  $("#add_user").attr("data-id_client", id_client);
  $(".global").hide();
  $("#box_users").html("");
}

function monthsConciliations(){
  $(".dropdown-month").removeClass("font-weight-bold");
  var params = {
    action: "monthsConciliations",
    year: yearActual
  };
  $.post(
    "../model/conciliation_model.php",
    params,
    function (data) {
      if (data.code == 200) {
        var mes = "";
        $.each( data.data, function( key, value ) {
          mes = parseInt(value.mes) < 10 ? '0' + parseInt(value.mes) : parseInt(value.mes);
          $(`*[data-month="${mes}"]`).addClass("font-weight-bold");
        });
      }
    },
    "json"
  );
}