var dataTable = '',
    dataTableTrigger = '',
    formTrigger = $('#formTrigger');

$(function() {  

    monitor_list.init();
    monitor_list.dt_automation_list();
    monitor_list.events();
    monitor_list.clear();

});

monitor_list = {
    init: function() {

        formTrigger.validate({
            rules: {
                trigger_name: {
                    required: true
                },
                automation_trigger: {
                    required: true
                }
            }
        });

        $("#modalTrigger").on("shown.bs.modal", function() {
            $("#value_tags").select2({
                    multiple: true,
                    tags: true,
                    maximumSelectionLength: 1,
                });

        });

    },

    dt_trigger_list: function() {
        if ($.fn.DataTable.isDataTable("#dtTriggerList")) {
            $('#dtTriggerList').DataTable().clear().destroy();
        }
        dataTableTrigger = $('#dtTriggerList').DataTable({
            "processing": true,
            "serverSide": true,
            "searching": false,
            "lengthChange": false,
            "ajax": {
                url: "../model/automation_model.php", // json datasource
                data: {
                    method: "dtTriggerList",
                    id_automation: $('#id_automation').val()
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            'columnDefs': [
                {"sClass": "dpass",
                "aTargets": [0]
                }
            ],
            "order": [
                [1, "asc"]
            ]
        });
    },

    dt_automation_list: function() {
        var i = 0;
        $('#dtAutomationList tfoot th').each(function() {
            if (i != 0 && i != 5 && i != 6) {
                var title = $(this).text();
                $(this).html('<input type="text" placeholder="' + title + '" style="width:100%;" />');
            }
            i++;
        });
        dataTable = $('#dtAutomationList').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: "../model/automation_model.php", // json datasource
                data: {
                    method: "dtTransactionList"
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            'columnDefs': [
                {"sClass": "dpass",
                "aTargets": [0]
                }
            ],
            "order": [
                [1, "asc"]
            ]
        });
        
        dataTable.columns().every(function() {
            var that = this;
            $('input', this.footer()).on('keyup change', function() {
                if (that.search() !== this.value) {
                    that.search(this.value).draw();
                }
            });
        });
        dataTable.on("change", "tbody tr .m-checkbox", function() {
            $(this).parents("tr").toggleClass("active")
        });
    },

    delete_automation: function(id) {
        swal({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!"
        }).then(function(e) {
            if (e.dismiss === "cancel") {
                swal("Cancelled", "Data is safe :)", "error");
            }
            if (e.value) {
                var parametros = {
                    method: 'deleteAutomation',
                    id: id
                };
                $.post('../model/automation_model.php', parametros, function(data) {
                    if (data == 1) {
                        swal("Deleted!", "Automation has been deleted.", "success");
                        dataTable.draw();
                    }
                });
            }
        });
    },    

    events: function() {






        $('#dtAutomationList tbody').on('click', '.btnDeleteTtransaction', function() {
            var data = dataTable.row($(this).parents('tr')).data();
            var rand_id = data[0];
            swal({
                title: "Are you sure?",
                text: "Do you want to, Stop Transaction?",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, do it!"
            }).then(function(e) {
                //e.value && swal("Deleted!", "Your file has been deleted.", "success")
                if (e.dismiss) {
                    swal({
                        position: "top-center",
                        type: "success",
                        title: 'Transaction don\'t stop..!:)',
                        showConfirmButton: !1,
                        timer: 1500
                    });
                }
                if (e.value) {
                    $('#modal_confirm').modal('hide');
                        var datos = {
                            method: 'stop_transaction',
                            rand_id: rand_id
                        };
                    $.post("../model/automation_model.php", datos, function(response) {
                        if (response.code == '200') {
                            swal(response.message, 'success');
                            dataTable.draw();
                        }
                    }, "json");
                }

            });
        });



    },

    getIdTransaction: function(rand_id) {
        console.log(rand_id)
    },
    getIdAutomation: function(automation_id) {
        sessionStorage.setItem('idAutomation', automation_id);
        window.location.href='automation.php';
    },

    getIdCampaign: function(idcampaign) {
        sessionStorage.setItem('idcampaign', idcampaign);
        window.location.href='automation.php';
    },

    clear: () => {
        formTrigger.validate().resetForm();
        $('#selectServices').val("");
        $('#selecCampaign').val("");
        $('#selectServicesDiv').hide();
        $('#selecCampaignDiv').hide();      
    }

};