var MODEL = "../model/model_sms_package.php";

var dataTable = "";

var MessageManager = {
  inicio: function() {
    MessageManager.loadNumberMessage();
  },
  loadNumberMessage: function() {//for client
    var dt = {
      method: "loadNumberMessageForClient"
    };
    $.post(
      MODEL,
      dt,
      function(data) {
        if (data.numberMessage == '0') {
          $("#numberMessage").addClass('text-danger');
        } else {
          $("#numberMessage").removeClass('text-danger');
        }
        $("#numberMessage").html(data.numberMessage);
        $("#cantNumberMessage").val(data.numberMessage);
       // $("#contadorSmsDisponibles").html(data.numberMessage);
      },
      "json"
    );
  },
  dataTables: function() {
    dataTable = $("#dtListUserForClient").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      ajax: {
        url: MODEL, // json datasource
        data: {
          method: "ListUserForClients"
        },
        type: "post",
        error: function() {}
      },
      order: [
        [0, "asc"]
      ]
    });
  },
  addMessageUser: function(id) {
    $("#input_message_number").val("");
    sessionStorage.setItem("id_user", id);
    $("#modalAddMessageUser").modal("show");
  },
  eventos: function() {

    ///////
    $("#btnSaveAddMessageUser").click(function(e) {
      e.preventDefault();
      $("#btnSaveAddMessageUser").hide();
      var cantNumberMessage = $("#cantNumberMessage").val();
      var dt = {
        method: "addMessageUser",
        idUser: sessionStorage.getItem("id_user"),
        inputMessageNumber: $("#input_message_number").val(),
        action: $("input:radio[name=action]:checked").val()
      };

      if (Number.isInteger(parseInt(dt.inputMessageNumber)) && parseInt(dt.inputMessageNumber) > 0) {

        $.post(
          MODEL,
          dt,
          function(data) {
            $("#btnSaveAddMessageUser").show();
            if (data.code == 400) {
              $("#modalAddMessageUser").modal("hide");
              //alert(data.message);
              Swal.fire({
                title: 'No..!',
                text: data.message
              });
              dataTable.draw(false);
              MessageManager.loadNumberMessage();
            }
            if (data.code == 200) {
              $("#modalAddMessageUser").modal("hide");
              // alert(data.message);
              Swal.fire({
                title: 'Ok...!',
                text: data.message
              });
              dataTable.draw(false);
              MessageManager.loadNumberMessage();//para box client
              loadNumberMessageUser();//para box user
              CounterMessage();
            }
          },
          "json"
        );


      } else {
        $("#input_message_number").val("")
        Swal.fire({
          icon: 'danger',
          title: 'ERROR',
          text: 'Must Indicate Only Valid Numbers!',
        });
      }

    });


    $('#consumed_sms').click(function(e) {
        e.preventDefault();
        discounted_sms();
        dataTable.draw(false);
        MessageManager.loadNumberMessage();
    });
    
  }
};

$(function() {
  MessageManager.inicio();
  MessageManager.dataTables();
  MessageManager.eventos();
});