var modules = "my leads";

$(function () {
  leads_ads_list.init();
  leads_ads_list.dt_leads_ads_list();
  leads_ads_list.events();

  $.fn.modal.Constructor.prototype._enforceFocus = function () {};
  $.fn.select2.defaults.set("width", "100%");
});

leads_ads_list = {
  init: function () {
    $("#my_leads_ads_list_date_to").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm/dd/yy",
    });

    $("#my_leads_ads_list_date_from").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm/dd/yy",
    });

    $(".date_us").datepicker({
      dateFormat: "yy/mm/dd",
      appendText: "YY/MM/DD",
      changeMonth: true,
      changeYear: true,
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
    });

    $("#my_leads_ads_list_date_to").change(function () {
      if (
        $("#my_leads_ads_list_date_to").val() != "" &&
        $("#my_leads_ads_list_date_from").val() != ""
      ) {
        createRange =
          $("#my_leads_ads_list_date_from").val() +
          ";" +
          $("#my_leads_ads_list_date_to").val();
        dtLeadsAdsList.columns([8]).search(createRange).draw();
      }
    });

    $("#btn_clear_date_range").click(function () {
      $("#my_leads_ads_list_date_from").val("");
      $("#my_leads_ads_list_date_to").val("");
      dtLeadsAdsList.columns([8]).search("").draw();
    });
  },
  events: function () {},
  forwardSms: function (id) {    
    var lang = localStorage.getItem("settingLang");
    swal({
      title: lang == "es" ? "¿Estas seguro?" : "Are you sure?",
      text:
        lang == "es"
          ? "¡Usted desea reenviar el mensaje!"
          : "You want to forward the message!",
      type: "warning",
      showCancelButton: !0,
      confirmButtonText: lang == "es" ? "Si, hazlo" : "Yes, do it!",
      cancelButtonText: lang == "es" ? "No, cancelar" : "No, cancel!",
      reverseButtons: !0,
    }).then(function (e) {
      if (e.value) {
        preloader('show'); 
          $.post(
            "../model/leads_in_model.php",
            {
              method: "forwardSms",
              id: id,
            },
            function (response) {
              if (response.code == 200) {
                preloader("hide", response.message, "success");
                dtLeadsAdsList.draw(false);
              }
              if (response.code == 206) {
                preloader("hide", 'message '+response.message, "error");
                dtLeadsAdsList.draw(false);
              }
            },
            "json"
          );
      }
    });

  },
  deleteLeads: function (id) {    
    var lang = localStorage.getItem("settingLang");
    swal({
      title: lang == "es" ? "¿Estas seguro?" : "Are you sure?",
      text:
        lang == "es"
          ? "¡Usted desea eliminar el leads!"
          : "You want to delete the leads!",
      type: "warning",
      showCancelButton: !0,
      confirmButtonText: lang == "es" ? "Si, hazlo" : "Yes, do it!",
      cancelButtonText: lang == "es" ? "No, cancelar" : "No, cancel!",
      reverseButtons: !0,
    }).then(function (e) {
      if (e.value) {
        preloader('show'); 
          $.post(
            "../model/leads_in_model.php",
            {
              method: "deleteLeads",
              id: id,
            },
            function (response) {
              if (response.code == 200) {
                preloader("hide", response.message, "success");
                dtLeadsAdsList.draw(false);
              } else {
                preloader("hide", "Error!", "error");
              }
            },
            "json"
          );
      }
    });
  },
  dt_leads_ads_list: function () {
    // Setup - add a text input to each footer cell
    var i = 0;
    var timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;

    $("#dtLeadsAdsList tfoot th").each(function () {
      if (i != 0 && i != 15) {
        var title = $(this).text();
        $(this).html(
          '<input type="text" placeholder="' +
            title +
            '" style="width:100%;" />'
        );
      }
      i++;
    });

    dtLeadsAdsList = $("#dtLeadsAdsList").DataTable({
      processing: true,
      serverSide: true,
      responsive: true,
      // "sDom": "Rlfrtip",
      scrollX: 200,
      scrollCollapse: true,
      lengthMenu: [
        [10, 25, 50, 100, 250, 500, 1000],
        [10, 25, 50, 100, 250, 500, 1000],
      ],
      ajax: {
        url: "../model/leads_in_model.php", // json datasource
        data: {
          method: "myLeadsAdsList",
          timezone: timezone,
        },
        type: "post", // method  , by default get
        error: function () {
          // error handling
        },
      },
      columnDefs: [
        {
          targets: [0],
          orderable: false,
        },
        {
          targets: [1],
          orderable: true,
        },
      ],
      rowCallback: function (row, data, index) {
        if (data[17] == 1) {
          //aldrha
          // var $color = hexToRgbA(data[16]);
          $(row).css("background-color", data[16]);
        }
      },
      order: [[0, "DESC"]],
      drawCallback: function (response) {
        response.json.id_role == 1
          ? dtLeadsAdsList.columns([9]).visible(true, true)
          : dtLeadsAdsList.columns([9]).visible(false, false);
        console.log(response.json.id_role);
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        } else {
          arrayLeadsList = [];
          $("input[name=leads_ads_list_check_leads]").each(function (index) {
            arrayLeadsList.push($(this).val());
          });
        }
      },
    });
    // Apply the search
    dtLeadsAdsList.columns().every(function () {
      var that = this;
      $("input", this.footer()).on("keyup change", function () {
        if (that.search() !== this.value) {
          that.search(this.value).draw();
        }
      });
    });
    $('input.toggle-vis').on('change', function(e) {
			e.preventDefault();
			var column = dtLeadsAdsList.column($(this).attr('data-column'));
			column.visible(!column.visible());
		});
  },
  clear: function () {},
};
