$(function () {
  // dynamic grid
  leads_export.dt_leads_export();
});

leads_export = {
  init: function () {},
  dt_leads_export: function () {
    var i = 0;
    $("#leads_ads_export_table tfoot th").each(function () {
      if (i != 15 && i != 16) {
        var title = $(this).text();
        $(this).html(
          '<input type="text" placeholder="' +
            title +
            '" style="width:100%;" />'
        );
      }
      i++;
    });
    var $dt_tableExport = $("#leads_ads_export_table"),
      $dt_buttons = $dt_tableExport.prev(".dt_colVis_buttons");
    $("#title_report").val("Leads Exports");
    //console.log($('#title_report').val())
    var dataTable = $("#leads_ads_export_table").DataTable({
      processing: true,
      serverSide: true,
      lengthMenu: [
        [10, 100, 1000, 2000, 5000, 10000],
        [10, 100, 1000, 2000, 5000, 10000],
      ],
      responsive: true,
      deferRender: true,
      // "sDom": "Rlfrtip",
      scrollX: 200,
      bInfo: true,
      searching: true,
      ajax: {
        url: "../model/ctLeadsAds.php", // json datasource
        data: {
          method: "leadsAdsListExport",
        },
        type: "post", // method  , by default get
        error: function () {
          // error handling
        },
      },
      order: [[1, "asc"]],
      buttons: [
        {
          extend: "copyHtml5",
          footer: true,
          text: '<i class="la la-files-o"></i> Copy',
          titleAttr: "Copy",
          exportOptions: {
            columns: [0, 1, 2, 4, 5, 5, 7, 14],
          },
        },
        {
          extend: "print",
          footer: true,
          text: '<i class="la la-print"></i> Print',
          titleAttr: "Print",
          exportOptions: {
            columns: [0, 1, 2, 4, 5, 7, 14],
          },
          title: function () {
            return $("#title_report").val();
          },
        },
        {
          extend: "excelHtml5",
          footer: true,
          text: '<i class="la la-file-excel-o"></i> XLSX',
          titleAttr: "",
          exportOptions: {
            columns: [0, 1, 2, 4, 5, 7, 14],
          },
          title: function () {
            return $("#title_report").val();
          },
        },
        {
          extend: "csvHtml5",
          footer: true,
          text: '<i class="la la-file-text-o"></i> CSV',
          titleAttr: "CSV",
          exportOptions: {
            columns: [0, 1, 2, 4, 5, 7, 14],
          },
          title: function () {
            return $("#title_report").val();
          },
        },
      ],
      initComplete: function () {
        dataTable.buttons().container().appendTo($dt_buttons);
      },
    });
    dataTable.columns().every(function () {
      var that = this;
      $("input", this.footer()).on("keyup change", function () {
        if (that.search() !== this.value) {
          that.search(this.value).draw();
        }
      });
    });
  },
};
