"use strict";
var $formValidate = $('#frmAddLandingPage');
var dataTable = '';

var landing_page_list = {
    init: function() {
       
        $("#frmAddLandingPage").validate({
            rules: {
                "add_name": {
                    required: !0
                },
                "input-file-a": {
                    required: !0
                },
                "add_cost": {
                    required: !0
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });
    },
    list: function() {
        dataTable = $('#dtLandingPageList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/ctLeadsAds.php", // json datasource
                data: {method: "dtLandingPageList"},
                type: "post", // method  , by default get
                error: function() {}
            },
            "columnDefs": [{
                targets: [-1],
                orderable: false
            }],
            "order": [
                [0, "asc"]
            ]
        });
    },
    buy_landing_page: function(id){
        swal({
            title: "Are you sure you buy this landing page??",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, Buy it!"
        }).then(function(e) {
            if (e.dismiss === "cancel") {
                swal("Cancelled", "Data is safe :)", "error");
            }
            if (e.value) {
                var parametros = {
                    "method": "buyLandingPage",
                    "id": id
                };
                $.post('../model/ctLeadsAds.php', parametros, function(data) {
                    if (data.code == 200) {
                        swal({type: "success",title: data.salida});  
                        dataTable.draw();
                    }
                    
                   
                }, 'json');
            }
        });
    },
    events:function(){
        landing_page_list.clear();
        $('#landing_page_button_add').click(function() {

            if ($formValidate.valid()) {
                var status = 1,
                    image = '';
                if ($('#add_status').is(':checked')) {
                    status = 1;
                } else {
                    status = 2;
                }

                if ($('.file-preview-frame > img').attr('src') === undefined && $('#landing_page_preview_image').attr('src') != '') {
                    image = $('#landing_page_preview_image').attr('src');
                } else {
                    image = $('.file-preview-frame > img').attr('src');
                }
                preloader('show');
                $.post("../model/ctLeadsAds.php", {
                    "method": 'addLandingPages',
                    "id": $('#id_landing_page').val() == '' ? 0 : $('#id_landing_page').val(),
                    "name": $('#add_name').val(),
                    "cost": $('#add_cost').val(),
                    "status": status,
                    "image": image
                }, function(data) {
                    if (data.mss == '1') {
                        console.log(data)
                        $("#modal_add_lading_page").modal('hide');
                        preloader('hide', data.salida, 'success');
                        dataTable.draw(false)
                    } else {
                        preloader('hide', data.salida, 'error');
                        //notification(data.salida, 'danger');
                        console.log(data.mss);
                    }
                    preloader('hide');
                }, "json").fail(function(error) {
                    console.log(error.responseJSON)
                    preloader('hide');
                });
            }
        });
    },
    view_modal: function(id) {
        landing_page_list.clear()
        $('#id_landing_page').val(id);
        var checked = $("#add_status").is(':checked');
        preloader('show');
        $.post("../model/ctLeadsAds.php", {
                "method": 'findLandingPageEdit',
                "id": id
            },
            function(data) {
                preloader('hide');
                $('#add_name').val(data.name);
                $('#add_cost').val(data.cost);
                $('#landing_page_preview_image').attr('src', data.image);


                if ((data.status == 1 && checked == false) || (data.status == 2 && checked == true)) {
                    $('#add_status').click();
                }
                $('#modal_add_lading_page').modal('show');
           }, "json").fail(function(error) {
                console.log(error.responseJSON)
                preloader('hide');
            });
           
    },
    status: function(id) {
        var parametros = {
            "method": "changeStatusLandingPage",
            "id": id
        }
        preloader('show');
        $.post('../model/ctLeadsAds.php', parametros, function(data) {
            if (data.res === 'yes') {
                preloader('hide', 'Status Updated...!', 'success');
                //notification('Data Updated', 'success');
                dataTable.draw();
            }
            preloader('hide');
        }, 'json');
    },

    clear: function(){
        $("#msg_alert_1").addClass("m--hide").show(), mUtil.scrollTop();
        $('#add_name').val('');
        $('#add_cost').val('');
        $('#input-file-a').val('');
        $formValidate.validate().resetForm();
    }

};
function getIdLandingPage(id_landing_page) {
    var method = 'findLandingPages';
    preloader('show');
    $.post("../model/ctLeadsAds.php", {
                "method": method,
                "id": id_landing_page
            },
            function(data) {
                preloader('hide');
                if (data.mss == '1') {
                    $('#landing_pages_image').attr("src", data.image);
                } else {
                    console.log(data.mss);
                }
            }, "json")
        .fail(
            function(error) {
                console.log(error.responseJSON)

            }
        );
}
$(function() {
    landing_page_list.init();
    landing_page_list.list();
    landing_page_list.events();
});