"use strict";
var $formValidate = $('#add_leads_form');
var dataTable = '';

$(function() {
    landing_page.init();
    landing_page.events();
});

var landing_page = {
    init: function() {
        $("#add_leads_form").validate({
            rules: {
                add_leads_input_full_name: {
                    required: !0
                },
                add_leads_input_phone: {
                    required: !0
                },
                add_leads_input_country: {
                    required: !0
                },
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });
        // Get the modal
        var modal = document.getElementById('myModal');

        // Get the image and insert it inside the modal - use its "alt" text as a caption
        var img = document.getElementById('myImg');
        var modalImg = document.getElementById("img01");
        var captionText = document.getElementById("caption");
     
        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
          modal.style.display = "none";
        } 
    },
    events:function(){
        $('#btnSaveLeadsAds').click(function() {             
            var leads_email = $('#add_leads_input_email');
            var leads_phone = $('#add_leads_input_phone');
            $('#add_leads_input_phone').removeAttr('required');
            if (leads_phone.val() == '' && leads_email.val() == '') {
                leads_phone.attr('required', 'required');
            }

            if ($formValidate.valid()) {                 
                $.post("../model/landing_page_model.php", {
                    "method": 'addLeadsAdsLP',
                    "id": $('#id_lead').val() == '' ? 0 : $('#id_lead').val(),
                    "id_campaign_leads_ads": $('#id_campaign_leads_ads').val(),
                    "id_client": $('#id_client').val(),
                    "id_user_crm": $('#id_user_crm').val(),
                    "full_name": $('#add_leads_input_full_name').val(),
                    "phone": $('#add_leads_input_phone').val(),
                    "country": $('#add_leads_input_country').val(),
                    "email": $('#add_leads_input_email').val(),
                    "city": $('#add_leads_input_city').val(),
                    "zip": $('#add_leads_input_zip').val(),
                    "state": $('#add_state').val(),
                    "source": $('#add_source').val(),
                    "note": $('#add_leads_textarea_note').val(),
                    "updated": getFecha()
                }, function(data) {                    
                    if (data.mss == '1') {
                         $('#myModal').show();
                        landing_page.clear();
                    } else {
                        swal(data.salida,'','error')
                    }
                }, "json").fail(function(error) {
                    swal('FAIL', '', 'error');
                    console.log(error.responseJSON);
                });
            }
        });
    },
    clear:function(){
        $('#add_leads_input_full_name').val('');
        $('#add_leads_input_phone').val('');
        $('#add_leads_input_country').val('');
        $('#add_leads_input_email').val('');
        $('#add_leads_input_city').val('');
        $('#add_leads_input_zip').val('');
        $('#add_state').val('');
        $('#add_leads_textarea_note').val('');
        $formValidate.validate().resetForm();
    }

};
function getHora() {
    var h = new Date();
    var hora = moment(h).format('HH:mm:ss');
    return hora
}

function getFecha() {
    var f = new Date();
    var fecha = moment(f).format('YYYY-MM-DD HH:mm:ss');
    return fecha
}


function convertUTCDateToLocalDate(date) {
    var newDate = new Date(date.getTime() + date.getTimezoneOffset() * 60 * 1000);
    var offset = date.getTimezoneOffset() / 60;
    var hours = date.getHours();
    newDate.setHours(hours - offset);

    var year = newDate.getFullYear(); //el año se puede quitar de este ejemplo
    var mes = newDate.getMonth(); //pero ya que estamos lo ponemos completo
    var dia = newDate.getDate();
    var hora = newDate.getHours();
    var minutos = newDate.getMinutes();
    var segundos = newDate.getSeconds();
    //aquí se hace lo 'importante'
    if (mes < 10) {
        mes = '0' + (mes + 1)
    }
    if (dia < 10) {
        dia = '0' + dia
    }
    if (hora < 10) {
        hora = '0' + hora
    }
    if (minutos < 10) {
        minutos = '0' + minutos
    }
    if (segundos < 10) {
        segundos = '0' + segundos
    }

    return year + '-' + mes + '-' + dia + ' ' + hora + ':' + minutos + ':' + segundos;
}

function getClockTime() {
    var now = new Date();
    var hour = now.getHours();
    var minute = now.getMinutes();
    var second = now.getSeconds();
    var ap = "AM";
    if (hour > 11) {
        ap = "PM";
    }
    if (hour > 12) {
        hour = hour - 12;
    }
    if (hour == 0) {
        hour = 12;
    }
    if (hour < 10) {
        hour = "0" + hour;
    }
    if (minute < 10) {
        minute = "0" + minute;
    }
    if (second < 10) {
        second = "0" + second;
    }
    var timeString = hour + ':' + minute + " " + ap;
    return timeString;
}

