"use strict";
var $formAddValidate = $('#add_group_form');
var $dt_list = '',
    $select_group = '',
    $selectUser = '',
    dtgroupLis = '',
    dt_list = '',
    dt_group = '';

var group_add = {
    init: function() {
        $("#add_group_form").validate({
            rules: {
                group_name: {
                    required: !0
                },
                select_group: {
                    required: !0
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });
        group_add.cargaSelect();
    },

    dt_group_add_lis: function() {

        dtgroupLis = $('#dtgroupLis').DataTable({
            processing: true,
            serverSide: true,
            "responsive": !0,
            ajax: {
                url: "../model/ctGroupAdd.php", // json datasource
                data: {
                    method: "groupAddList"
                },
                type: "post", // method  , by default get
                error: function() { // error handling

                }
            },
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            },
            columnDefs: [{
                targets: [1],
                orderable: false
            }],
            columnDefs: [{
                sClass: "dpass",
                aTargets: [4]
            }]
        });

    },

    dt_group_list: function() {
        dt_group = $('#dt_group').DataTable({
            processing: true,
            serverSide: true,
            "responsive": !0,
            ajax: {
                url: "../model/ctGroupAdd.php", // json datasource
                data: {
                    method: "findGroup"
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            columnDefs: [{
                sClass: "dpass",
                aTargets: [0, 2]
            }],
            order: [
                [2, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });

    },

    dt_list_g: function(id) {
        //alert(id)
        dt_list = $('#dt_list').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/ctGroupAdd.php", // json datasource
                data: {
                    method: "dt_list",
                    "id": id
                },
                type: "post", // method  , by default get
                error: function() { // error handling

                }
            },
            'columnDefs': [{
                "sClass": "dpass",
                "aTargets": [0, 4]
            }],
            "order": [
                [2, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });

    },

    events: function() {
        $('#select_group_add').change(function() {});
        var $idLeads = $('#leads_ads_list_id_leads');

        // $('.iCheck-helper').click(function () {
        //     var cells = dtgroupLis.cells( ).nodes();
        //     $(cells).find(':checkbox').prop('checked', $('#leads_ads_list_check_all').is(':checked'));
        // });
        $("#leads_ads_list_check_all").on("change", ".m-group-checkable", function() {
            $('input:checkbox').not(this).prop('checked', this.checked);
        });

        $('#assign_group').click(function() {
            var method = 'assignGroup';
            var id_user_crm = '';

            preloader('show');
            $("input[name=leads_ads_list_check_leads]").each(function(index) {
                if ($(this).is(':checked')) {
                    id_user_crm += $(this).val() + ',';
                }
            });

            $.post("../model/ctGroupAdd.php", {
                        "method": method,
                        "id_user_crm": id_user_crm.slice(0, -1),
                        "id_group": $('#select_group_add').val()
                    },
                    function(data) {
                    	if (data.code == '440'){
							loginTimeout(data.message);
							return;
						}
                        if (data.code == '200') {
                            preloader('hide', data.message, 'success');
                            dtgroupLis.draw();
                        } else {
                            preloader('hide', data.message, 'error');
                            console.log(data.message);
                        }
                        preloader('hide');
                    }, "json")
                .fail(
                    function(error) {
                        console.log(error.responseJSON);
                        preloader('hide');
                    }
                );

        });
        $('#btnSaveGroup').click(function() {

            if ($formAddValidate.valid()) {
                var method = 'addGroup';
                preloader('show');
                $.post("../model/ctGroupAdd.php", {
                            "method": method,
                            "id": $('#id_group').val(),
                            "name": $('#group_name').val()
                        },
                        function(data) {
                        	if (data.code == '440'){
			                    loginTimeout(data.message);
			                    return;
			                }
                            if (data.code == '200') {
                                preloader('hide', data.message, 'success');
                                dt_group.draw();
                                dtgroupLis.draw();
                                group_add.cargaSelect();
                                group_add.clear();
                            } else {
                                preloader('hide', data.message, 'error');
                            }

                        }, "json")
                    .fail(
                        function(error) {
                            console.log(error.responseJSON);
                            preloader('hide');
                        }
                    );
            }

        });
        $('#dtgroupLis tbody').on('click', '.btnDelete2', function() {
            var data = dtgroupLis.row($(this).parents('tr')).data();
            var id = data[4];
            swal({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                type: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete it!"
            }).then(function(e) {
                if (e.dismiss === "cancel") {
                    swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {
                    var parametros = {
                        "method": "deteleGroupDetaill",
                        "id": id
                    };
                    //console.log(parametros)
                    preloader('show');
                    $.post('../model/ctGroupAdd.php', parametros, function() {
                        dtgroupLis.draw();
                        preloader('hide', 'Your Record Has Been Deleted...!', 'success');

                    });

                }

            });
        });
        $('#dt_group tbody').on('click', '.btnEditar', function() {
            var data = dt_group.row($(this).parents('tr')).data();
            var group_name = data[1];
            var id_group = data[0];
            group_add.cargaSelect();
            $('#id_group').val(id_group);
            $('#group_name').val(group_name);
            $('#id_group').val(id_group);
            $('#select_group').val(data[2]);

        });
        $('#dt_group tbody').on('click', '.btnDelete', function() {
            var data = dt_group.row($(this).parents('tr')).data();
            var id = data[0];
            swal({
                title: "Are you sure you want to eliminate this group ?",
                text: "Are you really sure to eliminate this group? There are people who could belong this group...!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, delete it!"
            }).then(function(e) {
                if (e.dismiss === "cancel") {
                    swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {
                    var parametros = {
                        "method": "deteleGroup",
                        "id": id
                    };
                    console.log(parametros)
                    preloader('show');
                    $.post('../model/ctGroupAdd.php', parametros, function(data) {
                    	if (data.code == '440'){
		                    loginTimeout(data.message);
		                    return;
		                }
                        group_add.cargaSelect();
                        if (data.code == '200') {
                            dt_group.draw();
                            dtgroupLis.draw();
                            dt_list.draw();
                            preloader('hide', 'Your Record Has Been Deleted....!', 'success');
                        }
                    },'json');
                }
            });
        });
        $('#dt_group tbody').on('click', '.btnView', function() {
            if ($.fn.DataTable.isDataTable("#dt_list")) {
                $('#dt_list').DataTable().clear().destroy();
            }
            var data = dt_group.row($(this).parents('tr')).data();
            var id = data[0];
            $('#id').val(id);
            $("#group_detaill").modal('show');
            group_add.dt_list_g(id);
        });
        $('#dt_list tbody').on('click', '.btnDelete', function() {
            var data = dt_list.row($(this).parents('tr')).data();
            var id = data[4];

            swal({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, delete it!"
            }).then(function(e) {
                if (e.dismiss === "cancel") {
                    swal("Cancelled", "Data is safe :)", "error");
                }
                if (e.value) {
                    var parametros = {
                        "method": "deteleGroupDetaill",
                        "id": id
                    };
                    //console.log(parametros)
                    preloader('show');
                    $.post('../model/ctGroupAdd.php', parametros, function() {
                        group_add.cargaSelect();
                        dtgroupLis.draw();
                        dt_list.draw();
                        preloader('hide', 'Your Record Has Been Deleted...!', 'success');

                    });

                }
            });
        });
    },
    cargaSelect: function() {
        $('#select_group_add').html('');
        preloader('show');
        $.post('../model/ctGroupAdd.php', {
            method: 'groupxid'
        }, function(data) {
            //$('#select_group_add').html(data);
            preloader('hide');
            if (data.res === 'not') {
                $('#assign_group').hide();
                $('#select_group_add').attr('disabled', true);
            }
            if (data.res === 'yes') {
                $('#assign_group').show();
                $('#select_group_add').removeAttr('disabled');
                $('#select_group_add').html(data.datos);
            }
        }, 'json');

    },
    show_modal: function(type) {
        var phone = $('#leads_ads_list_leads_phone');
        group_add.clear();
        if (type == 1) {
            $('#id_leads_history_sms').val(0);
            $('#leads_history_sms_modal_phone').val(phone.val());
            $("#leads_history_sms").modal('show');
        } else if (type == 2) {
            $('#id_leads_history_notes').val(0);
            $("#leads_ads_list_modal_add_notes").modal('show');
        } else if (type == 3) {
            $('#open_app_call').attr('href', 'tel://' + phone.val())
            document.getElementById("open_app_call").click()
            $('#id_leads_history_call').val(0);
            $('#leads_history_call_modal_input_phone').val(phone.val());
            $("#leads_ads_list_modal_call_maked").modal('show');
        }
    },
    close_modal: function() {
        $("#leads_history_sms").modal('hide');
    },
    clear: function() {
        $("#group_name").val('');
        $("#select_group").parent().removeClass("required");
        $('#select_group_add').val('');
        $('#leads_history_sms_modal_phone').val('');
        $('#leads_history_sms_modal_subject').val('');
        $('#leads_history_sms_modal_response').val('');
        $formAddValidate.validate().resetForm();
    }
};
jQuery(document).ready(function() {
    group_add.init();
    group_add.dt_group_add_lis();
    group_add.dt_group_list();
    group_add.dt_list_g();
    group_add.events();
    group_add.clear();
});