var $formFlow = $('#modal_add_flow_from'),
$formStage = $('#modal_add_stage_from'),
dataTable = '';
var select_role_flow = ''; 

$(function() {

    flow_list.init();
    flow_list.dt_flow_list();
    flow_list.events();

});

flow_list = {
    init: function() {

        $("#flow_modal_stage").on('show.bs.modal', function(){
            $("#flow_modal_select_activities").select2({
                placeholder:"Add a tag",
                tags:!0,
                maximumSelectionLength: 1
            });
        });
        $("#modal_add_flow_from").validate({
            rules: {
                modal_add_flow_name: {
                    required: !0
                },
                modal_add_flow_service: {
                    required: !0
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) { }
        });

        $("#modal_add_stage_from").validate({
            rules: {
                modal_add_stage_name: {
                    required: !0
                },
                modal_add_stage_probability: {
                    required: !0
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_2").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) { }
        });

        //SORTABLE
        $( ".row_position" ).sortable({
            delay: 150,
            stop: function() {
                var selectedData = new Array();
                $('.row_position>tr').each(function() {
                    selectedData.push($(this).attr("id"));
                });
                flow_list.changeOrder(selectedData);
            }
        });

        //select multiple para los activities
        $("#modal_add_stage_activities").select2({
            placeholder: "Add a activities", tags: !0
        });

        select_role_flow = $("#select_role_flow").select2({
			placeholder: "Select related..",
			minimumResultsForSearch: 1 / 0
		});
    },

    dt_flow_list: function() {
        dataTable = $('#dtFlowList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "ajax": {
                url: "../model/ctOpportunities.php", // json datasource
                data: {
                    method: "dtFlowList"
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            "order": [
            [1, "asc"]
            ],
            drawCallback: function(response) {
                if (response.code == '440'){
                    loginTimeout(response.message);
                    return;
                }else{
                    dataTable.columns( [ 0] ).visible( false, false );
                }
            }
        });
    },
    events: function() {
        var isMigrate = $('#modal_add_stage_migration'),
        idClient = $('#modal_add_stage_client'),
        idServices = $('#modal_add_stage_service');

        $('#modal_add_flow_service').change(function(){
            var flow_service = $('#modal_add_flow_service').val();
            $.post("../model/ctOpportunities.php", {flow_service: flow_service, method:'checkFlow'}, function(data){
            //console.log(data)
                if (data.code == '440'){
                    loginTimeout(data.message);
                    return;
                }
                else if(data.code == '200'){
                    confirmOops('This service has already been assigned to a flow');
                    $('#modal_add_flow_service').val('');
                }

            }, "json");
        });

        $("#modal_add_flow_button_add").click(function() {
            if ($formFlow.valid()) {
                //preloader('show');
                var status = 1;
                status = ($('#modal_add_flow_status').is(':checked')) ? '1' : '0';

                var roles = '';
                $('select[name^="select_role_flow"]').each(function() {
					roles += $(this).val() + ',';
				});
                 

                $.post("../model/ctOpportunities.php", {
                    "method": 'editFlow',
                    "id": $('#modal_add_flow_id').val() == '0' ? 0 : $('#modal_add_flow_id').val(),
                    "name": $('#modal_add_flow_name').val(),
                    "id_services": $('#modal_add_flow_service').val(),
                    "status": status,
                    "roles":roles
                }, function(data) {
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }
                    else if(data.code == '200'){
                        preloader('hide', data.salida, 'success');
                        if ($('#modal_add_flow_id').val() == '0' || $('#modal_add_flow_id').val() == '') {
                            $('#modal_add_flow_id').val(data.id);
                            $('#modal_add_flow_add_stages').removeClass('disabled');
                            //$formFlow.validate().resetForm();
                        }
                        dataTable.draw(false);
                    }else {
                        preloader('hide', data.salida, 'error');
                        // console.log(data.mss);
                    }
                    preloader('hide', data.salida);
                }, "json").fail(function(error) {
                    preloader('hide', 'FAIL', 'danger');
                    console.log(error.responseJSON)
                });
            }
        });
        $("#modal_add_flow_stage_add").click(function() {
            if ($formStage.valid()) {
                var activities = '',
                success_sale = '',
                migrate = '',
                success_sale = '';
                $.each($('#modal_add_stage_activities').val(), function(index, value) {
                    activities += value + ',';
                });
                preloader('show');
                if($("#modal_add_stage_success_sale").is(':checked')){
                    success_sale = 1;
                }else{
                    success_sale = 0;
                }
                if (isMigrate.is(':checked')) {
                    migrate = 1;
                } else {
                    migrate = 0;
                }
                $.post("../model/ctOpportunities.php", {
                    "method": 'editFlowStage',
                    "id": ($('#modal_add_stage_id_flow_stages').val() == '0' || $('#modal_add_stage_id_flow_stages').val() == '')? 0 : $('#modal_add_stage_id_flow_stages').val(),
                    "id_flow": $('#modal_add_flow_id').val(),
                    "name": $('#modal_add_stage_name').val(),
                    "probability": $('#modal_add_stage_probability').val(),
                    "success_sale": success_sale,
                    "migrate": migrate,
                    "id_client": idClient.val(),
                    "id_services": $('#modal_add_stage_service').val(),
                    "id_campaign_leads_ads": $('#modal_add_stage_campaign').val(),
                    "id_user_crm": $('#modal_add_stage_supervisor').val(),
                    "activities": activities.slice(0, -1)
                }, function(data) {
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }
                    else if(data.code == '200'){
                        preloader('hide', data.salida, 'success');
                        //$(location).attr('href', 'flow_edit.php?idFlow=' + $('#modal_add_flow_id').val());
                        flow_list.show_flow($('#modal_add_flow_id').val());
                    } else {
                        preloader('hide', data.salida, 'error');
                        console.log(data.mss);
                    }
                    preloader('hide');
                }, "json").fail(function(error) {
                    preloader('hide', 'FAIL', 'danger');
                    console.log(error.responseJSON)
                });
            }
        });

        $("#flow_button_delete").click(function() {
            preloader('show');
            $.post("../model/ctOpportunities.php", {
                "method": 'deleteFlow',
                "id": $('#modal_add_flow_id').val()
            }, function(data) {
                if (data.code == '440'){
                    loginTimeout(data.message);
                    return;
                }
                else if(data.code == '200'){
                    preloader('hide', data.salida, 'success');
                    flow_list.dt_flow_list();
                } else {
                    preloader('hide', data.salida, 'error');
                    console.log(data.mss);
                }
                preloader('hide');
            }, "json").fail(function(error) {
                preloader('hide', 'FAIL', 'danger');
                console.log(error.responseJSON)
            });
        });

        idClient.change(function() {
            console.log('idClient.change')
            $('#modal_add_stage_service').html('');
            $('#modal_add_stage_supervisor').html('');
            $('#modal_add_stage_campaign').html('');
            if(idClient.val() != ''){
             $.post("../model/ctOpportunities.php",{
                method:'findServices&SupervisorByClient',
                id_client: idClient.val()
            },
            function(response){
                if (response.code == '440'){
                    loginTimeout(data.message);
                    return;
                }
                else if(response.code == '200'){
                    var services_detail = response.services;
                    var supervisor_detail = response.supervisor;

                    var list = $('#modal_add_stage_service');
                    list.append(new Option('Select services', ''));
                    $.each(services_detail, function(){
                        list.append(new Option(this.name, this.id));
                    });

                    list = $('#modal_add_stage_supervisor');
                    $.each(supervisor_detail, function(){
                        list.append(new Option(this.name, this.id));
                    });
                    preloader('hide');
                }
            },"json");
         }
     });

        idServices.change(function() {
            console.log('idServices.change')
            $('#modal_add_stage_campaign').html('');
            if(idClient.val() != ''){
             $.post("../model/ctOpportunities.php",{
                method:'findCampaignByServices',
                id_services: idServices.val()
            },
            function(response){
                if (response.code == '440'){
                    loginTimeout(data.message);
                    return;
                }
                else if(response.code == '200'){
                    var campaign_detail = response.campaign;

                    var list = $('#modal_add_stage_campaign');
                    $.each(campaign_detail, function(){
                        list.append(new Option(this.name, this.id));
                    });
                    preloader('hide');
                }
            },"json");
         }
     });

    },
    show_flow: function(id){
        flow_list.clear_flow();
        var checked = $('#modal_add_stage_migration').is(':checked');
        $.post("../model/ctOpportunities.php", {
            "method": 'findFlowById',
            "id": id
        }, function(data) {
            if (data.code == '440'){
                loginTimeout(data.message);
                return;
            }
            else if (data.code === '200') {
                $('#modal_add_flow_add_stages').removeClass('disabled');
                var flow_detail = data.flow[0];
                //console.log(flow_detail.name);
                $('#modal_add_flow_id').val(id);
                $('#modal_add_flow_name').val(flow_detail.name);
                $('#modal_add_flow_service').val(flow_detail.id_services);
                if ((flow_detail.status == 1 && checked == false) || (flow_detail.status == 2 && checked == true)) {
                    $('#modal_add_flow_status').attr('checked',true);
                }

                $('#select_role_flow').val(null).trigger("change");
                if (flow_detail.roles != null) {
                    var roles = flow_detail.roles.split(",");
                    $('#select_role_flow').val(roles).trigger("change");
                }                
                 
                $("#tbody_flow").html("");
                //console.log('data.salida: ' + flow_detail);
                if (data.salida == null) {
                    var tr = '<tr id='+'><td class="uk-text-bold">'+'</td><td>'+'</td><td><a  class="m-portlet__nav-link btn m-btn m-btn--hover-warning m-btn--icon m-btn--icon-only m-btn--pill" data-container="body" data-toggle="modal" data-target="#modal_add_stage" data-placement="top" title="Edit" onclick="flow_list.show_modal_flow_stages('+')"><i class="la la-edit"></i></a><a class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" data-container="body" data-toggle="m-tooltip" data-placement="top" title="Delete " onclick="flow_list.deleteStage('+')"><i class="la la-remove"></i></a></td></tr>';
                    $("#tbody_flow").append(tr)
                } else {
                    for(var i=0; i<data.salida.length; i++){
                        var tr = '<tr id='+data.salida[i].id+'><td class="uk-text-bold">'+data.salida[i].name+'</td><td>'+data.salida[i].probability+'</td><td><a  class="m-portlet__nav-link btn m-btn m-btn--hover-warning m-btn--icon m-btn--icon-only m-btn--pill" data-container="body" data-toggle="modal" data-target="#modal_add_stage" data-placement="top" title="Edit" onclick="flow_list.show_modal_flow_stages('+data.salida[i].id+')"><i class="la la-edit"></i></a><a class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" data-container="body" data-toggle="m-tooltip" data-placement="top" title="Delete " onclick="flow_list.deleteStage('+data.salida[i].id+')"><i class="la la-remove"></i></a></td></tr>';
                        $("#tbody_flow").append(tr)
                    }
                }

                $("#modal_add_flow").modal('show');
                preloader('hide');
            }
        }, "json").fail(function(error) {
            console.log(error.responseJSON)
        });
    },
    show_stage: function(id){

    },
    show_migrate: function(){
     var checkValue = $('#modal_add_stage_migration').is(':checked');
     if(checkValue === true){
        $('.migration_hidden').toggle('show');
    }
    else{
        $('.migration_hidden').toggle('hide');
    }
},

clear_flow: function() {
    $("#tbody_flow").html("");
    $("#modal_add_stage_id_flow_stages").val('');
    $("#modal_add_flow_id").val('');
    $('#modal_add_flow_name').val('');
    $('#modal_add_flow_service').val('');
    $('#modal_add_flow_add_stages').addClass('disabled');
    $formFlow.validate().resetForm();

},

clear_stage: function() {

    $('#modal_add_stage_name').val('');
    $('#modal_add_stage_probability').val('');
    $('#modal_add_stage_activities').val('');

    if ($("#modal_add_stage_success_sale").is(':checked')){
        $('#modal_add_stage_success_sale').attr('checked',false);
    }
    if ($("#modal_add_stage_migration").is(':checked')){
        $('#modal_add_stage_migration').attr('checked',false);
    }
    $('.migration_hidden').hide();
    $('#modal_add_stage_client').val('');
    $('#modal_add_stage_service').html('');
    $('#modal_add_stage_campaign').html('');
    $('#modal_add_stage_supervisor').html('');
    
    $('#select_role_flow').val(null).trigger("change");

    $formStage.validate().resetForm();

},
show_modal_flow_stages: function(id_flow_stages) {
    $('#modal_add_stage_id_flow_stages').val(id_flow_stages)
    flow_list.clear_stage()
    $.post("../model/ctOpportunities.php", {
        "method": 'findFlowStages',
        "id": id_flow_stages
    }, function(data) {
        console.log('data: '+data)
        var activities = '';
        $('#modal_add_stage_name').val(data.name);
        $('#modal_add_stage_probability').val(data.probability);
        if(data.success_sale == 1){
               //$('#flow_modal_input_success_sale').iCheck('check');
           }else{
               //$('#flow_modal_input_success_sale').iCheck('uncheck');
           }
           if (data.activities !== null) {
            activities = data.activities.split(',');
        }

        $('#modal_add_stage_activities').val(activities);
        $('#modal_add_stage_activities').trigger('change');
        if (data.migrate == 1) {
            $('.migration_hidden').toggle('show');
            $('#modal_add_stage_migration').prop('checked', true);
            $('#modal_add_stage_client').val(data.id_client);
            $('#modal_add_stage_client').trigger('change');
            setTimeout(function(){
                $('#modal_add_stage_service').val(data.id_services);
                $('#modal_add_stage_service').trigger('change');
            },1000);
            setTimeout(function(){
                $('#modal_add_stage_service').val(data.id_services);
                $('#modal_add_stage_service').trigger('change');
                $('#modal_add_stage_campaign').val(data.id_campaign_leads_ads);
                $('#modal_add_stage_campaign').trigger('change');
                $('#modal_add_stage_supervisor').val(data.id_user_crm);
            },1200);
        }


    }, "json").fail(function(error) {

        confirm(error);
        console.log('error: '+error.responseJSON)
    });
    $('#flow_modal_stage').modal('show');
        //$("#flow_modal_stage").show();
    },
    deleteStage: function (id) {
        swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!'
        }).then(function(result) {
            if (result.value) {
                $.post('../model/ctOpportunities.php', {method: 'deleteStage', id: id}, function (data){
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }
                    else if (data.code === '200') {
                        flow_list.show_flow($('#modal_add_flow_id').val());
                        swal('Stage Deleted!','success');
                    }
                }, 'json');
            }});
    },

    deleteFlow: function (id) {
        swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!'
        }).then(function(result) {
            if (result.value) {
                $.post('../model/ctOpportunities.php', {method: 'deleteFlow', id: id}, function (data){
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }
                    else if (data.code === '200') {
                        swal('Flow Deleted!','success');
                        dataTable.draw();
                    }
                }, 'json');
            }});
    },

    changeOrder: function (data){
        var parametros = {
            "method": "orderStage",
            "position": data
        };
        $.ajax({
            data: parametros,
            url:"../model/ctOpportunities.php",
            type:'post',
            success:function(){
                preloader('hide','POSITON ORDER UPDATE SUCCESSFULLY','success');
            }
        })
    }
};