'use strict';

var formValidateFileType = $('#documents_type_form'),
	dataTable = '',
	image = '',
	$selectRelated = '';

var myDropzone = new Dropzone("div#my-dropzone", {
	paramName: "file",
	maxFiles: '1',
	maxFilesize: 5,
	timeout: 200,
	addRemoveLinks: !0,
	accept: function(e, o) {

		// myDropzone.destroy()
	}



});

var list_documents_type = {
	init: () => {

		formValidateFileType.validate({
			rules: {
				documents_type_list_input_name: {
					required: true
				},
				documents_type_list_textarea_description: {
					required: true
				}
			}
		});

		$selectRelated = $("#select_related").select2({
			placeholder: "Select related..",
			minimumResultsForSearch: 1 / 0
		});

	},
	event: () => {

		$('#my-dropzone').click(function() {
			$('.dz-image').html('');
		});

		$('#btnNewDocument').click(function() {
			list_documents_type.cleanForm();
			$('#documents_type').modal('show');
		});

		$('#btnNewDocumentType').click(function() {

			if (formValidateFileType.valid()) {
				var id = $('#documents_type_input_id').val();
				var image = $('.dz-image img').attr('src');
				var related = '';

				$('select[name^="select_related"]').each(function() {
					related += $(this).val() + ',';
				});

				preloader('show');
				$.post("../model/documents_type_model.php", {
						"method": 'saveDocumentsType',
						"name": $('#documents_type_list_input_name').val(),
						"related": related.slice(0, -1),
						"description": $('#documents_type_list_textarea_description').val(),
						"image": image,
						"id": id
					},
					function(response) {
						if (response.code == '440'){
		                    loginTimeout(response.message);
		                    return;
		                }
						$("#documents_type").modal('hide');
						preloader('hide', 'Data Save...!', 'success');
						dataTable.draw();
					}, "json");
			}

		});

		$('#listdocumentsType tbody').on('click', '.btnEdit', function() {

			list_documents_type.cleanForm();
			var data = dataTable.row($(this).parents('tr')).data();
			var id = data[1];

			$('#documents_type_input_id').val(id);
			preloader('show');
			$.post("../model/documents_type_model.php", {
						"method": 'findDocumentsInfo',
						"id": id
					},
					function(response) {
						if (response.code == '440'){
		                    loginTimeout(response.message);
		                    return;
		                }
						preloader('hide');
						$('#setImage').show();

						$('#select_related').val(null).trigger("change");
						if (response.related != null){
							var related = response.related.split(',');
							$('#select_related').val(related).trigger("change");
						}

						$('#documents_type_list_input_name').val(response.name);
						$("#documents_type_list_input_name").parent().addClass("md-input-filled");
						$('#documents_type_list_textarea_description').val(response.description);
						$("#documents_type_list_textarea_description").parent().addClass("md-input-filled");
						$('.dz-image img').attr('src', response.image);
						$('.dz-image img').trigger('change');
						$("#documents_type").modal('show');

					}, "json")
				.fail(
					function(error) {
						console.log(error.responseJSON)
						preloader('hide', error.responseJSON, 'error');
					}
				);

		});

		$('#listdocumentsType tbody').on('click', '.btnDelete', function() {
			var data = dataTable.row($(this).parents('tr')).data();
			swal({
				title: "Are you sure?",
				text: "You won't be able to revert this!",
				type: "warning",
				showCancelButton: !0,
				confirmButtonText: "Yes, delete it!",
				cancelButtonText: "No, cancel!",
				reverseButtons: !0
			}).then(function(e) {
				
				if (e.dismiss) {
					swal({
						position: "top-center",
						type: "success",
						title: 'Data is safe :)',
						showConfirmButton: !1,
						timer: 1500
					});

				}
				if (e.value) {
					var method = 'deleteDocumentsType';
					var id = data[1];
					preloader('show');
					$.post("../model/documents_type_model.php", {
								"method": method,
								"id": id
							},
							function(data) {
								if (data.code == '440'){
								    loginTimeout(data.message);
								    return;
								}
								if (data.mss == '1') {
									preloader('hide', data.salida, 'success');
									dataTable.draw();
								} else {
									preloader('hide', data.salida, 'error');
									console.log(data.mss);
								}
							}, "json")
						.fail(
							function(error) {
								preloader('hide');
								console.log(error.responseJSON)
							}
						);

				}

			});

		});

	},
	dt_list_type: () => {
		dataTable = $('#listdocumentsType').DataTable({
			"processing": true,
			"serverSide": true,
			"responsive": !0,
			"ajax": {
				url: "../model/documents_type_model.php", // json datasource
				data: {
					method: "listdocumentsType"
				},
				type: "post", // method  , by default get
				error: function() { // error handling                    
				}
			},
			"order": [
				[2, "asc"]
			],
            drawCallback: function(response) {
            	if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }else{
                	dataTable.columns( [ 0, 1] ).visible( false, false );
                }
            }
		});
	},
	getIdDocumentsType: (id) => {

		var method = 'findDocumentsImage';
		preloader('show');
		$.post("../model/documents_type_model.php", {
					"method": method,
					"id": id
				},
				function(data) {
					preloader('hide');
					if (data.mss == '1') {
						$('#documents_type_image').attr("src", data.image);
						$('#modal_lightbox').modal('show');
					} else {
						console.log(data.mss);
					}

				}, "json")
			.fail(
				function(error) {
					console.log(error.responseJSON)
					preloader('hide');
				}
			);
	},
	cleanForm: () => {
		$('#documents_type_input_id').val(0);
		$('#documents_type_list_input_name').val('');
		$('#documents_type_list_textarea_description').val('');
		$('.dz-image img').attr('src', '');

		formValidateFileType.validate().resetForm();
	}

};


$(function() {
	list_documents_type.init();
	list_documents_type.dt_list_type();
	list_documents_type.event();
});