var dataTable = "";
const MODEL = "../model/contract_model.php";
var frmAddContract = $('#frmAddContract');
var commission = [];

var id_client = $('#id_client').val();
var date_approve = $('#date_approve').val();
 

const ContractController = {
    init:function () {
        $("#add_Phone").intlTelInput({
            autoHideDialCode: true,
            onlyCountries: ["us", "pr", "ca","ve"],
            preferredCountries: ["us"],
          });         

          frmAddContract.validate({
            rules: {
              add_name: {
                required: true                 
              },
              add_Email: {
                required: true,
                email: true,
              },
              add_Phone: {
                minlength: 5,
                maxlength:20                
              },               
              add_commission: {
                required: true                
              },
              add_code: {
                required: true,
              },
              select_agent_type:{
                required: true
              },
              add_idclient:{
                required: true
              }
            },
          });

          preloader("show")
          $.post(MODEL, {method:'loadCommission'},
            function (response, textStatus, jqXHR) {
              preloader("hide")
              commission = response.data;
            },
            "json"
          );   
    },
    table:function () {
        dataTable = $('#dtContractList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: MODEL, // json datasource
                data: {
                    method: "list"
                },
                type: "post",
                error: function() {}
            },
            "columnDefs": [{
                targets: [-1],
                orderable: false
            }],
            "order": [
                [0, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });
    },
    event:function(){
        $("#btnNewContract").click(function (e) { 
            e.preventDefault();
            ContractController.clean();            
            $("#modalNewContract").modal('show');            
        });
        /////////////////////////////////////////
        $("#btnSaveContract").click(function (e) { 
            e.preventDefault();
            if ($("#frmAddContract").valid()) {
              let id = $('#id').val();
              let phone='';
              if (id == 0) {
                let code = "+" + $("#add_Phone").intlTelInput("getSelectedCountryData").dialCode;
                phone = code + $("#add_Phone").val();
              }else{
                phone = $("#add_Phone").val();
              }
              let up_line = $('input:radio[name=up_line]:checked').val();
              let dt = {
                  method:'saveContract',
                  id:$('#id').val(),
                  name:$('#add_name').val(),
                  phone:phone,
                  email:$('#add_Email').val(),
                  type:$('#select_agent_type').val(),
                  commission:$('#add_commission').val(),                     
                  client:$('#add_idclient').val(),
                  up_line:up_line
              }
              if (up_line == 'agent') {
                dt.parent = $('#add_idparent').val();
              } 
              if (up_line == 'associate') {
                dt.parent = 0;
              }     

              preloader("show");
              $.post(MODEL, dt,
                function (response, textStatus, jqXHR) {
                    
                  if (response.code == 200) {
                    preloader("hide",response.message,"success");
                    dataTable.draw();
                  }
                  if (response.code == "440") {
                    loginTimeout(response.message);
                    return;
                  }
                  $("#modalNewContract").modal('hide'); 
                },
                "json"
              );
            }
        });
        ///////////////////////////////////////////////
        $("#select_agent_type").change(function (e) { 
          e.preventDefault();
          let select_agent_type = $("#select_agent_type").val();
           
          if (select_agent_type == "") {
            $("#add_commission").val("");
          }else{
            commission.map(function(value){              
              if (value.id_role == select_agent_type) {
                $("#add_commission").val(value.commission);
              }
            });
          }
        });
        ///////////////////////////////////////////////
        //Code for select parent before client
        $('#add_idclient').change( function(){
          let add_idclient = $(this).val();          
          if (add_idclient == '') {
            $("#add_idparent").html("");
          }else{
            getParent(add_idclient);
          }               
        });
        ////////////////////////////////////////////////
        $('input:radio[name="up_line"]').change(function(){             
          if ($(this).val() == 'associate') {
            $('#select_agent').hide();
          }
          if ($(this).val() == 'agent') {
            $('#select_agent').show();
          }
          $('#add_idclient').val('');
          $('#add_idparent').html('');
        });
        //////////////////////////////////////////////////
        /*$("#add_Phone").blur(function (e) { 
          e.preventDefault();
          var lang = localStorage.getItem("settingLang");
          
          if (!/^[0-9]{5,20}$/.test($("#add_Phone").val())) {
            $("#add_Phone").val("");
            var text = lang == "es" ? "Solo números, de 5 a 20 dígitos" : "Only numbers, from 5 to 20 digits";
            preloader("hide", text, "error"); 
          }            
          var code = "+" + $("#add_Phone").intlTelInput("getSelectedCountryData").dialCode;
          var phone = code + $("#add_Phone").val();           
           
        })*/
        //////////////////////////////////////////////////
        $('#btnApprove').click(function (e) { 
          e.preventDefault();
          
          swal({
            title: "Are you sure?",
            text: "you want approve this information :)!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, I agree!",
            cancelButtonText: "No, cancel!",
            reverseButtons: !0,
          }).then(function (e) {         
            if (e.value) {
              var parametros = {
                method: "saveApprove",
                id: $('#id_data').val(),                
                email:$('#femail').val()
              }; 
              preloader("show");
              $.post(MODEL,
                parametros,
                function (response) {               
                  if (response.code == 440) {
                    loginTimeout(response.message);
                    return;
                  }
                  if (response.code == 200) {     
                    $('#modalSeeData').modal('hide');         
                    preloader('hide',response.message,'success');
                    dataTable.draw();                    
                  }
                  if (response.code == 204) {
                    preloader("hide", response.message, "error");                                
                  }
                },
                "json"
              );
            }
          });
        });
        ///////////////////////////////////////////////////
        $("#add_Email").blur(function(){
          let add_Email = $('#add_Email').val();
          var lang = localStorage.getItem("settingLang");
          if (add_Email == '') {
            var text = lang == "es" ? "correo, no puede estar vacio...!" : "mail, cannot be empty";
            preloader("hide", text, "error"); 
          }else{
            $.post(MODEL, {method:'checkEmail',add_Email},
              function (response, textStatus, jqXHR) {  
                let obj = response.data;
                if (response.code == 204) {
                  var text = lang == "es" ? "correo,  ya esta en uso...!" : "mail, already in use";
                  preloader("hide", text, "error"); 
                  $('#add_Email').val("");
                }                 
              },
              "json"
            );
          }
        
        });
        
    },
    clean:function(){
        $('#id').val(0);
        $('#add_name').val('');
        $('#add_Phone').val('');
        $('#add_Email').val('');
        $('#add_code').val('');
        $('#add_commission').val('');
        $('#select_agent_type').val('');
        $('#add_idclient').val('');
        $('#add_idparent').html('');
        $('#select_agent').show();

        $("#exampleRadios1").prop("checked", true); 
        $("#exampleRadios2").prop("checked", false); 

        $("#frmAddContract").validate().resetForm();
    },
    edit:function (id) {
      ContractController.clean()
      let dt ={method:'edit',id}
      preloader("show");
      $.post(MODEL, dt,
        function (response, textStatus, jqXHR) {
          
          if (response.code == 200) {
            $('#id').val(response.data.id);
            $('#add_name').val(response.data.name);
            //$('#add_Phone').val(response.data.cell);
            $("#add_Phone").intlTelInput("setNumber",response.data.cell);
            $('#add_Email').val(response.data.email);
            $('#add_code').val(response.data.agent_code);
            $('#add_commission').val(response.data.commission);
            $('#select_agent_type').val(response.data.id_role);
            $('#add_idclient').val(response.data.id_client);
            
            if (response.data.up_line == 'agent') {
              $('#add_idparent').html('');
              $('#select_agent').show();
              $("input[name='up_line'][value='associate']").prop("checked",false);
              $("input[name='up_line'][value='agent']").prop("checked",true);
              getParent(response.data.id_client,response.data.id_parent);
            }
            if (response.data.up_line == 'associate') {
              $('#add_idparent').html('');
              $('#select_agent').hide();     
              $("input[name='up_line'][value='associate']").prop("checked",true);
              $("input[name='up_line'][value='agent']").prop("checked",false);                   
            }
            

            $("#modalNewContract").modal('show'); 
            preloader("hide"); 
          } 
          if (response.code == 440) {
            loginTimeout(response.message);
            return;
          }
        },
        "json"
      );
    },
    sendLink:function (id) {
      swal({
        title: "Are you sure?",
        text: "you want to send link :)!",
        type: "warning",
        showCancelButton: !0,
        confirmButtonText: "Yes, send it!",
        cancelButtonText: "No, cancel!",
        reverseButtons: !0,
      }).then(function (e) {         
        if (e.value) {
          var parametros = {
            method: "sendLink",
            id: id,
          };
          preloader("show");
          $.post(MODEL,
            parametros,
            function (response) {               
              if (response.code == 440) {
                loginTimeout(response.message);
                return;
              }
              if (response.code == 200) {
                preloader("hide", response.message, "success");
                dataTable.draw();                 
              }
              if (response.code == 204) {
                preloader("hide", response.message, "error");                                
              }
            },
            "json"
          );
        }
      });
    },
    seeData:function (id) {     

      // cargar el contrato
      $('#viewContrato').html('');
      let dt = {id_client:$('#id_client').val()}
      $.get("https://contract.gosmartcrm.com/app/views/steps/contracts/boots.php", dt,
        function (response, textStatus, jqXHR) { 
          $('#viewContrato').html(response);
        },
        "html"
      );

      swal({
        title: "Are you sure?",
        text: "you want to see this information :)!",
        type: "warning",
        showCancelButton: !0,
        confirmButtonText: "Yes, I agree!",
        cancelButtonText: "No, cancel!",
        reverseButtons: !0,
      }).then(function (e) {         
        if (e.value) {
          var parametros = {
            method: "seeData",
            id: id,
          };
          preloader("show");
          $.post(MODEL,
            parametros,
            function (response) {               
              if (response.code == 440) {
                loginTimeout(response.message);
                return;
              }
              if (response.code == 200) {              
                console.log(response.data);                
                /////////// 
                let parents = $('#parents').val(); // lista clientes
                listaClientsValids = parents.split(','); /// lista en array
                //////
                console.log('listaClientsValids');
                console.log(listaClientsValids);
                console.log('id_client ',id_client);
                /////////////////////////////////////
                let obj = response.data;
                $('#id_data').val(obj.id);                
                setTimeout(() => {
                  if (listaClientsValids.includes(id_client)) {
                    $('#daysignature').html(obj.day);
                    $('#monthsignature').html(obj.month);
                    $('#yearsignature').html(obj.year);
                    $('#name_agent_contract').html(obj.name);
                    $('.dateToday').html(obj.date_full);                     
                    
                    if (obj.date_approve == null || obj.date_approve == '') {
                      $('.dateApprove').html(date_approve);
                    }else{
                      $('.dateApprove').html(obj.date_approve);
                    }    
                     

                    if (obj.id_parent != 0) {
                      dataParent(obj.id_parent);
                    }
                    ///
                    if (obj.id_parent == 0) {
                      $('#name-upline').html(obj.name_client);
                      $('#code-upline').html('--- --- ---');
                    }                    
    
                    $('#fname').val(obj.name);
                    $('#fir_name').html(obj.name);
                    $('#faddress').val(obj.user_address);
                    $('#fbirthday').val(obj.birthdate);
                    $('#fgender').val(obj.gender);
                    $('#fcity').val(obj.user_city);
                    $('#fstate').val(obj.user_state);
                    $('#fphone').val(obj.cell);
                    $('#fphonehome').val(obj.phone_home);
                    $('#fzipcode').val(obj.user_zip);
                    $('#fcountry').val(obj.user_county);
                    $('#fphoneoffice').val(obj.office_phone);
                    $('#ffax').val(obj.fax);
                    $('#femail').val(obj.email);
                    $('#fwebsite').val(obj.user_web_page);  
                    
                    $('#position').html(obj.name_role);
                    $('.commission').html(obj.commission);
  
                    $('#nombre_agent_banco').html(obj.pay_to);
                    $('#social_code').html(obj.social_security);
                    if (obj.user_type_account == 'CORRIENTE') {
                      $('#corriente').prop('checked', true);    
                      $('#ahorro').prop('checked', false);                    
                    }
                    if (obj.user_type_account == 'AHORROS') {
                      $('#corriente').prop('checked', false);    
                      $('#ahorro').prop('checked', true);   
                    }
                    $('#bank').html(obj.user_bank_name);
                    $('#addressbank').html(obj.pay_address);
                    $('#routing').html(obj.user_route_number);
                    $('#ctaBank').html(obj.user_personal_bissnes);
  
                    $('.agentSing').html('');
                    $('.agentSing').append('<img src="" alt="Firma agent" width="28%" class="sig_agent">');
                    $('.sig_agent').attr("src", obj.url_sig);
  
                    if (obj.accepted == 1) {
                      $('#accepted').prop('checked', true);   
                    }
                    if (obj.accepted == 0) {
                      $('#accepted').prop('checked', false);   
                    }
  
                    $('#view_registered').html(obj.registered);
                    if (obj.status == '4') {
                      $('#btnApprove').hide();
                    }else{
                      $('#btnApprove').show();
                    }
                  }                
                  preloader("hide");
                  $('#modalSeeData').modal('show');
                }, 3000);
                
              }
              if (response.code == 204) {
                preloader("hide", response.message, "error");                                
              }
            },
            "json"
          );
        }
      });
    },
    seeDocuments:function (id) {
      swal({
        title: "Are you sure?",
        text: "you want to see this information :)!",
        type: "warning",
        showCancelButton: !0,
        confirmButtonText: "Yes, I agree!",
        cancelButtonText: "No, cancel!",
        reverseButtons: !0,
      }).then(function (e) {         
        if (e.value) {
          var parametros = {
            method: "seeData",
            id: id,
          };
          preloader("show");
          $.post(MODEL,
            parametros,
            function (response) {               
              if (response.code == 440) {
                loginTimeout(response.message);
                return;
              }
              if (response.code == 200) {              
                console.log(response.data); 
                let obj = response.data;
                $('#loadLicense').prop('src','');
                $('#loadDocument').prop('data','');
                setTimeout(() => {
                  $('#loadLicense').prop('src',obj.doc_license);
                  $('#loadDocument').prop('data',obj.doc_pdf);
                  preloader("hide");
                  $('#modalSeeDocument').modal('show');
                }, 3000);
                
              }
              if (response.code == 204) {
                preloader("hide", response.message, "error");                                
              }
            },
            "json"
          );
        }
      });
    }
}

$(function () {
    ContractController.init();
    ContractController.table();
    ContractController.event();
});

 
function getParent(params, id_parent = '') {
  $("#add_idparent").html('<option>please wait...! :)</option>');
  //$('#btnSaveContract').prop('disabled','disabled');
  ///////////////////////////////////////////////////////////////
  $.post(MODEL, { method: 'parentByClient', add_idclient: params},
  function (response) {
    $("#add_idparent").html('');
    //$('#btnSaveContract').prop('disabled','');
    /////////////////////////
    if(response.code == 200){
      let select = '';   
      ////////////////////////////     
      response.data.map( item => {               
        if (id_parent == item.id) select += `<option value="${item.id}" selected>${item.name}</option>`;
        select += `<option value="${item.id}" >${item.name}</option>`           
      }); 
      ////////////////////////////
      $("#add_idparent").html(select);               
    }          
    },
    "json"
  );
}

function dataParent(id_parent) {
  $.post(MODEL, {method:'dataParent',id_parent},
    function (response, textStatus, jqXHR) {
      let obj = response.data;
      $('#name-upline').html(obj[0].name);
      $('#code-upline').html(obj[0].agent_code.toUpperCase());
    },
    "json"
  );
}

 