var dataTable = '';

$(function(){
    contacts_required_documents.init();
});

firebaseInit();

var contacts_required_documents = {
    init: function() {
        dataTable = $('#documensList').DataTable({
            "paging": false,
            "searching": false,
            "processing": true,
            "serverSide": true,
            "responsive": {
                details: {
                    display: $.fn.dataTable.Responsive.display.childRowImmediate,
                    type: 'none',
                    target: ''
                }
            },
            "ajax": {
                url: "../model/required_documents_by_service_model.php", // json datasource
                data: {
                    method: "dtRequiredDocumentsContactsByService",
                    id_contact: $('#id_contact').val(),
                    id_service: $('#id_service').val()
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },

            'columnDefs': [{
                "sClass": "dpass",
                "aTargets": [0],
            },
            {
                "targets": [0],
                "visible": false
            }
            ],

            "order": [
                [2, "asc"]
            ]
        });
    },
    getDocumentInfo: function(id, filename) {
        $('#formUpDocuments')[0].reset();
        if (filename != '') {
            swal('A file "'+ filename +'" is already loaded!', ' Please delete it first', 'error')
                .then(function() {
                    $("#upload_documents").modal('hide')
                });
        } else {
            $('#document_required').val(id);
            $('#document_filename').val(filename);
        }
    },

    noFileAlert: function(id) {
        swal('File Not Found!', "Not Uploaded Yet", "warning");
    },
};

function preloader(type, message='', status='') {
    console.log('preloader');
    swal({
        title: "Loading!",
        showConfirmButton: false,
        showCancelButton: false,
        allowOutsideClick: false,
        onOpen: function() {
            if (type == 'show') {
                swal.showLoading()
            }else {
                if (message != ''){
                    swal({
                        title: message,
                        type: status,
                        timer: 2000
                    });
                }else{
                  swal.close()
                }
            }

        }
    }).then(function(e) {
        "timer" === e.dismiss && console.log("I was closed by the timer")
    })
}
function firebaseInit(){
    var config = {
        apiKey: "AIzaSyCP0Ac-otaPwQvhITVnafAjQqce36jYQvE",
        authDomain: "gosmartcrm-f37ac.firebaseapp.com",
        databaseURL: "https://gosmartcrm-f37ac.firebaseio.com",
        projectId: "gosmartcrm-f37ac",
        storageBucket: "gosmartcrm-f37ac.appspot.com",
        messagingSenderId: "61573422266",
        appId: "1:61573422266:web:f90a908caf85c0f3"
    };

    if (!firebase.apps.length) { //verifica si ya esta cargada app para evitar error por duplicacion
       firebase.initializeApp(config);
    }

    var email = 'gosmartcrm@gmail.com';
    var password = '/*AVerSiAdivinasEsta963-)';

    firebase.auth().signInWithEmailAndPassword(email, password).catch(function(error) {
        var errorCode = error.code;
        var errorMessage = error.message;
        alert("Error autenticating Firebase!", errorCode + ' - ' + errorMessage, "error");
    });
}

function firebaseUploadFile(typeRelated){ //typeRelated: 1:Client , 2:Contact, 3:User

    var id_required_documents = '';

    if ($('#document_required').html() != null) {
        var id_required_documents = $('#document_required').val();
        var file = document.getElementById("upload_document").files[0];
    }

    var mainDir = 'contacts/';
    var idRelated = $('#id_contact').val();

    if (file.length != 0) {

        preloader('show');

        firebaseInit();
        var file_path = mainDir + idRelated + '/' + file.name
        var storageRef = firebase.storage().ref();
        var uploadTask = storageRef.child(file_path).put(file);
        uploadTask.on('state_changed', function(snapshot){
        var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
        console.log('Upload is ' + progress + '% done');
          switch (snapshot.state) {
            case firebase.storage.TaskState.PAUSED: // or 'paused'
              console.log('Upload is paused');
              break;
            case firebase.storage.TaskState.RUNNING: // or 'running'
              console.log('Upload is running');
              break;
          }
        }, function(error) {
            swal("Error Uploading!\r\nError Code: " + error.code);
        }, function() {
            uploadTask.snapshot.ref.getDownloadURL().then(function(downloadURL) {
                var parametros = {
                    "method": "saveFilesUrl",
                    "type": typeRelated,
                    "id_related": idRelated,
                    "id_required_documents": id_required_documents,
                    "file_name": file.name,
                    "file_path": file_path,
                    "file_url": downloadURL
                };
                preloader('show');
                $.post("../model/required_documents_by_service_model.php", parametros, function(data) {
                    if (data.code == '440'){
                            loginTimeout(data.message);
                            return;
                        }
                    if (data.response == '200') {

                        $.post('../model/required_documents_by_service_model.php', {
                            method: 'sendMail',
                            id_related: data.id_related,
                            id_required_documents: data.id_required_documents,
                            filename: data.filename,
                            document_name: data.document_name,
                            file_url: data.file_url,
                            id_service: $('#id_service').val()
                        }, function(response) {
                            if (response.code == '200') {
                                swal('File Loaded!', data.filename + " is in your cloud bucket", "success");
                                dataTable.draw();
                                $(".modal").modal('hide');
                                preloader('hide',data.message,'sucess');
                            }
                            if (response.code == '204') {
                                preloader('hide',data.message,'danger');
                            }
                            if (response.code == '202') {
                                dataTable.draw();
                                preloader('hide', data.message, 'sucess');
                                $(".modal").modal('hide');

                            }

                        }, "json");

                    }
                    if (data.response == '204') {
                        preloader('hide',data.message,'sucess');
                        swal('File Loaded with error!', "Please try again. DB Error", "error");
                    }

                },'json')
                .fail(
                    function(error) {
                        preloader('hide');
                        console.log(error.responseJSON);
                    }
                );
            });
        });

    } else {
        swal('No File to Upload!', "Please try again", "error");
    }
}

function firebaseDeleteFile(file_path, file_name, typeRelated){

    if (file_path != '') {

        firebaseInit();

        swal({
            title: "Are you sure?",
            text: "You can't revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!"
        }).then(function(e) {
            if (e.dismiss === "cancel") {
                swal("Cancelled", "File is safe :)", "error");
            }
            if (e.value) {

                var storageRef = firebase.storage().ref();
                storageRef.child(file_path).delete();


                var parametros = {
                    "method": "deleteFilesUrl",
                    "file_path": file_path,
                    "file_name": file_name,
                    "typeRelated": typeRelated
                };
                $.ajax({
                    data: parametros,
                    url: '../../app/model/required_documents_by_service_model.php',
                    method: 'post',
                    dataType: 'json',
                    success: function (data) {
                        if (data.code == '440'){
                            loginTimeout(data.message);
                            return;
                        }
                        if (data.response == '200') {
                            swal('File Deleted!', "", "success");
                            dataTable.draw();
                        }
                        if (data.response == '204') {
                            swal('Can\'t delete file!', "Please try again", "error");

                        }
                    },
                    //si ha ocurrido un error
                    error: function(){
                        swal('File Not Deleted!', "Please try again", "error");
                    }
                });

            }
        });

    } else {

        swal('No File to Delete!', "Please check", "error");

    }

}

function showImage(file_url) {
    swal({
        title: 'File Preview/Download',
        html: '<div><embed src=' + file_url + ' width="338px"/></div><div><a href="' + file_url + '" download target="_blank"> Download File</a></div>'
    });
}