var objeto = {};

var contacts_import = {
	init: function() {
		$("#product_edit_tags_control").select2({
			placeholder: "Select tags",
			tags: !0,
			multiple: true,
			tokenSeparators: [',']
		});
		$("#product_edit_status_control").select2({
			placeholder: "Select Status",
			minimumResultsForSearch: 1 / 0
		});

	},
	events: function() {
		$("#addTags").on('click', function() {
			$("#dv tr").find('td:eq(5)').each(function() {
				var htmlString = $(this).html();
				$(this).text($('#product_edit_tags_control').val());
			});
			var valores = "";
			$("#dv tr").find('td').each(function() {
				valores += $(this).html();
				var x = new Array(valores);
				//alert(x);
			});
		});
		$("#addStatus").on('click', function() {
			$("#dv tr").find('td:eq(6)').each(function() {
				var htmlString = $(this).html();
				$(this).text($('#product_edit_status_control').val());
			});
			var valores = "";
			$("#dv tr").find('td').each(function() {
				valores += $(this).html();
				var x = new Array(valores);
			});
		});
		$("#download").on('click', function() {
			var html = ("#Tdownload").outerHTML;
			export_table_to_csv(html, "table.csv");
		});

		$('#btnSendTblDataToServer').click(function() {
			var TableData;
			method = 'importContacts';
			TableData = JSON.stringify(storeTblValues());
			$('#tbSendTblDataToServer').val('JSON array to send to server: \n\n' + TableData.replace(/},/g, "},\n"));
			preloader('show');
			$.ajax({
				type: "POST",
				url: '../model/ctContacts.php',
				data: {
					"method": method,
					"pTableData": TableData
				},
				success: function(msg) {
					// return value stored in msg variable 
					$('#tbServerResponse').val('Server Response:\n\n' + msg);
					preloader('hide', 'Import Success...!', 'success');
				}
			});
		});
		$('#dvCSV').show();
		$("#upload").bind("click", function() {
			var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
			if (regex.test($("#fileUpload").val().toLowerCase())) {
				if (typeof(FileReader) != "undefined") {
					var reader = new FileReader();
					reader.onload = function(e) {
						var table = $("<table id=\"dv\" class=\"table table-striped table-bordered table-hover\"/>");
						var rows = e.target.result.split("\n");
						for (var i = 0; i < rows.length; i++) {
							var row = $("<tr />");
							var cells = rows[i].split(",");
							var array = [11, 11, 15, 15, 8, 15, 8];
							if (cells != '') {
								for (var j = 0; j < cells.length + 2; j++) {
									var cell = $("<td style='text-align: center;' width='" + array[j] + "%;'/>");
									cell.html(cells[j]);
									row.append(cell);
								}
								table.append(row);
							}
						}
						$("#dvCSV").html('');
						$("#dvCSV").append(table);
						$("#dv tr:nth-child(1)").hide();
					}
					reader.readAsText($("#fileUpload")[0].files[0]);
				} else {
					alert("This browser does not support HTML5.");
				}
			} else {
				alert("Please upload a valid CSV file.");
			}
		});
	}
};

function download_csv(csv, filename) {
	var csvFile;
	var downloadLink;

	csvFile = new Blob([csv], {
		type: "text/csv"
	});
	downloadLink = document.createElement("a");
	downloadLink.download = filename;
	downloadLink.href = window.URL.createObjectURL(csvFile);
	downloadLink.style.display = "none";
	document.body.appendChild(downloadLink);
	downloadLink.click();
}

function export_table_to_csv(html, filename) {
	var csv = [];
	var rows = document.querySelectorAll("#Tdownload tr");

	for (var i = 0; i < rows.length; i++) {
		var row = [],
			cols = rows[i].querySelectorAll("td, th");

		for (var j = 0; j < cols.length; j++)
			row.push(cols[j].innerText);

		csv.push(row.join(","));
	}
	download_csv(csv.join("\n"), filename);
}

document.querySelector("button").addEventListener("click", function() {
	var html = document.querySelector("#Tdownload").outerHTML;
	export_table_to_csv(html, "#Tdownload.csv");
});

function storeTblValues() {
	var TableData = new Array();

	$('#dv tr').each(function(row, tr) {
		TableData[row] = {
			"name": $(tr).find('td:eq(0)').text(),
			"last_name": $(tr).find('td:eq(1)').text(),
			"contacts_phone": $(tr).find('td:eq(2)').text(),
			"email": $(tr).find('td:eq(3)').text(),
			"address": $(tr).find('td:eq(4)').text(),
			"tags": $(tr).find('td:eq(5)').text(),
			"type_client": $(tr).find('td:eq(6)').text()
		}
	});
	TableData.shift(); // first row will be empty - so remove
	return TableData;
}

$(function() {
	contacts_import.init();
	contacts_import.events();
});