'use strict';

var formValidate = $('#contact_form'),
	idContact = '';

var formEditPhone = $("#formEditPhone");
var formEditEmail = $("#formEditEmail");


var contacts_edit = {
	init: () => {

		//campo fecha
		var t;
		t = mUtil.isRTL() ? {
			leftArrow: '<i class="la la-angle-right"></i>',
			rightArrow: '<i class="la la-angle-left"></i>'
		} : {
			leftArrow: '<i class="la la-angle-left"></i>',
			rightArrow: '<i class="la la-angle-right"></i>'
		};

		$("#birthday").datepicker({
			dateFormat: "mm/dd/yy",
			appendText: "MM/DD/YY",
			changeMonth: true,
			changeYear: true,
			yearRange: "-100:+0",
			rtl: mUtil.isRTL(),
			todayHighlight: !0,
			orientation: "bottom left",
			templates: t
		});

		//select multiple para las company
		$("#contact_select_company").select2({
			placeholder: "Add a Company",
			tags: !0,
			maximumSelectionLength: 1
		});

		//select multiple para los tags
		$("#contact_select_tags").select2({
			placeholder: "Add a tag",
			tags: !0
		});

		//form repeater       
		$("#repeatPhone").repeater({
			initEmpty: !1,
			defaultValues: {
				"text-input": "foo"
			},
			show: function() {
				$(this).slideDown()
			},
			hide: function(e) {
				$(this).slideUp(e)
			}
		});

		$("#repeatEmail").repeater({
			initEmpty: !1,
			defaultValues: {
				"text-input": "foo"
			},
			show: function() {
				$(this).slideDown()
			},
			hide: function(e) {
				$(this).slideUp(e)
			}
		});

		//form validate
		formValidate.validate({
			rules: {
				contact_input_name: {
					required: true
				},
				contact_input_last_name: {
					required: true
				},
				contact_input_phone_number: {
					required: true
				},
				contact_input_email: {
					required: true
				}
			}
		});

		formEditPhone.validate({
			rules: {
				contact_input_phone_number_edit: {
					required: true
				}
			}
		});

		formEditEmail.validate({
			rules: {
				contact_input_email_edit: {
					required: true
				}
			}
		});

	},
	events: () => {

		$('#contact_input_name').keyup(function() {
			$('#name').html($('#contact_input_name').val());
		});

		$('#contact_input_last_name').keyup(function() {
			$('#last').html($('#contact_input_last_name').val());
		});

		$('#contact_input_title').keyup(function() {
			$('#title').html($('#contact_input_title').val());
		});

		$('#saveNewContact').click(function() {
			if (formValidate.valid()) {

				var id = $('#contact_input_id').val();
				var tags = '';
				var select_type_phone = '';
				var input_phone_number = '';
				var select_type_email = '';
				var input_email = '';
				var image = '';
				var id_country = '';

				$.each($('#contact_select_tags').val(), function(index, value) {
					tags += value + ',';
				});
				tags = tags.substring(0, tags.length - 1);

				$('.contact_select_type_phone').each(function() {
					select_type_phone += $(this).val() + ',';
				});
				$('.contact_input_phone_number').each(function() {
					input_phone_number += $(this).val() + ',';
				});
				$('.contact_select_type_email').each(function() {
					select_type_email += $(this).val() + ',';
				});
				$('.contact_input_email').each(function() {
					input_email += $(this).val() + ',';
				});

				if ($('#contact_select_country').val() !== null) {
					id_country = $('#contact_select_country').val();
				} else {
					id_country = 0;
				}

				image = $('.file-preview-image').attr('src') ? $('.file-preview-image').attr('src') : $('#contact_input_id_avatar').attr('src');

				var datos = {
					"method": 'editContact',
					"id": $('#contact_input_id').val() == '0' ? 0 : $('#contact_input_id').val(),
					"name": $('#contact_input_name').val(),
					"last_name": $('#contact_input_last_name').val(),
					"company": $('#contact_select_company').val(),
					"title": $('#contact_input_title').val(),
					"id_avatar": $('#contact_input_id_avatar').val() == '' ? 1 : $('#contact_input_id_avatar').val(),
					"address": $('#contact_input_address').val(),
					"type_address": $('#contact_input_type_address').val(),
					"city": $('#contact_input_city').val(),
					"state": $('#contact_input_state').val(),
					"id_country": id_country[0],
					"zip": $('#contact_input_zip').val(),
					"county": $('#contact_input_county').val(),
					"score": $('#contact_select_score').val(),
					"tags": tags,
					"status": 1,
					"select_type_phone": select_type_phone.slice(0, select_type_phone.length),
					"input_phone_number": input_phone_number.slice(0, input_phone_number.length),
					"select_type_email": select_type_email.slice(0, select_type_email.length),
					"input_email": input_email.slice(0, input_email.length),
					"image": image,
					"type_source": 'System',
					"type_client": 'Created',
					"user_assign": $('#contact_select_user').val(),
					"birthday": $('#birthday').val(),
					"age": $('#age').val(),
					"language": $('#contact_select_languaje').val(),
					"communication_language": $('#contact_select_communication_languaje').val()
				};
				//console.log(datos);


				preloader('show');
				$.post("../model/ctContacts.php", datos, function(response) {

					if (response.code == '440') {
						loginTimeout(response.message);
						return;
					} else if (response.code == '200') {
						preloader('hide', response.message, 'success');
						if ($('#contact_input_id').val() == '0') {
							$('#contact_input_id').val(response.id);
						}
					} else if (response.code == '204') {
						preloader('hide', response.message, 'error');
					}

				}, "json").fail(function(error) {
					console.log(error);
					preloader('hide');
				});



			} //fin de validate
		});

		$("#d_form_section_phone_remove a").click(function(e) {
			e.preventDefault();
			var method = 'removeContactsPhone';
			var id = $(this).attr('data-idRemove');
			preloader('show');
			$.post("../model/ctContacts.php", {
					"method": method,
					"id": id
				}, function(response) {
					if (response.code == '440') {
						loginTimeout(response.message);
						return;
					} else if (response.code === '200') {
						preloader('hide', response.message, 'success');
						location.reload();

					} else if (response.code === '204') {
						preloader('hide', response.message, 'error');
					}

				}, "json")
				.fail(
					function(error) {
						preloader('hide');
					}
				);

		});

		$("#d_form_section_email_remove a").click(function(e) {
			e.preventDefault();
			var method = 'removeContactsEmail';
			var id = $(this).attr('data-idRemove');

			preloader('show');

			$.post("../model/ctContacts.php", {
					"method": method,
					"id": id
				}, function(response) {
					if (response.code == '440') {
						loginTimeout(response.message);
						return;
					} else if (response.code === '200') {
						preloader('hide', response.message, 'success');
						location.reload();
					} else {
						preloader('hide', response.message, 'error');
					}

				}, "json")
				.fail(
					function(error) {
						console.log(error.responseJSON);
						preloader('hide');
					}
				);

		});

		$("#btnSaveEditPhone").click(function(e) {
			e.preventDefault();
			if (formEditPhone.valid()) {
				var datos = {
					method: "saveEditContactPhone",
					id_phone: $("#id_phone").val(),
					type_phone: $("#contact_select_type_phone_edit").val(),
					phone_number: $("#contact_input_phone_number_edit").val()
				};
				preloader("show");
				$.post(
					"../model/ctContacts.php",
					datos,
					function(data) {
						if (data.code == 200) {
							$("#modalEditPhoneContact").modal("hide");
							preloader("hide", data.message, "success");
							setTimeout(() => {
								location.reload();
							}, 2000);
						}
					},
					"json"
				);
			}
		});

		$("#btnSaveEditEmail").click(function(e) {
			e.preventDefault();
			if (formEditEmail.valid()) {
				var datos = {
					method: "saveEditContactEmail",
					id_email: $("#id_email").val(),
					type_email: $("#contact_select_type_email_edit").val(),
					email: $("#contact_input_email_edit").val()
				};
				preloader("show");
				$.post(
					"../model/ctContacts.php",
					datos,
					function(data) {
						if (data.code == 200) {
							$("#modalEditEmailContact").modal("hide");
							preloader("hide", data.message, "success");
							setTimeout(() => {
								location.reload();
							}, 2000);
						}
					},
					"json"
				);
			}
		});

		$(".editContactPhone").click(function(e) {
			e.preventDefault();
		});

		$(".editContactEmail").click(function(e) {
			e.preventDefault();
		});

	},
	cleanForm: () => {
		idContact = "";
		$("#id_phone").val("");
		$("#id_email").val("");
		formEditPhone.validate().resetForm();
		formEditEmail.validate().resetForm();
	},
	editContactPhone: function(id) {
		contacts_edit.cleanForm();
		swal({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			type: "warning",
			showCancelButton: !0,
			confirmButtonText: "Yes, Edit it!",
			cancelButtonText: "No, cancel!",
			reverseButtons: !0
		}).then(function(e) {
			if (e.dismiss) {
				swal({
					position: "top-center",
					type: "success",
					title: "Data is safe :)",
					showConfirmButton: !1,
					timer: 1500
				});
			}
			if (e.value) {
				var datos = {
					method: "loadPhoneContact",
					id_phone: id
				};
				preloader("show");
				$.post(
					"../model/ctContacts.php",
					datos,
					function(data) {
						preloader("hide", data.message, "success");
						$("#id_phone").val(data.id_phone);
						$("#contact_select_type_phone_edit").val(data.type_phone);
						$("#contact_input_phone_number_edit").val(data.phone_number);
					},
					"json"
				);
				$("#modalEditPhoneContact").modal("show");
			}
		});
	},
	editContactEmail: function(id) {
		contacts_edit.cleanForm();
		swal({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			type: "warning",
			showCancelButton: !0,
			confirmButtonText: "Yes, Edit it!",
			cancelButtonText: "No, cancel!",
			reverseButtons: !0
		}).then(function(e) {
			if (e.dismiss) {
				swal({
					position: "top-center",
					type: "success",
					title: "Data is safe :)",
					showConfirmButton: !1,
					timer: 1500
				});
			}
			if (e.value) {
				var datos = {
					method: "loadEmailContact",
					id_email: id
				};
				preloader("show");
				$.post(
					"../model/ctContacts.php",
					datos,
					function(data) {
						preloader("hide");
						$("#id_email").val(data.id_email);
						$("#contact_select_type_email_edit").val(data.type_email);
						$("#contact_input_email_edit").val(data.email);
					},
					"json"
				);
				$("#modalEditEmailContact").modal("show");
			}
		});
	}

};

/*
function calcularEdad(fecha) {
	//console.log('change');
	var hoy = new Date();
	var cumpleanos = new Date(fecha);
	//console.log(cumpleanos);
	var edad = hoy.getFullYear() - cumpleanos.getFullYear();
	var m = hoy.getMonth() - cumpleanos.getMonth();

	if (m < 0 || (m === 0 && hoy.getDate() < cumpleanos.getDate())) {
		edad--;
	}

	if (edad < 18 || edad > 100) {
		preloader('hide', 'Age Not Valid....!', 'error');
		$("#birthday").val('');
		$("#birthday").focus();
		$('#age').val('');
	} else {
		$('#age').val(edad);
	}

};
*/

function calcularEdad(fecha) {
	//console.log('change');
	var arr = fecha.split("/");
	var newfecha = arr[2] + "/" + arr[0] + "/" + arr[1];
	// arr[0] mes 
	// arr[1] dia
	// arr[2] ano
	//console.log('fecha: ' + newfecha);
	var hoy = new Date();
	var cumpleanos = new Date(newfecha);
	//console.log(cumpleanos);
	var edad = hoy.getFullYear() - cumpleanos.getFullYear();
	var m = hoy.getMonth() - cumpleanos.getMonth();

	if (m < 0 || (m === 0 && hoy.getDate() < cumpleanos.getDate())) {
		edad--;
	}

	if (edad < 18 || edad > 100) {
		preloader('hide', 'Age Not Valid....!', 'error');
		$("#birthday").val('');
		$("#birthday").focus();
		$('#age').val('');
	} else {
		$('#age').val(edad);
	}

};

function dateValidated(fecha) {
	//console.log('change');
	if (fecha !== "") {
		var valido = isValidDate(fecha);
		//console.log('valido: ' + valido);
		if (!valido) {
			preloader('hide', 'Format Date Not Valid....!', 'error');
			$("#birthday").val('');
			$("#birthday").focus();
			$('#age').val('');
		}
		if (valido) {
			calcularEdad(fecha);
		}
	}
};

function isValidDate(date) {
	var matches = /^(\d{1,2})[-\/](\d{1,2})[-\/](\d{4})$/.exec(date);
	if (matches == null) return false;
	var d = matches[2];
	var m = matches[1] - 1;
	var y = matches[3];
	var composedDate = new Date(y, m, d);
	return composedDate.getDate() == d &&
		composedDate.getMonth() == m &&
		composedDate.getFullYear() == y;
}

$(function() {
	contacts_edit.init();
	contacts_edit.events();
});