var formAddAdjustment = $("#formAddAdjustment");
var formPaymentRecord = $("#formPaymentRecord");

$.fn.select2.defaults.set("width", "100%");
$.fn.modal.Constructor.prototype.enforceFocus = function () {};
var xxx = {};
var dataTableCommissions = "";
var dataTableSummary = "";
var dataTable = "";

var lang = localStorage.getItem("settingLang");

var yearActual = new Date().getFullYear();
var monthActual = moment().format('M') < 10 ? '0' + moment().format('M') : moment().format('M');

let Conciliation = {
  event: () => {
    $('#payments_date_year').val(yearActual);

    $(document).on('click', ".dropdown-month", function(){
      monthActual = $(this).attr("data-month"); // actualizar monthActual

      setTimeout(() => { //Dar chance para que las traducciones se apliquen 
        var itemText = $(this).text();
        $('#dropdownMenuButton').text(itemText);
      }, "3000");

      if (yearActual == "" || monthActual == "") {
        swal("Error", "must indicate date from!", "error");
        return;
      }
      var date = "01-" + monthActual + '-' + yearActual;
      Conciliation.tableCommissions(date);
      Conciliation.tableSummary(date);
      Conciliation.showTotalAgentsPlans(date);
    });

    $(`*[data-month="${monthActual}"]`).trigger('click');

    $("#payments_date_year").change(function(){
      yearActual = $(this).val(); // actualizar yearActual
      $(".dropdownSelectMonth").text("Select");
      monthsConciliations();
    })

    formAddAdjustment.validate({
      rules: {
        add_user: {
          required: true,
        },
        add_amount: {
          required: true,
          number: true,
        },
        add_adjustment_date: {
          required: true,
        },
        add_type: {
          required: true,
        },
        add_note: {
          required: false,
        },
      },
    });

    formPaymentRecord.validate({
      rules: {
        reconciliation_payment_date: {
          required: true,
        },
        payment_description: {
          required: true,
        },
      },
    });

    $("#btPaymentRecord").click(function () {
      var idCommissionPayments = "";
      var amountTotalSelected = 0;
      $("input[name=CommissionPayments]").each(function (index) {
        if ($(this).is(":checked")) {
          idCommissionPayments += $(this).val() + ",";
        }
      });
    
      if (idCommissionPayments == "") {
        preloader("hide", "Must indicate Policy...!", "error");
        return; 
      }
    
      if (idCommissionPayments != "") {
        if ($("#formPaymentRecord").valid()) {
          var params = {
            action: "paymentRecord",
            idCommissionPayments: idCommissionPayments.slice(0, -1),
            reconciliation_payment_date: $("#reconciliation_payment_date").val(),
            payment_description: $("#payment_description").val(),
          };
          console.log(params);
          preloader("show");
          $.post(
            "../model/conciliation_model.php",
            params,
            function (data) {
               console.log(data); 
              if (data.code == 200) {
                dataTableCommissions.draw();
                dataTableSummary.draw();
                dataTable.draw();
                
                $("#reconciliation_payment_date").val('');  
                $("#payment_description").val('');          
              
                $("input[name='CommissionPayments']").prop("checked", false);
              
                preloader("hide", data.message, "success");
              } else if (data.code == 204) {
                preloader("hide", data.message, "error");
              } else {
                preloader("hide", "Error", "error");
              }
            },
            "json"
          );
        }
      }
    });

    $(document).on("change", ".commissionCheckbox, #check_all", function(){
      var amountTotalSelected = 0;
      $("input[name=CommissionPayments]").each(function (index) {
        if ($(this).is(":checked")) {
          const row = $(this).closest('tr');
          const fourthColumnValue = row.find('td:nth-child(5) div').text();
          amountTotalSelected = amountTotalSelected + parseFloat(fourthColumnValue);
        }
      });
      $("#amount_total_selected").val(amountTotalSelected.toFixed(2));
    });

    $("#modalDetailsConciliaton").on("shown.bs.modal", function () {
      $("#check_all").on("change", ".m-group-checkable", function () {
        $("input:checkbox[name='CommissionPayments']")
          .not(this)
          .prop("checked", this.checked);
      });
    });

    $("#btnSaveRecal").click(function (e) {
      swal({
        title: "Are you sure?",
        text: "You can't revert this!",
        type: "warning",
        showCancelButton: !0,
        confirmButtonText: "Yes, save it!",
      }).then(function (e) {
        if (e.dismiss === "cancel") {
          swal("Cancelled", "Change is safe :)", "error");
        }
        if (e.value) {
          var params = {
            action: "saveRecal",
            idCommision: $("#idCommision").val(),
            newPorcentaje: $("#newPorcentaje").attr("newPorcentaje"),
            newCommission: $("#newCommission").attr("newCommission"),
          };
          preloader("show");
          $.post(
            "../model/conciliation_model.php",
            params,
            function (data) {
              if (data.code == 200) {
                preloader("hide", data.messaje, "success");
                $("#modalRecalculate").modal("hide");
                dataTableCommissions.draw();
                dataTableSummary.draw();
              }
            },
            "json"
          );
        }
      });
    });

    $("#dtCommissionsList tbody").on(
      "click",
      ".btnRecalculate",
      function (item) {
        Conciliation.cleanRecalculate();
        var data = JSON.parse($(this).attr("data-dataRecalculate"));
        let $amount = parseFloat(data.amount);
        console.log(data);
        let dataTr = dataTableCommissions.row($(this).parents("tr")).data();
        let idCommision = dataTr[0];
        let $date = "01-" + monthActual + '-' + yearActual;
        let params = {
          action: "getRecal",
          person_interacting: data.person_interacting,
          date: $date,
          id_payment_due: data.id_payment_due,
        };
        preloader("show");
        $.post(
          "../model/conciliation_model.php",
          params,
          function (res) {
            console.log("result", res.response.code);
            if (res.response.code == 200) {
              preloader("hide", "success", "success");
              $("#modalRecalculate").modal("show");
              $("#name").html(data.name_agent);
              $("#idCommision").val(idCommision);
              $("#policy").html(data.policy);
              $("#amount").html($amount);
              $("#oldPorcentaje").html(data.commission_percentage + "%");
              $("#oldCommission").html("$" + data.commission_amount);

              console.log("result", res);
              $("#newPorcentaje").html(
                res.response.data.commission_percentage + "%"
              );
              $("#newPorcentaje").attr(
                "newPorcentaje",
                res.response.data.commission_percentage
              );
              $("#newCommission").html(
                "$" + res.response.data.amount_commission
              );
              $("#newCommission").attr(
                "newCommission",
                res.response.data.amount_commission
              );
              console.log("result", res);
              if (
                data.commission_percentage ===
                  res.response.data.commission_percentage ||
                data.commission_percentage === "5" ||
                res.response.data.commission_percentage === 5
              ) {
                $(".newPorcentaje").attr("hidden", true);
                $(".newCommission").attr("hidden", true);
                $("#btnSaveRecal").attr("disabled", true);
              } else {
                $("#btnSaveRecal").attr("disabled", false);
                $(".newPorcentaje").attr("hidden", false);
                $(".newCommission").attr("hidden", false);
              }
              preloader("hide");
            } else {
              preloader("hide", res.response.message, "info");
            }
          },
          "json"
        );
      }
    );

    $("#add_adjustment_date").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm/dd/yy",
    });

    $("#reconciliation_payment_date").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm/dd/yy",
    });

    $("#btn_clear_date_range").click(function () {
      $(".dropdownSelectMonth").text("Select");
    });

    $(".tab_commissions").click(function (e) {
      e.preventDefault();
      $("#buttonsDataTableSummary").hide();
      $("#buttonsDataTableCommissions").show();
    });

    $(".tab_summary").click(function (e) {
      e.preventDefault();
      $("#buttonsDataTableCommissions").hide();
      $("#buttonsDataTableSummary").show();
    });

    $("#btn_reprocesses").click(function (e) {
      var lang = localStorage.getItem("settingLang");
      Swal.fire({
        title: lang == "en" ? "Are you sure?" : "Estas seguro?",
        icon: "warning",
        input: "text",
        inputPlaceholder: "00/0000",
        showCancelButton: true,
        confirmButtonText: lang == "en" ? "Yes" : "Si",
        onOpen: function () {
          console.log("on Open");
          $(".swal2-input").datepicker({
            rtl: mUtil.isRTL(),
            todayHighlight: !0,
            orientation: "bottom left",
            dateFormat: "mm-yy",
          });
          $(".swal2-input").blur();
        },
        inputValidator: (value) => {
          return new Promise((resolve) => {
            if (value != "") {
              var data = {
                action: "reprocesses",
                date: "01-" + $(".swal2-input").val(),
                lang: lang,
              };
              $.post(
                "../model/conciliation_model.php",
                data,
                function (data) {
                  if (data.code == 201) {
                    Swal.fire({
                      title: lang == "en" ? "Are you sure?" : "Estas seguro?",
                      text: data.message,
                      showCancelButton: true,
                      icon: "warning",
                      confirmButtonText: lang == "en" ? "Yes" : "Si",
                    }).then((result) => {
                      if (result.value) {
                        preloader("show");
                        var params = {
                          action: "deletedAndReprocesses",
                          date: data.date,
                        };
                        $.post(
                          "../model/conciliation_model.php",
                          params,
                          function (data) {
                            if (data.code == 200) {
                              dataTableCommissions.draw();
                              dataTableSummary.draw();
                              preloader("hide", data.message, "success");
                            } else {
                              preloader("hide", data.message, "info");
                            }
                          },
                          "json"
                        );
                      }
                    });
                  } else if (data.code == 204) {
                    preloader("hide", data.message, "info");
                  } else if (data.code == 200) {
                    dataTableCommissions.draw();
                    dataTableSummary.draw();
                    preloader("hide", data.message, "success");
                  }
                },
                "json"
              );
            } else {
              resolve("You need to select date");
            }
          });
        },
      });
    });

    $("#btn_add_adjustment").click(function (e) {
      Conciliation.cleanAdjustment();
      $("#modalAddAdjustment").modal("show");
    });

    $("#btn_close_conciliation").click(function (e) {
      var lang = localStorage.getItem("settingLang");
      Swal.fire({
        title: lang == "en" ? "Are you sure?" : "Estas seguro?",
        text:
          lang == "en"
            ? "Once it's applied, you won't be able to make changes to this month's records."
            : "Una vez que se aplique, no podrá realizar cambios en los registros de este mes.",
        showCancelButton: true,
        confirmButtonText: lang == "en" ? "Yes" : "Si",
      }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.value) {
          var params = {
            action: "closeConciliation",
            date: "01-" + monthActual + '-' + yearActual
          };
          $.post(
            "../model/conciliation_model.php",
            params,
            function (data) {
              if (data.code == 200) {
                dataTableCommissions.draw();
                dataTableSummary.draw();
                preloader("hide", data.message, "success");
              } else if (data.code == 204) {
                preloader("hide", data.message, "info");
              } else {
                preloader("hide", "Error", "error");
              }
            },
            "json"
          );
        }
      });
    });

    $("#btnSaveAdjustment").click(function () {
      if ($("#formAddAdjustment").valid()) {
        var params = {
          action: "addAdjustment",
          id_user: $("#add_user").attr("data-id"),
          id_client: $("#add_user").attr("data-id_client"),
          amount: $("#add_amount").val(),
          adjustment_date: $("#add_adjustment_date").val(),
          type: $("#add_type").val(),
          note: $("#add_note").val(),
        };
        preloader("show");
        $.post(
          "../model/conciliation_model.php",
          params,
          function (data) {
            if (data.code == 200) {
              dataTableCommissions.draw();
              dataTableSummary.draw();
              $("#modalAddAdjustment").modal("hide");
              preloader("hide", data.message, "success");
            } else if (data.code == 204) {
              preloader("hide", data.message, "error");
            } else {
              preloader("hide", "Error", "error");
            }
          },
          "json"
        );
      }
    });

    $("#add_user").keyup(function () {
      $(".global").hide();
      $("#box_users").html("");
      let name = $(this).val().trim();
      name = name.trim();
      if (name.length >= 3) {
        let dt = {
          action: "loadAutoCompletUser",
          name: $(this).val(),
        };
        preloader("show");
        $.post(
          "../model/conciliation_model.php",
          dt,
          function (response, textStatus, jqXHR) {
            if (response.listUsers == null) {
              preloader("hide");
            }
            if (response.listUsers.length > 0) {
              $(".global").show();
              let list = '<ul id="country-list" style="list-style:none">';
              response.listUsers.forEach((element) => {
                list += `<li onClick="selectUser(${element.id},${element.id_client},'${element.name}');"><span style="cursor:pointer">${element.name} - ${element.agent_code}</span></li>`;
              });
              list += "</ul>";
              preloader("hide");
              $("#box_users").html(list);
            }
          },
          "json"
        );
      }
      // if (contact_name.length > 3) {
      //   $("#add_user").attr("data-id", 0);
      // }
    });

    $("#btn_show_total_agents_plans").on("click", function () {
      var date = "01-" + monthActual + '-' + yearActual;
      $(".spanShowLabelAgentsPlans").removeClass("d-none");
      $(".spanShowTotalAgentsPlans").removeClass("d-none");
      $(".span_total_agents_plans").text(parseInt(0).toFixed(2));
      Conciliation.showTotalAgentsPlans(date);
    });
  },
  tableCommissions: (date) => {
    var i = 0;

    if ($.fn.DataTable.isDataTable("#dtCommissionsList")){
      $("#dtCommissionsList").DataTable().destroy();
    }
    $("#dtCommissionsList tbody").empty();

    $("#dtCommissionsList tfoot th").each(function () {
      if (!(i == 0) && i != 18 && i != 16 && i != 17) {
        var title = $(this).text();
        $(this).html(
          '<input type="text" placeholder="' +
            title +
            '" style="width:100%;" />'
        );
      }
      i++;
    });

    dataTableCommissions = $("#dtCommissionsList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      lengthMenu: [20, 35, 50, 75, 100, 250, 500, 1000],
      dom: "Bfrltip",
      ajax: {
        url: "../model/conciliation_model.php", // json dataholder
        data: {
          action: "listCommissions",
          lang: localStorage.getItem("settingLang"),
        },
        type: "post",
        error: function () {},
      },
      columnDefs: [
        {
          targets: [0],
          visible: false,
        },
        {
          targets: [15],
          orderable: false,
        },
        {
          targets: [16],
          orderable: false,
        },
      ],
      searchCols: [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        { search: date },
      ],
      order: [[4, "desc"]],
      buttons: [
        {
          extend: "csvHtml5",
          footer: true,
          text: '<i class="la la-file-text-o"></i> CSV',
          titleAttr: "CSV",
          title: "Commissions",
        },
        {
          extend: "pdfHtml5",
          text: '<i class="la la-file-pdf-o"></i> PDF',
          pageSize: "LEGAL",
          orientation: "landscape",
          title: "rCOI Disclosures",
          exportOptions: {
            columns: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15],
            orthogonal: "print",
          },
          download: "open",
        },
      ],
      drawCallback: function (response) {
        // var id_role = $("#role_id").val();
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
        if (response.json.data_total != null) {
          $(".span_total_payments").text(response.json.data_total.total_amount);
          $(".span_serenity_total").text(
            (response.json.data_total.total_amount / 2).toFixed(2)
          );
          $(".span_all_commission").text(
            parseFloat(response.json.data_total.total_commission).toFixed(2)
          );
          $(".span_direct_commission").text(
            parseFloat(response.json.data_total.direct_commission).toFixed(2)
          );
          $(".span_override_commission").text(
            parseFloat(response.json.data_total.override_commission).toFixed(2)
          );
          $(".span_adjustment").text(
            parseFloat(response.json.data_total.adjustment).toFixed(2)
          );
        }
      },
    });

    dataTableCommissions
      .buttons()
      .container()
      .appendTo("#buttonsDataTableCommissions");

    //Apply the search
    dataTableCommissions.columns().every(function () {
      var that = this;
      $("input", this.footer()).on("keyup change", function () {
        if (that.search() !== this.value) {
          that.search(this.value).draw();
        }
      });
    });
    dataTableCommissions.on("change", "tbody tr .m-checkbox", function () {
      $(this).parents("tr").toggleClass("active");
    });
  },
  tableDetailsConciliaton: (id, name_agent) => {
    Conciliation.cleanPaymentRecord();
    if ($.fn.DataTable.isDataTable("#dtDetailsConciliaton")) {
      $("#dtDetailsConciliaton").DataTable().clear().destroy();
    }
    var date = "01-" + monthActual + '-' + yearActual;
    $("#modalDetailsConciliaton").modal("show");

    $("#titlePayment").html(`Payment Commission  ${name_agent}`);

    dataTable = $("#dtDetailsConciliaton").DataTable({
      processing: true,
      serverSide: true,
      lengthMenu: [
        [10, 20, 100, 250, 500, 1000],
        [10, 20, 100, 250, 500, 1000],
      ],
      responsive: !0,
      ajax: {
        url: "../model/conciliation_model.php", // json datasource
        data: {
          action: "dtDetailsConciliaton",
          lang: localStorage.getItem("settingLang"),
          id_agent: id,
          date: date,
        },
        type: "post", // method  , by default get
        error: function () {
          // error handling
        },
      },
      columnDefs: [
        {
          targets: [0, 1],
          orderable: false,
          width: "5%",
        },
      ],
      order: [[2, "asc"]],
      drawCallback: function (response) {
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
        // dataTable.columns([8]).visible(false, false);
        // dataTable.columns([9]).visible(false, false);
        // dataTable.columns([10]).visible(false, false);
        // dataTable.columns([11]).visible(false, false);
        // dataTable.columns([13]).visible(false, false);
      },
    });
  },
  tableDetailsConciliatonView: (id, name_agent) => {
    Conciliation.cleanPaymentRecord();
    if ($.fn.DataTable.isDataTable("#dtDetailsConciliatonView")) {
        $("#dtDetailsConciliatonView").DataTable().clear().destroy();
    }
    var date = "01-" + monthActual + '-' + yearActual;
    $("#modalDetailsConciliatonView").modal("show");

    $("#nameAgentPaid").text(` ${name_agent}`);

    dataTable = $("#dtDetailsConciliatonView").DataTable({
        processing: true,
        serverSide: true,
        lengthMenu: [
            [10, 20, 100, 250, 500, 1000],
            [10, 20, 100, 250, 500, 1000],
        ],
        responsive: !0,
        ajax: {
            url: "../model/conciliation_model.php",
            data: {
                action: "dtDetailsConciliatonView",
                lang: localStorage.getItem("settingLang"),
                id_agent: id,
                date: date,
            },
            type: "post",
            error: function () {
                // error handling
            },
            dataSrc: function (json) {
                
                if (json.amountTotal !== undefined) {
                    var nameLabel = localStorage.getItem("settingLang") == "es" ? "Monto Total" : "Amount Total";
                    $("#amountTotalPaymentAgent").text(`${nameLabel}: ${parseFloat(json.amountTotal).toFixed(2)}`);
                }
                return json.data;
            }
        },
        columnDefs: [
            {
                targets: [0, 1],
                orderable: false,
                width: "5%",
            },
        ],
        order: [[2, "asc"]],
        drawCallback: function (response) {
            if (response.json && response.json.code == "440") {
                loginTimeout(response.json.message);
                return;
            }
        },
        initComplete: function (response) {  
            var nuevoDiv = $('<div>', { 
                id: 'amountTotalPaymentAgent', 
                class: 'col-md-4 font-weight-bold tr', 
                key: "amountTotal" 
            });
            var parentLengthDiv = $('#dtDetailsConciliatonView_length').parent();
            var parentFilterDiv = $('#dtDetailsConciliatonView_filter').parent();

            parentLengthDiv.removeClass('col-md-6').addClass('col-md-4');
            parentFilterDiv.removeClass('col-md-6').addClass('col-md-4');

            nuevoDiv.insertAfter(parentLengthDiv);

            var nameLabel = localStorage.getItem("settingLang") == "es" ? "Monto Total" : "Amount Total";
            $("#amountTotalPaymentAgent").text(`${nameLabel}: ${parseFloat(response.json.amountTotal).toFixed(2)}`);
                 
        }
    });
},
  tableSummary: (date) => {
    var i = 0;

    if ($.fn.DataTable.isDataTable("#dtSummaryList")){
      $("#dtSummaryList").DataTable().destroy();
    }
    $("#dtSummaryList tbody").empty();

    $("#dtSummaryList tfoot th").each(function () {
      if (!(i == 0) && i != 7 && i != 8 && i != 16 && i != 15) {
        var title = $(this).text();
        $(this).html(
          '<input type="text" placeholder="' +
            title +
            '" style="width:100%;" />'
        );
      }
      i++;
    });

    var buttons = [
      {
        extend: "csvHtml5",
        footer: true,
        text: '<i class="la la-file-text-o"></i> CSV',
        titleAttr: "CSV",
        title: "Summary",
      },
      {
        extend: "pdfHtml5",
        footer: true,
        text: '<i class="la la-file-pdf-o"></i> PDF',
        pageSize: "LEGAL",
        orientation: "landscape",
        titleAttr: "PDF",
        download: "open",
        title: "Summary",
      },
    ];
    var id_user_crm = $("#id_user_crm").val();

    if (id_user_crm == 2436) {
      buttons.push({
        extend: "pdfHtml5",
        text: '<i class="la la-file-pdf-o"></i> Summary-Deposit',
        pageSize: "A3",
        orientation: "portrait",
        title: () => `Summary-Deposit ${monthActual} - ${yearActual}`,
        exportOptions: {
          columns: [1, 3, 9, 10, 11, 12, 13, 14, 15],
          orthogonal: "print",
        },
        customize: function (doc) {
          doc.content[1].margin = [20, 0, 100, 20]; //left, top, right, bottom
        },
        download: "open",
      });
    }

    dataTableSummary = $("#dtSummaryList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      lengthMenu: [20, 35, 50, 75, 100, 200, 500],
      dom: "Bfrltip",
      ajax: {
        url: "../model/conciliation_model.php", // json dataholder
        data: {
          action: "listSummary",
          lang: localStorage.getItem("settingLang"),
        },
        type: "post",
        error: function () {},
      },
      columnDefs: [
        {
          targets: [0, 9, 10, 11, 12, 13, 14, 15],
          visible: false,
        },
        {
          targets: [7],
          orderable: false,
        },
        {
          className: "dt-center",
          targets: [1, 2, 3, 4, 5, 6],
        },
      ],
      searchCols: [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        { search: date },
        null,
        null,
        null,
        null,
        null,
        null,
        null,
      ],
      order: [[0, "desc"]],
      buttons: [
        {
          extend: "csvHtml5",
          footer: true,
          text: '<i class="la la-file-text-o"></i> CSV',
          titleAttr: "CSV",
          title: "Summary",
        },
        {
          extend: "pdfHtml5",
          footer: true,
          text: '<i class="la la-file-pdf-o"></i> PDF',
          pageSize: "LEGAL",
          orientation: "landscape",
          titleAttr: "PDF",
          download: "open",
          title: "Summary",
        },
        {
          extend: "pdfHtml5",
          text: '<i class="la la-file-pdf-o"></i> Summary-Deposit ',
          pageSize: "LETTER",
          orientation: "landscape",
          title: () => `Summary-Deposit ${monthActual} - ${yearActual}`,
          exportOptions: {
            columns: [1, 3, 9, 10, 11, 12, 13, 14, 15],
            orthogonal: "print",
          },
          customize: function (doc) {
            doc.content[1].margin = [30, 0, 30, 0]; //left, top, right, bottom
          },
          download: "open",
        },
      ],
      drawCallback: function (response) {
        // var id_role = $("#role_id").val();
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
        // if (id_role == "29")
        // {
        //   dataTable.columns([9]).visible(false, false);detailsConciliatond
        // }
      },
    });

    dataTableSummary.buttons().container().appendTo("#buttonsDataTableSummary");

    //Apply the search
    dataTableSummary.columns().every(function () {
      var that = this;
      $("input", this.footer()).on("keyup change", function () {
        if (that.search() !== this.value) {
          that.search(this.value).draw();
        }
      });
    });
    dataTableSummary.on("change", "tbody tr .m-checkbox", function () {
      $(this).parents("tr").toggleClass("active");
    });
  },
  viewNote: (id) => {
    event.preventDefault();
    preloader("show");
    $("#view_note").val("");
    var params = {
      action: "viewNote",
      id: id,
    };
    $.post(
      "../model/conciliation_model.php",
      params,
      function (data) {
        if (data.code == 200) {
          //console.log(data);
          $("#modalViewNote").modal("show");
          $("#view_note").val(data.note);
          preloader("hide");
        } else {
          preloader("hide", data.message, "info");
        }
      },
      "json"
    );
  },
  paymentRecord: (id) => {
    $("#modalPaymentRecord").modal("show");
    $("#idCommision").val(id);
    var params = {
      action: "getConciliation",
      id: id,
    };
    $.post(
      "../model/conciliation_model.php",
      params,
      function (data) {
        if (data.code == 200) {
          $("#reconciliation_payment_date")
            .datepicker("setDate", data.reconciliation_payment_date)
            .trigger("change");
          $("#payment_description").val(data.payment_description);
          dataTableCommissions.draw(false);
          dataTableSummary.draw(false);
          dataTable.draw(false);
          preloader("hide", data.message, "success");
        } else if (data.code == 204) {
          preloader("hide", data.message, "info");
        } else {
          preloader("hide", "Error", "error");
        }
      },
      "json"
    );
  },
  cleanAdjustment: (id) => {
    $("#add_user").val("");
    $("#add_user").attr("data-id", "");
    $("#add_user").attr("data-id_client", "");
    $("#add_amount").val("");
    $("#add_adjustment_date").val("");
    $("#add_type").val("");
    $("#add_note").val("");
    $("#name").html("");
    $("#policy").html("");
    $("#amount").html("");
    $("#oldPorcentaje").html("");
    $("#oldCommission").html("");
  },
  cleanRecalculate: () => {
    $("#name").html("");
    $("#policy").html("");
    $("#amount").html("");
    $("#oldPorcentaje").html("");
    $("#oldCommission").html("");
  },
  cleanPaymentRecord: () => {
    $("#add_adjustment_date").val("");
    $("#payment_description").val("");
  },
  showTotalAgentsPlans: (date) => {
    preloader("show");
    $.post(
      "../model/conciliation_model.php",
      { action: "showTotalAgentsPlans", search: date },
      function (response) {
        if (response.code == 200) {
          preloader("hide");
          if (response.total_amount !== null) {
            $(".span_total_agents_plans").text(
              parseFloat(response.total_amount).toFixed(2)
            );
          } else {
            $(".span_total_agents_plans").text(parseInt(0).toFixed(2));
          }
        }
      },
      "json"
    );
  },
};

$(function () {
  monthsConciliations();
  Conciliation.event();
  //Conciliation.tableCommissions();
  //Conciliation.tableSummary();
});

function selectUser(id, id_client, name) {
  $("#add_user").val(name);
  $("#add_user").attr("data-id", id);
  $("#add_user").attr("data-id_client", id_client);
  $(".global").hide();
  $("#box_users").html("");
}

function monthsConciliations(){
  $(".dropdown-month").removeClass("font-weight-bold");
  var params = {
    action: "monthsConciliations",
    year: yearActual
  };
  $.post(
    "../model/conciliation_model.php",
    params,
    function (data) {
      if (data.code == 200) {
        var mes = "";
        $.each( data.data, function( key, value ) {
          mes = parseInt(value.mes) < 10 ? '0' + parseInt(value.mes) : parseInt(value.mes);
          $(`*[data-month="${mes}"]`).addClass("font-weight-bold");
        });
      }
    },
    "json"
  );
}
