'use strict';
let conciergeAgentsCreditsDataTable = '';
let conciergeCreditTransactionsList = '';
let t;
let currentAvailableCredits = availableCredits;

let pendingAssignment = null;
let currentAssignmentType = null;

let concierge_agents_credits_list = {
    init: function () {
        $('#creditAssignmentModal').on('shown.bs.modal', function () {
            $('#select_user_crm_agent_individual').select2({
                placeholder: 'Select Agents..',
                dropdownParent: $('#creditAssignmentModal'),
            });

            $('#select_user_crm_agent_massive').select2({
                placeholder: 'Select Agents..',
                tags: !0,
                dropdownParent: $('#creditAssignmentModal'),
            });
        });

        if (userRole != 1) {
            $('#credit_amount').attr('max', currentAvailableCredits);
            $('#credit_amount_massive').attr('max', currentAvailableCredits);
            $('.form-text small').each(function () {
                $(this).text('Máximo disponible: ' + currentAvailableCredits + ' créditos');
            });
            $('#modal_available_credits').text(currentAvailableCredits);
        }

        $('.date_us')
            .datepicker({
                appendText: 'MM/DD/YYYY',
                changeMonth: true,
                changeYear: true,
                rtl: mUtil.isRTL(),
                todayHighlight: !0,
                orientation: 'bottom left',
                templates: t,
            })
            .on('changeDate', function (e) {
                $(this).datepicker('hide');
            });

        $('#select_user_crm_agent_massive').change(function (e) {
            let intValue = 0;
            const $sel = $('#select_user_crm_agent_massive');
            if ($sel.length && $sel.data('select2')) {
                intValue = $sel.select2('data').length;
            } else {
                const val = $sel.val();
                intValue = Array.isArray(val) ? val.length : val ? 1 : 0;
            }

            let stringValue = intValue > 1 ? 'agents' : 'agent';
            $('#quantity_seleted_assignment').text(`to ${intValue} ${stringValue}`);

            concierge_agents_credits_list.calculateMassiveTotal();
        });

        $('#credit_amount_massive').on('input', function () {
            concierge_agents_credits_list.calculateMassiveTotal();
        });

        //Limpiar el form cuando cambio de tab
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            let target = $(e.target).attr('href');
            if (target === '#tab_individual_assignment') {
                let f = document.getElementById('addFormIndividualAssignment');
                if (f) f.reset();
                // limpiar select2 si está inicializado
                if ($('#select_user_crm_agent_individual').length && $('#select_user_crm_agent_individual').data('select2')) {
                    $('#select_user_crm_agent_individual').val(null).trigger('change');
                }
                // limpiar cualquier contador o label relacionado
                $('#quantity_seleted_assignment').text('');
            } else if (target === '#tab_mass_assignment') {
                let f2 = document.getElementById('addFormMassiveAssignment');
                if (f2) f2.reset();
                if ($('#select_user_crm_agent_massive').length && $('#select_user_crm_agent_massive').data('select2')) {
                    $('#select_user_crm_agent_massive').val(null).trigger('change');
                }
                $('#quantity_seleted_assignment').text('');
                $('#massive_total_credits').text('0');
            }
        });

        $('#confirmAssignmentButton').click(function () {
            concierge_agents_credits_list.processAssignment();
        });

        $('#confirmAssignmentModal').on('hidden.bs.modal', function () {
            pendingAssignment = null;
            currentAssignmentType = null;
        });

        concierge_agents_credits_list.refreshAvailableCredits();
    },
    calculateMassiveTotal: function () {
        let creditAmount = parseInt($('#credit_amount_massive').val()) || 0;

        let selectedAgentsCount = 0;
        const $sel = $('#select_user_crm_agent_massive');
        if ($sel.length && $sel.data('select2')) {
            selectedAgentsCount = $sel.select2('data').length;
        } else {
            const val = $sel.val();
            selectedAgentsCount = Array.isArray(val) ? val.length : val ? 1 : 0;
        }
        let totalCredits = creditAmount * selectedAgentsCount;

        $('#massive_total_credits').text(totalCredits);

        // Validación adicional para no administradores
        if (typeof availableCredits !== 'undefined' && userRole != 1) {
            if (totalCredits > availableCredits) {
                $('#massive_total_credits').css('color', 'red');
                $('#massive_assignment_button_add').prop('disabled', true);
            } else {
                $('#massive_total_credits').css('color', '');
                $('#massive_assignment_button_add').prop('disabled', false);
            }
        }
    },
    processAssignment: function () {
        if (!pendingAssignment) return;

        preloader('show');
        $.post(
            '../model/agents_model.php',
            pendingAssignment.params,
            function (data) {
                if (data.code == 200) {
                    conciergeAgentsCreditsDataTable.draw();

                    if (userRole != 1) {
                        let newAvailable = currentAvailableCredits;
                        if (currentAssignmentType === 'individual') {
                            newAvailable -= pendingAssignment.creditAmount;
                        } else if (currentAssignmentType === 'massive') {
                            newAvailable -= pendingAssignment.totalCredits;
                        }
                        concierge_agents_credits_list.updateAvailableCredits(newAvailable);
                    }

                    $('#creditAssignmentModal').modal('hide');
                    $('#confirmAssignmentModal').modal('hide');
                    preloader('hide', data.message, 'success');
                } else if (data.code == 204) {
                    preloader('hide', data.message, 'error');
                } else {
                    preloader('hide', 'Error', 'error');
                }
            },
            'json'
        ).fail(function () {
            preloader('hide', 'Error processing request', 'error');
        });
    },
    // Función para actualizar los créditos disponibles en toda la interfaz
    updateAvailableCredits: function (newCredits) {
        currentAvailableCredits = newCredits;

        $('.m-portlet__head-text b span').last().text(currentAvailableCredits);

        $('.modal_available_credits').text(currentAvailableCredits);

        $('#credit_amount').attr('max', currentAvailableCredits);
        $('#credit_amount_massive').attr('max', currentAvailableCredits);

        $('.form-text small').each(function () {
            $(this).text('Máximo disponible: ' + currentAvailableCredits + ' créditos');
        });

        // Recalcular total masivo
        this.calculateMassiveTotal();

        if (userRole != 1 && currentAvailableCredits <= 0) {
            $('#btn_add_credits_concierge').hide();
            $('.alert-info').hide();
        } else if (userRole != 1) {
            $('#btn_add_credits_concierge').show();
            $('.alert-info').show();
        }
    },

    // Función para obtener créditos actualizados del servidor
    refreshAvailableCredits: function () {
        if (userRole != 1) {
            $.post(
                '../model/agents_model.php',
                { method: 'getAvailableCredits' },
                function (data) {
                    if (data.code == 200) {
                        concierge_agents_credits_list.updateAvailableCredits(data.available_credits);
                    }
                },
                'json'
            );
        }
    },
    list: function () {
        conciergeAgentsCreditsDataTable = $('#dtConciergeAgentCreditList').DataTable({
            processing: true,
            serverSide: true,
            responsive: !0,
            ajax: {
                url: '../model/agents_model.php', // json datasource
                data: { method: 'dtConciergeAgentCreditList' },
                type: 'post', // method  , by default get
                error: function () {},
            },
            columnDefs: [
                {
                    targets: [0],
                    visible: false,
                    width: '5%',
                },
            ],
            order: [[0, 'asc']],
        });
    },

    events: function () {
        $('#btn_add_credits_concierge').click(function (e) {
            // Conciliation.cleanAdjustment();
            $('#creditAssignmentModal').modal('show');
        });

        $('#individual_assignment_button_add').click(function () {
            if ($('#addFormIndividualAssignment').valid()) {
                let params = {
                    method: 'addIndividualAssignmentCredits',
                    id_agent_crm: $('#select_user_crm_agent_individual').select2('data')[0].id,
                    credit_amount: $('#credit_amount').val(),
                    expired_date: $('#expired_date').val(),
                    comment: $('#comment').val(),
                };

                if (userRole != 1) {
                    let creditAmount = parseInt($('#credit_amount').val()) || 0;
                    if (creditAmount > currentAvailableCredits) {
                        preloader('hide', 'Insufficient credits available', 'error');
                        return false;
                    }
                }

                // Obtener nombre del agente seleccionado
                let selectedAgentText = $('#select_user_crm_agent_individual').select2('data')[0].text;
                let agentName = selectedAgentText.split(' - ')[0];
                let creditAmount = $('#credit_amount').val();

                // Mostrar modal de confirmación
                let confirmMessage = `Are you sure you want to assign ${creditAmount} credits to agent ${agentName}?`;
                $('#confirmMessage').text(confirmMessage);

                // Guardar datos para procesar después de confirmar
                pendingAssignment = {
                    params: params,
                    creditAmount: parseInt(creditAmount) || 0,
                };
                currentAssignmentType = 'individual';

                $('#confirmAssignmentModal').modal('show');
            }
        });

        $('#massive_assignment_button_add').click(function () {
            if (typeof availableCredits !== 'undefined' && userRole != 1) {
                let totalCredits = parseInt($('#massive_total_credits').text()) || 0;
                if (totalCredits > availableCredits) {
                    preloader('hide', 'Insufficient credits available', 'error');
                    return false;
                }
            }

            if ($('#addFormMassiveAssignment').valid()) {
                let userCrmAgent = '';
                $('select[name^="select_user_crm_agent_massive"]').each(function () {
                    userCrmAgent += $(this).val() + ',';
                });

                let params = {
                    method: 'addMassiveAssignmentCredits',
                    id_agent_crm: userCrmAgent.slice(0, -1),
                    credit_amount: $('#credit_amount_massive').val(),
                    expired_date: $('#expired_date_massive').val(),
                    comment: $('#comment_massive').val(),
                };

                // Calcular información para la confirmación
                let creditAmount = parseInt($('#credit_amount_massive').val()) || 0;
                let selectedAgentsCount = 0;
                const $sel = $('#select_user_crm_agent_massive');
                if ($sel.length && $sel.data('select2')) {
                    selectedAgentsCount = $sel.select2('data').length;
                } else {
                    const val = $sel.val();
                    selectedAgentsCount = Array.isArray(val) ? val.length : val ? 1 : 0;
                }
                let totalCredits = creditAmount * selectedAgentsCount;

                // Mostrar modal de confirmación
                let confirmMessage = `Are you sure you want to assign ${totalCredits} credits to ${selectedAgentsCount} agents?`;
                $('#confirmMessage').text(confirmMessage);

                // Guardar datos para procesar después de confirmar
                pendingAssignment = {
                    params: params,
                    totalCredits: totalCredits,
                };
                currentAssignmentType = 'massive';

                $('#confirmAssignmentModal').modal('show');
            }
        });

        $('#btn_add_credit').click(function () {
            let currentValue = parseInt($('#edit_credit_amount').val()) || 0;
            if (userRole != 1) {
                if (currentValue < currentAvailableCredits) {
                    $('#edit_credit_amount').val(currentValue + 1);
                }
            } else {
                $('#edit_credit_amount').val(currentValue + 1);
            }
        });

        $('#btn_subtract_credit').click(function () {
            let currentValue = parseInt($('#edit_credit_amount').val()) || 0;
            let originalCredits = parseInt($('#edit_original_credits').val()) || 0;

            // Si no es administrador, no permitir restar créditos
            if (userRole != 1) {
                preloader('hide', 'You cannot remove credits once assigned', 'error');
                return;
            }

            if (currentValue > -originalCredits) {
                $('#edit_credit_amount').val(currentValue - 1);
            }
        });

        $('#individual_assignment_button_edit').click(function () {
            let credit_change = parseInt($('#edit_credit_amount').val()) || 0;
            let original_credits = parseInt($('#edit_original_credits').val()) || 0;

            if (credit_change == 0) {
                preloader('hide', 'No changes to save', 'info');
                return;
            }

            // Si no es administrador y trata de restar créditos, mostrar error
            if (userRole != 1 && credit_change < 0) {
                preloader('hide', 'You cannot remove credits once assigned', 'error');
                return;
            }

            if (userRole != 1) {
                if (credit_change > 0 && credit_change > currentAvailableCredits) {
                    preloader('hide', 'You do not have enough credits to assign.', 'error');
                    return;
                }
            }

            if (credit_change < 0 && Math.abs(credit_change) > original_credits) {
                preloader('hide', 'You cannot remove more credits than the agent has.', 'error');
                return;
            }

            // Mostrar confirmación para la edición también
            let agentName = $('#edit_select_user_crm_agent_individual').select2('data')[0].text.split(' - ')[0];
            let action = credit_change > 0 ? 'add' : 'remove';
            let confirmMessage = `Are you sure you want to ${action} ${Math.abs(credit_change)} credits to agent ${agentName}?`;

            $('#confirmMessage').text(confirmMessage);

            pendingAssignment = {
                params: {
                    method: 'updateIndividualAssignmentCredits',
                    id: $('#edit_id_agent_credit').val(),
                    credit_change: credit_change,
                    comment: $('#edit_comment').val(),
                },
            };

            $('#confirmAssignmentModal').modal('show');
        });
    },
    edit: function (id) {
        let datos = {
            method: 'editIndividualAssignmentCredits',
            id: id,
        };
        preloader('show');
        $.post(
            '../model/agents_model.php',
            datos,
            function (data) {
                preloader('hide');
                $('#edit_id_agent_credit').val(data.id);
                $('#edit_select_user_crm_agent_individual').val(data.id_user_crm).trigger('change');
                $('#edit_available_credits').val(data.available_credits);
                $('#edit_original_credits').val(data.available_credits);
                $('#edit_expired_date').val(data.expired_date);
                $('#edit_comment').val(data.comment || '');
                $('#edit_credit_amount').val(0);

                $('#editCreditAssignmentModal').modal('show');
            },
            'json'
        );
    },
    list_transactions: function (id, id_agent_logged) {
        if ($.fn.DataTable.isDataTable('#dtConciergeCreditTransactionsList')) {
            $('#dtConciergeCreditTransactionsList').DataTable().clear().destroy();
        }
        $('#listCreditsTransactionsModal').modal('show');

        conciergeCreditTransactionsList = $('#dtConciergeCreditTransactionsList').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            destroy: true,
            ajax: {
                url: '../model/agents_model.php',
                type: 'post',
                // enviar los parámetros dinámicamente para cada request y asegurar que el id llega correctamente
                data: function (d) {
                    d.method = 'dtConciergeCreditTransactionsList';
                    d.id_agent_credit = id;
                    d.id_agent_logged = id_agent_logged;
                },
                error: function (xhr, error, thrown) {
                    console.error('Failed to load transactions:', error, thrown);
                },
            },
            columnDefs: [
                {
                    targets: [0],
                    visible: false,
                    width: '5%',
                },
            ],
            order: [[0, 'asc']],
        });
    },
    clear: function () {
        $('#select_user_crm_agent_individual').val(null).trigger('change');
        $('#select_user_crm_agent_massive').val(null).trigger('change');
        $('#credit_amount').val(1);
        $('#expired_date').val('');
        $('#comment').val('');
        $('#credit_amount_massive').val(1);
        $('#expired_date_massive').val('');
        $('#comment_massive').val('');
        $('#quantity_seleted_assignment').text('');
        $('#massive_total_credits').text('0');
        $('#massive_total_credits').css('color', '');
        $('#massive_assignment_button_add').prop('disabled', false);
    },
};

$(function () {
    concierge_agents_credits_list.init();
    concierge_agents_credits_list.list();
    concierge_agents_credits_list.events();
});
