var MODELOCOMPANY = "../model/company_model.php";

var dataTable = "";

var frmAddCompany = $("#frmAddCompany");

var Company = {
  inicio: () => {
    $("#file-es").fileinput({
      theme: "fas",
      language: "es",
      //uploadUrl: '#',
      allowedFileExtensions: ["png", "jpg", "jpeg"]
    });

    dataTable = $("#dtCompanyList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      ajax: {
        url: MODELOCOMPANY, // json datasource
        data: {
          method: "list"
        },
        type: "post",
        error: function() {}
      },
      columnDefs: [{
        targets: [],
        orderable: false
      }],
      order: [
        [0, "asc"]
      ]
    });

    $("#modalNewCompany").on("shown.bs.modal", function() {
      $("#add_idcategories").select2({
        placeholder: "Select Categories",
        tags: !0
      });
    });

    frmAddCompany.validate({
      rules: {
        add_name: {
          required: !0
        }
      }
    });
  },
  eventos: () => {
    $("#btnNewCompany").click(function(e) {
      e.preventDefault();
      Company.clear();
      $("#modalNewCompany").modal("show");
    });

    $("#btnSaveCompany").click(function(e) {
      e.preventDefault();
      if (frmAddCompany.valid()) {
        var categories = "";
        $('select[name^="add_idcategories"]').each(function() {
          categories += $(this).val() + ",";
        });
        var datos = {
          method: "savecompany",
          idCompany: $("#idCompany").val(),
          input_add_name: $("#input_add_name").val(),
          add_idcategories: $("#add_idcategories").val()
        };
        preloader("show");
        $.post(
          MODELOCOMPANY,
          datos,
          function(data) {
            if (data.code === 201) {
              $("#modalNewCompany").modal("hide");
              preloader("hide", data.messaje, "success");
              dataTable.draw();
            }
            if (data.code === 200) {
              $("#modalNewCompany").modal("hide");
              preloader("hide", data.messaje, "success");
              dataTable.draw();
            }
          },
          "json"
        );
      }
    });

    // $("#btnSaveImageCompany").click(function(e) {
    //  //boton de cargar imagen
    //  e.preventDefault();
    //  var img = $(".file-preview-image").attr("src");

    //  if (typeof img !== "undefined") {
    //    var image = $(".file-preview-image").attr("src");
    //    var datos = {
    //      method: "loadIMG",
    //      imagen: image,
    //      company_id: sessionStorage.getItem("id_company")
    //    };
    //    preloader("show");
    //    $.post(
    //      MODELOCOMPANY,
    //      datos,
    //      function(data) {
    //        if (data.code == 200) {
    //          $("#modalLogoCompany").modal("hide");
    //          preloader("hide", data.messaje, "success");
    //          dataTable.draw();
    //          $(".file-preview-image").attr("src", "");
    //        }
    //      },
    //      "json"
    //    );
    //  }
    // });

  },

  edit: id => {
    var datos = {
      method: "editCompany",
      id: id
    };
    $.post(
      MODELOCOMPANY,
      datos,
      function(data) {
        $("#idCompany").val(data.id);
        $("#input_add_name").val(data.name);
        var cat = data.id_categories.split(",");
        $("#add_idcategories").val(cat);
        $("#modalNewCompany").modal("show");
        console.log(data.id_categories);
      },
      "json"
    );
  },
  logo: id => {
    sessionStorage.setItem("id_company", id);
    $("#modalLogoCompany").modal("show");
  },
  clear: () => {
    $("#idCompany").val(0);
    frmAddCompany.validate().resetForm();
  },

  getLogoInfo: function(id, filename) {
    console.log(filename);
    $('#formUpDocuments')[0].reset();
    if (filename !== '') {
      swal('A file "'+ filename +'" is already loaded!', ' Please delete it first', 'error')
      .then(function() {
        $("#modalLogoCompany").modal('hide')
      });
    } else {
      $('#id_company').val(id);
      $("#modalLogoCompany").modal("show");
    }
  },

  showImage: function(file_url) {
    swal({
      title: 'Logo Preview',
      html: '<div><embed src=' + file_url + ' width="338px"/></div>'
    });
  },

  noFileAlert: function(id) {
    swal('Image Not Found!', "Not Uploaded Yet", "warning");
  },
};

(function() {
  Company.inicio();
  Company.eventos();
  $.fn.modal.Constructor.prototype._enforceFocus = function() {};
  $.fn.select2.defaults.set("width", "100%");
})();
