const MODEL = "../model/comission_model.php";
var dataTable = "";
var frmAddCommission = $('#frmAddCommission');

const ComissionController = {
    init:function () {
         
      frmAddCommission.validate({
            rules: {
              add_name: {
                required: true                 
              },
              add_commission: {
                required: true,
                number :true                 
              } 
            },
          });
    },
    table:function () {
        dataTable = $('#dtComissionList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "searching":false,
            "ajax": {
                url: MODEL, // json datasource
                data: {
                    method: "list"
                },
                type: "post",
                error: function() {}
            },
            "columnDefs": [{
                targets: [-1],
                orderable: false
            }],
            "order": [
                [0, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });
    },
    event:function(){
        $("#btnNewContract").click(function (e) { 
            e.preventDefault();
            ComissionController.clean();
            $("#modalNewCommission").modal('show');            
        });
        /////////////////////////////////////////
        $("#btnSaveComission").click(function (e) { 
            e.preventDefault();
            if ($("#frmAddCommission").valid()) {
                 
                let dt = {
                    method:'saveCommission',
                    id:$('#id').val(),
                    id_role:$('#select_role').val(),
                    commission:$('#add_commission').val(),
                    
                }                
                preloader("show");
                $.post(MODEL, dt,
                  function (data, textStatus, jqXHR) {   
                    //console.log(data);                  
                    if (data.code == 200) {
                      preloader("hide", data.message, "success");
                      dataTable.draw();
                    }
                    if (data.code == 204) {
                      preloader("hide", data.message, "error");
                      //dataTable.draw();
                    }
                    $("#modalNewCommission").modal('hide');  
                  },
                  "json"
                );
            }
        });
    },
    clean:function(){
        $('#id').val(0);
        $('#select_role').val('2');
        $('#add_commission').val(''); 
        $("#frmAddCommission").validate().resetForm();
    },
    edit:function (id) {
      let dt ={method:'edit',id}
      preloader("show");
      $.post(MODEL, dt,
        function (response, textStatus, jqXHR) {         
           
          $('#id').val(response.data.id);
          $('#select_role').val(response.data.id_role);
          $('#add_commission').val(response.data.commission); 
          $("#modalNewCommission").modal('show'); 
          preloader("hide");
        },
        "json"
      );
    },
    status:function (id) {
      let dt ={method:'status',id}
      preloader("show");
      $.post(MODEL, dt,
        function (response, textStatus, jqXHR) {
          preloader("hide");
          dataTable.draw();
        },
        "json"
      );
    }
}

$(function () {
    ComissionController.init();
    ComissionController.table();
    ComissionController.event();
});