var $frmAddCategorie = $('#frmAddCategorie'),
    dataTable = '',
    idCategory = '';



categories_view = {
    init: () => {

        dataTable = $('#dtCategoriesList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/categories_model.php", // json datasource
                data: {
                    action: "list"
                },
                type: "post",
                error: function() {}
            },
            "columnDefs": [{
                targets: [-1],
                orderable: false
            }],
            "order": [
                [0, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });

        $frmAddCategorie.validate({
            rules: {
                add_name: {
                    required: true,
                    minlength: 3
                },
                add_description: {
                    required: true
                }
            }
        });

    },
    event: () => {
        $('#btnSaveCatagery').click(function() {
            if ($frmAddCategorie.valid()) {
                if (idCategory == '') {
                    var parametros = {
                        "action": "insert",
                        "name": $("#add_name").val(),
                        "description": $("#add_description").val(),
                        "status": 1
                    }
                    preloader('show');
                    $.post('../model/categories_model.php', parametros, function(data) {
                        if (data.code == '440'){
                            loginTimeout(data.message);
                            return;
                        }
                        $('#modalNewCategory').modal('hide');
                        categories_view.clear();
                        preloader('hide', 'New Category Save...!', 'success');
                        dataTable.draw();
                    }, 'json');
                } else {
                    var parametros = {
                        "action": "update",
                        "id": idCategory,
                        "name": $("#add_name").val(),
                        "description": $("#add_description").val()
                    }
                    preloader('show');
                    $.post('../model/categories_model.php', parametros, function(data) {
                        if (data.code == '440'){
                            loginTimeout(data.message);
                            return;
                        }
                        $('#modalNewCategory').modal('hide');
                        categories_view.clear();
                        preloader('hide', 'Data Updated...!', 'success');
                        dataTable.draw();
                    }, 'json');
                }
            }
        });


        $('#btnNewCategory').click(function() {
            categories_view.clear();
            $('#modalNewCategory').modal('show');
        });

    },
    edit: (id) => {
        categories_view.clear();
        idCategory = id;
        var parametros = {
            "action": "edit",
            "id": id
        }
        preloader('show');
        $.post('../model/categories_model.php', parametros, function(data) {
            if (data.code == '440'){
                loginTimeout(data.message);
                return;
            }
            preloader('hide');
            idCategory = data[0].id;
            $('#add_name').val(data[0].name);
            $('#add_description').val(data[0].description);
            $('#modalNewCategory').modal('show');

        }, 'json')
    },
    del: (id) => {
        swal({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel!",
            reverseButtons: !0
        }).then(function(e) {

            if (e.dismiss) {
                swal({
                    position: "top-center",
                    type: "success",
                    title: 'Data is safe :)',
                    showConfirmButton: !1,
                    timer: 1500
                });
                //swal("Cancelled", "Data is safe :)", "error");
            }
            if (e.value) {
                var parametros = {
                    "action": "delete",
                    "id": id
                };
                preloader('show');
                $.post('../model/categories_model.php', parametros, function(data) {
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }
                    preloader('hide');
                    swal({
                        position: "top-center",
                        type: "error",
                        title: 'Data Has Been Deleted...!',
                        showConfirmButton: !1,
                        timer: 1500
                    });
                    //swal("Deleted!", "Data has been deleted.", "success");
                    dataTable.draw();
                },'json');

            }
            //e.value ? swal("Deleted!", "Data has been deleted.", "success") : "cancel" === e.dismiss && swal("Cancelled", "Your imaginary file is safe :)", "error")
        });
    },
    clear: () => {
        idCategory = '';
        $('#add_name').val('');
        $('#add_description').val('');
        $frmAddCategorie.validate().resetForm();
    },
    status: (id) => {
        var parametros = {
            "action": "changeStatus",
            "ID": id
        }
        preloader('show');
        $.post('../model/categories_model.php', parametros, function(data) {
            preloader('hide');
            if (data.res === 'yes') {
                preloader('hide', 'Data Updated...!', 'success');
                dataTable.draw();
            }
        }, 'json');
    }

};


$(function() {
    categories_view.init();
    categories_view.event();
});