var $formValidateCampaignType = $('#campaign_type_form');
dataTable = '';

$(function() {

    list_type.init();
    list_type.events();
    list_type.dt_list_type();
});

list_type = {

    init: function() {
        $("#campaign_type_form").validate({
            rules: {
                campaign_type_list_select_category: {
                    required: !0
                },
                campaign_type_list_input_name: {
                    required: !0
                },
                campaign_type_list_textarea_description: {
                    required: !0
                },


            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });

    },

    events: function() {
        $('#campaign_type_button_add').click(function() {
            if ($formValidateCampaignType.valid()) {
                var status = 1;
                if ($('#campaign_type_list_input_status').is(':checked')) {
                    status = 1;
                } else {
                    status = 2;
                }
                preloader('show');
                $.post("../model/inbound_marketing_model.php", {
                        "method": 'saveCampaignType',
                        "id": $('#campaign_type_input_id').val() == '0' ? 0 : $('#campaign_type_input_id').val(),
                        "name": $('#campaign_type_list_input_name').val(),
                        "category": $('#campaign_type_list_select_category').val(),
                        "description": $('#campaign_type_list_textarea_description').val(),
                        "status": status
                    },
                    function(response) {
                        if (response.code == '440'){
                            loginTimeout(response.message);
                            return;
                        }else{
                            $("#campaign_type").modal('hide');
                            preloader('hide', response.message, 'success');
                            dataTable.draw();
                        }                        
                    }, "json");
            } else {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            }

        });

    },
    view_modal: function(id) {


        $('#campaign_type_input_id').val(id);
        var checked = $("#campaign_type_list_input_status").is(':checked');
        preloader('show');
        $.post("../model/inbound_marketing_model.php", {
                    "method": 'findCampaignTypeById',
                    "id": id
                },
                function(data) {
                    if (data.code == '440'){
                        loginTimeout(data.message);
                        return;
                    }else{
                        preloader('hide');
                        $('#campaign_type_list_select_category').val(data.category);
                        $('#campaign_type_list_input_name').val(data.name);
                        $("#campaign_type_list_input_name").parent().addClass("md-input-filled");
                        $('#campaign_type_list_textarea_description').val(data.description);
                        $("#campaign_type_list_textarea_description").parent().addClass("md-input-filled");
                        if ((data.status == 1 && checked == false) || (data.status == 2 && checked == true)) {
                            $('#campaign_type_list_input_status').click();
                        }
                        $("#campaign_type").modal('show');
                    }
                }, "json")
            .fail(
                function(error) {
                    preloader('hide', 'FAIL', 'danger'),
                        setTimeout(function() {
                            $(location).attr('href', '../../common/stop_sesion.php');
                        }, 1000);

                }
            )
    },
    view_new_modal: function() {

        $('#campaign_type_input_id').val(0);
        $('#campaign_type_list_select_category').val(1);
        $('#campaign_type_list_input_name').val('');
        $('#campaign_type_list_textarea_description').val('');
        var checked = $("#campaign_type_list_input_status").is(':checked');
        if ((checked == true)) {
            $('#campaign_type_list_input_status').click();
        }
        $("#campaign_type_list_input_name").parent().removeClass("md-input-filled");
        $("#campaign_type_list_textarea_description").parent().removeClass("md-input-filled");
        $("#campaign_type").modal('show');
    },
    dt_list_type: function() {

        dataTable = $('#listType').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: "../model/inbound_marketing_model.php", // json datasource
                data: {
                    method: "listType"
                },
                type: "post", // method  , by default get
                error: function() { // error handling                    
                }
            },
            "columnDefs": [{
                targets: [0],
                data: null,
                defaultContent: '<input type="checkbox" data-md-icheck class="check_row">',
                orderable: false
            }],
            "order": [
                [1, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });
    },
    clear: function() {
        $("#msg_alert_1").addClass("m--hide").show(), mUtil.scrollTop();
        $("#campaign_type_list_select_category").val('');
        $("#campaign_type_list_input_name").val('');
        $('#campaign_type_list_textarea_description').val('');
        $formValidateCampaignType.validate().resetForm();
    }
};