"use strict";

var $formAddValidate = $('#add_bussiness_from'),
    dataTable = '';


var bussiness = {
    init: function() {
        $("#add_bussiness_from").validate({
            rules: {
                bussiness_modal_name: {
                    required: !0
                },
                bussiness_modal_tax_id: {
                    required: !0
                },
                bussiness_modal_owners: {
                    required: !0
                },
                bussiness_modal_payrolls: {
                    required: !0
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });
        $("#bussiness_modal").on("shown.bs.modal", function() {
            $("#bussiness_modal_owners").select2({
                placeholder: "Select owner",
                tags: !0
            });
            $("#bussiness_modal_payrolls").select2({
                placeholder: "Select users",
                tags: !0
            });
        });

    },
    bussiness_list: function() {

        dataTable = $('#bussiness_list').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/bussiness_model.php", // json datasource
                data: {
                    method: "bussiness_list"
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            "order": [
                [1, "asc"]
            ]
        });

    },
    events: function() {

        $('#bussiness_modal_button').click(function() {

            if ($formAddValidate.valid()) {

                var owners = '';
                var payroll = '';

                $.each($('#bussiness_modal_owners').val(), function(index, value) {
                    owners += value + ',';
                });
                $.each($('#bussiness_modal_payrolls').val(), function(index, value) {
                    payroll += value + ',';
                });

                preloader('show');
                $.post("../model/bussiness_model.php", {
                    "method": 'bussiness_add',
                    "id": $('#bussiness_modal_id').val() == '0' ? 0 : $('#bussiness_modal_id').val(),
                    "name": $('#bussiness_modal_name').val(),
                    "tax_id": $('#bussiness_modal_tax_id').val(),
                    "address": $('#bussiness_modal_address').val(),
                    "phone_1": $('#bussiness_modal_phone_1').val(),
                    "phone_2": $('#bussiness_modal_phone_2').val(),
                    "phone_3": $('#bussiness_modal_phone_3').val(),
                    "email_1": $('#bussiness_modal_email_1').val(),
                    "email_2": $('#bussiness_modal_email_2').val(),
                    "email_3": $('#bussiness_modal_email_3').val(),
                    "fax_1": $('#bussiness_modal_fax_1').val(),
                    "fax_2": $('#bussiness_modal_fax_2').val(),
                    "fax_3": $('#bussiness_modal_fax_3').val(),
                    "owners": owners.slice(0, -1),
                    "payroll": payroll.slice(0, -1),
                    "status": status
                }, function(data) {
                    if (data.mss == '1') {
                        $("#bussiness_modal").modal('hide');
                        preloader('hide', data.salida, 'success');
                        //notification(data.salida, 'success');
                        dataTable.draw(false)
                    } else {
                        preloader('hide', data.salida, 'error');
                        //notification(data.salida, 'danger');
                        console.log(data.mss);
                    }
                    preloader('hide');
                }, "json").fail(function(error) {
                    console.log(error.responseJSON)
                    preloader('hide');
                });

            }
        });

        $('#bussiness_list body').on('click', '.button_edit', function() {
            //console.log('button_edit')
            var data = dataTable.row($(this).parents('tr')).data();
            var id = data[0];
            //console.log(id)
            $('#bussiness_modal_id').val(id);
            //class_bussiness.findBussinessById(id);

        });

    },
    clear: function() {
        //console.log('clear');
        $("#msg_alert_1").addClass("m--hide").show(), mUtil.scrollTop();
        $('#bussiness_modal_id').val('0');
        $('#bussiness_modal_name').val('');
        $('#bussiness_modal_tax_id').val('');
        $('#bussiness_modal_address').val('');
        $('#bussiness_modal_phone_1').val('');
        $('#bussiness_modal_phone_2').val('');
        $('#bussiness_modal_phone_3').val('');
        $('#bussiness_modal_email_1').val('');
        $('#bussiness_modal_email_2').val('');
        $('#bussiness_modal_email_3').val('');
        $('#bussiness_modal_fax_1').val('');
        $('#bussiness_modal_fax_2').val('');
        $('#bussiness_modal_fax_3').val('');
        $('#bussiness_modal_owners').val('');
        $('#bussiness_modal_payrolls').val('');
        $formAddValidate.validate().resetForm();
    },
    findBussinessById: function(id) {
        preloader('show');
        $.post("../model/bussiness_model.php", {
            "method": 'findBussinessById',
            "id": id
        }, function(data) {
            preloader('hide');
            if (data.mss == '1') {
                $('#bussiness_modal_id').val(id);
                $('#bussiness_modal_name').val(data.name);
                $('#bussiness_modal_tax_id').val(data.tax_id);
                $('#bussiness_modal_address').val(data.address);
                $('#bussiness_modal_phone_1').val(data.phone_1);
                if (data.phone_2 != '') {
                    $('#bussiness_modal_phone_2').val(data.phone_2);
                }
                if (data.phone_3 != '') {
                    $('#bussiness_modal_phone_3').val(data.phone_3);
                }
                $('#bussiness_modal_email_1').val(data.email_1);
                if (data.email_2 != '') {
                    $('#bussiness_modal_email_2').val(data.email_2);
                }
                if (data.email_3 != '') {
                    $('#bussiness_modal_email_3').val(data.email_3);
                }
                $('#bussiness_modal_fax_1').val(data.fax_1);
                if (data.fax_2 != '') {
                    $('#bussiness_modal_fax_2').val(data.fax_2);
                }
                if (data.fax_3 != '') {
                    $('#bussiness_modal_fax_3').val(data.fax_3);
                }
                if (data.owners !== null){
                    var owners = data.owners.split(',');
                    $('#bussiness_modal_owners').val(owners);
                }
                var payrolls = data.payrolls.split(',');
                $('#bussiness_modal_payrolls').val(payrolls);
                $("#bussiness_modal").modal('show');
            } else {
                console.log(data.mss);
            }
            preloader('hide');
        }, "json").fail(function(error) {
            console.log(error.responseJSON)
        });
    }
};

$(function() {
    bussiness.init();
    bussiness.bussiness_list();
    bussiness.events();
});